/* Creates WPS objects for InfoBank. */
/* TRACE ALL */

FALSE=0;
TRUE=1;

CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

CALL SysCls;
SAY "InfoBank Information Retrieval System Installation Utility."
SAY ""

fullpath=Directory()
IF right(fullpath, 1) \= "\" THEN DO
   fullpath = fullpath || "\"
END

reply=CheckIfFilesExist(fullpath);
IF \reply THEN DO
   SAY "Couldn't locate the file(s) in '"||fullpath||"'."
   SAY "Please check that the file(s) exist in the directory."
   EXIT
END

TryAgain:
SAY
reply = GetYesNo("Do you want to install InfoBank into another directory?")
IF reply THEN DO
   Parse Value SysCurPos() with row col
   SAY "Please enter target directory: ";
   col=col+31
   Call SysCurPos row, col
   PULL newpath;
   IF (newpath="") THEN DO
      SAY "Empty string!"
      SIGNAL TryAgain;
   END
   ELSE IF \(SUBSTR(newpath,2,1)=':') THEN DO
      SAY "You have to specify the full path! E.g. 'C:\InfoBank'."
      SIGNAL TryAgain;
   END
   /* Create the target directory if necessary. */
   result = SysFileTree( Directory, 'Dirs', 'D' )
   IF Dirs.0 = 0 Then
   DO
      result = SysMkDir(newpath)
      IF (result==0) | (result==5) THEN DO
         fullpath=newpath;
         '@COPY InfoBank.* 'fullpath' > NUL'
         '@COPY Setup.* 'fullpath' > NUL'
         '@COPY ReadMe.1st 'fullpath' > NUL'
         '@COPY WHATSNEW.TXT 'fullpath' > NUL'
      END
      ELSE DO
         SAY 'ERROR: Unable to create target directory.'
         EXIT
      END
   END

END


reply = GetYesNo("Do you want to create WPS objects for InfoBank?")
IF reply THEN DO
      CALL SysCreateObject "WPFolder", "InfoBank", "<WP_DESKTOP>", "OBJECTID=<InfoBank>","ReplaceIfExists";
      CALL SysCreateObject 'WPProgram','InfoBank','<InfoBank>','CCVIEW=YES;EXENAME='||fullpath||'\InfoBank.EXE;PROGTYPE=PM'
      CALL SysCreateObject 'WPProgram','InfoBank Setup','<InfoBank>','CCVIEW=YES;EXENAME='||fullpath||'\Setup.EXE;PROGTYPE=PM'
      CALL SysCreateObject 'WPProgram','InfoBank Help','<InfoBank>','CCVIEW=YES;EXENAME=VIEW.EXE;PROGTYPE=PM;PARAMETERS='||fullpath||'InfoBank.INF'
      CALL SysCreateObject 'WPProgram','Setup Help','<InfoBank>','CCVIEW=YES;EXENAME=VIEW.EXE;PROGTYPE=PM;PARAMETERS='||fullpath||'Setup.INF'
END

SAY
SAY "Done! Thanks for your interest in InfoBank!"

EXIT

GetYesNo: procedure

SAY arg(1)
PARSE VALUE SysCurPos() WITH row col
curPos= SysCurPos(row-1,LENGTH(arg(1))+1)

DO FOREVER
   key=SysGetKey('NoEcho')
   SELECT
      WHEN key='y'|key='Y' THEN
        DO
         SAY key
         return 1       /* True. */
        END
      WHEN key=D2C(13)|key='n'|key='N' THEN
        DO
         SAY key
         return 0       /* False. */
        END
      OTHERWISE
         NOP
   END
END
RETURN

CheckIfFilesExist: procedure
   FALSE=0;
   TRUE=1;

   fileFound=TRUE;

   CALL SysFileTree arg(1) || "InfoBank.EXE", found1, "OF"
   CALL SysFileTree arg(1) || "InfoBank.INF", found2, "OF"
   CALL SysFileTree arg(1) || "Setup.EXE", found3, "OF"
   CALL SysFileTree arg(1) || "Setup.INF", found4, "OF"
   CALL SysFileTree arg(1) || "ReadMe.1st", found5, "OF"
   CALL SysFileTree arg(1) || "WhatsNew.TXT", found6, "OF"
   IF found1.1 = "FOUND1.1" THEN DO
      SAY "Couldn't find InfoBank.EXE."
      fileFound=FALSE;
      END
   IF found2.1 = "FOUND2.1" THEN DO
      SAY "Couldn't find InfoBank.INF."
      fileFound=FALSE;
   END
   IF found3.1 = "FOUND3.1" THEN DO
      SAY "Couldn't find Setup.EXE."
      fileFound=FALSE;
   END
   IF found4.1 = "FOUND4.1" THEN DO
      SAY "Couldn't find Setup.INF."
      fileFound=FALSE;
   END
   IF found5.1 = "FOUND5.1" THEN DO
      SAY "Couldn't find ReadMe.1st."
      fileFound=FALSE;
   END

   IF found6.1 = "FOUND6.1" THEN DO
      SAY "Couldn't find WhatsNew.TXT"
      fileFound=FALSE;
   END

   RETURN fileFound;

CheckPathname: procedure
   /* Verify the directory exists. */
   Result = SysFileTree( arg(1), 'Dirs', 'D' )
   If Dirs.0 = 0 Then Do
      RETURN 0;
   End

   RETURN 1; /* Path found. */

