{
  INFODISK.PAS

  This file is the Pascal source for INFODISK.EXE 1.00
  It needs at least Turbo Pascal 6.0 to be compiled because it includes
  assembler code, but if you inline it, it will also work with TP 5.0 or older

  This file may be freely copied or distributed for any non-commercial use.
  If you modify it, please let me know so I can upgrade it easily.

  For any question or suggestion, please e-mail me at :
      p6ip329@cicrp.jussieu.fr     until the middle of September 1995,
  or
      willy@U40024.citi2.fr        after this date.
  (In a future release, I'll give my new address.)

  You can also mail me at home:

      Willy TARREAU
      23, rue Richepanse
      78500 Sartrouville
      FRANCE

      PS: I also accept postcards  :-)

                                                                Willy.
}

uses temps;

const hextab : array [0..15] of char = '0123456789ABCDEF';
      NbTours = 200;
      numdsk : shortint = -1;   { means the 2 disks will be tested }
      dump   : boolean = false;
      inverse: boolean = true;

var b : array [0..511] of byte;
    c : array [0..511] of char absolute B;
    w : array [0..255] of word absolute B;
    s : string [50];
    ch : char;
    LngDump : word;
    ChParam   : string;

Procedure Delay1;
begin
  tempsazero;
  while (tempsactuel<10000) do;
{ delay(1);}
end;

function intstr(s : string) : integer;
var i,j : integer;
begin
  val(s,i,j);
  intstr:=i;
end;

function Hexb(b : byte) : string;
begin
  hexb:=hextab[b shr 4 and 15]+hextab[b and 15];
end;

Procedure Pret;
var i : word;
begin
  i:=1000;
  while ((port[$1F7] and $80)>0) and (i>0) do
  begin
    dec(i);
    delay1;
  end;
end;

Function Error : byte;
begin
  if (port[$1F7] and 1)=0 then Error:=0
                          else Error:=port[$1F1];
end;

Procedure ResetDsk;
begin
  port[$3f6]:=4;
  delay1;
  port[$3f6]:=0;
  Pret;
end;

Procedure ChgDsk(d : byte);
begin
  port[$1F6]:=$A0 or (d and 1) shl 4;
  Pret;
end;

Procedure Commande(c : byte);
begin
  port[$1f7]:=c;
  Pret;
end;

Procedure LitID;
var i : word;
begin
  fillchar(b,512,0);
  Commande($EC);
  if error>0 then exit;
  i:=0;
  while ((port[$1F7] and 8)>0) and (i<256) do
  begin
    w[i]:=portw[$1f0];
    inc(i);
  end;
end;

Procedure Nettoie(var s : string);
begin
  while (s[0]>#0) and (s[1]<=#32) do
    delete(s,1,1);
  while pos('  ',s)>0 do
    delete(s,pos('  ',s),1);
  if s[length(s)]=' ' then dec(s[0]);
end;


Function VitsRot : word;
var t : real;
    i : word;
    e : boolean;
begin
  e:=false;
  TempsAZero;
  for i:=1 to NbTours do
  asm
      mov    dx,1F7h
      xor    cx,cx
    @@1:
      in     al,dx
      test   al,2
      loopz  @@1
      jz     @@4
      xor    cx,cx
    @@2:
      in     al,dx
      test   al,2
      loopnz @@2
      jz     @@3
    @@4:
      mov    i,NbTours      { end }
      mov    E,1
    @@3:
  end;
  if not e then
    t:=i/SecEnReel*60
  else
    t:=0;
  VitsRot:=round(t);
end;

Procedure Identifie(d : byte);
var cyl,tet,bpt,bps,bpsf,spt : word;
    cac : word;
    i,j : word;
    id,tol : byte;
    cap : longint;

begin
  write('Physical disk ',d,' : ');
  ResetDsk;
  chgdsk(d);
  if Error>0 then writeln('Error #',error,' before identification.')
  else
  begin
    LitID;
    if Error>0 then writeln('Error #',error,' during identification.')
    else
    if dump then
    begin
      writeln('The identification gave the following codes : ');
      writeln;
      for i:=0 to ((LngDump+15) shr 4)-1 do
      begin
        write(hexb(hi(i*16)),hexb(lo(i*16)),':  ');
        for j:=0 to 15 do
          write(hexb(b[i*16+j]),' ');
        write('   ');
        for j:=0 to 15 do
        begin
          ch:=char(b[i*16+j]);
          if (ch<#32) or (ch>#160) then
            write('.')
          else
            write(ch);
        end;
        writeln;
      end;
    end
    else
    begin
      id:=b[0];
      tol:=b[1];
      cyl:=w[1];
      tet:=w[3];
      bpt:=w[4];
      bps:=w[5];
      bpsf:=bps and $FF00;
      spt:=w[6];
      cac:=w[$15];      { nbre de secteurs cachables }
      if id=0 then
      begin
        writeln('not found');
        exit;
      end;
      writeln('End of identification.');
      writeln('  Physical geometry   : ',cyl,' cylinders, ',tet,' heads, ',spt,' sectors.');
      cap:=longint(bps)*longint(cyl)*longint(tet)*longint(spt);
    {  cap:=longint(bpt)*longint(cyl)*longint(tet); }
      writeln('  Unformated capacity : ',cap,' bytes (',cap div 1048576,' MB), ',bps,' bytes per sector');
      cap:=longint(bpsf)*longint(cyl)*longint(tet)*longint(spt);
      writeln('  Formated capacity   : ',cap,' bytes (',cap div 1048576,' MB), ',bpsf,' bytes per sector');
      cap:=longint(cac)*longint(bpsf) shr 10;
      writeln('  Cache memory        : ',cap,' KB');
      if inverse then
        for i:=9 to $2E do
        begin
          j:=w[i];
          w[i]:=lo(j)*256+hi(j);     { little endian to big endian }
        end;
      s:='';
      for i:=$12 to $27 do s:=s+c[i];
      nettoie(s);
      writeln('  Serial number       : ',s);
      s:='';
      for i:=$2E to $35 do s:=s+c[i];
      nettoie(s);
      writeln('  Reference           : ',s);
      s:='';
      for i:=$36 to $5D do s:=s+c[i];
      nettoie(s);
      writeln('  Model               : ',s);
      write  ('  Miscellaneous codes : Media = ',hexb(id));
      writeln('h,  Rotational tolerance = ',hexb(tol),'h');
    end;
  end;
  if not dump then
  begin
    write ('  Rotational speed    : ');
{    i:=wherex; }
    write('evaluation in progress ...');
    j:=VitsRot;
{    gotoxy(i,wherey); }
    for i:=12 to 37 do write(#8);
{    clreol; }
    if j>0 then writeln(j,' rpm (within ',100/NbTours:0:1,'%).       ')
           else writeln('Couldn''t measure.');
  end;
end;


Function StrPar(p : string) : string;
var i,j,k : integer;
begin
  k:=length(p);
  i:=pos(p,ChParam);
  inc(i,k);
  j:=i;
  if i>k then
    while (i<=length(ChParam)) and (ChParam[i]<>' ') do
      inc(i);
  StrPar:=copy(ChParam,j,i-j);
end;

Procedure InitParam;
var T : Text;
    i : word;
begin
  move(ptr(PrefixSeg,$80)^,ChParam,sizeof(ChPAram));
  for i:=1 to length(ChParam) do ChParam[i]:=upcase(ChParam[i]);
  for i:=2 to length(ChParam) do
  begin
    if (ChParam[i]='-') then ChParam[i]:='/';
    if (ChParam[i]='/') and (ChParam[i-1]<>' ') then insert(' ',ChParam,i);
  end;

  if (pos('/?',ChParam)>0) or (pos('/h',ChParam)>0) then
  begin
    writeln('Syntax: INFODISK [/Ddisk] [/L[size]] [/I]');
    writeln('  - disk, which equals 0 or 1, is the number of the disk to test.');
    writeln('  - /L to require a listing of hexadecimal codes given by identification.');
    writeln('    [size] is the number of bytes to dump (1 to 512), 128 by default.');
    writeln('  - /I asks for not inverting bytes (usually used with /L).');
    halt;
  end;

  Inverse:=pos('/I',ChParam)=0;
  Dump:=pos('/L',ChParam)>0;
  if dump then
  begin
    LngDump:=IntStr(StrPar('/L'));
    if (LngDump<1) or (LngDump>512) then LngDump:=128;
  end;
  if pos('/D',ChParam)>0 then
    NumDsk:=IntStr(StrPar('/D'));
end;


BEGIN
  writeln('INFODISK : IDE hard disk identificator                       (W.Tarreau - 1994)');
  writeln('  NB : Hard disks don''t have to be declared in setup to be identified.');
  writeln;
  InitParam;
  if NumDsk<=0 then
  begin
    identifie(0);
    writeln;
  end;
  if (NumDsk=-1) or (NumDsk=1) then
  begin
    identifie(1);
  end;
  ResetDsk;
  chgdsk(0);
end.
