/* INETLG49.CMD 	(INETLOG.CMD v. 4.9)
(c) 1995 by Jerry Levy,  Marblehead, MA (USA) 03 Nov 95
jlevy@ibm.net

REXX Program to extract and totalize daily and
monthly time-ons by analyzing the IBM WARP
Internet Dialer CONNECT.LOG file */

version = '4.9'

/* Right to freely use, modify, distribute granted
but please acknowledge source as a courtesy if you build upon it.
Please pass on comments, suggestions, problems to jlevy@ibm.net
------------------------------------
Getting Started (See ReadMe.1st)
Program History (See changes.txt)
Use of Command-line options:
   FIX LOG	and	CONDENSE (See ReadMe.1st)
----------------------------------- */

arg ModifyLogFile
/* The following are acceptable command-line
parameters (case is unimportant):
  CONDENSE to remove extraneous lines from
  connection log file

  FIXLOG to pre-pend year to dates which do
  not have a year
Only one of these can be used at a time */

/* --START OF THINGS THAT MAY REQUIRE EDITING FOR SETUP-- 

Customize these five items if you need to.
Don't forget the quotation marks as the equates
(especially the first two) aren't syntactically
correct without them. */

   log_file = 'c:\tcpip\etc\connect.log'
/* Complete path and filespec for the log file */

   output_file = 'c:\tcpip\etc\file.$$$'
/* File you want output saved to */

   Use_VRexx = 'NO'
/* YES = means we prompt for filenames using
VREXX dialog boxes */

   one_screen_atatime = 'YES'
/* Pause as each screen fills up? */

/* Presentation of Results: How represent connection times?
1 = as minutes and hours, e.g., 339.22 mins   5.65 hrs
2 = as hh:mm:ss and hours, e.g., 05:39:13      5.65 hrs
3 or anything else: shows all three ways,
   e.g, 339.22 mins  05:39:13   5.65 hrs */

   presentation = 3

/* ---END OF THINGS THAT MAY REQUIRE EDITING -----

Leading digits for connects, minutes, hours per day or month.
You should not need to change these.  If you exceed 9,999
connects, 9,999,999 minutes, or 999,999 hours per period
you will crash, but then I think you have other problems. */

sig_x = 4
/* Significant figures for connects/day or mo */

sig_min = 7
/* ... for minutes/day or mo */

sig_hr = 6
/* ... for hours/day or month */

'@cls'
What_R_We = 'INETLOG  v'||version '     (c) 1995 by Jerry Levy'

Use_VRexx = translate(Use_VRexx)
/* so we accept upper, lower case yes'es*/

one_screen_atatime = translate(one_screen_atatime)

signal on failure name ErrHandler
signal on halt name ErrHandler
signal on syntax name ErrHandler
/*signal on error name ErrHandler*/ /* we don't use this one */

/*========MAIN PROGRAM=========*/
call LOAD_REXX_UTILS
call INITIALIZE_VARIABLES
call PROMPTING
/* for VRexx2 prompting plus other input/output file manipulations */

if ModifyLogFile = 'TESTFIXEDLOG' then
   do
      say 'Not permitted to use TestFixedLog as a command-line argument.  Exiting...'
      call CLEANUP
   end
if ModifyLogFile = 'FIXLOG' then call FIX_LOG
if ModifyLogFile = 'CONDENSE' then call CONDENSE_LOG
call ANALYZE_LOGFILE
/* gets, calculates, totalizes connect times.  Mostly a
bunch of conditionals with a call to a data-formatting
routine. All is stored in variables for output all at once */

call OUTPUTTER
/* Outputs everything to console and to disk	*/

if ModifyLogFile = TestFixedLog then call LOG_FILE_CLEANUP
/* rename, etc., modified log file */

call CLEANUP			/* EXITS	*/
/*====END OF MAIN PROGRAM=======*/

LOAD_REXX_UTILS:
/* Load the REXXUTIL functions	*/

   call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call sysloadfuncs
RETURN	/* from LOAD_REXX_UTILS	*/

INITIALIZE_VARIABLES:
crlf = d2c(13)||d2c(10)	/* carriage return + linefeed */
Escape = d2c(27)	/* Escape character	*/

/* initialize all of these	*/

month.01 = 'Jan'
month.02 = 'Feb'
month.03 = 'Mar'
month.04 = 'Apr'
month.05 = 'May'
month.06 = 'Jun'
month.07 = 'Jul'
month.08 = 'Aug'
month.09 = 'Sep'
month.10 = 'Oct'
month.11 = 'Nov'
month.12 = 'Dec'

/*  Variables
	signons_each_day	Accumulate number of connects daily
	signons_each_month	Accumulate number of connects monthly
	TimeOn			Time, each connect  (minutes)
	DailyTimeOn		Accumulated minutes, daily
	MonthlyTimeOn		Accumulated minutes, monthly */ 

/*More variables: these we initialize as follows: */
	old_m = 0		/* Storage of a 2-digit month (eg 05 = May) */
	old_d = 0		/* ... and a 2-digit day */ 
	dcounter = 0		/* Counter increments each sign-on in a day */
	mcounter = 0		/* Same for each sign-on in a month */
	monthline = ''	/* Initialize both of these as null strings */
	dayline = ''		/* These are for monthly and daily output strings */

/* A typical line generated in the connect.log upon disconnect looks like
either this for a dialer version preceeding v1.45:
	11/15 19:08:38 Disconnected after 00:06:20  0 errors  0 discards'
or this style for v. 1.45 and later:
	1995/11/15 19:08:38 Disconnected after 00:06:20  0 errors  0 discards
We search for a key_phrase using the RexxUtil function SysFileSearch */

	key_phrase = 'Disconnected after'	/* Word or phrase we'll search for */

RETURN	/* from INITIALIZE_VARIABLES	*/

PROMPTING:
/* Initialize VREXX for prompting, and/or do other input/outout file stuff	*/

if Use_VRexx = 'YES' then
   do						/* Start up VREXX	*/
      '@echo off'
      call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
      initcode = VInit()
      if initcode = 'ERROR' then signal CLEANUP
   end

 if Use_VRexx = 'YES' then	    	/* Select logfile */
      do until result <> ''		/* Don't accept a nonexistent filename */
         call VdialogPos 30, 50
         button = VFileBox('Select Connection Log File to Work On', log_file, filename)
         if button = 'OK' then log_file = filename.vstring
         if button = 'CANCEL' then call CLEANUP

         call stream log_file, 'c', 'query exists'
         if result = '' then
            do
               say log_file 'does not exist, try again!'||crlf
               call beep 1000,100
            end
      end
 
if ModifyLogFile = 'FIXLOG' | ModifyLogFile = 'CONDENSE' then
   do
      output_file_bak = output_file	/* Back up output_file */
      parse var log_file fname '.' ext
      output_file = fname||'.new'	/* Name for a connect.new file we will make   */
		/* Erase any instance of this new file if it exists		*/
      call stream output_file, 'c', 'query exists'
      if result <> '' then call SysFileDelete output_file
   end

 if Use_VRexx = 'YES' then	    	/* Prompt for output filename	*/
      do until result <> ''		/* Don't accept a nonexistent filename	*/
         call VdialogPos 60, 50
         button = VFileBox('MUST ENTER a filename to output results to', output_file, filename)
         if button = 'OK' then file = filename.vstring
         if button = 'CANCEL' then call CLEANUP

/* We don't let you name the output file connect.log, config,sys, or autoexec.bat	*/
               file1 = translate(filespec('name', log_file))
               file2 = translate(filespec('name',file))
               if file2 == CONNECT.LOG | file2 == CONFIG.SYS | file2 == AUTOEXEC.BAT | file2 == file1 then
                  do
                     say translate(log_file) 'and' translate(file)
                     say 'were just entered as log file and output file, respectively.'
                     say 'CONNECT.LOG, CONFIG.SYS, AUTOEXEC.BAT, or the name you select'
                     say 'as the logfile, are all not permitted as output filenames.'
                     say crlf
                     call beep 1000,100
                     result = ''
                  end
              else
                  do
                     result = 'OK'
                     output_file = file
                  end
      end


/* If VRexx is NO, here is where we Check if the output file exists.
If it does, we overwrite it, and if not we create it. BUT....
we don't want to do something stupid like try to erase a vital
file or the connect logfile... */

if Use_Vrexx <> 'YES' then
   do
        call stream log_file, 'c', 'query exists'
         if result = '' then
            do
               say 'Aborting.' log_file 'does not exist.'
               say 'Check for the correct logfile name at the log_file equate in INETLOG.CMD.'
               call beep 1000,100
               call CLEANUP
           end
   end

if Use_VRexx <> 'YES' then
   do
      file1 = translate(filespec('name', log_file))
      file2 = translate(filespec('name', output_file))
      if file2 == CONNECT.LOG | file2 == CONFIG.SYS | file2 == AUTOEXEC.BAT | file2 == file1 then
        do
            say translate(log_file) 'and' translate(output_file)
            say 'were just entered as logfile and output file, respectively.'
            say 'CONNECT.LOG, CONFIG.SYS, AUTOEXEC.BAT, or the name you select'
            say 'as the logfile, are all not permitted as output filenames.'
            say crlf
            call beep 1000,100
            call CLEANUP					/* Error, so Exit	*/
         end
   end

/* Terminate VREXX if we were using it	*/

if Use_VRexx = 'YES' then
   do
      call VExit
      Use_VRexx = 'NO'
/* 'NO', so on eventually exiting the pgm we
don't re-run VExit if we've just run it here */

   end

/* Backup any output file of the same name if it exists, then erase orig. */

        call stream output_file, 'c', 'query exists'
        if result <> '' then
            do
               parse var output_file fname '.' ext
              '@copy' output_file fname||'.bak > NUL'
               call SysFileDelete output_file
            end
RETURN	/* from PROMPTING	*/

ANALYZE_LOGFILE:
/* Now find all lines in connect.log that contain the key_phrase string
A typical line generated in the connect.log after disconnect is
either this for a dialer version preceeding v. 1.45:
	11/15 19:08:38 Disconnected after 00:06:20  0 errors  0 discards
or this style for v. 1.45 and later:
	1995/11/15 19:08:38 Disconnected after 00:06:20  0 errors  0 discards
which we would parse as follows:
	date  word2       word3    word4 connect_time */

call SysFileSearch key_phrase, log_file, 'line.'

RC = 0

DO i = 1 to line.0		/* the END for this "do" is in caps down below*/
   parse var line.i date word2 word3 word4 connect_time remainder

   date2 = right(date,5)	/* Date, excluding year if year is or is not present, is 5 chars: mm/dd */   
      if length(date) > 5 then Year = substr((date), 1, length(date) -6 )||' '	/* space added */
	/* More than mm/dd (5 chars) then year is there.				*/
    	/* length(date) -6 = length of however many characters are used for the	*/
	/* year (4 now (e.g., 1995) but some joker might change it to 2 (e.g., 95)	*/
	/* We then add 1 char for the / separator + 1				*/

       else  Year = '     '	/* If pre v1.45 Dialer, no year, pad 5 spaces */

   mm = substr(date2, 1, 2)	/* Extract the month of a connection as a 2-dig number*/
   dd = substr(date2, 4, 2)	/* ...and the day				*/
   hrs = substr(connect_time, 1, 2)	/* Extract the number of hours on-line*/
   mins = substr(connect_time, 4, 2)	/*... and mins			*/
   secs = substr(connect_time, 7, 2)	/*...and seconds			*/
   if hrs < 0 then call ErrDST	/* hrs is negative */
   if mins < 0 then call ErrDST	/* or mins is negative */
   if secs < 0 then call ErrDST	/* or secs is negative.  Time change error? Abort */

TimeOn = (60*hrs + mins + (1/60)*secs)	/* Calculate time_on for that connection*/

IF old_d = 0 then
   do				/* for very first connection line*/
      old_m = mm
      old_d = dd
      old_y = Year
      signons_each_day = 1			/* reset to 1	*/
      signons_each_month = 1
      DailyTimeOn = TimeOn	/* This and next one are timeons in minutes	*/
      MonthlyTimeOn = TimeOn
   end

ELSE IF old_m = mm & old_d = dd & Month <> 0 then
   do				/* continue to accumulate times if same month and day*/
      old_y = Year
      signons_each_day = signons_each_day + 1
      signons_each_month = signons_each_month + 1
      DailyTimeOn = DailyTimeOn + TimeOn
      MonthlyTimeOn = MonthlyTimeOn + TimeOn
   end

ELSE IF old_m = mm & old_d <> dd then	/* new day of same month	*/
   do
      call prepare_data
      dcounter = dcounter + 1
      Year.dcounter = Year
      Year.mcounter = Year
      dayline.dcounter = Year.dcounter||month.old_m old_d d_signons d_mins d_hhmmss d_hrs

      old_d = dd
      old_y = Year
      signons_each_day = 1			/* Start counting over again	*/
      signons_each_month = signons_each_month + 1
      DailyTimeOn = TimeOn
      MonthlyTimeOn = MonthlyTimeOn + TimeOn
   end

ELSE IF old_m <> mm & old_m <> 0 then
   do		/* for any new month, which by definition is also a new day	*/
      call prepare_data
      dcounter = dcounter + 1
      Year.dcounter = old_y
      dayline.dcounter = Year.dcounter||month.old_m old_d d_signons d_mins d_hhmmss d_hrs

      mcounter = mcounter + 1
      Year.mcounter = old_y
      monthline.mcounter = Year.mcounter||month.old_m m_signons m_mins m_hhmmss m_hrs

      old_m = mm
      old_d = dd
      old_y = Year
      signons_each_day = 1
      signons_each_month = 1
      DailyTimeOn = TimeOn
      MonthlyTimeOn = TimeOn
   end

/* end of all these IF's and ELSE IF's */
 
END	/* of searching for key_phrase in all possible lines in the connect.log */

/* Now,since last day and last month is done: */

         call prepare_data
         dcounter = dcounter + 1
         Year.dcounter = Year
         dayline.dcounter = Year.dcounter||month.old_m old_d d_signons d_mins d_hhmmss d_hrs

         mcounter = mcounter + 1
         Year.mcounter = Year
         monthline.mcounter = Year.mcounter||month.old_m m_signons m_mins m_hhmmss m_hrs

RETURN	/* from ANALYZE_LOGFILE	*/

OUTPUTTER:
/* Now output everything to console and to file		*/

/* get the screen size; rows is what we are interested in	*/

parse value SysTextScreenSize() with rows cols

call stream STDIN, 'c', 'open read'
/* Tell us all	*/
      intro = What_R_We
      say intro
      call lineout output_file, intro
      intro = 'Analysis of' log_file    '('||Date() '@' Time()||')'
      say intro
      call lineout output_file, intro
      say crlf||DAILY TOTALS
      call lineout output_file, crlf||DAILY TOTALS
      do j = 1 to dcounter
         say dayline.j
         call lineout output_file, dayline.j
         if one_screen_atatime = 'YES' then			
            if (j - rows + 6)//(rows - 5) = 0 then
               do
                  say '               Press any key to continue...'		
                 answer = SysGetKey(NOECHO)
               end
      end

      if one_screen_atatime = 'YES' then			
          if (j - rows + 6)//(rows - 5) > 5 then	 /* If at about 5 lines to		*/
					/*a 'Press-Any-Key to continue'...	*/
            do
               say '   Daily Totals done, press any key for Monthlies...'		
               answer = SysGetKey(NOECHO)
               j = 0	/* If decision is to do a 'Press-Any-Key to continue', reset to 0 */
            end

      say crlf||MONTHLY TOTALS
      call lineout output_file, crlf||MONTHLY TOTALS
      do k = 1 to mcounter
         say monthline.k
         call lineout output_file, monthline.k
         if one_screen_atatime = 'YES' then			
            if (k + j - rows + 6)//(rows - 6) = 0 then
               do
                  say '               Press any key to continue...'		
                 answer = SysGetKey(NOECHO)
               end
      end
   finished = crlf||'End of analysis of' log_file
   say finished
   call lineout output_file, finished
RETURN	/* from OUTPUTTER	*/

LOG_FILE_CLEANUP:
call stream log_file, 'c', 'close'
call stream output_file, 'c', 'close'
say 'If everything looks OK, pressing R will rename'
say log_file 'to' log_file_bak

parse var log_file_bak fname '.' ext
'@copy' log_file_bak  fname||'.bak > NUL'
 
say 'The original log file is already backed up'
say 'as' fname||'.bak' crlf
say '               Press R to Rename or any other key to exit...'		
if translate(SysGetKey(NOECHO)) = "R" then

/* Remember: log_file_bak is the original connect logfile name
and log_file is now the .NEW connect log we just created	*/
do
   '@copy' log_file log_file_bak '> NUL'
   call stream log_file, 'c', 'query exists'
   if result <> '' then call SysFileDelete log_file
end
RETURN	/* from LOG_FILE_CLEANUP */

PREPARE_DATA:
/* Calculates.  Also formats what is to be put into an output line*/
 
/* Signons per day or month, as, e.g.: '4X' */
   d_signons =format(signons_each_day, sig_x)||'X'
   m_signons = format(signons_each_month, sig_x)||'X'

/* Minutes/day, minutes/month, hrs/day, hrs/month as, e.g.: '105.50 mins or hrs' */
   d_mins = format(DailyTimeOn, sig_min, 2) 'mins'
   d_hrs = format((DailyTimeOn/60), sig_hr, 2) 'hrs'
   m_mins = format(MonthlyTimeOn, sig_min, 2) 'mins'
   m_hrs = format((MonthlyTimeOn/60), sig_hr, 2) 'hrs'

/* minutes, seconds per day or month, as 2-digit numbers; hrs can exceed 2 digs */  
   dy_hh = format(trunc(DailyTimeOn/60),sig_hr)			
   dy_mm = right(trunc(DailyTimeOn//60),2,'0')
   dy_ss = right(trunc(60*((DailyTimeOn//60) - trunc(DailyTimeOn//60))),2,'0')
   mo_hh = format(trunc(MonthlyTimeOn/60),sig_hr)
   mo_mm = right(trunc(MonthlyTimeOn//60),2,'0')
   mo_ss = right(trunc(60*((MonthlyTimeOn//60) - trunc(MonthlyTimeOn//60))),2,'0') 

/* hours, minutes, seconds per day or month, as, e.g.: '1:45:30'*/  
   d_hhmmss = '  '||dy_hh||':'||dy_mm||':'||dy_ss
   m_hhmmss = '  '||mo_hh||':'||mo_mm||':'||mo_ss

/* note that setting presentation = anything but 1 or 2 shows both	 time formats */


   if presentation = 1 then
      do			/* Do not show hhmmss format */
         d_hhmmss = ''
         m_hhmmss = ''
      end

   if presentation = 2 then
      do			/* Do not show regular mins format */
         d_mins = ''
         m_mins = ''
      end
RETURN

CONDENSE_LOG:
log_file_bak = log_file		/* Save this filespec */
call SysFileSearch key_phrase, log_file, 'line.'
RC = 0
do i = 1 to line.0
   call LineOut output_file, line.i	/* write line to disk	*/
end
call stream log_file, 'c', 'close'
call stream output_file, 'c', 'close'
log_file = output_file		/* Use output_file that we just created from Fix_Log as the log file */
output_file = output_file_bak	 /* Restore this as file to output to */
ModifyLogFile = TestFixedLog	/* Run the main routine to do test new connection log */
call SysCls
say 'The conversion is done.'
say crlf
say log_file 'is the condensed connection log file.'
say 'We will now test it.  Please evaluate whether'
say 'the data being spit out are reasonable.  The output will'
say 'also be saved to disk as' output_file
say 'which can be examined with the System Editor.'
say 'If you want to quit now, press ESCAPE.'
say 'Otherwise, press any other key to run the test.'
if SysGetKey(NOECHO) = Escape then call CLEANUP
call SysCls
say 'Starting the analysis of' log_file 'as the log file.'
call SysSleep 2			/* Let us read the message	*/

/* Back up any output file of the same name if it exists, then erase orig. */
call stream output_file, 'c', 'query exists'
   if result <> '' then
      do
         parse var output_file fname '.' ext
         '@copy' output_file fname||'.bak > NUL'
         call SysFileDelete output_file
     end
RETURN	/* from CONDENSE_LOG	*/

FIX_LOG:
/* Fix log file to insert (pre-pend) a year when
needed to conform to connection logfile style for
Dialer v. 1.33, 1.45 and beyond */

call SysCLS
log_file_bak = log_file		/* Save this filespec */
 say 'The Advantis Internet Dialer beginning with v4.5 has the year as '
say 'part of the date stamp.  Dialer v4.5 inserts into the connection log'
say 'file dates in the format of 1995/06/13 instead of 06/13 as'
say 'previously for a date such as Jun 13, 1995.  This present version'
say 'of INETLOG will work with connection logs having old new, or'
say 'mixed date formats.'
say 'The subroutine you are now running will update datestamps in your'
say 'connection logfile to the v4.5 style.  Then instead of showing years'
say 'for just some entries, the year shows in the output for ALL entries.' 
say crlf
say 'You will be prompted to enter the year you first used the dialer, which'
say 'will be the year of the first entry made in your connection log file.'
say 'This routine will attach (i.e., pre-pend) that year to each date in the'
say 'connection log file until roll-over to the next year, wherupon the year'
say 'that we pre-pend is incremented by 1.  You will be prompted for the'
say 'starting year.'
say crlf
say 'If you want to quit now, press ESCAPE.  To proceed, hit any other key.' crlf
if SysGetKey(NOECHO) = Escape then call CLEANUP

do until RetCode = 0
   say 'Enter the starting year as a 4-digit number (Q to quit):'
   pull Year
   if Year = 'Q' | Year = 'q' then call CLEANUP
   if Year > 9999 | Year < 1000 | datatype(Year) \= 'NUM' then
      do
         say 'Not right number of characters or non-numeric entry.  Try again.'
         RetCode = 1
      end
   else RetCode = 0
end
 
say 'This may take some time, please be patient...'

Year = Year - 1
mm_old = 13
do until Lines(log_file) = 0
   DataLine = LineIn(log_file) 	/* Get a line	*/
   date = word(Dataline, 1)		/* The date should be the first word */
   if length(date) = 5 & substr(date, 3, 1) == '/' then
/* This line is our baby, since word 1 is in form mm/dd */

      do
         mm = substr(date, 1, 2) /* Determine if we should we increment the year */
         if mm < mm_old then Year = Year + 1  /* month (as number) should increase unless year changes*/ 
         mm_old = mm
         DataLine = Year||'/'||DataLine	/* Pre-pend the year and the / to the line*/
         call LineOut output_file, DataLine	/* write line to disk	*/
     end
   else call LineOut output_file, DataLine
end
call stream log_file, 'c', 'close'
call stream output_file, 'c', 'close'
log_file = output_file		/* Use output_file that we just created from Fix_Log as the log file */
output_file = output_file_bak	 /* Restore this as file to output to */
ModifyLogFile = TestFixedLog	/* Run the main routine to do test new connection log */
call SysCls
say 'The conversion is done.'
say crlf
say log_file 'is the new year-modified connection'
say 'log file. We will now test it.  Please evaluate whether'
say 'the data being spit out are reasonable.  The output will'
say 'also be saved to disk as' output_file
say 'which can be examined with the System Editor.'
say 'If you want to quit now, press ESCAPE.'
say 'Otherwise, press any other key to run the test.'
if SysGetKey(NOECHO) = Escape then call CLEANUP
call SysCls
say 'Starting the analysis of' log_file 'as the log file.'
call SysSleep 2			/* Let us read the message	*/

/* Back up any output file of the same name if it exists, then erase it	*/
call stream output_file, 'c', 'query exists'
   if result <> '' then
      do
         parse var output_file fname '.' ext
         '@copy' output_file fname||'.bak > NUL'
         call SysFileDelete output_file
     end
RETURN

ErrDST:                         /* If error due to time change */
say 'INETLOG has found a negative number for time-on-line'
say 'in an entry in your' log_file 'file.'
say ''
say 'You may have reset your clock backwards while on line, e.g.,'
say 'while changing from Summer time (Daylight Saving Time) to'
say 'Winter time (Standard time).'
say ''
say 'To fix:  1.  Open' log_file 'in your System Editor'
say '2.  edit any connection time(s) that have a minus sign.'
say 'Example (for a typical one-hour summer-to-winter time correction):'
say '   change'
say '1995/10/29 06:26:43 Disconnected after -00:-58:-4  0 errors  0 discards'
say '   to'
say '1995/10/29 06:26:43 Disconnected after 00:01:56  0 errors  0 discards'
say ''
say 'If the error was not from a summer-time change, make whatever'
say 'correction seems reasonable to eliminate the offending minus'
say 'signs (like just removing them).'
say ''
say '     Aborting...'
call CLEANUP
RETURN

ErrHandler:
call beep 300, 500
say 'Rexx error' rc 'in line' sigl||':' errortext(rc)
say sourceline(sigl)

CLEANUP:
/* Exit.  Also terminate VREXX if we are using it
and if it has not already been removed */

   if Use_VRexx = 'YES' then call VExit
   say 'Press any key to exit...'		
   answer = SysGetKey(NOECHO)
   EXIT
RETURN	/* for CLEANUP	*/