/* Message translation utility for The Internet Connection and Maximus BBS
   Copyright (c) 1995, Mark Williamson
*/

#include <io.h>
#include <share.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <dos.h>
#include <stdio.h>
#include <stdarg.h>
void strcatf(char *s, char *format,...);
char *makepath(char *path, char *filename);
char *strrep(char *str, char *oldstr, char *newstr);
char *trim(char *str);
void strrepl(char *string, char oldchr, char newchr);

void main(int argc,char *argv[])
{
   FILE *fp;
   char buffer[120],msginf[550];
   char line[120];
   int x;
   argc=argc;
   if(argv[1]==NULL) return;
   fp=_fsopen(argv[1],"rt",SH_DENYNO);
   if(fp==NULL) return;
   strcpy(msginf,"");
   while(!feof(fp))
   {
      if(fgets(buffer,119,fp)==NULL) break;
      trim(buffer);
      if(strncmpi(buffer,"Area",4)==0)
      {
         buffer[(strstr(buffer,"Msg#")-buffer)-2]=0;
         strcatf(msginf,"%s\n",buffer+5);
      }
      if(strncmpi(buffer,"From:",5)==0)
      {
         buffer[strstr(buffer," (")-buffer]=0;
         strcatf(msginf,"%s\n",buffer+6);
      }
      if(strncmpi(buffer,"To:",3)==0)
      {
         buffer[strstr(buffer," (")-buffer]=0;
         strcatf(msginf,"%s\n",buffer+4);
      }
      if(strncmpi(buffer,"Subject:",8)==0)
      {
         strcatf(msginf,"%s\n",buffer+9);
         break;
      }
   }

   fclose(fp);
   fp=_fsopen(argv[2],"wt",SH_DENYNONE);
   if(fp==NULL) return;
   fprintf(fp,"%s",msginf);
   fclose(fp);
}


void strrepl(char *string, char oldchr, char newchr)
{
	while (*string != NULL)
	{
		if (*string == oldchr)
			 *string = newchr;
		string++;
	}
	return;
}

char *strrep(char *str, char *oldstr, char *newstr)
{
	int OldLen, NewLen;
	char *p, *q;
	if (NULL == (p = strstr(str, oldstr)))
		return p;
	OldLen = strlen(oldstr);
	NewLen = strlen(newstr);
	memmove(q = p + NewLen, p + OldLen, strlen(p + OldLen) + 1);
	memcpy(p, newstr, NewLen);
	return q;
}

char *trim(char *str)
{
	char *ibuf = str, *obuf = str;
	int i = 0, cnt = 0;
	/*
	 * *  Trap NULL 
	 */

	if (str)
	{
		/*
		 * *	Remove leading spaces (from RMLEAD.C) 
		 */

		for (ibuf = str; *ibuf && isspace(*ibuf); ++ibuf)
			;
		if (str != ibuf)
			memmove(str, ibuf, ibuf - str);
		/*
		 * *	Collapse embedded spaces (from LV1WS.C)
		 */

		while (*ibuf)
		{
			if (isspace(*ibuf) && cnt)
				ibuf++;
			else
			{
				if (!isspace(*ibuf))
					cnt = 0;
				else
				{
					*ibuf = ' ';
					cnt = 1;
				}
				obuf[i++] = *ibuf++;
			}
		}
		obuf[i] = NULL;
		/*
		 * *	Remove trailing spaces (from RMTRAIL.C) 
		 */

		while (--i >= 0)
		{
			if (!isspace(obuf[i]))
				break;
		}
		obuf[++i] = NULL;
	}
	return str;
}

void strcatf(char *s, char *format,...)
{
	char string[1512];
	va_list arg_pointer;
	va_start(arg_pointer, format);
	vsprintf(string, format, arg_pointer);
	va_end(arg_pointer);
	strcat(s, string);
	return;
}

char *makepath(char *path, char *filename)
{
	static char fullname[80];
	if (strlen(path) == 0)
	{
		strcpy(fullname, filename);
		return (fullname);
	}

	strcpy(fullname, path);	/* store directory */
	/* add trailing backslash if none */
	if (fullname[strlen(fullname) - 1] != '\\')
	{
		strcat(fullname, "\\");
	}


	strcat(fullname, filename);	/* add filename to end */
	return (fullname);
}
