unit Winveru;
{It's not EASY to get the precise Windows version, when
 you have to account for Windows, W4WG, Windows 95, and
 Windows NT. The WindowsVersion function does the job, though
 it can only report the WOW layer version in Windows NT, not
 the actual NT version}

interface

PROCEDURE WindowsVersion(VAR Platform, Version : Word;
  VAR Enhanced : Boolean);

FUNCTION WinVerString(VAR Platform, Version : Word;
  VAR Enhanced : Boolean) : String;

CONST (* FIG05.TXT *)
  WINVER_WIN31 = 0;
  WINVER_311_W4WG = 1;
  WINVER_311 = 2;
  WINVER_W4WG = 3;
  WINVER_NT = 4;
  WINVER_95 = 5;
  WINVER_EXCEPT = 6;

implementation
uses WinTypes, WinProcs, Ver, SysUtils;

TYPE
  DPMIRegisters = RECORD
    edi, esi, ebp, reserved, ebx, edx, ecx, eax : LongInt;
    flags, es, ds, fs, gs, ip, cs, sp, ss : Word;
  END;

  FUNCTION DPMIRealInterrupt(IntNo, CopyWords : Word;
    VAR R : DPMIRegisters) : Boolean; Assembler;
  ASM
    MOV AX,0300h
    MOV BX,IntNo
    MOV CX,CopyWords
    LES DI,R
    INT 31h
    JC @Error
    MOV AX,1
    JMP @Done
    @Error:
    XOR AX,AX
    @Done:
  END;


PROCEDURE WindowsVersion(VAR Platform, Version : Word;
  VAR Enhanced : Boolean); (* FIG05.TXT *)
{Platform matches one of the WINVER_xxxx constants
 Version has major/minor in high/low bytes}

  FUNCTION ResourceVersion : Word;
  {Returns file version from version resource, or 0
   if can't get. Both Windows for Workgroups 3.11 and
   plain Windows 3.11 show "3.11" in the version resource}
  VAR
    VerBuffSize   : LongInt;
    VerBuffHandle : LongInt;
    VerBuff       : PChar;
    VerBuffStrg   : String;
    VerPosLoc     : Byte;
    VerNumBuff    : ARRAY[0..5] OF Char;
    WinVerS       : String[4];
  BEGIN
    Result := 0;
    {check version number in resource}
    VerBuffSize := GetFileVersionInfoSize('USER.EXE', VerBuffHandle);
    IF VerBuffSize = 0 THEN Exit;
    GetMem(VerBuff, VerBuffSize+1);
    try try
      IF GetFileVersionInfo('USER.EXE', VerBuffHandle,
           VerBuffSize, VerBuff) THEN
        BEGIN
          VerBuffStrg[0] := #255;
          Move(VerBuff^, VerBuffStrg[1], 255);
          VerPosLoc := Pos('FileVersion', VerBuffStrg);
          IF VerPosLoc = 0 THEN Exit;
          WinVerS := Copy(VerBuffStrg, VerPosLoc+12, 4);
          Result := StrToInt(Copy(WinVerS, 3, 2)) SHL 8
            + StrToInt(Copy(WinVerS, 1, 1));
        END;
    finally
      FreeMem(VerBuff, VerBuffSize+1);
    end;
    except
      {If an exception occurs, forget it}
      On Exception DO
    end;
  END;

  FUNCTION DPMIVersion : Word;
  {get the Windows version the way a DOS program would.
   W4WG tells the truth; Windows 3.11 lies}
  VAR R : DPMIRegisters;
  BEGIN
    Result := 0;
    IF GetWinFlags AND WF_PMODE = 0 THEN Exit;
    FillChar(R, SizeOf(R), 0);
    R.eax := $160A;
    IF DPMIRealInterrupt($2F, 0, R) THEN
      Result := R.ebx;
    Result := Swap(Result);
  END;

VAR
  GetVer, ResVer, DPMIVer : Word;
BEGIN
  GetVer   := LoWord(GetVersion);
  Version  := GetVer;
  Platform := WINVER_WIN31;
  IF GetWinFlags AND $4000 > 0 THEN
    Platform := WINVER_NT
  ELSE IF Word(LoByte(GetVer)) SHL 8 + HiByte(GetVer) > $350 THEN
    Platform := WINVER_95
  ELSE
    BEGIN
      ResVer  := ResourceVersion;
      DPMIVer := DPMIVersion;
      {If the reported version is 3.10 but the resource version
       is 3.11, then this is either 3.11 or W4WG}
      IF GetVer = $A03 THEN
        CASE ResVer OF
          $A03 : ; {a match - plain Windows 3.1}
          $B03 : Platform := WINVER_311_W4WG;
          0    : Platform := WINVER_311_W4WG;
        END;
      {If the DPMI version lies, it's 3.11; if it's
       true it's W4WG}
      IF Platform = WINVER_311_W4WG THEN
        BEGIN
          Version := $B03;
          CASE DPMIVer OF
            $A03 : Platform := WINVER_311;
            $B03 : Platform := WINVER_W4WG
          END;
        END;
    END;
  CASE Platform OF
    WINVER_WIN31,
    WINVER_311,
    WINVER_W4WG : Enhanced := GetWinFlags AND WF_ENHANCED > 0;
    ELSE Enhanced := TRUE;
  END;
END;

FUNCTION WinVerString(VAR Platform, Version : Word;
  VAR Enhanced : Boolean) : String;
BEGIN
  WindowsVersion(Platform, Version, Enhanced);
  CASE Platform OF
    WINVER_311,
    WINVER_WIN31    : Result :=
      Format('Windows %d.%.2d', [LoByte(Version), HiByte(Version)]);
    WINVER_W4WG     : Result :=
      Format('Windows for Workgroups %d.%.2d', [LoByte(Version), HiByte(Version)]);
    WINVER_NT       : Result :=
      Format('Windows NT, WOW %d.%.2d', [LoByte(Version), HiByte(Version)]);
    WINVER_95       : Result :=
      Format('Windows 95  %d.%.2d', [LoByte(Version), HiByte(Version)]);
    ELSE Result :=
      ('Unknown Windows version');
  END;
END;

end.
