UNIT TextLoc;
(**) INTERFACE (**)

  FUNCTION TFilePos(VAR F : Text) : LongInt;
  PROCEDURE TSeek(VAR F : Text; SeekLoc : LongInt);
  FUNCTION TFileSize(var F : Text) : LongInt;

(**) IMPLEMENTATION (**)
USES SysUtils;

  FUNCTION TFilePos(VAR F : Text) : LongInt;
  VAR
    Adjust  : Word;
    CurrPos : LongInt;
  BEGIN
    IF TTextRec(F).Mode <> fmInput THEN
      BEGIN
        InOutRes := 104; {file not open for input}
        Exit;
      END;
    ASM
      MOV AH, 42h     {move file pointer}
      MOV AL, 01h     {relative to current position}
      XOR CX, CX
      XOR DX, DX      {zero offset in CX:DX}
      LES DI, F
      MOV BX, ES:[DI] {first word is handle}
      INT 21h
      JNC @ok
      MOV InOutRes, AX
      RET
      @ok:
      MOV Word(@Result), AX
      MOV Word(@Result+2), DX  {result is ready}
      LES DI, F
      {subtract unread portion
       of buffer from result}
      MOV BX, TTextRec(ES:[DI]).BufEnd
      SUB BX, TTextRec(ES:[DI]).BufPos
      SUB Word(@Result), BX
      SBB Word(@Result+2), 0
    END;
  END;

  PROCEDURE TSeek(VAR F : Text; SeekLoc : LongInt);
  VAR CurrPos : LongInt;
  BEGIN
    IF TTextRec(F).Mode <> fmInput THEN
      BEGIN
        InOutRes := 104; {file not open for input}
        Exit;
      END;
    ASM
      MOV AH, 42h      {"move file pointer"}
      MOV AL, 01h      {relative to current position}
      XOR CX, CX
      XOR DX, DX       {zero offset in CX:DX}
      LES DI, F
      MOV BX, ES:[DI]  {first word is handle}
      INT 21h
      JNC @ok
      MOV InOutRes, AX
      RET
      @ok:
      MOV Word(CurrPos), AX
      MOV Word(CurrPos+2), DX {got current position}
    END;
    {-- IF the position we want is already  --}
    {-- in the TTextRec's buffer, use it!    --}
    {-- Otherwise, seek to the desired spot --}
    Dec(CurrPos, TTextRec(F).BufEnd);
    CurrPos := SeekLoc - CurrPos;
    IF (CurrPos >= 0) AND
       (CurrPos < TTextRec(F).BufEnd) THEN
      TTextRec(F).BufPos := CurrPos
    ELSE
      BEGIN
        ASM
          MOV AH, 42h   {move file pointer}
          MOV AL, 0h    {absolute from start of file}
          MOV CX, Word(SeekLoc+2)
          MOV DX, Word(SeekLoc)     {location in CX:DX}
          LES DI, F
          MOV BX, ES:[DI]  {first word is handle}
          INT 21h
          JNC @ok
          MOV InOutRes, AX
          RET
          @ok:
        END;
      TTextRec(F).BufPos := 0;  {must re-read buffer}
      TTextRec(F).BufEnd := 0;
    END;
  END;

  FUNCTION TFileSize(var F : Text) : LongInt;
  VAR CurrPos : LongInt;
  BEGIN
    IF TTextRec(F).Mode <> fmInput THEN
      BEGIN
        InOutRes := 104; {file not open for input}
        Exit;
      END;
    {FIRST get current position}
    ASM 
      MOV AH, 42h     {move file pointer}
      MOV AL, 01h     {relative to current position}
      XOR CX, CX
      XOR DX, DX      {zero offset in CX:DX}
      LES DI, F
      MOV BX, ES:[DI]  {first word is handle}
      INT 21h
      JNC @ok
      MOV InOutRes, AX
      RET
      @ok:
      MOV Word(CurrPos), AX
      MOV Word(CurrPos+2), DX  {got current position}
    END;
    {SECOND move to end of file}
    ASM
      MOV AH, 42h     {move file pointer}
      MOV AL, 02h     {relative to end of file}
      XOR CX, CX
      XOR DX, DX      {zero offset in CX:DX}
      LES DI, F
      MOV BX, ES:[DI]  {first word is handle}
      INT 21h
      JNC @ok
      MOV InOutRes, AX
      RET
      @ok:
      MOV Word(@Result), AX
      MOV Word(@Result+2), DX  {result is ready}
    END;
    {THIRD go back to where you were}
    ASM 
      MOV AH, 42h   {move file pointer}
      MOV AL, 0h    {absolute from start of file}
      MOV CX, Word(CurrPos+2)
      MOV DX, Word(CurrPos) {location in CX:DX}
      LES DI, F
      MOV BX, ES:[DI]  {first word is handle}
      INT 21h
      JNC @ok
      MOV InOutRes, AX
      RET
      @ok:
    END;
  END;

END.
