{$K+}
LIBRARY FileCdrL; (* FIG08.TXT *)
USES WinTypes, WinProcs;
CONST
  WM_FILESYSCHANGE = $0034;
  hWndInUse        : hWnd = 0;

  FUNCTION FileCdr(FILECDRPROC : TFarProc) : LongInt; FAR;
    EXTERNAL 'KERNEL' Index 130;

  PROCEDURE FileCdrProc(wActionCode : Word; lpszPath : PChar);Export;
  BEGIN
    SendMessage(hWndInUse, WM_FILESYSCHANGE, Hi(wActionCode),
      LongInt(lpszpath));
  END;

  FUNCTION FileCdrInstall(H : hWnd) : Bool; Export;
  BEGIN
    FileCdrInstall := FALSE;
    IF hWndInUse <> 0 THEN Exit;
    IF NOT Bool(LoWord(FileCdr(@FileCdrProc))) THEN Exit;
    hWndInUse := H;
    FileCdrInstall := TRUE;
  END;

  FUNCTION FileCdrUninstall(H : hWnd) : Bool; Export;
  BEGIN
    FileCdrUninstall := FALSE;
    IF hWndInUse = 0 THEN Exit;
    IF hWndInUse <> H THEN Exit;
    FileCdr(NIL);
    hWndInUse  := 0;
    FileCdrUninstall := TRUE;
  END;


EXPORTS
  FileCdrInstall     INDEX 1,
  FileCdrUnInstall   INDEX 2;
BEGIN
END.
