unit Fexetype;
{INCTRL 2 needs to know what kind of executable the
 install program is - DOS executable, Windows executable,
 or DOS batch file. The ExeType function makes that
 determination, and ExeTypeName returns a matching name
 for each type. As a bonus, the IsCdRom function tells if
 a given drive is a CD-ROM.}

interface
FUNCTION ExeType(const TheName : String) : Integer;
FUNCTION ExeTypeName(typ : Integer) : String;
FUNCTION IsCdRom(DriveNum : Word) : Boolean;

CONST
  ET_UNKNOWN  = -5;
  ET_NODISK   = -4;
  ET_NOTEXE   = -3;
  ET_EXCEPT   = -2;
  ET_NOEXIST  = -1;
  ET_BLANK    = 0;
  ET_DOSEXE   = 1;
  ET_COM      = 2;
  ET_BAT      = 3;
  ET_WINEXE   = 4;
  ET_PEXE     = 5;

implementation
Uses SysUtils, WinProcs, WinTypes;

FUNCTION ExeType(const TheName : String) : Integer;
CONST
  WasName : String = '';
  WasRslt : Integer = 0;
VAR
  FileName     : String;
  F            : File;
  OldFileMode  : Byte;
  OldErrMode   : Word;
  Signature, W : Word;
  Ext          : String[4];
BEGIN
  Filename := TheName;
  W := Pos(' ', Filename);
  IF W > 0 THEN Filename := Copy(Filename, 1, W-1);
  IF Filename = WasName THEN
    BEGIN
      {If we've already checked this file, return
       the same result!}
      Result := WasRslt;
      Exit;
    END;
  OldErrMode := SetErrorMode(SEM_FAILCRITICALERRORS);
  IF NOT FileExists(FileName) THEN
    BEGIN
      Result := ET_NOEXIST;
      WasRslt := Result;
      Exit;
    END;
  SetErrorMode(OldErrMode);
  OldFileMode := FileMode;
  FileMode := 0; {read-only}
  try
    AssignFile(F, Filename);
    try
      Reset(F, 1);
      BlockRead(F, Signature, 2);
      IF Signature = $5A4D {MZ} THEN
        BEGIN
          Result := ET_DOSEXE; {but may be Win exe}
          WasRslt := Result;
          try
            Seek(F, $18);
            BlockRead(F, W, 2);
            IF W >= $40 THEN
              BEGIN
                Seek(F, $3C);
                BlockRead(F, W, 2);
                Seek(F, W);
                BlockRead(F, W, 2);
                IF W = $454E THEN
                  Result := ET_WINEXE
                ELSE IF W = $4550 THEN
                  Result := ET_PEXE;
              END;
          except
            On Exception DO
            {don't worry about exceptions}
          end;
        END
      ELSE
        BEGIN
          Ext := Uppercase(ExtractFileExt(Filename));
          IF Ext = '.COM' THEN
            Result := ET_COM
          ELSE IF Ext = '.BAT' THEN
            Result := ET_BAT
          ELSE Result := ET_NOTEXE;
        END;
    finally
      CloseFile(F);
      FileMode := OldFileMode;
      WasRslt := Result;
    end;
  except
    ON Exception DO
      BEGIN
        Result := ET_EXCEPT;
        WasName := '';
        WasRslt := 0;
      END;
  end;
END;

FUNCTION ExeTypeName(typ : Integer) : String;
BEGIN
  CASE typ OF
    ET_BLANK    : Result := '(two phase operation)';
    ET_DOSEXE   : Result := 'DOS EXE file';
    ET_WINEXE   : Result := 'Windows Executable';
    ET_PEXE     : Result := '32-bit Windows Executable';
    ET_COM      : Result := 'DOS COM file';
    ET_BAT      : Result := 'DOS batch file';
    ET_NOTEXE   : Result := 'Not an executable file';
    ET_EXCEPT   : Result := 'Error accessing file';
    ELSE          Result := '';
  END;
END;

FUNCTION IsCdRom(DriveNum : Word) : Boolean;
{Based on an article in the Microsoft Developers
 Network CD-ROM}
VAR F : WordBool;
BEGIN
  ASM
      mov ax, 1500h      { first test for presence of MSCDEX }
      xor bx, bx
      int 2fh
      mov ax, bx         { MSCDEX is not there if bx is zero }
      or  ax, ax         { ...so return FALSE }
      jz  @no_mscdex
      mov ax, 150bh      { MSCDEX driver check API }
      mov cx, DriveNum     { ...cx is drive index }
      int 2fh
@no_mscdex:
      mov f,ax
  END;
  Result := F;
END;

end.
