unit Aboutbox;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TAboutForm = class(TForm)
    LabelUserName: TLabel;
    LabelCompName: TLabel;
    LabelWinVer: TLabel;
    LabelDOSVer: TLabel;
    LabelWinMode: TLabel;
    ValueMemory: TLabel;
    ValueMathCo: TLabel;
    ValueFSRs: TLabel;
    Bevel1: TBevel;
    Image1: TImage;
    BitBtn1: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutForm: TAboutForm;

implementation
Uses WinVerU, Inifiles;
{$R *.DFM}
procedure TAboutForm.FormCreate(Sender: TObject);
VAR
  WinVer, WinFlags : LongInt;
  hInstUser        : Word;
  {at least 40 in NT; NT setup accepts 46}
  Buffer           : ARRAY[0..46] OF Char;
  vPlatform,
  vVersion         : Word;
  vEnhanced        : Boolean;
begin
  Image1.Picture.Graphic := Application.Icon;
  WinVer := GetVersion;
  LabelWinVer.Caption := WinVerString(vPlatform, vVersion, vEnhanced);
  LabelDosVer.Caption := Format('DOS %u.%.2u',
    [HiByte(HiWord(WinVer)), LoByte(HiWord(WinVer))]);
  {Get user name and company name from SERIALNO.INI
   (present with Windows for Workgroups)}
  WITH TIniFile.Create('SERIALNO.INI') DO
    try
      LabelUserName.Caption := ReadString('mswindows', 'username', '');
      LabelCompName.Caption := ReadString('mswindows', 'company', '');
    finally
      Free;
    end;
  {If failed to get user name or company name, read them
   from the string resources of USER.EXE}
  IF (LabelUserName.Caption = '') OR (LabelCompName.Caption = '') THEN
    BEGIN
      hInstUser := LoadLibrary('USER');
      FreeLibrary(hInstUser);
      LoadString(hInstUser, 514, Buffer, 46);
      LabelUserName.Caption := StrPas(Buffer);
      LoadString(hInstUser, 515, Buffer, 46);
      LabelCompName.Caption := StrPas(Buffer);
    END;
  WinFlags := GetWinFlags;
  IF vEnhanced THEN
    LabelWinMode.Caption := '386 Enhanced Mode'
  ELSE IF WinFlags AND WF_PMODE > 0 THEN
    LabelWinMode.Caption := 'Standard Mode'
  ELSE LabelWinMode.Caption := 'Real Mode';
  IF WinFlags AND WF_80x87 > 0 THEN
    ValueMathCo.Caption := 'Present'
  ELSE ValueMathCo.Caption := 'Absent';
END;

procedure TAboutForm.FormActivate(Sender: TObject);
begin
  ValueFSRs.Caption := Format(
    '%d%% Free', [GetFreeSystemResources(
      GFSR_SYSTEMRESOURCES)]);
  ValueMemory.Caption := FormatFloat(',#######',
    MemAvail DIV 1024) + ' KB Free';
end;


end.
