unit IncReg;
{******************************************************************************}
{                                                                              }
{                           IMPORTANT NOTICE                                   }
{                                                                              }
{          (c) Copyright 1996 by Softouch Development Incorporated             }
{                                                                              }
{                         ALL RIGHTS RESERVED                                  }
{                                                                              }
{       Software and documentation are the confidential property and           }
{       contain trade secrets of Softouch Development Incorporated.            }
{       Any copying, use, disclosure, modification, or transfer by rental,     }
{       sale, or otherwise without the written consent of Softouch             }
{       Development Incorporated is strictly prohibited.                       }
{                                                                              }
{       Portions may be Copyright (c) 1995 Borland International.              }
{       All restriction apply.                                                 }
{******************************************************************************}
{  IncBase    - Main base class of all Incremental Combos.                     }
{  IncCombo   - Your basic incremental combo with a list box of items.         }
{  IncDBCombo - Your basic DataAware incremental combo with list box of items. }
{  IncDBSrc   - Incremental Combo that is used to navigate a DataSet.          }
{  IncDBLup   - DataAware Incremental Lookup Combo.                            }
{******************************************************************************}
{                                                                              }
{  Problem Log                                                                 }
{  03/14/96  Started problem log                                               }
{                                                                              }
{******************************************************************************}
interface

uses
	{$IFDEF Win32}
	Windows,
	{$ELSE}
	Forms,
	{$ENDIF}
	Classes, DsgnIntf, Dialogs, Controls, IncAbout, IncBase, IncCombo, IncDBCmb, IncDBSrc, IncDBLup,
	DBTables;

type
	TIncComboAboutBox = class(TComponentEditor)
	procedure ExecuteVerb(Index: Integer); override;
	function GetVerb(Index: Integer): string; override;
	function GetVerbCount: Integer; override;
	end;

  TDBStringProperty = class(TStringProperty)
  public
	 function GetAttributes: TPropertyAttributes; override;
	 procedure GetValueList(List: TStrings); virtual; abstract;
	 procedure GetValues(Proc: TGetStrProc); override;
  end;

  TLookupIndexProperty = class(TDBStringProperty)
  public
	 procedure GetValueList(List: TStrings); override;
  end;

  TSearchIndexProperty = class(TDBStringProperty)
  public
	 procedure GetValueList(List: TStrings); override;
  end;

procedure Register;

implementation

procedure TIncComboAboutBox.ExecuteVerb(Index: Integer);
var IncAboutBox: TIncAboutBox;
begin
	IncAboutBox := TIncAboutBox.Create(Application);
	IncAboutBox.ShowModal;
	IncAboutBox.Destroy;
end;

function TIncComboAboutBox.GetVerb(Index: Integer): string;
begin
  Result := 'About...';
end;

function TIncComboAboutBox.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
	Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
I: Integer;
Values: TStringList;
begin
	Values := TStringList.Create;
	try
		GetValueList(Values);
		for I := 0 to Values.Count - 1 do Proc(Values[I]);
	finally
		Values.Free;
	end;
end;

procedure TLookupIndexProperty.GetValueList(List: TStrings);
begin
	with (GetComponent(0) as TDBIncLookupCombo) do
		begin
		if (LookupSource <> Nil) and (LookupSource.DataSet <> Nil)
		and LookupSource.DataSet.InheritsFrom(TTable) then
			TTable(LookupSource.DataSet).GetIndexNames(List);
		end;
end;

procedure TSearchIndexProperty.GetValueList(List: TStrings);
begin
	with (GetComponent(0) as TDBIncSearchCombo) do
		begin
		if (LookupSource <> Nil) and (LookupSource.DataSet <> Nil)
		and LookupSource.DataSet.InheritsFrom(TTable) then
			TTable(LookupSource.DataSet).GetIndexNames(List);
		end;
end;

procedure Register;
begin
  RegisterComponentEditor(TIncCombo        ,TIncComboAboutBox);
  RegisterComponentEditor(TDBIncCombo      ,TIncComboAboutBox);
  RegisterComponentEditor(TDBIncLookupCombo,TIncComboAboutBox);
  RegisterComponentEditor(TDBIncSearchCombo,TIncComboAboutBox);
  RegisterComponents('IncCombos',[TIncCombo]);
  RegisterComponents('IncCombos',[TDBIncCombo]);
  RegisterComponents('IncCombos',[TDBIncLookupCombo]);
  RegisterComponents('IncCombos',[TDBIncSearchCombo]);
  RegisterPropertyEditor(TypeInfo(string),TDBIncSearchCombo,'LookupIndex',TSearchIndexProperty);
  RegisterPropertyEditor(TypeInfo(string),TDBIncLookupCombo,'LookupIndex',TLookupIndexProperty);
end;


end.
