#include <owl\owlpch.h>
#pragma hdrstop
#include <owl\framewin.h>
#include <owl\scroller.h>
#include <owl\opensave.h>
#include <string.h>
#include <dir.h>
#include <time.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include "viewdlg.h"
#include "imagevw.h"
#include "imglib30.h"

#define MAXAPPNAME  20
#define JPG 1
#define PCX 2
#define GIF 3
#define BMP 4
#define PNG 5

static const char AppName[] = "ImgView2";
TGaugeDialog* Gdlg;
TGauge2Dialog* Gdlg2;
short Callback(int i)
 {
	return Gdlg->SetValue(i);
  };
short Callback2(int i)
 {
	return Gdlg2->SetValue(i);
 };


class TViewWindow : virtual public TWindow {
  public:
		char      FileName[MAXPATH];
		TBitmap*  Bitmap;
		TPalette* Palette;
		TBrush*   BkgndBrush;
		long      Rop;
		int       PixelWidth;
		int       PixelHeight;
		WORD      Colors;
		BOOL      Fit;

		TViewWindow();
	  ~TViewWindow();

  protected:
		void      CmOpenJpg();
		void      CmOpenBmp();
		void      CmOpenGif();
		void      CmOpenPcx();
		void      CmOpenPng();
		void      CmImageInfo();
		void      CmFit();
		void      CeFit(TCommandEnabler& ce);

		void      Paint(TDC&, BOOL erase, TRect&);
		void      EvSize(UINT sizeType, TSize&);

		void      EvPaletteChanged(HWND hWndPalChg);
		BOOL      EvQueryNewPalette();
		void      EvSetFocus(HWND); // should use above when working
		void      EvDestroy();

		BOOL      UpdatePalette(BOOL alwaysRepaint);
		void      AdjustScroller();
		void      SetCaption(const char*);
		void      CmSaveToJpg();
		void      CmSaveToBmp();
		void      CmSaveToPng();
		void      CmSaveToGif();
		void      CmSaveToPcx();
		int       ReadFile(const char * filename, const char * filetitle, int type);
		int       WriteFile(const char * filename, int type);
  private:
		DecTransfer DecBuffer;
		ComTransfer ComBuffer;
		EncTransfer EncBuffer;

  DECLARE_RESPONSE_TABLE(TViewWindow);
};

DEFINE_RESPONSE_TABLE1(TViewWindow, TWindow)
  EV_COMMAND(CM_OPENJPG, CmOpenJpg),
  EV_COMMAND(CM_OPENBMP, CmOpenBmp),
  EV_COMMAND(CM_OPENGIF, CmOpenGif),
  EV_COMMAND(CM_OPENPCX, CmOpenPcx),
  EV_COMMAND(CM_OPENPNG, CmOpenPng),
  EV_COMMAND(CM_INFO, CmImageInfo),
  EV_COMMAND(CM_FIT, CmFit),
  EV_COMMAND(CM_SAVETOJPG, CmSaveToJpg),
  EV_COMMAND(CM_SAVETOBMP, CmSaveToBmp),
  EV_COMMAND(CM_SAVETOPNG, CmSaveToPng),
  EV_COMMAND(CM_SAVETOGIF, CmSaveToGif),
  EV_COMMAND(CM_SAVETOPCX, CmSaveToPcx),
  EV_COMMAND_ENABLE(CM_FIT, CeFit),
  EV_WM_SIZE,
  EV_WM_PALETTECHANGED,
  EV_WM_QUERYNEWPALETTE,
  EV_WM_SETFOCUS,
  EV_WM_DESTROY,
END_RESPONSE_TABLE;

//
// Constructor for a TViewWindow, sets scroll styles andconstructs
// the Scroller object.  Also sets the Rop based on whether thedisplay
// is monochrome (two-color) or polychrome.
//
TViewWindow::TViewWindow()
  : TWindow(0, 0, 0)
{
  Attr.Style |= WS_VSCROLL | WS_HSCROLL;
  Bitmap = 0;
  Palette = 0;
  BkgndBrush = new TBrush(::GetSysColor(COLOR_WINDOW));
  Scroller = new TScroller(this, 1, 1, 200, 200);
  Fit = FALSE;

  TScreenDC screenDC;
  if (screenDC.GetDeviceCaps(NUMCOLORS) < 3 )
	 Rop = NOTSRCCOPY;
  else
	 Rop = SRCCOPY;
  memset(&DecBuffer, 0, sizeof(DecBuffer));
  DecBuffer.Res8But = BF_CHECKED;
  DecBuffer.Scl1But = BF_CHECKED;
  DecBuffer.Rad1DBut = BF_CHECKED;
  memset(&EncBuffer, 0, sizeof(EncBuffer));
  EncBuffer.Res8But = BF_CHECKED;
  memset(&ComBuffer, 0, sizeof(ComBuffer));
  strcpy(ComBuffer.Cquality, "75");
  strcpy(ComBuffer.Csmooth, "00");

  SetCaption(0);
}

TViewWindow::~TViewWindow()
{
  delete Bitmap;
  delete Palette;
  delete BkgndBrush;
  delete Scroller;
}

//
// Build up a caption based on a filename, and set it into the title.
//
void
TViewWindow::SetCaption(const char* name)
{
  char caption[MAXPATH + MAXAPPNAME + 2 + 1];
  strcpy(FileName, name ? name : "(Untitled)");
  strcpy(caption, GetApplication()->GetName());
  strcat(caption, " - ");
  strcat(caption, FileName);
  if (Parent)
	 Parent->SetCaption(caption);
}

//
// Toggle Fit member variable & adjust scroller as needed
//
void
TViewWindow::CmFit()
{
  Fit = !Fit;
  AdjustScroller();
}

//
// The fit menu item is checked if the Fit member is true
//
void
TViewWindow::CeFit(TCommandEnabler& ce)
{
  ce.SetCheck(Fit ? TCommandEnabler::Checked : TCommandEnabler::Unchecked);
}

int TViewWindow::ReadFile(const char * filename, const char * filetitle, int type)
{
  int resolution, option, scale, res;
  unsigned int hddb, hpal;
  char message[40];

  // If type equal JPEG then get input parameters
  TDecDialog* pDlg = new TDecDialog(this, &DecBuffer);
  if (pDlg->Execute() != IDOK)
		// leave
  return 0;

  SetCursor(0, IDC_WAIT);
  delete Bitmap;
  delete Palette;
  // Set Bitmap output resolution  - 24, 8, or 4 bit
  if (DecBuffer.Res24But == BF_CHECKED)
	 resolution = 24;
  else if (DecBuffer.Res8But == BF_CHECKED)
	 resolution = 8;
  else
	 resolution = 4;

  // Set Color Quantization and dithering methods for output.
  // This is used if Resolution != 24

  if (DecBuffer.Rad1But == BF_CHECKED)
	 option = 0;
  else
	 option = 1;

  // Set output Bitmap scale factor either 1/1, 1/2, 1/4, or 1/8
  // of origional size
  if (DecBuffer.Scl1But == BF_CHECKED)
	 scale = 1;
  else if (DecBuffer.Scl2But == BF_CHECKED)
	 scale = 2;
  else if (DecBuffer.Scl4But == BF_CHECKED)
	 scale = 4;
  else
	 scale = 8;

  // Show progress display modaless dialog box
  if (type == 1)
	 sprintf(message, "Decompressing JPG File");
  else if (type == 2)
	 sprintf(message, "Decompressing PCX File");
  else if (type == 3)
	 sprintf(message, "Decompressing GIF File");
  else if (type == 5)
    sprintf(message, "Decompressing PNG File");
  else
	 sprintf(message, "Decompressing BMP File");
  Gdlg = new TGaugeDialog(this);
  Gdlg->SetCaption(message);
  Gdlg->Create();

  // password variable - the code is given when you register
  int password = 0;
  res = 0;
  // call the DLL function to read the image in global memory
  switch (type)
	{
	 case 1:
		res = readjpgfile(filename, resolution, scale, option, password,
						  &hddb, &hpal, Callback, 1);
		break;
	 case 2:
		res = readpcxfile(filename, resolution, option, password,
								&hddb, &hpal, Callback, 1);
		break;
	 case 3:
		res = readgiffile(filename, resolution, option, password,
		                  &hddb, &hpal, Callback, 1);
		break;
	 case 4:
		res = readbmpfile(filename, resolution, option, password,
		                  &hddb, &hpal, Callback, 1);
		break;
	 case 5:
		res = readpngfile(filename, resolution, option, password, &hddb,
		                  &hpal, Callback, 1);
      break;
	}

  // destroy progress display dialog and free global memory
  Gdlg->Destroy();
  delete Gdlg;
  SetCursor(0, IDC_ARROW);

  // if success set Bitmap and Palette for Painting
  if (res != 1)
	 return 0;


  Palette = new TPalette((HPALETTE)hpal, AutoDelete);
  Bitmap = new TBitmap((HBITMAP)hddb, AutoDelete);
  PixelWidth = Bitmap->Width();
  PixelHeight = Bitmap->Height();
  UpdatePalette(TRUE);
  AdjustScroller();
  SetCaption(filetitle);
  return 1;
}


void
TViewWindow::CmOpenJpg()
{
  TOpenSaveDialog::TData data (
		OFN_FILEMUSTEXIST,
		"JPEG Files (*.JPG)|*.jpg|",
		0,
		"",
		"JPG"
  );
  int res = 0;
  TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,data);
  if (tmpdlg->Execute() == IDOK)
	{
	 char fileTitle[MAXPATH];
	 TOpenSaveDialog::GetFileTitle(data.FileName, fileTitle,MAXPATH);
	 res = ReadFile(data.FileName, fileTitle, 1);
	 if (!res)
		MessageBox("Error Opening JPG File", "Error", MB_ICONSTOP | MB_OK);
	}
  delete tmpdlg;
}

void
TViewWindow::CmOpenGif()
{
  TOpenSaveDialog::TData data (
		OFN_FILEMUSTEXIST,
		"GIF Files (*.GIF)|*.gif|",
		0,
		"",
		"GIF"
  );
  int res = 0;
  TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,data);
  if (tmpdlg->Execute() == IDOK)
	{
	 char fileTitle[MAXPATH];
	 TOpenSaveDialog::GetFileTitle(data.FileName, fileTitle,MAXPATH);
	 res = ReadFile(data.FileName, fileTitle, 3);
	 if (!res)
		MessageBox("Error Opening GIF File", "Error", MB_ICONSTOP | MB_OK);
	}
  delete tmpdlg;
}

void
TViewWindow::CmOpenPcx()
{
  TOpenSaveDialog::TData data (
		OFN_FILEMUSTEXIST,
		"PCX Files (*.PCX)|*.pcx|",
		0,
		"",
		"PCX"
  );
  int res = 0;
  TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,data);
  if (tmpdlg->Execute() == IDOK)
	{
	 char fileTitle[MAXPATH];
	 TOpenSaveDialog::GetFileTitle(data.FileName, fileTitle,MAXPATH);
	 res = ReadFile(data.FileName, fileTitle, 2);
	 if (!res)
		MessageBox("Error Opening PCX File", "Error", MB_ICONSTOP | MB_OK);
	}
  delete tmpdlg;
}

void
TViewWindow::CmOpenPng()
{
  TOpenSaveDialog::TData data (
		OFN_FILEMUSTEXIST,
		"PNG Files (*.PNG)|*.png|",
		0,
		"",
		"PNG"
  );
  int res = 0;
  TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,data);
  if (tmpdlg->Execute() == IDOK)
	{
	 char fileTitle[MAXPATH];
	 TOpenSaveDialog::GetFileTitle(data.FileName, fileTitle,MAXPATH);
	 res = ReadFile(data.FileName, fileTitle, 5);
	 if (!res)
		MessageBox("Error Opening PNG File", "Error", MB_ICONSTOP | MB_OK);
	}
  delete tmpdlg;
}

void
TViewWindow::CmOpenBmp()
{
  TOpenSaveDialog::TData data (
		OFN_FILEMUSTEXIST,
		"Bitmap Files (*.BMP)|*.bmp|",
		0,
		"",
		"BMP"
  );
  int res = 0;
  TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,data);
  if (tmpdlg->Execute() == IDOK)
	{
	 char fileTitle[MAXPATH];
	 TOpenSaveDialog::GetFileTitle(data.FileName, fileTitle,MAXPATH);
	 res = ReadFile(data.FileName, fileTitle, 4);
	 if (!res)
		MessageBox("Error Opening BMP File", "Error", MB_ICONSTOP | MB_OK);
	}
  delete tmpdlg;
}

void TViewWindow::CmSaveToBmp()
{
 TOpenSaveDialog::TData bmpdata (
		OFN_HIDEREADONLY|OFN_NOREADONLYRETURN,
		"Bmp Files (*.BMP)|*.BMP|",
		0,
		0,
		"*.bmp"
	  );
 int res = 0;
 if (Bitmap)
  {
	TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,bmpdata);
	if (tmpdlg->Execute() == IDOK)
	 {
	  res = WriteFile(bmpdata.FileName, 4);
	  if (!res)
		 MessageBox("Error Writing BMP File", "Error", MB_ICONSTOP | MB_OK);
	 }
	delete tmpdlg;
  }
	else
	  MessageBox("No Image Loaded!", "Error Writing BMP", MB_OK);
}

void TViewWindow::CmSaveToJpg()
{
 TOpenSaveDialog::TData jpgdata (
		OFN_HIDEREADONLY|OFN_NOREADONLYRETURN,
		"Jpg Files (*.JPG)|*.JPG|",
		0,
		0,
		"*.jpg"
	  );
 int res = 0;
 if (Bitmap)
  {
	TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,jpgdata);
	if (tmpdlg->Execute() == IDOK)
	 {
	  res = WriteFile(jpgdata.FileName, 1);
	  if (!res)
		 MessageBox("Error Writing JPG File", "Error", MB_ICONSTOP | MB_OK);
	 }
	delete tmpdlg;
  }
	else
	  MessageBox("No Image Loaded!", "Error Writing JPG", MB_OK);
}

void TViewWindow::CmSaveToPng()
{
 TOpenSaveDialog::TData jpgdata (
		OFN_HIDEREADONLY|OFN_NOREADONLYRETURN,
		"Png Files (*.PNG)|*.PNG|",
		0,
		0,
		"*.png"
	  );
 int res = 0;
 if (Bitmap)
  {
	TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,jpgdata);
	if (tmpdlg->Execute() == IDOK)
	 {
	  res = WriteFile(jpgdata.FileName, 5);
	  if (!res)
		 MessageBox("Error Writing PNG File", "Error", MB_ICONSTOP | MB_OK);
	 }
	delete tmpdlg;
  }
	else
	  MessageBox("No Image Loaded!", "Error Writing PNG", MB_OK);
}

void TViewWindow::CmSaveToGif()
{
 TOpenSaveDialog::TData jpgdata (
		OFN_HIDEREADONLY|OFN_NOREADONLYRETURN,
		"Gif Files (*.GIF)|*.GIF|",
		0,
		0,
		"*.gif"
	  );
 int res = 0;
 if (Bitmap)
  {
	TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,jpgdata);
	if (tmpdlg->Execute() == IDOK)
	 {
	  res = WriteFile(jpgdata.FileName, 3);
	  if (!res)
		 MessageBox("Error Writing GIF File", "Error", MB_ICONSTOP | MB_OK);
	 }
	delete tmpdlg;
  }
	else
	  MessageBox("No Image Loaded!", "Error Writing GIF", MB_OK);
}

void TViewWindow::CmSaveToPcx()
{
 TOpenSaveDialog::TData jpgdata (
		OFN_HIDEREADONLY|OFN_NOREADONLYRETURN,
		"Pcx Files (*.PCX)|*.PCX|",
		0,
		0,
		"*.pcx"
	  );
 int res = 0;
 if (Bitmap)
  {
	TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,jpgdata);
	if (tmpdlg->Execute() == IDOK)
	 {
	  res = WriteFile(jpgdata.FileName, 2);
	  if (!res)
		 MessageBox("Error Writing PCX File", "Error", MB_ICONSTOP | MB_OK);
	 }
	delete tmpdlg;
  }
	else
	  MessageBox("No Image Loaded!", "Error Writing PCX", MB_OK);
}

int TViewWindow::WriteFile(const char * filename, int type)
{
	HBITMAP hddb;
	HPALETTE hpal;
	int ret = 0;
	int quality, smooth, resolution;
	char message[20];
	if (type == 1)
	 {
	  TComDialog* pDlg = new TComDialog(this, &ComBuffer);

	  // Display the options for writing a JPEG file
	  if (pDlg->Execute() != IDOK)
		{
		 delete pDlg;
		 return 0;
		}
	  // Set the quality of the JPEG image.  A higher quality
	  // yields a better JPEG image that takes more space.

	  sscanf(ComBuffer.Cquality, "%d", &quality);

	  // Set a smoothing factor on the JPEG image.
	  sscanf(ComBuffer.Csmooth, "%d", &smooth);
	 }
	else
	 {
	  TEncDialog* pDlg = new TEncDialog(this, &EncBuffer);
	  if (pDlg->Execute() != IDOK)
		 // leave
		 return 0;

	  SetCursor(0, IDC_WAIT);

	  // Set Bitmap output resolution  - 24, 8, or 4 bit
	  if (EncBuffer.Res24But == BF_CHECKED)
		 resolution = 24;
	  else if (EncBuffer.Res8But == BF_CHECKED)
		 resolution = 8;
	  else
		 resolution = 4;
	 }
	SetCursor(0, IDC_WAIT);

	hddb = *Bitmap;
	hpal = *Palette;

	Gdlg2 = new TGauge2Dialog(this);
	if (type == 1)
	  sprintf(message, "Creating JPEG File");
	else if (type == 2)
     sprintf(message, "Creating PCX File");
	else if (type == 3)
	  sprintf(message, "Creating GIF FIle");
	else if (type == 4)
	  sprintf(message, "Creating BMP File");
	else
	  sprintf(message, "Creating PNG File");
	Gdlg2->SetCaption(message);
	Gdlg2->Create();

	switch (type)
	 {
	  case 1:
		 ret = writejpegfile(filename, quality, smooth, 0,
							(unsigned int)hddb, (unsigned int)hpal, Callback2, 1);
		 break;
	  case 2:
		 ret = writepcxfile(filename, resolution, 0,
							(unsigned int)hddb, (unsigned int)hpal, Callback2, 1);
		 break;
	  case 3:
		 ret = writegiffile(filename, resolution, 0,
							(unsigned int)hddb, (unsigned int)hpal, Callback2, 1);
		 break;
	  case 4:
		 ret = writebmpfile(filename, resolution, 0,
							(unsigned int)hddb, (unsigned int)hpal, Callback2, 1);
		 break;
	  case 5:
		 ret = writepngfile(filename, resolution, 1, 0,
							(unsigned int)hddb, (unsigned int)hpal, Callback2, 1);
		 break;
	 }

	Gdlg2->Destroy();
	delete Gdlg2;
	if (ret == 1)
	 {
	 }
	else
	  MessageBox("Error creating File", "Error", MB_OK);
	SetCursor(0, IDC_ARROW);
	if (ret == 1)
	  return 1;
	else
	  return 0;
}

//
// Adjust the Scroller range so that the the origin is the
// upper-most scrollable point and the corner is the
// bottom-most.
//
void
TViewWindow::AdjustScroller()
{
  TRect  clientRect = GetClientRect();

  // only show scrollbars when image is larger than
  // the client area and we are not stretching to fit.
  //
  if (Fit)
	 Scroller->SetRange(0, 0);

  else
	{
	 TPoint Range(Max(PixelWidth-clientRect.Width(), 0),
									Max(PixelHeight-clientRect.Height(),0));
	 Scroller->SetRange(Range.x, Range.y);
	}
  Scroller->ScrollTo(0, 0);
  if (!GetUpdateRect(clientRect, FALSE))
	 Invalidate(FALSE);
}

//
// Reset scroller range.
//
void
TViewWindow::EvSize(UINT SizeType, TSize& Size)
{
  TWindow::EvSize(SizeType, Size);
  if (SizeType != SIZEICONIC)
	{
	 AdjustScroller();
	 Invalidate(FALSE);
	}
}

//
// Somebody changed the palette. If its not us, then we need toupdate.
//
void
TViewWindow::EvPaletteChanged(HWND hWndPalChg)
{
  if (hWndPalChg != HWindow)
	 UpdatePalette(TRUE);    // pass FALSE to UpdateColors()instead of repaint
}

//
// We need to re-realize the logical palette each time
// we regain the input focus
//
BOOL
TViewWindow::EvQueryNewPalette()
{
  return UpdatePalette(TRUE);
}

//
// Use this message temporarily until the palette msgs get routedto us
//
void
TViewWindow::EvSetFocus(HWND)
{
  UpdatePalette(TRUE);
}

void
TViewWindow::EvDestroy()
{
  TWindow::EvDestroy();
}

BOOL
TViewWindow::UpdatePalette(BOOL alwaysRepaint)
{
  if (Palette)
	{
	 TClientDC clientDC(*this);
	 #if !defined(__WIN32__)
		Palette->UnrealizeObject();
	 #endif
	 clientDC.SelectObject(*Palette, FALSE);
	 if (alwaysRepaint)
		Invalidate(FALSE);
	 else
		clientDC.UpdateColors();
	 return TRUE;
	}
  return FALSE;
}

void
TViewWindow::Paint(TDC& dc, BOOL, TRect&)
{
  TRect clientRect = GetClientRect();
  dc.SelectObject(*BkgndBrush);

  if (Bitmap)
	{
	 TMemoryDC memoryDC(dc);
	 memoryDC.SelectObject(*Bitmap);
	 dc.SetStretchBltMode(COLORONCOLOR);
	 if (Palette)
	  {
		dc.SelectObject(*Palette, FALSE);
		dc.RealizePalette();
		memoryDC.SelectObject(*Palette, FALSE);
	  }

	 TRect imageRect(0,0, PixelWidth, PixelHeight);
	 if (Parent->IsIconic())
	  {
		dc.StretchBlt(Parent->GetClientRect(), memoryDC,imageRect, Rop);
	  }
	 else
	  {
		clientRect += TPoint((int)Scroller->XPos,(int)Scroller->YPos);
		if (Fit)
		  dc.StretchBlt(clientRect, memoryDC,imageRect, Rop);
		else
		  dc.BitBlt(imageRect, memoryDC, TPoint(0,0), Rop);
		// Clear borders here for no flicker
		//
		if (!Fit)
		 {
		  dc.PatBlt(TRect(TPoint(PixelWidth,0),clientRect.BottomRight()));
		  dc.PatBlt(TRect(TPoint(0,PixelHeight),clientRect.BottomRight()));
       }
	  }
	}
  else
	dc.PatBlt(clientRect, PATCOPY);
}


void
TViewWindow::CmImageInfo()
{
  TOpenSaveDialog::TData data (
		OFN_HIDEREADONLY|OFN_FILEMUSTEXIST|OFN_NOREADONLYRETURN,
		"Image Files (*.*)|*.*|",
		0,
		"",
		""
  );
  int result, width, height, numcolors, bitspixel, planes;
  char filetype[20], filecomp[20];
  char message[300];
  TFileOpenDialog *tmpdlg = new TFileOpenDialog(this,data);
  if (tmpdlg->Execute() == IDOK)
	{
	 char fileTitle[MAXPATH];
	 TOpenSaveDialog::GetFileTitle(data.FileName, fileTitle,MAXPATH);
	 result = fileinfo(data.FileName, filetype, &width, &height, &bitspixel,
							 &planes, &numcolors, filecomp, 1);
	 if (result == 1)
	  {
		sprintf(message, "%s %s\nw: %d h: %d\nbits per pixel: %d planes: %d\n colors: %d",
						filetype, filecomp, width, height, bitspixel, planes, numcolors);
		MessageBox(message, fileTitle, MB_ICONINFORMATION | MB_OK);
	  }
	}
  delete tmpdlg;
}

//----------------------------------------------------------------------------

class TViewApp : public TApplication {
  public:
		TViewApp(const char far* name) : TApplication(name) {}
		void InitMainWindow()
		 {
		  MainWindow = new TFrameWindow(0, Name, new TViewWindow);
		  MainWindow->AssignMenu(JPGMENU);
		  MainWindow->SetIcon(this, JPGVIEW);
		 }
};

//----------------------------------------------------------------------------

int
OwlMain(int /*argc*/, char* /*argv*/ [])
{
  return TViewApp(AppName).Run();
}
