#ifndef IMAGEDIB_H
#define IMAGEDIB_H

#if defined (JPG_DLL)
#  define _JPGCLASS _export
#else
#  define _JPGCLASS
#endif

#if defined __cplusplus
# define _C "C"
#else
# define _C
#endif

#include <windows.h>
#include <windowsx.h>

extern _C int _JPGCLASS _pascal rdjpgfiledib(const char *filename, int resolution,
										 int scale, int dither, int password,
										 unsigned int * hdib, short (* pf)(int),
										 short errormode);

extern _C int _JPGCLASS _pascal wrjpegfiledib(const char *filename, int quality,
												 int smooth, int password,
												 unsigned int hdib, short (* pf)(int),
												 short errormode);

extern _C int _JPGCLASS _pascal rdgiffiledib(const char *filename, int resolution,
										  int dither, int password, unsigned int * hdib,
										  short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal rdpcxfiledib(const char *filename, int resolution,
										  int dither, int password, unsigned int * hdib,
										  short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal rdjpgstreamdib(void * inbuffer, long size,
					int resolution, int scale, int dither, int password,
					unsigned int * hdib, short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal rdpcxstreamdib(void * inbuffer, long size,
                                    int resolution, int dither,
												int password, unsigned int * hdib,
												short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal rdgifstreamdib(void * inbuffer, long size,
												int resolution, int dither,
												int password, unsigned int * hdib,
												short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal wrjpegstreamdib(void * inbuffer, long * size,
												 int quality, int smooth, int password,
												 unsigned int hdib,
												 short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal rdbmpstreamdib(void * inbuffer, long size,
										  int resolution, int dither, int password,
										  unsigned int * hdib,
										  short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal wrbmpstreamdib(void * inbuffer, long * size,
											  int resolution, int password, unsigned int hdib,
											  short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal rdbmpfiledib(const char * filename, int resolution,
													  int dither, int password,
													  unsigned int * hdib, short (* pf)(int),
													  short errormode);

extern _C int _JPGCLASS _pascal wrbmpfiledib(const char * filename, int resolution,
														int password, unsigned int hdib,
														short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal rdpngfiledib(const char * filename,
													  int resolution, int dither,
													  int password, unsigned int * hdib,
													  short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal rdpngstreamdib(void * inbuffer, long size,
													  int resolution, int dither,
													  int password, unsigned int * hdib,
													  short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal wrpngfiledib(const char *filename, int resolution,
												 int interlaced, int password,
												 unsigned int hdib, short (* pf)(int),
												 short errormode);

extern _C int _JPGCLASS _pascal wrpngstreamdib(void *inbuffer, long *size,
												 int resolution, int interlaced, int password,
												 unsigned int hdib, short (* pf)(int),
												 short errormode);

extern _C int _JPGCLASS _pascal wrgiffiledib(const char *filename, int resolution,
												 int password, unsigned int hdib,
												 short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal wrgifstreamdib(void * inbuffer, long * size,
										  int resolution, int password,
										  unsigned int hdib,short (* pf)(int),
										  short errormode);

extern _C int _JPGCLASS _pascal wrpcxfiledib(const char * filename, int resolution,
														int password, unsigned int hdib,
														short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal wrpcxstreamdib(void * inbuffer, long * size,
											  int resolution, int password,
											  unsigned int hdib, short (* pf)(int),
											  short errormode);

#endif
