{$X+,I+,R-}   {<<<<  This is a switch. Don't delete it}

{Copyright 1995 by
 Kevin Adams, 74742,1444
 Jan Dekkers, 72130,353

Professional Edition

With thanks to Andy Satori for his Visual Component advise. Andy can
be reached on CIS [71221,2010] or http://TheClassifieds.Com

No part of this Unit may be copied in any way. However, you may derive
other objects from TDBMultiImage, TDBMultiMedia

Part of Imagelib VCL/DLL Library.Uses ImageLib 2.2.1 Changed the callback to a
function instead of a procedure to let the user cancel out.

Bug fixes:

Changed callback in version 2.21 to a function with cdecl.
using the C calling convention.

Version 2.2.2 Added property ImageLibPalette which If set to True will
use the ImageLib Way to paint. If False it will paint the Delphi way.
This is a fix of a Stretchdraw Delphi bug which doesn't paint correctly
256 color palettes on 256 color Video cards

property TempMov
property TempAVI
property TempWAV
property TempMID
property TempRMI

MultiMedia blobs (AVI, MOV, WAV, MID, RMI are written to a file first
and than that file is being played. This can cause a problem when you
have two TDBMultiMedia objects on your forum both using the same Temp file
(A seldom something). Incase that could happen in your app you need to
assign to both TDBMultiMedia ojects different Temp Filenames. DON'T change
the extension since the delphi multimedia player is extension sensitive}


unit TDMultiP;      {To be used with version 3.0 of imagelib vcl}

interface

uses Setcr30, Setsr30, SysUtils, WinTypes, WinProcs, Messages,
     Classes, Graphics, Forms, Controls, Extctrls, StdCtrls, DLL30,
     Menus, DB, DBTables, Mask, Buttons, MPlayer, Printers;


{TPDBMultiImage}
Type
  TPDBMultiImage = class(TCustomControl)
  private
    FDataLink           :  TFieldDataLink;
    FPicture            :  TPicture;
    FBorderStyle        :  TBorderStyle;
    FAutoDisplay        :  Boolean;
    FStretch            :  Boolean;
    FCenter             :  Boolean;
    FPictureLoaded      :  Boolean;
    FUpdateAsJPG        :  Boolean;
    FUpdateAsBMP        :  Boolean;
    FUpdateAsGIF        :  Boolean;
    FUpdateAsPCX        :  Boolean;
    FUpdateAsPNG        :  Boolean;
    FReserved           :  Byte;
    FDither             :  Boolean;
    FReadResolution     :  TResolution;
    FWriteResolution    :  TResolution;
    FInterlaced         :  Boolean;
    FSaveQuality        :  Byte;
    FSaveSmooth         :  Byte;
    FColor              :  TColor;
    FImageLibPalette    :  Boolean;
    {scrolling message stuff}
    BitMsg              :  TBitmap;
    SMessageLeft        :  Integer;
    SMessageRight       :  Integer;
    SMessageTop         :  Integer;
    ScreenWd            :  Integer;
    ScreenHt            :  Integer;
    BitWidth            :  Integer;
    MessageRunning      :  Boolean;
    CMessageRunning     :  Boolean;
    DelayCounter        :  Longint;
    OldColor            :  TColor;
    MmsgCount           :  Integer;
    {Credit message stuff}
    SMessageBottom      : Integer;
    BitHeight           : Integer;
    Creditcounter       : Integer;
    procedure DataChange(Sender: TObject);
    function GetDataField: String;
    function GetDataSource: TDataSource;
    function GetField: TField;
    function GetReadOnly: Boolean;
    procedure PictureChanged(Sender: TObject);
    procedure SetAutoDisplay(Value: Boolean);
    procedure SetBorderStyle(Value: TBorderStyle);
    procedure SetCenter(Value: Boolean);
    procedure SetDataField(const Value: String);
    procedure SetDataSource(Value: TDataSource);
    procedure SetPicture(Value: TPicture);
    procedure SetReadOnly(Value: Boolean);
    procedure SetStretch(Value: Boolean);
    procedure UpdateData(Sender: TObject);
    procedure SetUpdateAsJPG(Value: Boolean);
    procedure SetUpdateAsBMP(Value: Boolean);
    procedure SetUpdateAsGIF(Value: Boolean);
    procedure SetUpdateAsPCX(Value: Boolean);
    procedure SetUpdateAsPNG(Value: Boolean);
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_Exit;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMCopy(var Message: TMessage); message WM_COPY;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    function GetPalette: HPALETTE; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Paint; override;
    procedure PaintTheDelpiWay;
    function GetSmooth : Byte;
    procedure SetSmooth(smooth : Byte);
    function GetQuality : Byte;
    procedure SetQuality(Quality : Byte);
    procedure SetReadRes(Res : TResolution);
    procedure SetWriteRes(Res : TResolution);
    procedure PrintICOWMF(X, Y, pWidth, pHeight: Integer);
    procedure PrintBitmap(X, Y, pWidth, pHeight: Integer);
    procedure LoadMessageFromStream(MessageStream : TStream);
    Procedure MoveMsg(Var WinMsg : TMessage); message WM_Trigger;
    Function Delay(Ms : Integer) : boolean;
    Function SaveMessageToStream(MFont  : Tfont;
                                  Mspeed : Integer;
                                  MColor : Tcolor;
                                  MMsg   : String) : Boolean;
    Procedure MoveCredMsg(Var WinMsg : TMessage); message WM_CTrigger;
    procedure LoadCreditMessageFromStream(MessageStream : TStream);
    Function SaveCreditMessageToStream(MFont  : Tfont;
                                       Mspeed : integer;
                                       MColor : Tcolor;
                                       MMsg   : TStringList) : Boolean;
  public
    BFiletype           :  String;
    Bwidth              :  Integer;
    BHeight             :  Integer;
    Bbitspixel          :  Integer;
    Bplanes             :  Integer;
    Bnumcolors          :  Integer;
    BSize               :  Longint;
    Bcompression        :  String;
    {scrolling message stuff}
    MsgText             :  String;
    MsgFont             :  TFont;
    MsgBkGrnd           :  TColor;
    MsgSpeed            :  Integer;
    {credit message}
    CreditBoxList       :  TStringList;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CopyToClipboard;
    procedure CutToClipboard;
    procedure LoadPicture;
    procedure PasteFromClipboard;
    procedure LoadFromFile(Filename : TFilename);
    procedure SaveToFile(Filename : TFilename);
    procedure SaveToFileAsGIF(Filename : TFilename);
    procedure SaveToFileAsPCX(Filename : TFilename);
    procedure SaveToFileAsPNG(Filename : TFilename);
    procedure SaveToFileAsBMP(Filename : TFilename);
    procedure SaveToFileAsJPG(Filename : TFilename);
    function GetInfoAndType : String;
    property Field: TField read GetField;
    property Picture: TPicture read FPicture write SetPicture;
    Procedure Trigger;
    Function CreateMessage : Boolean;
    procedure NewMessage;
    Procedure FreeMsg;
    {credit message}
    Function CreateCreditMessage : Boolean;
    procedure NewCreditMessage;
    procedure PrintMultiImage(X, Y, pWidth, pHeight: Integer);
  published
    property ImageReadRes : TResolution read FReadResolution write SetReadRes;
    property ImageWriteRes : TResolution read FWriteResolution write SetWriteRes;
    property JPegSaveQuality : Byte read GetQuality write SetQuality;
    property JPegSaveSmooth : Byte read GetSmooth write SetSmooth;
    property PNGInterLaced : Boolean read FInterlaced write FInterlaced default False;
    property ImageDither : Boolean read FDither write FDither;
    property UpdateAsJPG : Boolean read FUpdateAsJPG write SetUpdateAsJPG;
    property UpdateAsBMP : Boolean read FUpdateAsBMP write SetUpdateAsBMP;
    property UpdateAsGIF : Boolean read FUpdateAsGIF write SetUpdateAsGIF;
    property UpdateAsPCX : Boolean read FUpdateAsPCX write SetUpdateAsPCX;
    property UpdateAsPNG : Boolean read FUpdateAsPNG write SetUpdateAsPNG;
    property AutoDisplay: Boolean read FAutoDisplay write SetAutoDisplay default True;
    property BorderStyle: TBorderStyle read FBorderStyle write SetBorderStyle default bsSingle;
    property Center: Boolean read FCenter write SetCenter default True;
    property Color;
    property Align;
    property Ctl3D;
    property DataField: String read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ImageLibPalette : Boolean read FImageLibPalette write FImageLibPalette default True;
    property ParentColor default False;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly default False;
    property ShowHint;
    property Stretch: Boolean read FStretch write SetStretch default False;
    property TabOrder;
    property TabStop default True;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

{TDBMediaPlayer}
Type
  TPDBMediaPlayer = class(TMediaPlayer)
  {Just incase you/we want to add some stuff in the
   future we derived a seperate object.}
end;


{TPDBMultiMedia }
Type
  TPDBMultiMedia = class(TCustomControl)
  private
    FDataLink           :  TFieldDataLink;
    FPicture            :  TPicture;
    FBorderStyle        :  TBorderStyle;
    FAutoDisplay        :  Boolean;
    FStretch            :  Boolean;
    FCenter             :  Boolean;
    FPictureLoaded      :  Boolean;
    FUpdateAsJPG        :  Boolean;
    FUpdateAsBMP        :  Boolean;
    FUpdateAsGIF        :  Boolean;
    FUpdateAsPCX        :  Boolean;
    FUpdateAsPNG        :  Boolean;
    FAutoPlayMM         :  Boolean;
    FAutoMMHide         :  Boolean;
    FAutoRePlayMM       :  Boolean;
    FReserved           :  Byte;
    FDither             :  Boolean;
    FReadResolution     :  TResolution;
    FWriteResolution    :  TResolution;
    FInterlaced         :  Boolean;
    FSaveQuality        :  Byte;
    FSaveSmooth         :  Byte;
    FMediaPlayer        :  TPDBMediaPlayer;
    FMOVTempFile        :  String;
    FMPGTempFile        :  String;
    FAVITempFile        :  String;
    FWAVTempFile        :  String;
    FMIDTempFile        :  String;
    FRMITempFile        :  String;
    FTempFilePath       :  String;
    FImageLibPalette    :  Boolean;
    {scrolling message stuff}
    BitMsg              :  TBitmap;
    SMessageLeft        :  Integer;
    SMessageRight       :  Integer;
    SMessageTop         :  Integer;
    ScreenWd            :  Integer;
    ScreenHt            :  Integer;
    BitWidth            :  Integer;
    MessageRunning      :  Boolean;
    CMessageRunning     :  Boolean;
    DelayCounter        :  Longint;
    OldColor            :  TColor;
    MmsgCount           :  Integer;
    {Credit message stuff}
    SMessageBottom      : Integer;
    BitHeight           : Integer;
    Creditcounter       : Integer;
    procedure DataChange(Sender: TObject);
    function GetDataField: String;
    function GetDataSource: TDataSource;
    function GetMediaPlayer: TPDBMediaPlayer;
    function GetField: TField;
    function GetReadOnly: Boolean;
    procedure PictureChanged(Sender: TObject);
    procedure SetAutoDisplay(Value: Boolean);
    procedure SetBorderStyle(Value: TBorderStyle);
    procedure SetCenter(Value: Boolean);
    procedure SetDataField(const Value: String);
    procedure SetDataSource(Value: TDataSource);
    procedure SetMediaPlayer(Value: TPDBMediaPlayer);
    procedure SetPicture(Value: TPicture);
    procedure SetReadOnly(Value: Boolean);
    procedure SetStretch(Value: Boolean);
    procedure UpdateData(Sender: TObject);
    procedure SetUpdateAsJPG(Value: Boolean);
    procedure SetUpdateAsBMP(Value: Boolean);
    procedure SetUpdateAsGIF(Value: Boolean);
    procedure SetUpdateAsPCX(Value: Boolean);
    procedure SetUpdateAsPNG(Value: Boolean);
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_Exit;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMCopy(var Message: TMessage); message WM_COPY;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    function GetPalette: HPALETTE; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Paint; override;
    procedure PaintTheDelpiWay;
    function GetSmooth : Byte;
    procedure SetSmooth(smooth : Byte);
    function GetQuality : Byte;
    procedure SetQuality(Quality : Byte);
    procedure SetReadRes(Res : TResolution);
    procedure SetWriteRes(Res : TResolution);
    function GetTempPath : String;
    procedure SetTempPath(Temppath : String);
    function AddBackSlash(DirName : String) : String;
    Procedure CleanUpMultiMedia;
    function IsValidMultiMedia(Name : PChar) : boolean;
    procedure TimerNotify(var Message: TMessage); message WM_TIMER;
    procedure PrintICOWMF(X, Y, pWidth, pHeight: Integer);
    procedure PrintBitmap(X, Y, pWidth, pHeight: Integer);
    procedure LoadMessageFromStream(MessageStream : TStream);
    Procedure MoveMsg(Var WinMsg : TMessage); message WM_Trigger;
    Function Delay(Ms : Integer) : boolean;
    Function SaveMessageToStream(MFont  : Tfont;
                                 Mspeed : Integer;
                                 MColor : Tcolor;
                                 MMsg   : String) : Boolean;
    Procedure MoveCredMsg(Var WinMsg : TMessage); message WM_CTrigger;
    procedure LoadCreditMessageFromStream(MessageStream : TStream);
    Function SaveCreditMessageToStream(MFont  : Tfont;
                                       Mspeed : integer;
                                       MColor : Tcolor;
                                       MMsg   : TStringList) : Boolean;
   public
    BFiletype           :  String;
    Bwidth              :  Integer;
    BHeight             :  Integer;
    Bbitspixel          :  Integer;
    Bplanes             :  Integer;
    Bnumcolors          :  Integer;
    BSize               :  Longint;
    Bcompression        :  String;
    {scrolling message stuff}
    MsgText             :  String;
    MsgFont             :  TFont;
    MsgBkGrnd           :  TColor;
    MsgSpeed            :  Integer;
    {credit message}
    CreditBoxList       :  TStringList;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CopyToClipboard;
    procedure CutToClipboard;
    procedure LoadMedia;
    procedure PasteFromClipboard;
    procedure LoadFromFile(Filename : TFilename);
    procedure SaveToFile(Filename : TFilename);
    procedure SaveToFileAsGIF(Filename : TFilename);
    procedure SaveToFileAsPCX(Filename : TFilename);
    procedure SaveToFileAsPNG(Filename : TFilename);
    procedure SaveToFileAsBMP(Filename : TFilename);
    procedure SaveToFileAsJPG(Filename : TFilename);
    function GetInfoAndType : String;
    function GetMultiMediaExtensions : String;
    property Field: TField read GetField;
    property Picture: TPicture read FPicture write SetPicture;
    Procedure Trigger;
    Function CreateMessage : Boolean;
    procedure NewMessage;
    Procedure FreeMsg;
    Procedure ScrollErrorMessage(ErString : String);
    {credit message}
    Function CreateCreditMessage : Boolean;
    procedure NewCreditMessage;
    procedure PrintMultiImage(X, Y, pWidth, pHeight: Integer);
  published
    property ImageReadRes : TResolution read FReadResolution write SetReadRes;
    property ImageWriteRes : TResolution read FWriteResolution write SetWriteRes;
    property ImageDither : Boolean read FDither write FDither;
    property PNGInterLaced : Boolean read FInterlaced write FInterlaced default False;
    property JPegSaveQuality : Byte read GetQuality write SetQuality;
    property JPegSaveSmooth : Byte read GetSmooth write SetSmooth;
    property UpdateAsJPG : Boolean read FUpdateAsJPG write SetUpdateAsJPG;
    property UpdateAsBMP : Boolean read FUpdateAsBMP write SetUpdateAsBMP;
    property UpdateAsGIF : Boolean read FUpdateAsGIF write SetUpdateAsGIF;
    property UpdateAsPCX : Boolean read FUpdateAsPCX write SetUpdateAsPCX;
    property UpdateAsPNG : Boolean read FUpdateAsPNG write SetUpdateAsPNG;
    property AutoPlayMultiMedia : Boolean read FAutoPlayMM write FAutoPlayMM;
    property AutoRePlayMultiMedia : Boolean read FAutoRePlayMM write FAutoRePlayMM;
    property AutoHideMediaPlayer : Boolean read FAutoMMHide write FAutoMMHide;
    property PathForTempFile : String read GetTempPath write SetTempPath;
    property Align;
    property AutoDisplay: Boolean read FAutoDisplay write SetAutoDisplay default True;
    property BorderStyle: TBorderStyle read FBorderStyle write SetBorderStyle default bsSingle;
    property Center: Boolean read FCenter write SetCenter default True;
    property Color;
    property Ctl3D;
    property DataField: String read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property MediaPlayer: TPDBMediaPlayer read GetMediaPlayer write SetmediaPlayer;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ImageLibPalette : Boolean read FImageLibPalette write FImageLibPalette default True;
    property ParentColor default False;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly default False;
    property ShowHint;
    property Stretch: Boolean read FStretch write SetStretch default False;
    property TabOrder;
    property TabStop default True;
    property TempMov : String Read FMOVTempFile write FMOVTempFile;
    property TempAVI : String Read FAVITempFile write FAVITempFile;
    property TempWAV : String Read FWAVTempFile write FWAVTempFile;
    property TempMID : String Read FMIDTempFile write FMIDTempFile;
    property TempRMI : String Read FRMITempFile write FRMITempFile;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;


var
 TPDBMultiImageCallBack : TCallBackFunction;
 TPDBMultiMediaCallBack : TCallBackFunction;

{------------------------------------------------------------------------}
implementation
uses Consts, DBIErrs, DBITypes, Clipbrd, DBConsts, Dialogs;

{------------------------------------------------------------------------}

{TPDBMultiImage}
constructor TPDBMultiImage.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csFramed, csOpaque];
  Width := 105;
  Height := 105;
  TabStop := True;
  ParentColor := False;
  FPicture := TPicture.Create;
  FPicture.OnChange := PictureChanged;
  FBorderStyle := bsSingle;
  FAutoDisplay := True;
  FImageLibPalette:=True;
  FCenter := True;
  FUpdateAsJPG := True;
  FDither:=True;
  FReadResolution := Color256;
  FWriteResolution := Color256;
  FSaveQuality:=25;
  FSaveSmooth:=0;
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
  FDataLink.OnUpdateData := UpdateData;
  MsgFont:=TFont.Create;
  BitMsg := TBitmap.Create;
  MessageRunning:=False;
  CMessageRunning:=False;
  SetupMsg30:=Nil;
  SetupCredMsg30:=Nil;
  CreditBoxList:=TStringList.Create;
  Creditcounter:=0;
  DelayCounter:=0;
  Color:=clWindow;
end;
{------------------------------------------------------------------------}

destructor TPDBMultiImage.Destroy;
begin
  FPicture.Free;
  FDataLink.Free;
  MsgFont.Free;
  BitMsg.Free;
  FDataLink := nil;
  CreditBoxList.Free;
  inherited Destroy;
end;
{------------------------------------------------------------------------}

function TPDBMultiImage.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
end;
{------------------------------------------------------------------------}

function TPDBMultiImage.GetDataField: String;
begin
  Result := FDataLink.FieldName;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetDataField(const Value: String);
begin
  FDataLink.FieldName := Value;
end;
{------------------------------------------------------------------------}

function TPDBMultiImage.GetReadOnly: Boolean;
begin
  Result := FDataLink.ReadOnly;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetReadOnly(Value: Boolean);
begin
  FDataLink.ReadOnly := Value;
end;
{------------------------------------------------------------------------}

function TPDBMultiImage.GetField: TField;
begin
  Result := FDataLink.Field;
end;
{------------------------------------------------------------------------}

function TPDBMultiImage.GetPalette: HPALETTE;
begin
  Result := 0;
  If ImageLibPalette then Exit;
  If FPicture.Graphic is TBitmap then
    Result := TBitmap(FPicture.Graphic).Palette;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetAutoDisplay(Value: Boolean);
begin
  If FAutoDisplay <> Value then
  begin
    FAutoDisplay := Value;
    If Value then LoadPicture;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetBorderStyle(Value: TBorderStyle);
begin
  If FBorderStyle <> Value then
  begin
    FBorderStyle := Value;
    RecreateWnd;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetCenter(Value: Boolean);
begin
  If FCenter <> Value then
  begin
    FCenter := Value;
    Invalidate;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetStretch(Value: Boolean);
begin
  If FStretch <> Value then
  begin
    FStretch := Value;
    Invalidate;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.Paint;
var
  W, H        : Integer;
  R           : TRect;
  S           : String[63];
  OldBitmap   : HBitmap;
  MemDC       : HDC;
  hOldPal     : HPalette;
begin

  If (BFileType = 'ICO') or (BFileType = 'WMF') or (not ImageLibPalette) then begin
      PaintTheDelpiWay;
      Exit;
  end;

  with Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color := Color;

    If FPictureLoaded then begin
      If (Stretch) and (Picture.Graphic <> nil) then

        If Picture.Graphic.Empty then
          FillRect(ClientRect) else
         begin

            hOldPal := SelectPalette(Canvas.handle,Picture.Bitmap.Palette,False);
            RealizePalette(Canvas.handle);

            MemDC := CreateCompatibleDC(Canvas.handle);
            OldBitmap := SelectObject(MemDC,Picture.Bitmap.Handle);

            SetStretchBltMode(Canvas.handle,STRETCH_DELETESCANS);

            StretchBlt(Canvas.handle,
                       ClientRect.Left,
                       ClientRect.Top,
                       ClientRect.Right,
                       ClientRect.Bottom,
                       MemDC,
                       ClientRect.Left,
                       ClientRect.Top,
                       Picture.Bitmap.Width,
                       Picture.Bitmap.Height,
                       srcCopy);

             SelectObject(MemDC,OldBitmap);
             DeleteDC(MemDC);
             SelectPalette(Canvas.handle,hOldPal,False);
      end else begin

        SetRect(R, 0, 0, Picture.Width, Picture.Height);
        If Center then OffsetRect(R, (ClientWidth - Picture.Width) div 2,
          (ClientHeight - Picture.Height) div 2);

           hOldPal := SelectPalette(Canvas.handle,Picture.Bitmap.Palette,False);
           RealizePalette(Canvas.handle);

           MemDC := CreateCompatibleDC(Canvas.handle);
           OldBitmap := SelectObject(MemDC,Picture.Bitmap.Handle);

            BitBlt(Canvas.handle,
                       R.Left,
                       R.Top,
                       Picture.Bitmap.Width,
                       Picture.Bitmap.Height,
                       MemDC,
                       0,
                       0,
                       srcCopy);

             SelectObject(MemDC,OldBitmap);
             DeleteDC(MemDC);
             SelectPalette(Canvas.handle,hOldPal,False);

             ExcludeClipRect(Handle, R.Left, R.Top, R.Right, R.Bottom);
             FillRect(ClientRect);
             SelectClipRgn(Handle, 0);
          end;
    end else begin
     Font := Self.Font;
     If FDataLink.Field <> nil then
        S := FDataLink.Field.DisplayLabel
     else
        S := Name;
      S := '(' + S + ')';
      W := TextWidth(S);
      H := TextHeight(S);
      R := ClientRect;
      TextRect(R, (R.Right - W) div 2, (R.Bottom - H) div 2, S);
    end;

    If (GetParentForm(Self).ActiveControl = Self) and
      not (csDesigning in ComponentState) then begin
        Brush.Color := clWindowFrame;
        FrameRect(ClientRect);
    end;

  end;

  If (CMessageRunning) and (Picture = nil) then FreeMsg;
  If (MessageRunning) and (Picture = nil) then FreeMsg;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.PaintTheDelpiWay;
var
  W, H: Integer;
  R: TRect;
  S: String[63];
begin
  with Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := Color;
    If FPictureLoaded then
    begin
      If (Stretch) and (Picture.Graphic <> nil) then
        If Picture.Graphic.Empty then
          FillRect(ClientRect) else
          StretchDraw(ClientRect, Picture.Graphic)
      else
      begin
        SetRect(R, 0, 0, Picture.Width, Picture.Height);
        If Center then OffsetRect(R, (ClientWidth - Picture.Width) div 2,
          (ClientHeight - Picture.Height) div 2);
        StretchDraw(R, Picture.Graphic);
        ExcludeClipRect(Handle, R.Left, R.Top, R.Right, R.Bottom);
        FillRect(ClientRect);
        SelectClipRgn(Handle, 0);
      end;
    end else
    begin
      Font := Self.Font;
      If FDataLink.Field <> nil then
        S := FDataLink.Field.DisplayLabel else
        S := Name;
      S := '(' + S + ')';
      W := TextWidth(S);
      H := TextHeight(S);
      R := ClientRect;
      TextRect(R, (R.Right - W) div 2, (R.Bottom - H) div 2, S);
    end;
    If (GetParentForm(Self).ActiveControl = Self) and
      not (csDesigning in ComponentState) then
    begin
      Brush.Color := clWindowFrame;
      FrameRect(ClientRect);
    end;
  end;

  If (CMessageRunning) and (Picture = nil) then FreeMsg;
  If (MessageRunning) and (Picture = nil) then FreeMsg;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.PictureChanged(Sender: TObject);
begin
  FDataLink.Modified;
  FPictureLoaded := True;
  Invalidate;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  If (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.LoadPicture;
var
   Stream       :  TMemoryStream;
   Bitmap       :  TBitmap;
   Cursor       :  hCursor;
   Temp         :  String;
   Dith         :  Integer;
   ReadRes      :  Integer;

begin
  If not FPictureLoaded and (FDataLink.Field is TBlobField) then begin

  If TBlobField(FDataLink.Field).IsNull then Exit;

  If FReadResolution = Color16 then ReadRes := 4;
  If FReadResolution = Color256 then ReadRes := 8;
  If FReadResolution = ColorTrue then ReadRes := 24;

  If FDither then
    Dith:=1
  else
    Dith:=0;

   Temp:=GetInfoAndType;

   If Temp = 'SCM' then begin
      Stream:=TMemoryStream.Create;
      try
        Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         LoadMessageFromStream(Stream);
         If @TPDBMultiImageCallBack <> nil then
           TPDBMultiImageCallBack(0);
       finally
         SetCursor(Cursor);
         Stream.Free;
       end;
   end else

   If Temp = 'CMS' then begin
      Stream:=TMemoryStream.Create;
      try
        Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         LoadCreditMessageFromStream(Stream);
         If @TPDBMultiImageCallBack <> nil then
           TPDBMultiImageCallBack(0);
       finally
         SetCursor(Cursor);
         Stream.Free;
       end;
   end else

   If Temp = 'PNG' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not PNGblob(Stream.Memory,Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty PNG blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(Bitmap);
         finally
            SetCursor(Cursor);
            Bitmap.free;
            Stream.Free;
         end;
   end else

   If Temp = 'GIF' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not GIFblob(Stream.Memory,Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty GIF blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(Bitmap);
         finally
            SetCursor(Cursor);
            Bitmap.free;
            Stream.Free;
         end;
   end else

   If Temp = 'PCX' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not PCXblob(Stream.Memory,Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty PCX blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(Bitmap);
         finally
          SetCursor(Cursor);
          Bitmap.free;
          Stream.Free;
         end;
   end else

   If Temp = 'BMP' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not BMPblob(Stream.Memory,Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty BMP blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(Bitmap);
         finally
          SetCursor(Cursor);
          Bitmap.free;
          Stream.Free;
         end;
   end else

   If Temp = 'JPG' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not JPGblob(Stream.Memory,Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty Jpeg Blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
             Picture.Assign(Bitmap);
         finally
             SetCursor(Cursor);
             Bitmap.free;
             Stream.Free;
         end;
    end;
    GetInfoAndType;
 end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.DataChange(Sender: TObject);
begin
  If CMessageRunning then FreeMsg;
  If MessageRunning then FreeMsg;
  Picture.Graphic := nil;
  FPictureLoaded := False;
  If FAutoDisplay then LoadPicture;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetUpdateAsJPG(Value: Boolean);
begin
    FUpdateAsJPG:=True;
    FUpdateAsBMP:=False;
    FUpdateAsGIF:=False;
    FUpdateAsPCX:=False;
    FUpdateAsPNG:=False;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetUpdateAsGIF(Value: Boolean);
begin
    FUpdateAsJPG:=False;
    FUpdateAsBMP:=False;
    FUpdateAsGIF:=True;
    FUpdateAsPCX:=False;
    FUpdateAsPNG:=False;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetUpdateAsPCX(Value: Boolean);
begin
    FUpdateAsJPG:=False;
    FUpdateAsBMP:=False;
    FUpdateAsGIF:=False;
    FUpdateAsPCX:=True;
    FUpdateAsPNG:=False;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetUpdateAsBMP(Value: Boolean);
begin
    FUpdateAsJPG:=False;
    FUpdateAsBMP:=True;
    FUpdateAsGIF:=False;
    FUpdateAsPCX:=False;
    FUpdateAsPNG:=False;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetUpdateAsPNG(Value: Boolean);
begin
    FUpdateAsJPG:=False;
    FUpdateAsBMP:=False;
    FUpdateAsGIF:=False;
    FUpdateAsPCX:=False;
    FUpdateAsPNG:=True;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.UpdateData(Sender: TObject);
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  Longint;
   x,y          :  Longint;
   p            :  Pointer;
   WriteRes     :  Integer;
   InterL       :  Byte;
begin
  If FDataLink.Field is TBlobField then begin

    If Picture.Graphic is TBitmap then begin
      x:=Picture.Bitmap.Width;
      y:=Picture.Bitmap.Height;

      y:=y+(y div 5);
      x:=x+(x div 5);

      Usize:=(y * x);

      If Usize < 90000 then Usize:=Usize*2;

      {Since we can't know how much memory we need to allocate
      to write the picture to the stream we need to guess it. This
      is done using the width and height of the Bitmap. After the call
      to the dll using PUTJPGBLOB or PUTBMPBLOB Usize contains the
      correct size of the Bitmap stored in P^. You can increase or decrease
      the guessed memory by altering the Div by. For instance

      y:=y+(y div 3);
      x:=x+(x div 3);

      will allocate more memory then

      y:=y+(y div 6);
      x:=x+(x div 6);

      We played it on the save side. Use this "guess work" very carefully}


      P := GlobalAllocPtr(HeapAllocFlags, Usize);

      If P = Nil then
        Exit;

      If FWriteResolution = Color16 then WriteRes := 4;
      If FWriteResolution = Color256 then WriteRes := 8;
      If FWriteResolution = ColorTrue then WriteRes := 24;

      If FInterlaced then InterL :=1 else InterL :=0;

      If FUpdateAsJPG then
         If not putJPGblob(P, USize, FSaveQuality, FSaveSmooth, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('Jpeg BLOB Write Error', mtInformation, [mbOk], 0);

      If FUpdateAsBMP then
         If not putBMPblob(P, USize, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('BMP BLOB Write Error', mtInformation, [mbOk], 0);

      If FUpdateAsPCX then
         If not putPCXblob(P, USize, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('PCX BLOB Write Error', mtInformation, [mbOk], 0);

      If FUpdateAsGIF then
         If not putGIFblob(P, USize, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('GIF BLOB Write Error', mtInformation, [mbOk], 0);

      If FUpdateAsPNG then
         If not putPNGblob(P, USize, WriteRes, InterL, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('PNG BLOB Write Error', mtInformation, [mbOk], 0);


      Stream:=TMemoryStream.Create;
      Stream.Write(P^,USize);
      GlobalFreePtr(P);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;

    end else
      TBlobField(FDataLink.Field).Clear;
   end;
   GetInfoAndType;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.CopyToClipboard;
begin
  If Picture.Graphic <> nil then Clipboard.Assign(Picture);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.CutToClipboard;
begin
  If Picture.Graphic <> nil then
  begin
    CopyToClipboard;
    If FDataLink.Edit then
      Picture.Graphic := nil;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.PasteFromClipboard;
begin
  If Clipboard.HasFormat(CF_PICTURE) and FDataLink.Edit then begin
    CMessageRunning:=False;
    MessageRunning:=False;
    Picture.Assign(Clipboard);
   end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  If FBorderStyle = bsSingle then
    Params.Style := Params.Style or WS_BORDER;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key, Shift);
  case Key of
    VK_INSERT:
      If ssShift in Shift then PasteFromClipBoard else
        If ssCtrl in Shift then CopyToClipBoard;
    VK_DELETE:
      If ssShift in Shift then CutToClipBoard;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    ^X: CutToClipBoard;
    ^C: CopyToClipBoard;
    ^V: PasteFromClipBoard;
    #13: LoadPicture;
    #27: FDataLink.Reset;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.CMEnter(var Message: TCMEnter);
begin
  Invalidate; { Draw the focus marker }
  inherited;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.CMExit(var Message: TCMExit);
begin
  Invalidate; { Erase the focus marker }
  inherited;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.CMTextChanged(var Message: TMessage);
begin
  inherited;
  If not FPictureLoaded then Invalidate;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.WMLButtonDown(var Message: TWMLButtonDown);
begin
  If TabStop and CanFocus then SetFocus;
  inherited;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.WMLButtonDblClk(var Message: TWMLButtonDblClk);
begin
  LoadPicture;
  inherited;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.WMCut(var Message: TMessage);
begin
  CutToClipboard;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.WMCopy(var Message: TMessage);
begin
  CopyToClipboard;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.WMPaste(var Message: TMessage);
begin
  PasteFromClipboard;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.LoadFromFile(Filename : TFilename);
var
   Cursor       :  hCursor;
begin
  If not FileExists(Filename) then begin
    MessageDlg('File not found', mtInformation, [mbOk], 0);
    Exit;
  end;

  If UpperCase(ExtractFileExt(Filename)) <> '.JPG' then
  If UpperCase(ExtractFileExt(Filename)) <> '.GIF' then
  If UpperCase(ExtractFileExt(Filename)) <> '.PCX' then
  If UpperCase(ExtractFileExt(Filename)) <> '.BMP' then
  If UpperCase(ExtractFileExt(Filename)) <> '.PNG' then
  If UpperCase(ExtractFileExt(Filename)) <> '.SCM' then
  If UpperCase(ExtractFileExt(Filename)) <> '.CMS' then
  begin
    MessageDlg('Not a Jpeg, GIF, PCX, SCM, PNG, CMS or BMP File', mtInformation, [mbOk], 0);
    Exit;
  end;

  If FDataLink.Field is TBlobField then begin
    Cursor := SetCursor(LoadCursor(0,idc_Wait));
    TBlobField(FDataLink.Field).LoadFromFile(Filename);
    SetCursor(Cursor);
  end else begin
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;
  GetInfoAndType;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SaveToFile(Filename : TFilename);
var
  Cursor       :  hCursor;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));
    TBlobField(FDataLink.Field).SaveToFile(Filename);
    GetInfoAndType;
    SetCursor(Cursor)

  end else begin
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SaveToFileAsBMP(Filename : TFilename);
var
  Cursor       :  hCursor;
  WriteRes     :  Integer;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If FWriteResolution = Color16 then WriteRes := 4;
    If FWriteResolution = Color256 then WriteRes := 8;
    If FWriteResolution = ColorTrue then WriteRes := 24;

    If not putBMPfile(Filename, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing BMP file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SaveToFileAsGIF(Filename : TFilename);
var
  Cursor       :  hCursor;
  WriteRes     :  Integer;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If FWriteResolution = Color16 then WriteRes := 4;
    If FWriteResolution = Color256 then WriteRes := 8;
    If FWriteResolution = ColorTrue then WriteRes := 24;

    If not putGIFfile(Filename, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing GIF file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SaveToFileAsPCX(Filename : TFilename);
var
  Cursor       :  hCursor;
  WriteRes     :  Integer;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If FWriteResolution = Color16 then WriteRes := 4;
    If FWriteResolution = Color256 then WriteRes := 8;
    If FWriteResolution = ColorTrue then WriteRes := 24;

    If not putPCXfile(Filename, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing PCX file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SaveToFileAsPNG(Filename : TFilename);
var
  Cursor       :  hCursor;
  WriteRes     :  Integer;
  InterL       :  Byte;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If FWriteResolution = Color16 then WriteRes := 4;
    If FWriteResolution = Color256 then WriteRes := 8;
    If FWriteResolution = ColorTrue then WriteRes := 24;
    If FInterlaced then InterL :=1 else InterL :=0;

    If not putPNGfile(Filename, WriteRes, Interl, Picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing PNG file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SaveToFileAsJPG(Filename : TFilename);
var
  Cursor       :  hCursor;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap = nil then begin
       MessageDlg('Can''t save, image is not displayed', mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If not putJPGfile(Filename, FSaveQuality, FSaveSmooth, picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing JPG file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;


{------------------------------------------------------------------------}

function TPDBMultiImage.GetInfoAndType : String;
var
 Stream       :  TMemoryStream;
 Hdr          :  Array[0..45] of char;
 i            :  Byte;
begin
  If (FDataLink.Field is TBlobField) then
   If TBlobField(FDataLink.Field).IsNull then Exit;

   BFileType := 'Empty';
   Bwidth:=-1;
   BHeight:=-1;
   Bbitspixel:=-1;
   Bplanes:=-1;
   Bnumcolors:=-1;
   Bcompression:='-1';
   BSize:=-1;
   GetInfoAndType :='-1';

   Stream:=TMemoryStream.Create;
   TBlobField(FDataLink.Field).SaveToStream(Stream);

  If Stream.Memory = nil then begin
     MessageDlg('Error allocation Temporary blob memory', mtInformation, [mbOk], 0);
     Exit;
  end;

  Stream.Seek(0,0);
  Stream.read(hdr,SizeOf(Hdr)-1);

  for i:=0 to SizeOf(hdr)-1 do
   If hdr[i] = #0 then hdr[i]:=' ';

  If StrPos(hdr,'kevinjan') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MSG';
        BSize:=Stream.Size;
        BFileType:= 'SCM';
        GetInfoAndType:='SCM';
        If Stream.Memory <> nil then Stream.Free;
        Exit;
   end else

  If StrPos(hdr,'jankevin') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MSG';
        BSize:=Stream.Size;
        BFileType:= 'CMS';
        GetInfoAndType:='CMS';
        If Stream.Memory <> nil then Stream.Free;
        Exit;
   end else

   If not GetBlobInfo(Stream.Memory,
                    Stream.Size,
                    BFileType,
                    Bwidth,
                    BHeight,
                    Bbitspixel,
                    Bplanes,
                    Bnumcolors,
                    Bcompression) then
    MessageDlg('blobfield getinfo failed', mtInformation, [mbOk], 0) else
    begin
         BSize:=Stream.Size;
         If UpperCase(BFileType) = 'PNG' then GetInfoAndType:='PNG' else
         If UpperCase(BFileType) = 'GIF' then GetInfoAndType:='GIF' else
         If UpperCase(BFileType) = 'PCX' then GetInfoAndType:='PCX' else
         If UpperCase(BFileType) = 'JPEG' then GetInfoAndType:='JPG' else
         If UpperCase(BFileType) = 'BMP' then GetInfoAndType:='BMP';
    end;
  If Stream.Memory <> nil then Stream.Free;
end;
{------------------------------------------------------------------------}

function TPDBMultiImage.GetSmooth : Byte;
begin
  GetSmooth:=FSaveSmooth;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetSmooth(Smooth : Byte);
begin
  If (Smooth > 100) or (Smooth < 0) then FSaveSmooth:=5 else
   FSaveSmooth:=Smooth;
end;
{------------------------------------------------------------------------}

function TPDBMultiImage.GetQuality : Byte;
begin
  GetQuality:=FSaveQuality;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetQuality(Quality : Byte);
begin
  If (Quality > 100) OR (Quality < 1) then FSaveQuality:=25 else
   FSaveQuality:=Quality;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetReadRes(Res : TResolution);
begin
  FReadResolution := Res;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.SetWriteRes(Res : TResolution);
begin
  FWriteResolution := Res;
end;
{------------------------------------------------------------------------}

{------------------------------------------------------------------------
 scrolling message stuff
------------------------------------------------------------------------}

procedure TPDBMultiImage.LoadMessageFromStream(MessageStream : TStream);
var
  Msg      : TLabel;
begin
  FreeMsg;
  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  readmessagefromstream(MessageStream, MsgFont, MsgSpeed, MsgBkGrnd, MsgText);
  Refresh;
  If MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitWidth:=Msg.Width;
  SMessageLeft := ScreenWd;
  SMessageRight := ScreenWd + Msg.Width;
  SMessageTop := (ScreenHt - Msg.Height) Div 2;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   MessageRunning:=True;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.NewMessage;
var
  Msg      : TLabel;
begin
  FreeMsg;
  If MsgText = '' then Exit;
  If MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';
  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  Refresh;
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitWidth:=Msg.Width;
  SMessageLeft := ScreenWd;
  SMessageRight := ScreenWd + Msg.Width;
  SMessageTop := (ScreenHt - Msg.Height) Div 2;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   MessageRunning:=True;
end;
{------------------------------------------------------------------------}

Function TPDBMultiImage.CreateMessage : Boolean;
begin
 Result:=False;
 SetupMsg30:=TSetupMsg30.Create(Self);
 SetupMsg30.ShowModal;
 If SetupMsg30.ModalResult = mrOK then begin
  Result:=SaveMessageToStream(SetupMsg30.MessageFont,
                              SetupMsg30.MessageSpeed,
                              SetupMsg30.MessageColor,
                              SetupMsg30.MessageMsg);
 end;
 SetupMsg30.destroy;
 SetupMsg30:=Nil;
end;
{------------------------------------------------------------------------}

Procedure TPDBMultiImage.FreeMsg;
Begin
  If MessageRunning then
   Color:=OldColor;
  If CMessageRunning then
   Color:=OldColor;
  CMessageRunning:=False;
  MessageRunning:=False;
  Picture.Assign(nil);
end;
{------------------------------------------------------------------------}

Function TPDBMultiImage.Delay(Ms : Integer) : boolean;
Begin
 Inc(DelayCounter);
 If DelayCounter > MS then begin
  DelayCounter:=0;
  Result:=True;
 end else
  Result:=False;
end;
{------------------------------------------------------------------------}

Procedure TPDBMultiImage.MoveMsg(Var WinMsg : TMessage);
Begin
  If Not MessageRunning then Exit;
  If Not Delay(MsgSpeed)then Exit;
  Dec(SMessageLeft,1);
  Dec(SMessageRight,1);
  Inc(MmsgCount,1);
  If SMessageRight < 0 then begin
    SMessageLeft := ScreenWd;
    SMessageRight := SMessageLeft + BitWidth;
  end;
    with Canvas do
       Draw(SMessageLeft,SMessageTop,BitMsg);
end;
{------------------------------------------------------------------------}

Procedure TPDBMultiImage.Trigger;
Begin
  If SetupMsg30 <> nil then SetupMsg30.Trigger;
  If SetupCredMsg30 <> nil then SetupCredMsg30.Trigger;

  If (visible) and (enabled) then begin
   PostMessage(Handle, WM_Trigger, 0, 0);
   PostMessage(Handle, WM_CTrigger, 0, 0);
  end;

End;
{------------------------------------------------------------------------}

Function TPDBMultiImage.SaveMessageToStream(MFont  : Tfont;
                                           Mspeed : Integer;
                                           MColor : Tcolor;
                                           MMsg   : String) : Boolean;
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  Longint;
   P            :  Array[0..1602] of char;
begin
  Result:=True;
  If FDataLink.Field is TBlobField then begin
     If Length(MMsg) < 1 then
      begin
        Result:=False;
        Exit;
       end;

      Usize:=WriteMessageToStream(MFont, MSpeed, MColor, MMsg, P);

      If Usize < 1 then
       begin
        Result:=False;
        Exit;
       end;

      Stream:=TMemoryStream.Create;
      Stream.Write(P,Usize+1);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;
     GetInfoAndType;
   end;
end;


{------------------------------------------------------------------------
 credit message stuff
------------------------------------------------------------------------}

procedure TPDBMultiImage.LoadCreditMessageFromStream(MessageStream : TStream);
var
  Msg      : TLabel;
begin
  Picture.Assign(nil);
  ReadCreditFromStream(MessageStream, MsgFont, MsgSpeed, MsgBkGrnd, CreditBoxList);
  Creditcounter:=0;
  If CreditBoxList.Count <1 then Exit;
  MsgText:=CreditBoxList.Strings[Creditcounter];

  If MsgText = '' then Exit;
  If MsgText[1] <> ' ' then MsgText:='  ' + MsgText;
  If MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';

  ScreenWd:=Width;
  ScreenHt:=Height;
  Refresh;
  Msg := TLabel.Create(Self);
  Refresh;
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  Msg.Width:=Msg.Width+(Msg.Width div (Length(MsgText)-2));
  BitHeight:=Msg.Height;
  BitWidth:=Msg.Width;
  SMessageLeft :=(ScreenWd - Msg.Width) Div 2;
  SMessageTop := ScreenHt;
  SMessageBottom := SMessageTop + Msg.Height;

  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height+5;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color:=MsgBkGrnd;
    Rectangle(0, 0, Width, Height);
  end;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Pen.Color:=MsgBkGrnd;
    Rectangle(0, 0, BitMsg.Width, BitMsg.Height);
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   CMessageRunning:=True;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiImage.NewCreditMessage;
var
  Msg : TLabel;
begin
  If CreditBoxList.Count <1 then Exit;
  If Creditcounter > CreditBoxList.Count then Creditcounter:=0;

  MsgText:=CreditBoxList.Strings[Creditcounter];
  If MsgText = '' then Exit;

  If MsgText[1] <> ' ' then MsgText:='  ' + MsgText;
  If MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';

  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  Refresh;
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitHeight:=Msg.Height;
  Msg.Width:=Msg.Width+(Msg.Width div (Length(MsgText)-2));
  BitWidth:=Msg.Width;
  SMessageLeft :=(ScreenWd - Msg.Width) Div 2;
  SMessageTop := ScreenHt;
  SMessageBottom := SMessageTop + Msg.Height;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height+5;
  if not CMessageRunning then
   OldColor:=Color;
  Color:=MsgBkGrnd;

  with Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color:=MsgBkGrnd;
    Rectangle(0, 0, Width, Height);
  end;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Pen.Color:=MsgBkGrnd;
    Rectangle(0, 0, BitMsg.Width, BitMsg.Height);
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   CMessageRunning:=True;
end;
{------------------------------------------------------------------------}

Function TPDBMultiImage.SaveCreditMessageToStream(MFont  : Tfont;
                                                  Mspeed : integer;
                                                  MColor : Tcolor;
                                                  MMsg   : TStringList) : Boolean;
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  longInt;
   P            :  PChar;
begin
  Result:=True;
  if FDataLink.Field is TBlobField then begin

      GetMem(P,65528);

      Usize:=WriteCreditToStream(MFont, MSpeed, MColor, MMsg, P);

      If Usize < 1 then
       begin
        Result:=False;
        FreeMem(P,65528);
        exit;
       end;

      Stream:=TMemoryStream.Create;
      Stream.Write(P^,Usize+1);

      FreeMem(P,65528);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;

     GetInfoAndType;
   end;
end;

{------------------------------------------------------------------------}

Function TPDBMultiImage.CreateCreditMessage : Boolean;
begin
 Result:=False;

 SetupCredMsg30:=TSetupCredMsg30.Create(Self);

 SetupCredMsg30.ShowModal;

 if SetupCredMsg30.ModalResult = mrOK then begin
  Result:=SaveCreditMessageToStream(SetupCredMsg30.MessageFont,
                                    SetupCredMsg30.MessageSpeed,
                                    SetupCredMsg30.MessageColor,
                                    SetupCredMsg30.MessageStrList);
 end;
 SetupCredMsg30.destroy;
 SetupCredMsg30:=Nil;
end;

{------------------------------------------------------------------------}

Procedure TPDBMultiImage.MoveCredMsg(Var WinMsg : TMessage);
Begin
  If Not CMessageRunning then Exit;
  If not Delay(MsgSpeed) then Exit;
  Dec(SMessageTop,1);
  Dec(SMessageBottom,1);
  If SMessageTop < (0-BitHeight)-5 then begin
     If CreditBoxList.Count >0 then begin
        If Creditcounter < CreditBoxList.Count-1 then
           Inc(Creditcounter)
        else Creditcounter:=0;
        NewCreditMessage;
     end else begin
         SMessageTop := ScreenHt;
         SMessageBottom := SMessageTop + BitHeight;
     end;
  end;

  with Canvas do Draw(SMessageLeft,SMessageTop,BitMsg);
end;

{------------------------------------------------------------------------
Printing Stuff
------------------------------------------------------------------------}

procedure TPDBMultiImage.PrintMultiImage(X, Y, pWidth, pHeight: Integer);
begin
 If Picture.Graphic.Empty then Exit;

 If (BFiletype = 'ICO') or (BFiletype = 'WMF') then
   PrintICOWMF(X, Y, pWidth, pHeight)
 else
   PrintBitmap(X, Y, pWidth, pHeight)
end;
{---------------------------------------------------------------------}

procedure TPDBMultiImage.PrintBitmap(X, Y, pWidth, pHeight: Integer);
var
  Info     : PBitmapInfo;
  InfoSize : Integer;
  Image    : Pointer;
  ImageSize: Longint;
begin
   If (pWidth < 1) or (pHeight < 1) then begin
      pWidth:=Picture.Bitmap.Width;
      pHeight:=Picture.Bitmap.Height;
   end;

   Printer.Begindoc;

    with Picture.Bitmap do begin
      GetDIBSizes(Handle, InfoSize, ImageSize);
      Info := MemAlloc(InfoSize);
      try
        Image := MemAlloc(ImageSize);
        try
          GetDIB(Handle, Palette, Info^, Image^);
          with Info^.bmiHeader do
           StretchDIBits(Printer.Canvas.Handle, X, Y, pWidth,
            pHeight, 0, 0, biWidth, biHeight, Image, Info^,
            DIB_RGB_COLORS, SRCCOPY)
         finally
          FreeMem(Image, ImageSize);
         end;
      finally
       FreeMem(Info, InfoSize);
      end;
    end;
    Printer.Enddoc;
  end;
{---------------------------------------------------------------------}

procedure TPDBMultiImage.PrintICOWMF(X, Y, pWidth, pHeight: Integer);
begin
   If (pWidth < 1) or (pHeight < 1) then begin
    pWidth:=Picture.Graphic.Width;
    pHeight:=Picture.Graphic.Height;
   end;

   Printer.Begindoc;

   Printer.Canvas.StretchDraw(Rect(X, Y, pWidth, pHeight), Picture.Graphic);

   Printer.Enddoc;
end;
{------------------------------------------------------------------------
 end TPDBMultiImage
------------------------------------------------------------------------}



{TPDBMultiMedia}

constructor TPDBMultiMedia.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csFramed, csOpaque];
  Width := 105;
  Height := 105;
  TabStop := True;
  ParentColor := False;
  FPicture := TPicture.Create;
  FPicture.OnChange := PictureChanged;
  FBorderStyle := bsSingle;
  FAutoDisplay := True;
  FImageLibPalette:=True;
  FCenter := True;
  FUpdateAsJPG := True;
  FDither:=True;
  FReadResolution := Color256;
  FWriteResolution := Color256;
  FSaveQuality:=25;
  FSaveSmooth:=0;
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
  FDataLink.OnUpdateData := UpdateData;
  FMOVTempFile:='$$$.MOV';
  FMPGTempFile:='$$$.MPG';
  FAVITempFile:='$$$.AVI';
  FWAVTempFile:='$$$.WAV';
  FMIDTempFile:='$$$.MID';
  FRMITempFile:='$$$.RMI';
  FTempFilePath:='C:\';
  MsgFont:=TFont.Create;
  BitMsg := TBitmap.Create;
  MessageRunning:=False;
  CMessageRunning:=False;
  SetupMsg30:=Nil;
  SetupCredMsg30:=Nil;
  CreditBoxList:=TStringList.Create;
  Creditcounter:=0;
  DelayCounter:=0;
  Color:=clWindow;
  FAutoMMHide := False;
end;
{------------------------------------------------------------------------}

destructor TPDBMultiMedia.Destroy;
begin
  CleanUpMultiMedia;
  FPicture.Free;
  FDataLink.Free;
  MsgFont.Free;
  BitMsg.Free;
  FDataLink := nil;
  CreditBoxList.Free;
  inherited Destroy;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetDataField: String;
begin
  Result := FDataLink.FieldName;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetDataField(const Value: String);
begin
  FDataLink.FieldName := Value;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetReadOnly: Boolean;
begin
  Result := FDataLink.ReadOnly;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetReadOnly(Value: Boolean);
begin
  FDataLink.ReadOnly := Value;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetField: TField;
begin
  Result := FDataLink.Field;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetPalette: HPALETTE;
begin
  Result := 0;
  If ImageLibPalette then Exit;
  If FPicture.Graphic is TBitmap then
    Result := TBitmap(FPicture.Graphic).Palette;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetAutoDisplay(Value: Boolean);
begin
  If FAutoDisplay <> Value then
  begin
    FAutoDisplay := Value;
    If Value then LoadMedia;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetBorderStyle(Value: TBorderStyle);
begin
  If FBorderStyle <> Value then
  begin
    FBorderStyle := Value;
    RecreateWnd;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetCenter(Value: Boolean);
begin
  If FCenter <> Value then
  begin
    FCenter := Value;
    Invalidate;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetStretch(Value: Boolean);
begin
  If FStretch <> Value then
  begin
    FStretch := Value;
    Invalidate;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.Paint;
var
  W, H        : Integer;
  R           : TRect;
  S           : String[63];
  OldBitmap   : HBitmap;
  MemDC       : HDC;
  hOldPal     : HPalette;
begin

  If (BFileType = 'ICO') or (BFileType = 'WMF') or (not ImageLibPalette) then begin
      PaintTheDelpiWay;
      Exit;
  end;

  with Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color := Color;

    If FPictureLoaded then begin
      If (Stretch) and (Picture.Graphic <> nil) then

        If Picture.Graphic.Empty then
          FillRect(ClientRect) else
         begin

            hOldPal := SelectPalette(Canvas.handle,Picture.Bitmap.Palette,False);
            RealizePalette(Canvas.handle);

            MemDC := CreateCompatibleDC(Canvas.handle);
            OldBitmap := SelectObject(MemDC,Picture.Bitmap.Handle);

            SetStretchBltMode(canvas.handle,STRETCH_DELETESCANS);

            StretchBlt(Canvas.handle,
                       ClientRect.Left,
                       ClientRect.Top,
                       ClientRect.Right,
                       ClientRect.Bottom,
                       MemDC,
                       ClientRect.Left,
                       ClientRect.Top,
                       Picture.Bitmap.Width,
                       Picture.Bitmap.Height,
                       srcCopy);

             SelectObject(MemDC,OldBitmap);
             DeleteDC(MemDC);
             SelectPalette(Canvas.handle,hOldPal,False);
      end else begin

        SetRect(R, 0, 0, Picture.Width, Picture.Height);
        If Center then OffsetRect(R, (ClientWidth - Picture.Width) div 2,
          (ClientHeight - Picture.Height) div 2);

           hOldPal := SelectPalette(Canvas.handle,Picture.Bitmap.Palette,False);
           RealizePalette(Canvas.handle);

           MemDC := CreateCompatibleDC(Canvas.handle);
           OldBitmap := SelectObject(MemDC,Picture.Bitmap.Handle);

            BitBlt(Canvas.handle,
                       R.Left,
                       R.Top,
                       Picture.Bitmap.Width,
                       Picture.Bitmap.Height,
                       MemDC,
                       0,
                       0,
                       srcCopy);

             SelectObject(MemDC,OldBitmap);
             DeleteDC(MemDC);
             SelectPalette(Canvas.handle,hOldPal,False);

             ExcludeClipRect(Handle, R.Left, R.Top, R.Right, R.Bottom);
             FillRect(ClientRect);
             SelectClipRgn(Handle, 0);
      end;
    end else begin
     Font := Self.Font;
     If FDataLink.Field <> nil then
        S := FDataLink.Field.DisplayLabel
     else
        S := Name;
      S := '(' + S + ')';
      W := TextWidth(S);
      H := TextHeight(S);
      R := ClientRect;
      TextRect(R, (R.Right - W) div 2, (R.Bottom - H) div 2, S);
    end;

    If (GetParentForm(Self).ActiveControl = Self) and
      not (csDesigning in ComponentState) then begin
        Brush.Color := clWindowFrame;
        FrameRect(ClientRect);
    end;

  end;

  If (CMessageRunning) and (Picture = nil) then FreeMsg;
  If (MessageRunning) and (Picture = nil) then FreeMsg;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.PaintTheDelpiWay;
var
  W, H: Integer;
  R: TRect;
  S: String[63];
begin
  with Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := Color;
    If FPictureLoaded then
    begin
      If (Stretch) and (Picture.Graphic <> nil) then
        If Picture.Graphic.Empty then
          FillRect(ClientRect) else
          StretchDraw(ClientRect, Picture.Graphic)
      else
      begin
        SetRect(R, 0, 0, Picture.Width, Picture.Height);
        If Center then OffsetRect(R, (ClientWidth - Picture.Width) div 2,
          (ClientHeight - Picture.Height) div 2);
        StretchDraw(R, Picture.Graphic);
        ExcludeClipRect(Handle, R.Left, R.Top, R.Right, R.Bottom);
        FillRect(ClientRect);
        SelectClipRgn(Handle, 0);
      end;
    end else
    begin
      Font := Self.Font;
      If FDataLink.Field <> nil then
        S := FDataLink.Field.DisplayLabel else
        S := Name;
      S := '(' + S + ')';
      W := TextWidth(S);
      H := TextHeight(S);
      R := ClientRect;
      TextRect(R, (R.Right - W) div 2, (R.Bottom - H) div 2, S);
    end;
    If (GetParentForm(Self).ActiveControl = Self) and
      not (csDesigning in ComponentState) then
    begin
      Brush.Color := clWindowFrame;
      FrameRect(ClientRect);
    end;
  end;
  If (MessageRunning) and (Picture = nil) then FreeMsg;
  If (CMessageRunning) and (Picture = nil) then FreeMsg;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.PictureChanged(Sender: TObject);
begin
  FDataLink.Modified;
  FPictureLoaded := True;
  Invalidate;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  If (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;

  If (Operation = opRemove) and
    (AComponent = FMediaPlayer) then FMediaPlayer := nil;
end;
{------------------------------------------------------------------------}

Procedure TPDBMultiMedia.CleanUpMultiMedia;
begin
   If (csDesigning in ComponentState) then Exit;
   deletefile(FTempFilePath+FMPGTempFile);
   deletefile(FTempFilePath+FMOVTempFile);
   deletefile(FTempFilePath+FAVITempFile);
   deletefile(FTempFilePath+FWAVTempFile);
   deletefile(FTempFilePath+FMIDTempFile);
   deletefile(FTempFilePath+FRMITempFile);
end;

Procedure TPDBMultiMedia.ScrollErrorMessage(ErString : String);
begin
   FreeMsg;
   MsgText:=ErString;
   MsgFont.Name:='Arial';
   MsgFont.Size:=-16;
   MsgFont.Style:=[fsItalic];
   MsgFont.Color:=clWhite;
   MsgBkGrnd:=clTeal;
   MsgSpeed:=3;
   NewMessage;
end;

procedure TPDBMultiMedia.LoadMedia;
var
   Stream       :  TMemoryStream;
   Bitmap       :  TBitmap;
   Cursor       :  hCursor;
   Temp         :  String;
   Dith         :  Integer;
   ReadRes      :  Integer;

begin
  If not FPictureLoaded and (FDataLink.Field is TBlobField) then begin

   If TBlobField(FDataLink.Field).IsNull then Exit;

   Temp:=GetInfoAndType;

   If FMediaPlayer <> nil then
     FMediaPlayer.Close;

   CleanUpMultiMedia;

  If FReadResolution = Color16 then ReadRes := 4;
  If FReadResolution = Color256 then ReadRes := 8;
  If FReadResolution = ColorTrue then ReadRes := 24;

  If FDither then
    Dith:=1
  else
    Dith:=0;

  If Temp = 'SCM' then begin
      Stream:=TMemoryStream.Create;
      try
       If FMediaPlayer <> nil then
         If FAutoMMHide then
           FMediaPlayer.Visible:=False;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         LoadMessageFromStream(Stream);
         KillTimer(handle,1);
         If @TPDBMultiMediaCallBack <> nil then
           TPDBMultiMediaCallBack(0);
       finally
         SetCursor(Cursor);
         Stream.Free;
       end;
   end else

  If Temp = 'CMS' then begin
      Stream:=TMemoryStream.Create;
      try
       If FMediaPlayer <> nil then
         If FAutoMMHide then
           FMediaPlayer.Visible:=False;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         LoadCreditMessageFromStream(Stream);
         KillTimer(handle,1);
         If @TPDBMultiMediaCallBack <> nil then
           TPDBMultiMediaCallBack(0);
       finally
         SetCursor(Cursor);
         Stream.Free;
       end;
   end else

  If Temp = 'MPG' then begin
         try
            If (csDesigning in ComponentState) then Exit;

            If not IsValidMultiMedia('MPG') then begin
              ScrollErrorMessage('MPG Movie file can''t be played on this computer!');
              Exit;
            end;

              Cursor := SetCursor(LoadCursor(0,idc_Wait));
              FreeMsg;
              If FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=True;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FMPGTempFile);
               FMediaPlayer.Filename:=FTempFilePath+FMPGTempFile;
               FMediaPlayer.Open;
               If FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   If Temp = 'MOV' then begin
         try
            If (csDesigning in ComponentState) then Exit;

            If not IsValidMultiMedia('MOV') then begin
              ScrollErrorMessage('MOV Quicktime Movie file can''t be played on this computer!');
              Exit;
            end;

              Cursor := SetCursor(LoadCursor(0,idc_Wait));
              FreeMsg;
              If FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=True;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FMOVTempFile);
               FMediaPlayer.Filename:=FTempFilePath+FMOVTempFile;
               FMediaPlayer.Open;
               If FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   If Temp = 'AVI' then begin
         try
            If (csDesigning in ComponentState) then Exit;

            If not IsValidMultiMedia('AVI') then begin
              ScrollErrorMessage('AVI Movie file can''t be played on this computer!');
              Exit;
            end;

              Cursor := SetCursor(LoadCursor(0,idc_Wait));
              FreeMsg;
              If FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=True;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FAVITempFile);
               FMediaPlayer.Filename:=FTempFilePath+FAVITempFile;
               FMediaPlayer.Open;
               If FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   If Temp = 'WAV' then begin
         try
            If (csDesigning in ComponentState) then Exit;

            If not IsValidMultiMedia('WAV') then begin
              ScrollErrorMessage('Wave Sound file can''t be played on this computer!');
              Exit;
            end;

             Cursor := SetCursor(LoadCursor(0,idc_Wait));
             FreeMsg;
             If FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=True;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FWAVTempFile);
               FMediaPlayer.Filename:=FTempFilePath+FWAVTempFile;
               FMediaPlayer.Open;
               If FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   If Temp = 'MID' then begin
         try
            If (csDesigning in ComponentState) then Exit;

            If not IsValidMultiMedia('MID') then begin
              ScrollErrorMessage('Midi Sound file can''t be played on this computer!');
              Exit;
            end;

             Cursor := SetCursor(LoadCursor(0,idc_Wait));
             FreeMsg;
             If FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=True;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FMIDTempFile);
               FMediaPlayer.Filename:=FTempFilePath+FMIDTempFile;
               FMediaPlayer.Open;
               If FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   If Temp = 'RMI' then begin
         try
            If (csDesigning in ComponentState) then Exit;

            If not IsValidMultiMedia('RMI') then begin
              ScrollErrorMessage('RMI Sound file can''t be played on this computer!');
              Exit;
            end;

            Cursor := SetCursor(LoadCursor(0,idc_Wait));
            FreeMsg;
            If FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=True;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FRMITempFile);
               FMediaPlayer.Filename:=FTempFilePath+FRMITempFile;
               FMediaPlayer.Open;
               If FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   If Temp = 'PNG' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
       If FMediaPlayer <> nil then
         If FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not PNGblob(Stream.Memory,Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty PNG blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(Bitmap);
         finally
            SetCursor(Cursor);
            Bitmap.free;
            Stream.Free;
         end;
   end else

   If Temp = 'GIF' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
       If FMediaPlayer <> nil then
         If FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not GIFblob(Stream.Memory, Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty GIF blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(Bitmap);
         finally
            SetCursor(Cursor);
            Bitmap.free;
            Stream.Free;
         end;
   end else

   If Temp = 'PCX' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
       If FMediaPlayer <> nil then
         If FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not PCXblob(Stream.Memory, Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty PCX blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(Bitmap);
         finally
          SetCursor(Cursor);
          Bitmap.free;
          Stream.Free;
         end;
   end else

   If Temp = 'BMP' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
       If FMediaPlayer <> nil then
         If FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not BMPblob(Stream.Memory, Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty BMP blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(Bitmap);
         finally
          SetCursor(Cursor);
          Bitmap.free;
          Stream.Free;
         end;
   end else

   If Temp = 'JPG' then begin
      Stream:=TMemoryStream.Create;
      Bitmap:=TBitmap.Create;
      try
       If FMediaPlayer <> nil then
         If FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         If not JPGblob(Stream.Memory,Stream.Size, ReadRes, Dith, Bitmap, TPDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty Jpeg Blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
             Picture.Assign(Bitmap);
         finally
             SetCursor(Cursor);
             Bitmap.free;
             Stream.Free;
         end;
    end else
     KillTimer(handle,1);
    {GetInfoAndType;}
 end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.DataChange(Sender: TObject);
begin
  If CMessageRunning then FreeMsg;
  If MessageRunning then FreeMsg;
  Picture.Graphic := nil;
  FPictureLoaded := False;
  If FAutoDisplay then LoadMedia;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetUpdateAsJPG(Value: Boolean);
begin
    FUpdateAsJPG:=True;
    FUpdateAsBMP:=False;
    FUpdateAsGIF:=False;
    FUpdateAsPCX:=False;
    FUpdateAsPNG:=False;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetUpdateAsGIF(Value: Boolean);
begin
    FUpdateAsJPG:=False;
    FUpdateAsBMP:=False;
    FUpdateAsGIF:=True;
    FUpdateAsPCX:=False;
    FUpdateAsPNG:=False;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetUpdateAsPCX(Value: Boolean);
begin
    FUpdateAsJPG:=False;
    FUpdateAsBMP:=False;
    FUpdateAsGIF:=False;
    FUpdateAsPCX:=True;
    FUpdateAsPNG:=False;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetUpdateAsBMP(Value: Boolean);
begin
    FUpdateAsJPG:=False;
    FUpdateAsBMP:=True;
    FUpdateAsGIF:=False;
    FUpdateAsPCX:=False;
    FUpdateAsPNG:=False;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetUpdateAsPNG(Value: Boolean);
begin
    FUpdateAsJPG:=False;
    FUpdateAsBMP:=False;
    FUpdateAsGIF:=False;
    FUpdateAsPCX:=False;
    FUpdateAsPNG:=True;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.UpdateData(Sender: TObject);
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  Longint;
   x,y          :  Longint;
   p            :  Pointer;
   WriteRes     :  Integer;
   InterL       :  Byte;
begin
  If FDataLink.Field is TBlobField then begin

    If Picture.Graphic is TBitmap then begin
      x:=Picture.Bitmap.Width;
      y:=Picture.Bitmap.Height;

      y:=y+(y div 5);
      x:=x+(x div 5);

      Usize:=(y * x);

      If Usize < 90000 then Usize:=Usize*2;

      {Since we can't know how much memory we need to allocate
      to write the picture to the stream we need to guess it. This
      is done using the width and height of the Bitmap. After the call
      to the dll using PUTJPGBLOB or PUTBMPBLOB Usize contains the
      correct size of the Bitmap stored in P^. You can increase or decrease
      the guessed memory by altering the Div by. For instance

      y:=y+(y div 3);
      x:=x+(x div 3);

      will allocate more memory then

      y:=y+(y div 6);
      x:=x+(x div 6);

      We played it on the save side. Use this "guess work" very carefully}


      P := GlobalAllocPtr(HeapAllocFlags, Usize);
      If P = Nil then
        Exit;

      If FWriteResolution = Color16 then WriteRes := 4;
      If FWriteResolution = Color256 then WriteRes := 8;
      If FWriteResolution = ColorTrue then WriteRes := 24;

      If FInterlaced then InterL :=1 else InterL :=0;

      If FUpdateAsJPG then
         If not putJPGblob(P, USize, FSaveQuality, FSaveSmooth, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('Jpeg BLOB Write Error', mtInformation, [mbOk], 0);

      If FUpdateAsBMP then
         If not putBMPblob(P, USize, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('BMP BLOB Write Error', mtInformation, [mbOk], 0);

      If FUpdateAsPCX then
         If not putPCXblob(P, USize, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('PCX BLOB Write Error', mtInformation, [mbOk], 0);

      If FUpdateAsGIF then
         If not putGIFblob(P, USize, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('GIF BLOB Write Error', mtInformation, [mbOk], 0);

      If FUpdateAsPNG then
         If not putPNGblob(P, USize, WriteRes, InterL, Picture.Bitmap, TPDBMultiImageCallBack) then
           MessageDlg('PNG BLOB Write Error', mtInformation, [mbOk], 0);

      Stream:=TMemoryStream.Create;
      Stream.Write(P^,USize);
      GlobalFreePtr(P);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;

    end else
      TBlobField(FDataLink.Field).Clear;
   end;
   GetInfoAndType;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.CopyToClipboard;
begin
  If Picture.Graphic <> nil then Clipboard.Assign(Picture);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.CutToClipboard;
begin
  If Picture.Graphic <> nil then
  begin
    CopyToClipboard;
    If FDataLink.Edit then
      Picture.Graphic := nil;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.PasteFromClipboard;
begin
  If Clipboard.HasFormat(CF_PICTURE) and FDataLink.Edit then begin
    MessageRunning:=False;
    CMessageRunning:=False;
    Picture.Assign(Clipboard);
   end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  If FBorderStyle = bsSingle then
    Params.Style := Params.Style or WS_BORDER;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key, Shift);
  case Key of
    VK_INSERT:
      If ssShift in Shift then PasteFromClipBoard else
        If ssCtrl in Shift then CopyToClipBoard;
    VK_DELETE:
      If ssShift in Shift then CutToClipBoard;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    ^X: CutToClipBoard;
    ^C: CopyToClipBoard;
    ^V: PasteFromClipBoard;
    #13: LoadMedia;
    #27: FDataLink.Reset;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.CMEnter(var Message: TCMEnter);
begin
  Invalidate; { Draw the focus marker }
  inherited;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.CMExit(var Message: TCMExit);
begin
  Invalidate; { Erase the focus marker }
  inherited;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.CMTextChanged(var Message: TMessage);
begin
  inherited;
  If not FPictureLoaded then Invalidate;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.WMLButtonDown(var Message: TWMLButtonDown);
begin
  If TabStop and CanFocus then SetFocus;
  inherited;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.WMLButtonDblClk(var Message: TWMLButtonDblClk);
begin
  LoadMedia;
  inherited;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.WMCut(var Message: TMessage);
begin
  CutToClipboard;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.WMCopy(var Message: TMessage);
begin
  CopyToClipboard;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.WMPaste(var Message: TMessage);
begin
  PasteFromClipboard;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.LoadFromFile(Filename : TFilename);
var
   Cursor       :  hCursor;
begin

  If not FileExists(Filename) then begin
    MessageDlg('File not found', mtInformation, [mbOk], 0);
    Exit;
  end;

  If UpperCase(ExtractFileExt(Filename)) <> '.JPG' then
  If UpperCase(ExtractFileExt(Filename)) <> '.PNG' then
  If UpperCase(ExtractFileExt(Filename)) <> '.GIF' then
  If UpperCase(ExtractFileExt(Filename)) <> '.PCX' then
  If UpperCase(ExtractFileExt(Filename)) <> '.BMP' then
  If UpperCase(ExtractFileExt(Filename)) <> '.WAV' then
  If UpperCase(ExtractFileExt(Filename)) <> '.AVI' then
  If UpperCase(ExtractFileExt(Filename)) <> '.MOV' then
  If UpperCase(ExtractFileExt(Filename)) <> '.MID' then
  If UpperCase(ExtractFileExt(Filename)) <> '.RMI' then
  If UpperCase(ExtractFileExt(Filename)) <> '.SCM' then
  If UpperCase(ExtractFileExt(Filename)) <> '.CMS' then
  {If UpperCase(ExtractFileExt(Filename)) <> '.MPG' then}
  begin
    MessageDlg('A None Supported File Format', mtInformation, [mbOk], 0);
    Exit;
  end;

  If FDataLink.Field is TBlobField then begin
    Cursor := SetCursor(LoadCursor(0,idc_Wait));
    TBlobField(FDataLink.Field).LoadFromFile(Filename);
    SetCursor(Cursor);
  end else begin
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;
  {GetInfoAndType;}
  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SaveToFile(Filename : TFilename);
var
  Cursor       :  hCursor;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));
    TBlobField(FDataLink.Field).SaveToFile(Filename);
    GetInfoAndType;
    SetCursor(Cursor)

  end else begin
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SaveToFileAsBMP(Filename : TFilename);
var
  Cursor       :  hCursor;
  WriteRes     :  Integer;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If FWriteResolution = Color16 then WriteRes := 4;
    If FWriteResolution = Color256 then WriteRes := 8;
    If FWriteResolution = ColorTrue then WriteRes := 24;

    If not putBMPfile(Filename, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing BMP file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SaveToFileAsGIF(Filename : TFilename);
var
  Cursor       :  hCursor;
  WriteRes     :  Integer;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If FWriteResolution = Color16 then WriteRes := 4;
    If FWriteResolution = Color256 then WriteRes := 8;
    If FWriteResolution = ColorTrue then WriteRes := 24;

    If not putGIFfile(Filename, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing GIF file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SaveToFileAsPCX(Filename : TFilename);
var
  Cursor       :  hCursor;
  WriteRes     :  Integer;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If FWriteResolution = Color16 then WriteRes := 4;
    If FWriteResolution = Color256 then WriteRes := 8;
    If FWriteResolution = ColorTrue then WriteRes := 24;

    If not putPCXfile(Filename, WriteRes, Picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing PCX file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SaveToFileAsPNG(Filename : TFilename);
var
  Cursor       :  hCursor;
  WriteRes     :  Integer;
  InterL       :  Byte;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If FWriteResolution = Color16 then WriteRes := 4;
    If FWriteResolution = Color256 then WriteRes := 8;
    If FWriteResolution = ColorTrue then WriteRes := 24;
    If FInterlaced then InterL :=1 else InterL :=0;

    If not putPNGfile(Filename, WriteRes, Interl, Picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing PNG file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SaveToFileAsJPG(Filename : TFilename);
var
  Cursor       :  hCursor;
begin
  If FDataLink.Field is TBlobField then begin

    If TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield Bitmap is empty', mtInformation, [mbOk], 0);
       Exit;
    end;

    If picture.Bitmap = nil then begin
       MessageDlg('Can''t save, image is not displayed', mtInformation, [mbOk], 0);
       Exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    If not putJPGfile(Filename, FSaveQuality, FSaveSmooth, picture.Bitmap, TPDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing JPG file failed', mtInformation, [mbOk], 0);
      Exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    Exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}


function TPDBMultiMedia.GetInfoAndType : String;
var
 Stream       :  TMemoryStream;
 Hdr          :  Array[0..45] of char;
 i            :  Byte;
begin
  If (FDataLink.Field is TBlobField) then
   If TBlobField(FDataLink.Field).IsNull then Exit;

   BFileType := 'Empty';
   Bwidth:=-1;
   BHeight:=-1;
   Bbitspixel:=-1;
   Bplanes:=-1;
   Bnumcolors:=-1;
   Bcompression:='-1';
   BSize:=-1;
   GetInfoAndType :='-1';

   Stream:=TMemoryStream.Create;
   TBlobField(FDataLink.Field).SaveToStream(Stream);

   If Stream.Memory = nil then begin
     MessageDlg('Error allocation Temporary blob memory', mtInformation, [mbOk], 0);
     Exit;
   end;

   Stream.Seek(0,0);
   Stream.read(hdr,SizeOf(Hdr)-1);

   for i:=0 to SizeOf(hdr)-1 do
    If hdr[i] = #0 then hdr[i]:=' ';

   If StrPos(hdr,'RIFF') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='RIFF';

     If StrPos(hdr,'WAV') <> nil then begin
        BSize:=Stream.Size;
        BFileType:= 'WAV';
        GetInfoAndType:='WAV';
     end;

     If StrPos(hdr,'AVI') <> nil then begin
        BSize:=Stream.Size;
        BFileType:= 'AVI';
        GetInfoAndType:='AVI';
     end;

     If StrPos(hdr,'RMID') <> nil then begin
        BSize:=Stream.Size;
        BFileType:= 'RMI';
        GetInfoAndType:='RMI';
     end;

     If Stream.Memory <> nil then Stream.Free;
     Exit;
   end else

{   If StrPos(hdr,'mpeg') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MPEG';
        BSize:=Stream.Size;
        BFileType:= 'MPG';
        GetInfoAndType:='MPG';
        If Stream.Memory <> nil then Stream.Free;
        Exit;
   end else}

   If StrPos(hdr,'mdat') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='QTM';
        BSize:=Stream.Size;
        BFileType:= 'MOV';
        GetInfoAndType:='MOV';
        If Stream.Memory <> nil then Stream.Free;
        Exit;
   end else

   If StrPos(hdr,'MThd') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MIDI';
        BSize:=Stream.Size;
        BFileType:= 'MID';
        GetInfoAndType:='MID';
        If Stream.Memory <> nil then Stream.Free;
        Exit;
     end else

   If StrPos(hdr,'kevinjan') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MSG';
        BSize:=Stream.Size;
        BFileType:= 'SCM';
        GetInfoAndType:='SCM';
        If Stream.Memory <> nil then Stream.Free;
        Exit;
     end else

   If StrPos(hdr,'jankevin') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MSG';
        BSize:=Stream.Size;
        BFileType:= 'CMS';
        GetInfoAndType:='CMS';
        If Stream.Memory <> nil then Stream.Free;
        Exit;
     end else

 If not GetBlobInfo(Stream.Memory,
                    Stream.Size,
                    BFileType,
                    Bwidth,
                    BHeight,
                    Bbitspixel,
                    Bplanes,
                    Bnumcolors,
                    Bcompression) then
       MessageDlg('blobfield getinfo failed', mtInformation, [mbOk], 0)
    else begin
       BSize:=Stream.Size;
       If UpperCase(BFileType) = 'PNG' then GetInfoAndType:='PNG' else
       If UpperCase(BFileType) = 'GIF' then GetInfoAndType:='GIF' else
       If UpperCase(BFileType) = 'PCX' then GetInfoAndType:='PCX' else
       If UpperCase(BFileType) = 'JPEG' then GetInfoAndType:='JPG' else
       If UpperCase(BFileType) = 'BMP' then GetInfoAndType:='BMP';
    end;
  If Stream.Memory <> nil then Stream.Free;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetSmooth : Byte;
begin
  GetSmooth:=FSaveSmooth;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetSmooth(Smooth : Byte);
begin
  If (Smooth > 100) or (Smooth < 0) then FSaveSmooth:=5 else
   FSaveSmooth:=Smooth;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetQuality : Byte;
begin
  GetQuality:=FSaveQuality;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetQuality(Quality : Byte);
begin
  If (Quality > 100) or (Quality < 1) then FSaveQuality:=25 else
   FSaveQuality:=Quality;
end;
{------------------------------------------------------------------------}


function TPDBMultiMedia.GetTempPath : String;
begin
  GetTempPath:=FTempFilePath;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetTempPath(Temppath : String);
var
 Temp, OldDir : String;
begin
  Temp:=AddBackSlash(TempPath);
  GetDir(0,OldDir);

  {$I-}
   ChDir(Temp);
   If IOResult <> 0 then Temp:='C:\';
  {$I+}

  ChDir(OldDir);
  FTempFilePath:=Temp;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetReadRes(Res : TResolution);
begin
  FReadResolution := Res;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetWriteRes(Res : TResolution);
begin
  FWriteResolution := Res;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetMediaPlayer: TPDBMediaPlayer;
begin
 Result:=FMediaPlayer;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.SetMediaPlayer(Value: TPDBMediaPlayer);
begin
  FMediaPlayer:=Value;
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.AddBackSlash(DirName : String) : String;
const
  DosDelimSet : set of Char = ['\', ':', #0];
  begin
    If DirName[Length(DirName)] in DosDelimSet then
      AddBackSlash := DirName
    else
      AddBackSlash := DirName+'\';
  end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.IsValidMultiMedia(Name : PChar) : boolean;
 var
  Temp : Array[0..25] of char;
begin
   Result:=ValidMultiMedia(Name);
end;
{------------------------------------------------------------------------}

function TPDBMultiMedia.GetMultiMediaExtensions : String;
var
  Temp : String;
begin
  Temp:='All Media|*.BMP;*.GIF;*.PCX;*.JPG;*.SCM;*.PNG;*.CMS;';

  If IsValidMultiMedia('wav') then
    Temp:=Temp+'*.wav;';
  If IsValidMultiMedia('mid') then
    Temp:=Temp+'*.mid;';
  If IsValidMultiMedia('rmi') then
    Temp:=Temp+'*.rmi;';
  If IsValidMultiMedia('avi') then
    Temp:=Temp+'*.avi;';
  If IsValidMultiMedia('mov') then
    Temp:=Temp+'*.mov;';

  Temp:=Temp+'|BMP |*.BMP';
  Temp:=Temp+'|GIF |*.GIF';
  Temp:=Temp+'|JPG |*.JPG';
  Temp:=Temp+'|PCX |*.PCX';
  Temp:=Temp+'|SCM |*.SCM';
  Temp:=Temp+'|PNG |*.PNG';
  Temp:=Temp+'|CMS |*.CMS';

  If IsValidMultiMedia('wav') then
    Temp:=Temp+'|Wave|*.wav';
  If IsValidMultiMedia('mid') then
    Temp:=Temp+'|Midi|*.mid';
  If IsValidMultiMedia('rmi') then
    Temp:=Temp+'|RMI |*.rmi';
  If IsValidMultiMedia('avi') then
    Temp:=Temp+'|AVI |*.avi';
  If IsValidMultiMedia('mov') then
    Temp:=Temp+'|Movie|*.mov';

  Result:=Temp;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.TimerNotify(var Message: TMessage);
var
  MPosition : Integer;
begin
 If FMediaPlayer = nil then Exit;

 If not AutoRePlayMultiMedia then
   If FMediaPlayer.Mode <> MpPlaying then Exit;

  MPosition:=Round(FMediaPlayer.Position * (100 / FMediaPlayer.length));

  If @TPDBMultiMediaCallBack <> nil then
   TPDBMultiMediaCallBack(MPosition);

  If (FAutoRePlayMM) and (MPosition >= 100) and (FMediaPlayer.Filename <> '') then
   FMediaPlayer.Play;

end;
{------------------------------------------------------------------------
 scrolling message stuff
------------------------------------------------------------------------}

procedure TPDBMultiMedia.LoadMessageFromStream(MessageStream : TStream);
var
  Msg      : TLabel;
begin
  FreeMsg;
  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  readmessagefromstream(MessageStream, MsgFont, MsgSpeed, MsgBkGrnd, MsgText);
  Refresh;
  If MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitWidth:=Msg.Width;
  SMessageLeft := ScreenWd;
  SMessageRight := ScreenWd + Msg.Width;
  SMessageTop := (ScreenHt - Msg.Height) Div 2;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   MessageRunning:=True;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.NewMessage;
var
  Msg      : TLabel;
begin
  FreeMsg;
  If MsgText = '' then Exit;
  If MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';
  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  Refresh;
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitWidth:=Msg.Width;
  SMessageLeft := ScreenWd;
  SMessageRight := ScreenWd + Msg.Width;
  SMessageTop := (ScreenHt - Msg.Height) Div 2;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   MessageRunning:=True;
end;
{------------------------------------------------------------------------}

Function TPDBMultiMedia.CreateMessage : Boolean;
begin
 Result:=False;

 SetupMsg30:=TSetupMsg30.Create(Self);

 SetupMsg30.ShowModal;

 If SetupMsg30.ModalResult = mrOK then begin
  Result:=SaveMessageToStream(SetupMsg30.MessageFont,
                              SetupMsg30.MessageSpeed,
                              SetupMsg30.MessageColor,
                              SetupMsg30.MessageMsg);
 end;
 SetupMsg30.destroy;
 SetupMsg30:=Nil;
end;
{------------------------------------------------------------------------}

Procedure TPDBMultiMedia.FreeMsg;
Begin
  If MessageRunning then
   Color:=OldColor;
  If CMessageRunning then
   Color:=OldColor;
  CMessageRunning:=False;
  MessageRunning:=False;
  Picture.Assign(nil);
end;
{------------------------------------------------------------------------}

Function TPDBMultiMedia.Delay(Ms : Integer) : boolean;
Begin
 Inc(DelayCounter);
 If DelayCounter > MS then begin
  DelayCounter:=0;
  Result:=True;
 end else
  Result:=False;
end;
{------------------------------------------------------------------------}

Procedure TPDBMultiMedia.MoveMsg(Var WinMsg : TMessage);
Begin
  If Not MessageRunning then Exit;
  If Not Delay(MsgSpeed)then Exit;
  Dec(SMessageLeft,1);
  Dec(SMessageRight,1);
  Inc(MmsgCount,1);
  If SMessageRight < 0 then begin
    SMessageLeft := ScreenWd;
    SMessageRight := SMessageLeft + BitWidth;
  end;
    with Canvas do
       Draw(SMessageLeft,SMessageTop,BitMsg);
end;
{------------------------------------------------------------------------}

Procedure TPDBMultiMedia.Trigger;
Begin
  If SetupMsg30 <> nil then SetupMsg30.Trigger;
  If SetupCredMsg30 <> nil then SetupCredMsg30.Trigger;

  If (visible) and (enabled) then begin
   PostMessage(Handle, WM_Trigger, 0, 0);
   PostMessage(Handle, WM_CTrigger, 0, 0);
  end;
End;
{------------------------------------------------------------------------}

Function TPDBMultiMedia.SaveMessageToStream(MFont  : Tfont;
                                           Mspeed : Integer;
                                           MColor : Tcolor;
                                           MMsg   : String) : Boolean;
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  Longint;
   P            :  Array[0..1602] of char;
begin
  Result:=True;
  If FDataLink.Field is TBlobField then begin

     If Length(MMsg) < 1 then
      begin
        Result:=False;
        Exit;
       end;

      Usize:=WriteMessageToStream(MFont, MSpeed, MColor, MMsg, P);

      If Usize < 1 then
       begin
        Result:=False;
        Exit;
       end;

      Stream:=TMemoryStream.Create;
      Stream.Write(P,Usize+1);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;
     GetInfoAndType;
   end;
end;


{------------------------------------------------------------------------
 credit message stuff
------------------------------------------------------------------------}

procedure TPDBMultiMedia.LoadCreditMessageFromStream(MessageStream : TStream);
var
  Msg      : TLabel;
begin
  Picture.Assign(nil);
  ReadCreditFromStream(MessageStream, MsgFont, MsgSpeed, MsgBkGrnd, CreditBoxList);
  Creditcounter:=0;
  If CreditBoxList.Count <1 then Exit;
  MsgText:=CreditBoxList.Strings[Creditcounter];

  If MsgText = '' then Exit;
  If MsgText[1] <> ' ' then MsgText:='  ' + MsgText;
  If MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';

  ScreenWd:=Width;
  ScreenHt:=Height;
  Refresh;
  Msg := TLabel.Create(Self);
  Refresh;
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  Msg.Width:=Msg.Width+(Msg.Width div (Length(MsgText)-2));
  BitHeight:=Msg.Height;
  BitWidth:=Msg.Width;
  SMessageLeft :=(ScreenWd - Msg.Width) Div 2;
  SMessageTop := ScreenHt;
  SMessageBottom := SMessageTop + Msg.Height;

  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height+5;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color:=MsgBkGrnd;
    Rectangle(0, 0, Width, Height);
  end;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Pen.Color:=MsgBkGrnd;
    Rectangle(0, 0, BitMsg.Width, BitMsg.Height);
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   CMessageRunning:=True;
end;
{------------------------------------------------------------------------}

procedure TPDBMultiMedia.NewCreditMessage;
var
  Msg : TLabel;
begin
  If CreditBoxList.Count <1 then Exit;
  If Creditcounter > CreditBoxList.Count then Creditcounter:=0;

  MsgText:=CreditBoxList.Strings[Creditcounter];
  If MsgText = '' then Exit;

  If MsgText[1] <> ' ' then MsgText:='  ' + MsgText;
  If MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';

  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  Refresh;
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitHeight:=Msg.Height;
  Msg.Width:=Msg.Width+(Msg.Width div (Length(MsgText)-2));
  BitWidth:=Msg.Width;
  SMessageLeft :=(ScreenWd - Msg.Width) Div 2;
  SMessageTop := ScreenHt;
  SMessageBottom := SMessageTop + Msg.Height;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height+5;
  if not CMessageRunning then
   OldColor:=Color;
  Color:=MsgBkGrnd;

  with Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color:=MsgBkGrnd;
    Rectangle(0, 0, Width, Height);
  end;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Pen.Color:=MsgBkGrnd;
    Rectangle(0, 0, BitMsg.Width, BitMsg.Height);
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   CMessageRunning:=True;
end;
{------------------------------------------------------------------------}

Function TPDBMultiMedia.SaveCreditMessageToStream(MFont  : Tfont;
                                                  Mspeed : integer;
                                                  MColor : Tcolor;
                                                  MMsg   : TStringList) : Boolean;
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  longInt;
   P            :  PChar;
begin
  Result:=True;
  if FDataLink.Field is TBlobField then begin

      GetMem(P,65528);

      Usize:=WriteCreditToStream(MFont, MSpeed, MColor, MMsg, P);

      If Usize < 1 then
       begin
        Result:=False;
        FreeMem(P,65528);
        exit;
       end;

      Stream:=TMemoryStream.Create;
      Stream.Write(P^,Usize+1);

      FreeMem(P,65528);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;

     GetInfoAndType;
   end;
end;

{------------------------------------------------------------------------}

Function TPDBMultiMedia.CreateCreditMessage : Boolean;
begin
 Result:=False;

 SetupCredMsg30:=TSetupCredMsg30.Create(Self);

 SetupCredMsg30.ShowModal;

 if SetupCredMsg30.ModalResult = mrOK then begin
  Result:=SaveCreditMessageToStream(SetupCredMsg30.MessageFont,
                                    SetupCredMsg30.MessageSpeed,
                                    SetupCredMsg30.MessageColor,
                                    SetupCredMsg30.MessageStrList);
 end;
 SetupCredMsg30.destroy;
 SetupCredMsg30:=Nil;
end;

{------------------------------------------------------------------------}

Procedure TPDBMultiMedia.MoveCredMsg(Var WinMsg : TMessage);
Begin
  If Not CMessageRunning then Exit;
  If not Delay(MsgSpeed) then Exit;
  Dec(SMessageTop,1);
  Dec(SMessageBottom,1);
  If SMessageTop < (0-BitHeight)-5 then begin
     If CreditBoxList.Count >0 then begin
        If Creditcounter < CreditBoxList.Count-1 then
           Inc(Creditcounter)
        else Creditcounter:=0;
        NewCreditMessage;
     end else begin
         SMessageTop := ScreenHt;
         SMessageBottom := SMessageTop + BitHeight;
     end;
  end;

  with Canvas do Draw(SMessageLeft,SMessageTop,BitMsg);
end;


{------------------------------------------------------------------------
Printing Stuff
------------------------------------------------------------------------}

procedure TPDBMultiMedia.PrintMultiImage(X, Y, pWidth, pHeight: Integer);
begin
 If Picture.Graphic.Empty then Exit;

 If (BFiletype = 'ICO') or (BFiletype = 'WMF') then
   PrintICOWMF(X, Y, pWidth, pHeight)
 else
   PrintBitmap(X, Y, pWidth, pHeight)
end;
{---------------------------------------------------------------------}

procedure TPDBMultiMedia.PrintBitmap(X, Y, pWidth, pHeight: Integer);
var
  Info     : PBitmapInfo;
  InfoSize : Integer;
  Image    : Pointer;
  ImageSize: Longint;
begin
   If (pWidth < 1) or (pHeight < 1) then begin
      pWidth:=Picture.Bitmap.Width;
      pHeight:=Picture.Bitmap.Height;
   end;

   Printer.Begindoc;

    with Picture.Bitmap do begin
      GetDIBSizes(Handle, InfoSize, ImageSize);
      Info := MemAlloc(InfoSize);
      try
        Image := MemAlloc(ImageSize);
        try
          GetDIB(Handle, Palette, Info^, Image^);
          with Info^.bmiHeader do
           StretchDIBits(Printer.Canvas.Handle, X, Y, pWidth,
            pHeight, 0, 0, biWidth, biHeight, Image, Info^,
            DIB_RGB_COLORS, SRCCOPY)
         finally
          FreeMem(Image, ImageSize);
         end;
      finally
       FreeMem(Info, InfoSize);
      end;
    end;
    Printer.Enddoc;
  end;
{---------------------------------------------------------------------}

procedure TPDBMultiMedia.PrintICOWMF(X, Y, pWidth, pHeight: Integer);
begin
   If (pWidth < 1) or (pHeight < 1) then begin
    pWidth:=Picture.Graphic.Width;
    pHeight:=Picture.Graphic.Height;
   end;

   Printer.Begindoc;

   Printer.Canvas.StretchDraw(Rect(X, Y, pWidth, pHeight), Picture.Graphic);

   Printer.Enddoc;
end;

{------------------------------------------------------------------------}
{------------------------------------------------------------------------}


begin
 TPDBMultiImageCallBack:=nil;
 TPDBMultiMediaCallBack:=nil;
end.


