{Form to Create new credit messages. It will return:
MessageFont      : TFont;         the message's font
MessageSpeed     : Integer;       the scrolling speed 1 is fast 10 is slow
MessageColor     : TColor;        the background color
MessageStrList   : TStringList;   the credit messages in a stringist}

unit Setcr30;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, ColorGrd, DLL30;

type
  TSetupCredMsg30 = class(TForm)
    Memo1          : TMemo;
    Image1         : TImage;
    SpeedScrollBar : TScrollBar;
    Label1         : TLabel;
    Label2         : TLabel;
    Label3         : TLabel;
    ColorGrid      : TColorGrid;
    BitBtn1        : TBitBtn;
    BitBtn2        : TBitBtn;
    BitBtn3        : TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedScrollBarChange(Sender: TObject);
    procedure ColorGridChange(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    CBitMsg         : TBitmap;
    CSMessageLeft   : Integer;
    CSMessageBottom : Integer;
    CSMessageTop    : Integer;
    CScreenWd       : Integer;
    CScreenHt       : Integer;
    CBitHeight      : Integer;
    CDelayCounter   : LongInt;
    Creditcounter   : Integer;
    SMessageLeft    : Integer;
    SMessageRight   : Integer;
    SMessageTop     : Integer;
    ScreenWd        : Integer;
    ScreenHt        : Integer;
    CreditMessage   : TLabel;
    CMsgText        : String;
    CMsgBkGrnd      : TColor;
    CMsgSpeed       : Integer;
    CMessageRunning : Boolean;
    CreditBoxList   : TStringList;
    { Private declarations }
  public
    { Public declarations }
    MessageStrList  : TStringList;
    MessageFont     : TFont;
    MessageSpeed    : Integer;
    MessageColor    : TColor;
    procedure NewCMessage;
    Procedure FreeCMsg;
    Function  CDelay(Ms : Integer) : boolean;
    Procedure MoveCMsg(Var WinMsg : TMessage); message WM_CTrigger;
    procedure SetBackground;
    Procedure Trigger;
  end;

var
  SetupCredMsg30 : TSetupCredMsg30;


implementation

{$R *.DFM}

{------------------------------------------------------------------------}

procedure TSetupCredMsg30.FormCreate(Sender: TObject);
begin
   CreditMessage := TLabel.Create(Self);
   CreditMessage.Parent :=Self;
   CreditBoxList:=TStringList.Create;
   CBitMsg := TBitmap.Create;
   Creditcounter:=0;
   CMessageRunning:=False;
   CDelayCounter:=0;
   Memo1.Lines.Add('New credit messages here');
   CreditBoxList.Assign(Memo1.Lines);
   CMsgSpeed:=5;
   ColorGrid.BackGroundIndex:=4;
   ColorGrid.ForeGroundIndex:=14;
   SetBackground;
   NewCMessage;
end;
{------------------------------------------------------------------------}

Procedure TSetupCredMsg30.Trigger;
begin
  PostMessage(Handle, WM_CTrigger, 0, 0);
end;
{------------------------------------------------------------------------}

Function TSetupCredMsg30.CDelay(Ms : Integer) : boolean;
Begin
 Inc(CDelayCounter);
 if CDelayCounter > MS then begin
    CDelayCounter:=0;
    Result:=true;
 end else
  Result:=false;
end;
{------------------------------------------------------------------------}

Procedure TSetupCredMsg30.MoveCMsg(Var WinMsg : TMessage);
Begin
  if Not CMessageRunning then exit;
  if not CDelay(CMsgSpeed) then exit;

  Dec(CSMessageTop,1);
  Dec(CSMessageBottom,1);
  if CSMessageTop < (0-CBitHeight)-5 then begin

   if CreditBoxList.Count >0 then begin
    if Creditcounter < CreditBoxList.Count-1 then
     Inc(Creditcounter)
    else Creditcounter:=0;
    NewCMessage;
   end else begin
    CSMessageTop := CScreenHt;
    CSMessageBottom := SMessageTop + CBitHeight;
   end;
  end;
  Image1.Picture.Bitmap.Canvas.Draw(CSMessageLeft,CSMessageTop,CBitMsg);
end;

{------------------------------------------------------------------------}

procedure TSetupCredMsg30.SetBackground;
 begin
  with Image1.Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color:=CMsgBkGrnd;
    Rectangle(0, 0, Width, Height);
  end;
 end;
{------------------------------------------------------------------------}

procedure TSetupCredMsg30.NewCMessage;
begin
  if CreditBoxList.Count <1 then exit;
  if CreditMessage = nil then exit;
  if CBitMsg = nil then exit;

  CMsgText:=CreditBoxList.Strings[Creditcounter];
  if CMsgText = '' then exit;
  if CMsgText[Length(CMsgText)] <> ' ' then CMsgText:=CMsgText+' ';

  CScreenWd:=Image1.Width;
  CScreenHt:=Image1.Height;
  CreditMessage.Visible := False;
  CreditMessage.Caption := CMsgText;
  CBitHeight:=CreditMessage.Height;
  CSMessageLeft :=(CScreenWd - CreditMessage.Width) Div 2;
  CSMessageTop := CScreenHt;
  CSMessageBottom := CSMessageTop + CreditMessage.Height;
  CBitMsg.Width := CreditMessage.Width;
  CBitMsg.Height := CreditMessage.Height+5;
  CBitMsg.Canvas.Brush.Color :=CMsgBkGrnd;
  CBitMsg.Canvas.Brush.Style := bsSolid;
  CBitMsg.Canvas.Pen.Color:=CMsgBkGrnd;
  CBitMsg.Canvas.Rectangle(0, 0, CBitMsg.Width, CBitMsg.Height);
  CBitMsg.Canvas.Font := CreditMessage.Font;
  CBitMsg.Canvas.TextOut(1,1,CreditMessage.Caption);
  CMessageRunning:=True;
end;
{------------------------------------------------------------------------}

procedure TSetupCredMsg30.FormDestroy(Sender: TObject);
begin
  CMessageRunning:=False;

  if CBitMsg <> nil then
   CBitMsg.Free;
  CBitMsg:=Nil;

  if CreditMessage <> nil then
   CreditMessage.Free;
  CreditMessage:=Nil;

  if CreditBoxList <> nil then
   CreditBoxList.Free;
  CreditBoxList:=Nil;
end;
{------------------------------------------------------------------------}

Procedure TSetupCredMsg30.FreeCMsg;
Begin
  CMsgText:='';
  CreditBoxList.Clear;
  Creditcounter:=0;
  Image1.Picture.Assign(nil);
  CMessageRunning:=False;
end;
{------------------------------------------------------------------------}

procedure TSetupCredMsg30.SpeedScrollBarChange(Sender: TObject);
begin
  Label3.Caption:='Speed = '+IntToStr(SpeedScrollBar.Position);
  CMsgSpeed:=SpeedScrollBar.Position;
end;
{------------------------------------------------------------------------}

procedure TSetupCredMsg30.ColorGridChange(Sender: TObject);
begin
  CMsgBkGrnd:= ColorGrid.BackGroundColor;
  CreditMessage.Font.Color:= ColorGrid.ForeGroundColor;
  SetBackground;
  NewCMessage;
end;
{------------------------------------------------------------------------}

procedure TSetupCredMsg30.BitBtn2Click(Sender: TObject);
var
 FontDialog : TFontDialog;
begin
  FontDialog := TFontDialog.create(self);
  FontDialog.Font := CreditMessage.Font;
  if FontDialog.Execute then begin
     SetBackground;
     CreditMessage.Font := FontDialog.Font;
     NewCMessage;
  end;
  FontDialog.free;
end;
{------------------------------------------------------------------------}

procedure TSetupCredMsg30.Memo1Change(Sender: TObject);
begin
    CreditBoxList.Assign(Memo1.Lines);
end;
{------------------------------------------------------------------------}

procedure TSetupCredMsg30.BitBtn3Click(Sender: TObject);
begin
    MessageStrList :=CreditBoxList;
    MessageFont    :=CreditMessage.Font;
    MessageSpeed   :=SpeedScrollBar.Position;
    MessageColor   :=ColorGrid.BackGroundColor;
end;
{------------------------------------------------------------------------}

procedure TSetupCredMsg30.BitBtn1Click(Sender: TObject);
begin
  Close;
end;
{------------------------------------------------------------------------}
{------------------------------------------------------------------------}

end.
