unit Udemo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TMultiP, StdCtrls, ExtCtrls, Buttons, UAbout, UImage,
  BImage, MMBlob, UBlob, UMail, UScroll, Printers;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    Memo1: TMemo;
    BitBtn1: TBitBtn;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    BitBtn2: TBitBtn;
    PrintDialog1: TPrintDialog;
    Panel2: TPanel;
    PMultiImage1: TPMultiImage;
    Panel3: TPanel;
    MultiImage2: TPMultiImage;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure SpeedButton10Click(Sender: TObject);
    procedure SpeedButton11Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
    Procedure Trigger(Sender : TObject; Var Done : Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 PMultiImage1.ImageName:='SKYLINE.RES';
 {create a message at creation at MultiImage2 (Bottom one)}
 {set Message text}
    MultiImage2.MsgText:='ImageLib 3.0 by SkyLine Tools. Add PNG, CMS, SCM, JPG, ICO, PCX, BMP, WMF and GIF images'+
    ' to your applications. ImageLib supports both the File and Data-Aware (BLOB) read and write.'+
    ' Add all the image formats and AVI, MOV, MID, RMI, WAV to a TBlobfield.';
    {set Message font name;  Note you can alse do this with a font dialog}
    MultiImage2.MsgFont.Name:='Arial';
   {set Message font size}
    MultiImage2.MsgFont.Size:=-12;
    {set Message font style}
    MultiImage2.MsgFont.Style:=[];
    {set Message font color}
    MultiImage2.MsgFont.Color:=clAqua;
    {set Message background. Note you could do this also with a color dialog}
    MultiImage2.MsgBkGrnd:=clNavy;
    {set Message speed from 1 is fast to 10 is slow}
    MultiImage2.MsgSpeed:=7;
    {inititiate new message}
    MultiImage2.NewMessage;

    {IMPORTANT}
    {This is the moving engine for all the messages. Since an applcation
    can have only one OnIdle Trigger, this trigger needs to be subdivided
    by all your moving and animated objects. In this particular case the
    function is called TRIGGER but you can name it as you want as long
    you have a procedure named the same.}
    Application.OnIdle:=Trigger;
end;


Procedure TForm1.Trigger(Sender : TObject; Var Done : Boolean);
begin
   {This function is called when your app is idle. Subdivide the
    trigger event to your TMultiImage objects who may need one.
    If no Message is active it will not take up significant time}
    MultiImage2.Trigger;
end;


procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  AboutBox.Image1.Picture.BitMap:=PMultiImage1.Picture.BitMap;
  AboutBox.ShowModal;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  MultiImage2.Visible:=False;
  ViewImageForm:=TViewImageForm.Create(self);
  ViewImageForm.ShowModal;
  ViewImageForm.Free;
  MultiImage2.Visible:=true;
  Application.OnIdle:=Trigger;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  ConvertForm1:=TConvertForm1.Create(self);
  ConvertForm1.ShowModal;
  ConvertForm1.Free;
  Application.OnIdle:=Trigger;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  MultiImage2.Visible:=False;
  MMBlobForm:=TMMBlobForm.Create(self);
  MMBlobForm.ShowModal;
  MMBlobForm.Free;
  MultiImage2.Visible:=true;
  Application.OnIdle:=Trigger;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
  MultiImage2.Visible:=False;
  BlobForm1:=TBlobForm1.Create(self);
  BlobForm1.ShowModal;
  BlobForm1.Free;
  MultiImage2.Visible:=true;
  Application.OnIdle:=Trigger;
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
  MultiImage2.Visible:=False;
  MailOrderForm:=TMailOrderForm.Create(self);
  MailOrderForm.ShowModal;
  MailOrderForm.Free;
  MultiImage2.Visible:=true;
  Application.OnIdle:=Trigger;
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
  MultiImage2.Visible:=False;
  ScrollForm1:=TScrollForm1.Create(self);
  ScrollForm1.ShowModal;
  ScrollForm1.Free;
  MultiImage2.Visible:=true;
  Application.OnIdle:=Trigger;
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
begin
 Memo1.Lines.Clear;
 Memo1.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'ImageLib.txt');
 Memo1.Visible:=true;
 BitBtn1.Visible:=true;
 BitBtn2.Visible:=true;
end;


procedure TForm1.BitBtn1Click(Sender: TObject);
begin
 Memo1.Visible:=False;
 BitBtn1.Visible:=False;
 BitBtn2.Visible:=False;
end;

procedure TForm1.SpeedButton9Click(Sender: TObject);
begin
 Memo1.Lines.Clear;
 Memo1.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'ILibCust.txt');
 Memo1.Visible:=true;
 BitBtn1.Visible:=true;
 BitBtn2.Visible:=true;
end;

procedure TForm1.SpeedButton10Click(Sender: TObject);
begin
 Memo1.Lines.Clear;
 Memo1.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'ILibRef.txt');
 Memo1.Visible:=true;
 BitBtn1.Visible:=true;
 BitBtn2.Visible:=true;
end;

procedure TForm1.SpeedButton11Click(Sender: TObject);
begin
 Application.HelpFile := 'IMGLIB30.HLP';
 Application.HelpJump('');
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
var i : integer;
    p : integer;
begin
 if PrintDialog1.execute then begin

   Printer.Begindoc;
   p:=0;
   For i:=0 to Memo1.Lines.Count -1 do begin
    p:=i*45;
    Printer.Canvas.Textout(5,P,Memo1.Lines[i]);
   end;
   Printer.Enddoc;

 end;
end;

end.





