{Part of Imagelib VCL/DLL Library.
Written by Jan Dekkers and Kevin Adams (c) 1995. If you are a non
registered client, you may use or alter this demo only for evaluation
purposes.

Uses ImageLib 3.0

Changed callback in version 2.21 to a function with cdecl.
using the C calling convention.

scrolling text images
Cut, Copy and Paste to/from the clipboard
Printing bitmaps}


unit Mmblob;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, MPlayer, DB, DBTables, DBCtrls, Gauges, SysUtils,
  Dialogs, Mask, TDMultiP;

type
  TMMBlobForm = class(TForm)
    CancelBtn: TBitBtn;
    DataSource1: TDataSource;
    Table1: TTable;
    DBNavigator1: TDBNavigator;
    Gauge1: TGauge;
    OpenDialog1: TOpenDialog;
    BitBtn1: TBitBtn;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    OpenDialog2: TOpenDialog;
    BitBtn2: TBitBtn;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    DBMemo1: TDBMemo;
    BitBtn3: TBitBtn;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    BitBtn4: TBitBtn;
    ScrollBar1: TScrollBar;
    Panel1: TPanel;
    BitBtn5: TBitBtn;
    Panel2: TPanel;
    BitBtn6: TBitBtn;
    PrintDialog1: TPrintDialog;
    DBMultiMedia1: TPDBMultiMedia;
    DBMediaPlayer1: TPDBMediaPlayer;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    procedure CancelBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure ScrollBar1Change(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    function JustPathname(PathName : string) : string;
    Procedure Trigger(Sender : TObject; Var Done : Boolean);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MMBlobForm: TMMBlobForm;

implementation

{$R *.DFM}
{---------------------------------------------------------------------}

procedure TMMBlobForm.CancelBtnClick(Sender: TObject);
begin
{close the app}
 close;
end;
{---------------------------------------------------------------------}

{IMPORTANT}
{Changed in version 2.21 from a procedure to a function with cdecl.
 To cancel return a 0 else return a 1}

Function IwillBeCalled ( i : integer) : integer; cdecl; export;
{Callback function from the dll, CDECL and EXPORT ARE REQUIRED}

begin
  if Application.Terminated then

   {User wants to terminate the program. Pass a 0 to the dll}
   Result:=0

  else begin
   {Process Progress bar}
   if MMBlobForm <> Nil then
    MMBlobForm.Gauge1.Progress:=i;

   {Live in peace with others}
   Application.ProcessMessages;

   {tell the dll that everything is OK}
   Result:=1;
   end;
end;
{---------------------------------------------------------------------}


procedure TMMBlobForm.FormCreate(Sender: TObject);
begin
    {init label caption with file type}
    Panel1.Caption:=DBMultiMedia1.BFiletype;

    {init label caption with file size}
    Panel2.Caption:=IntToStr(DBMultiMedia1.Bsize)+ ' bytes';

    {On/Off Play the multimedia automatically}
    DBMultiMedia1.AutoPlayMultiMedia:=CheckBox1.Checked;

    {On/Off Hide the DBMediaPlayer Automatically if MM is present}
    DBMultiMedia1.AutoHideMediaPlayer:=CheckBox2.Checked;

    {On/Off RePlay the multimedia automatically}
    DBMultiMedia1.AutoRePlayMultiMedia:=CheckBox4.Checked;

    {On/Off Display the multimedia automatically}
    DBMultiMedia1.AutoDisplay:=CheckBox3.Checked;

    If FileExists(ExtractFilePath(Application.ExeName)+'mmblob.dbf') then begin
       {if the table exists open it on creation}
       Table1.DataBaseName:=JustPathName(Application.ExeName);
       Table1.TableName:='mmblob.dbf';
       Table1.Active:=True;
       {Show or hide the append/replace button, depending on
       the table active stasus}
       BitBtn7.Enabled:=Table1.Active;
       BitBtn4.Enabled:=Table1.Active;
       BitBtn3.Enabled:=Table1.Active;
       BitBtn1.Enabled:=Table1.Active;
     end;

   {IMPORTANT}
    {This is the moving engine for all the messages. Since an application
    can have only one OnIdle Trigger, this trigger needs to be subdivided
    by all your moving and animated objects. In this particular case the
    function is called TRIGGER but you can name it as you want as long
    you have a procedure named the same.}

    {Register the callback Fuction to the VCL}
    TPDBMultiMediaCallBack:=IwillBeCalled;

    Application.OnIdle:=Trigger;
 end;
{---------------------------------------------------------------------}

Procedure TMMBlobForm.Trigger(Sender : TObject; Var Done : Boolean);
begin
    {IMPORTANT}
   {This function is called when your app is idle. Subdivide the
    trigger event to your TDBMultiMedia objects who may need one.
    If no Message is active it will not take up significant time}
    DBMultiMedia1.Trigger;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.BitBtn1Click(Sender: TObject);
begin
  {fill the OpenDialog filter with the MM extensions as found in the win.ini
   (This means that the appropriate drivers are installed)}
  OpenDialog1.filter:=DBMultiMedia1.GetMultiMediaExtensions;

  {Execute the open dialog box}
  if OpenDialog1.Execute then begin

    {Place the Database in append mode}
    Table1.Append;

    {Load the Multimedia into the Blob}
    DBMultiMedia1.LoadfromFile(OpenDialog1.FileName);

    {Post that thing}
    Table1.Post;
  end;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.BitBtn3Click(Sender: TObject);
begin
  {fill the OpenDialog filter with the MM extensions as found in the win.ini
   (This means that the appropriate drivers are installed)}
  OpenDialog1.filter:=DBMultiMedia1.GetMultiMediaExtensions;

  {Execute the open dialog box}
  if OpenDialog1.Execute then begin

    {Place the Database in edit mode}
    Table1.Edit;

    {Load the Multimedia into the Blob}
    DBMultiMedia1.LoadfromFile(OpenDialog1.FileName);

    {Post that thing}
    Table1.Post;
  end;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.CheckBox1Click(Sender: TObject);
begin
     {Play the appropriate multimedi when there}
     DBMultiMedia1.AutoPlayMultiMedia:=CheckBox1.Checked;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.CheckBox2Click(Sender: TObject);
begin
    {On/Off Hide the DBMediaPlayer Automatically if MM is present}
     DBMultiMedia1.AutoHideMediaPlayer:=CheckBox2.Checked;

    if (Panel1.Caption = 'MID') or (Panel1.Caption = 'RMI') or (Panel1.Caption = 'WAV') then
    {hide blob window if no media needs to be display and auto hide is on}
     DBMultiMedia1.Visible:=not CheckBox2.Checked;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.CheckBox3Click(Sender: TObject);
begin
    {On/Off Display the multimedia automatically}
     DBMultiMedia1.AutoDisplay:=CheckBox3.Checked;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.CheckBox4Click(Sender: TObject);
begin
    {On/Off RePlay the multimedia automatically}
    DBMultiMedia1.AutoRePlayMultiMedia:=CheckBox4.Checked;
end;
{---------------------------------------------------------------------}

function TMMBlobForm.JustPathname(PathName : string) : string;
    {-Return just the drive:directory portion of a pathname}
  var
    I : Word;
  const
     DosDelimSet : set of Char = ['\', ':', #0];
  begin
    I := Succ(Word(Length(PathName)));
    repeat
      Dec(I);
    until (PathName[I] in DosDelimSet) or (I = 0);

    if I = 0 then
      {Had no drive or directory name}
      JustPathname[0] := #0
    else if I = 1 then
      {Either the root directory of default drive or invalid pathname}
      JustPathname := PathName[1]
    else if (PathName[I] = '\') then begin
      if PathName[Pred(I)] = ':' then
        {Root directory of a drive, leave trailing backslash}
        JustPathname := Copy(PathName, 1, I)
      else
        {Subdirectory, remove the trailing backslash}
        JustPathname := Copy(PathName, 1, Pred(I));
    end else
      {Either the default directory of a drive or invalid pathname}
      JustPathname := Copy(PathName, 1, I);
  end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.BitBtn2Click(Sender: TObject);
begin
{open the table}
 try
      If OpenDialog2.execute then begin
        Table1.Active:=False;
        Table1.DataBaseName:=JustPathname(OpenDialog2.FileName);
        Table1.TableName:=OpenDialog2.FileName;
        Table1.Active:=True;
      end;
 finally
        {Show or hide the append/replace button, depending on
        the table active status}
        BitBtn7.Enabled:=Table1.Active;
        BitBtn4.Enabled:=Table1.Active;
        BitBtn3.Enabled:=Table1.Active;
        BitBtn1.Enabled:=Table1.Active;
 end;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.BitBtn4Click(Sender: TObject);
begin
    {Place the Database in append mode}
    Table1.Append;
    {Create a New Message}
    If DBMultiMedia1.CreateMessage then
    {Post or cancel that thing}
       Table1.Post
    else
       Table1.Cancel;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.BitBtn7Click(Sender: TObject);
begin
    {Place the Database in append mode}
    Table1.Append;
    {Create a New Credit Message}
    If DBMultiMedia1.CreateCreditMessage then
    {Post or cancel that thing}
       Table1.Post
    else
       Table1.Cancel;
  end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.DataSource1DataChange(Sender: TObject;
  Field: TField);

var
   temp : string;

begin
  {Show or hide the scroll bar}
  ScrollBar1.Visible:=(DBMultiMedia1.BFiletype = 'SCM') or (DBMultiMedia1.BFiletype = 'CMS');

  {Syncronize the scrollbar's position}
  ScrollBar1.Position:=DBMultiMedia1.MsgSpeed;

   {Set the blob window to visible}
    DBMultiMedia1.Visible:=true;

    {Set the Video display rectangle to the rectangle of the blob window}
    DBMediaPlayer1.DisplayRect:=Rect(0,0,DBMultiMedia1.Width,DBMultiMedia1.Height);

    {Set the Video display to the the display of the blob window}
    DBMediaPlayer1.Display:=DBMultiMedia1;

    {init label caption with file type}
    Panel1.Caption:=DBMultiMedia1.BFiletype;

    {init label caption with file size}
    Panel2.Caption:=IntToStr(DBMultiMedia1.Bsize)+ ' bytes';

    {Get file type of blob stored}
    temp:=DBMultiMedia1.BFiletype;

    {Show print button only when image is there}
    BitBtn6.Enabled:= (DBMultiMedia1.Picture.Graphic <> nil);

    {Enable the next line. Just to show of (Play message if blob is a RMI file}
    {if temp = 'RMI' then BitBtn5Click(Sender);}

    {Enable the next line. Just to show of (Play message if blob is a MIDI file}
    {if temp = 'MID' then BitBtn8Click(Sender);}


    if (temp = 'MID') or (temp = 'RMI') or (temp = 'WAV') then
    {hide blob window if no media needs to be display and auto hide is on}
    DBMultiMedia1.Visible:=not CheckBox2.Checked;

end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.ScrollBar1Change(Sender: TObject);
begin
  {Set message speed 1(fast) to 10(slow)}
  DBMultiMedia1.MsgSpeed:=ScrollBar1.Position;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.BitBtn5Click(Sender: TObject);
begin
begin
   {create a message on the fly without actualy storing the message in the blob
   At any time you can play this message}
   {set Message text}
    DBMultiMedia1.MsgText:='Isn''t super to be a Delphi programmer ?? '+
    'Delphi is too Cool and so is every one who''s using VCL''s !! ';
    {set Message font name;  Note you could do this also with a font dialog}
    DBMultiMedia1.MsgFont.Name:='Arial';
   {set Message font size}
    DBMultiMedia1.MsgFont.Size:=-30;
    {set Message font style}
    DBMultiMedia1.MsgFont.Style:=[fsItalic];
    {set Message font color}
    DBMultiMedia1.MsgFont.Color:=clWhite;
    {set Message background. Note you could do this also with a color dialog}
    DBMultiMedia1.MsgBkGrnd:=clTeal;
    {set Message speed from 0 is fast to 10 is slow}
    DBMultiMedia1.MsgSpeed:=0;
    {show the speed control scroll bar}
    ScrollBar1.Visible:=True;
    {Set position according speed}
    ScrollBar1.Position:=DBMultiMedia1.MsgSpeed;
    {inititiate new message}
    DBMultiMedia1.NewMessage;
  end;
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.BitBtn6Click(Sender: TObject);
begin
{print image x y width and heigth (if width and heigth are 0 the image
original size is printed)}
 If PrintDialog1.Execute then
  DBMultiMedia1.PrintMultiImage(0,0,0,0);
end;
{---------------------------------------------------------------------}

procedure TMMBlobForm.BitBtn8Click(Sender: TObject);
begin
   {Create A credit message on the fly}
    DBMultiMedia1.FreeMsg;
   {Clear Message text if any}
    DBMultiMedia1.CreditBoxList.Clear;
   {Define Message text}
    DBMultiMedia1.CreditBoxList.Add(' ImageLib');
    DBMultiMedia1.CreditBoxList.Add(' Another fine product of');
    DBMultiMedia1.CreditBoxList.Add(' SKYLINE TOOLS');
    DBMultiMedia1.CreditBoxList.Add(' Programming : Kevin Adams');
    DBMultiMedia1.CreditBoxList.Add(' Programming : Jan Dekkers');
    DBMultiMedia1.CreditBoxList.Add(' Artwork & PR: Jillian Pinsker');

    {set Message font name;  Note you could do this also with a font dialog}
    DBMultiMedia1.MsgFont.Name:='Arial';
   {set Message font size}
    DBMultiMedia1.MsgFont.Size:=-14;
    {set Message font style}
    DBMultiMedia1.MsgFont.Style:=[fsbold];
    {set Message font color}
    DBMultiMedia1.MsgFont.Color:=clWhite;
    {set Message background. Note you could do this also with a color dialog}
    DBMultiMedia1.MsgBkGrnd:=clNavy;
    {set Message speed from 1 is fast to 10 is slow}
    DBMultiMedia1.MsgSpeed:=5;
    {Show Speed ScrollBar}
    DBMultiMedia1.Visible:=true;
    {set the speed/position}
    ScrollBar1.Position:=DBMultiMedia1.MsgSpeed;
    {inititiate new message}
    DBMultiMedia1.NewCreditMessage;
end;
{---------------------------------------------------------------------}
{---------------------------------------------------------------------}


procedure TMMBlobForm.FormDestroy(Sender: TObject);
begin
    {UNRegister the callback Fuction to the VCL}
    TPDBMultiMediaCallBack:=Nil;
    Application.OnIdle:=Nil;
    MMBlobForm:=Nil;
end;

end.

{---------------------------------------------------------------------}

{easy enough ?}

{---------------------------------------------------------------------}



