{Part of Imagelib VCL/DLL Library.
Written by Jan Dekkers and Kevin Adams (c) 1995. If you are a non
registered client, you may use or alter this demo only for evaluation
purposes.

Uses ImageLib 3.0

scrolling text images
Cut, Copy and Paste to/from the clipboard
Printing bitmaps}


unit Bimage;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, Spin, Buttons, UFullscr,
  Menus, UAbout, Tmultip, Dll30;

type
  TConvertForm1 = class(TForm)
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    Convert: TBitBtn;
    QualitySpin: TSpinEdit;
    Smoothspin: TSpinEdit;
    QualityLabel: TLabel;
    SmoothLabel: TLabel;
    GroupBox1: TGroupBox;
    res4: TRadioButton;
    res24: TRadioButton;
    res8: TRadioButton;
    GroupBox2: TGroupBox;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    E1: TMenuItem;
    A1: TMenuItem;
    ComboBox1: TComboBox;
    Sstretch: TCheckBox;
    GroupBox3: TGroupBox;
    CTOJPEG: TRadioButton;
    CTOBMP: TRadioButton;
    Label1: TLabel;
    FileListBox2: TFileListBox;
    DirectoryListBox2: TDirectoryListBox;
    DriveComboBox2: TDriveComboBox;
    Label2: TLabel;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    CTOGIF: TRadioButton;
    CTOPCX: TRadioButton;
    CTOPNG: TRadioButton;
    MultiImage1: TPMultiImage;
    GroupBox4: TGroupBox;
    Saveres4: TRadioButton;
    Saveres24: TRadioButton;
    Saveres8: TRadioButton;
    CheckBox2: TCheckBox;
    procedure DriveComboBox1Change(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure FileListBox1Change(Sender: TObject);
    procedure SstretchOnOff(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ResClick(Sender: TObject);
    procedure DitherClick(Sender: TObject);
    procedure MultiImage1Click(Sender: TObject);
    procedure E1Click(Sender: TObject);
    procedure A1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComboBox1Change(Sender: TObject);
    procedure ConvertClick(Sender: TObject);
    procedure DirectoryListBox2Change(Sender: TObject);
    procedure DriveComboBox2Change(Sender: TObject);
    procedure FileListBox2Change(Sender: TObject);
    procedure QualitySpinChange(Sender: TObject);
    procedure SmoothspinChange(Sender: TObject);
    procedure CTOJPEGClick(Sender: TObject);
    procedure SaveRes(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
  private
    function NameOnly(PName : string) : string;
  public
    { Public declarations }
  end;

var
  ConvertForm1: TConvertForm1;

implementation

{$R *.DFM}

{update the drive of DirectoryListBox1 with the drive of DriveComboBox1}
procedure TConvertForm1.DriveComboBox1Change(Sender: TObject);
begin
     DirectoryListBox1.Drive := DriveComboBox1.Drive;
end;

{update the directory of FileListBox1 with the directory of FileListBox1}
procedure TConvertForm1.DirectoryListBox1Change(Sender: TObject);
begin
     FileListBox1.Directory := DirectoryListBox1.Directory;
end;

{Display the image of the FileListBox1.filename}
procedure TConvertForm1.FileListBox1Change(Sender: TObject);
begin
 {set hourglass cursor}
  screen.cursor:=crHourGlass;
 try
 {display an image using the vcl}
  MultiImage1.imagename:=FileListBox1.filename;
 finally
  {set default cursor}
  screen.cursor:=crDefault;
 end;
end;

procedure TConvertForm1.FileListBox2Change(Sender: TObject);
begin
 {set hourglass cursor}
  screen.cursor:=crHourGlass;
 try
 {display an image using the vcl}
  MultiImage1.imagename:=FileListBox2.filename;
 finally
  {set default cursor}
  screen.cursor:=crDefault;
 end;
end;

{set strech mode}
procedure TConvertForm1.SstretchOnOff(Sender: TObject);
begin
  MultiImage1.stretch:=Sstretch.Checked;
end;


{what we do on create}
procedure TConvertForm1.FormCreate(Sender: TObject);
begin
    {set the value of the QualitySpin to the value of JPegSaveQuality}
    QualitySpin.value:=MultiImage1.JPegSaveQuality;

    {set the value of the Smoothspin to the value of JPegSaveSmooh}
    Smoothspin.value:=MultiImage1.JPegSaveSmooth;

end;

{Set the resolution to either 16, 256 or true color in the vcl}
procedure TConvertForm1.ResClick(Sender: TObject);
begin
 {set Display resolution to 4 bit 16 color}
 if res4.checked  then MultiImage1.ImageReadRes:=Color16;

 {set Display resolution to 8 bit 256 color}
 if res8.checked  then MultiImage1.ImageReadRes:=Color256;

 {set Display resolution to 24 bit true color}
 if res24.checked then MultiImage1.ImageReadRes:=ColorTrue;
end;

procedure TConvertForm1.DitherClick(Sender: TObject);
begin
  {set the Display dither }
  MultiImage1.ImageDither:=CheckBox1.checked;
end;


{show fullscreen}
procedure TConvertForm1.MultiImage1Click(Sender: TObject);
begin
  {copy image to fullscreen image}
  FullSlide.MultiImage1.Picture.Graphic:=MultiImage1.Picture.Graphic;
  {show the image fulscreen}
  FullSlide.showmodal;
end;

{exit the program}
procedure TConvertForm1.E1Click(Sender: TObject);
begin
 close;
end;

{about box}
procedure TConvertForm1.A1Click(Sender: TObject);
begin
{Copy the image to the image of he about box}
 AboutBox.Image1.Picture.Graphic:=MultiImage1.Picture.Graphic;
{show the about box}
 AboutBox.showmodal;
end;

{what to do on exit}
procedure TConvertForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
{}
end;

procedure TConvertForm1.ComboBox1Change(Sender: TObject);
begin
 FileListBox1.Mask:=ComboBox1.text;
 FileListBox1.Update;
end;


{return filename only. no path, no extension}
function TConvertForm1.NameOnly(PName : string) : string;
 var
   DtP : Byte;

 function JName(PName : string) : string;
  var
    I : Word;
  const
    DDSet : set of Char = ['\', ':', #0];
  begin
    I := Succ(Word(Length(PName)));
    repeat
      Dec(I);
    until (PName[I] in DDSet) or (I = 0);
    JName := Copy(PName, Succ(I), 64);
  end;

  begin
    PName := JName(PName);
    DtP := Pos('.', PName);
    if DtP > 0 then
      PName := Copy(PName, 1, DtP-1);
    NameOnly := PName;
  end;



{The actual conversion}
procedure TConvertForm1.ConvertClick(Sender: TObject);
var i          : integer;
    pTempExt   : string[4];
    pExtension : string[4];
    pName      : string[13];
    pPath      : string[100];
    toTemp      : string;
    frTemp      : string;
begin
 Label3.CapTion:='';

 if CTOJPEG.Checked then
    pTempExt:='.JPG';
 if CTOBMP.Checked then
    pTempExt:='.BMP';
 if CTOGIF.Checked then
    pTempExt:='.GIF';
 if CTOPCX.Checked then
    pTempExt:='.PCX';
 if CTOPNG.Checked then
    pTempExt:='.PNG';

 for i:=0 to FileListBox1.items.count-1 do begin
     if FileListBox1.Selected[i] then begin

       pExtension:=UpperCase(ExtractFileExt(FileListBox1.Items.Strings[i]));
       pName:=UpperCase(NameOnly(FileListBox1.Items.Strings[i]));
       pPath:=UpperCase(DirectoryListBox2.Directory);

       toTemp:=pPath+'\'+pName+pTempExt;
       frTemp:=UpperCase(DirectoryListBox1.Directory+'\'+FileListBox1.Items.Strings[i]);
       {set hourglass cursor}
        screen.cursor:=crHourGlass;
try
       if CTOJPEG.Checked then begin
        MultiImage1.imagename:=frTemp;
        MultiImage1.SaveAsJpg(toTemp)
       end else
       if CTOBMP.Checked then begin
        MultiImage1.imagename:=frTemp;
        MultiImage1.SaveAsBMP(toTemp)
       end else
       if CTOGIF.Checked then begin
        MultiImage1.imagename:=frTemp;
        MultiImage1.SaveAsGIF(toTemp)
       end else
       if CTOPCX.Checked then begin
        MultiImage1.imagename:=frTemp;
        MultiImage1.SaveAsPCX(toTemp)
       end else
       if CTOPNG.Checked then begin
        MultiImage1.imagename:=frTemp;
        MultiImage1.SaveAsPNG(toTemp)
       end;
finally
      {set default cursor}
      screen.cursor:=crDefault;
      FileListBox2.UpDate;
      FileListBox1.UpDate;
end;
      end;
      Label3.CapTion:='DONE';
 end;
end;

procedure TConvertForm1.DirectoryListBox2Change(Sender: TObject);
begin
  FileListBox2.Directory := DirectoryListBox2.Directory;
end;

procedure TConvertForm1.DriveComboBox2Change(Sender: TObject);
begin
  DirectoryListBox2.Drive := DriveComboBox2.Drive;
end;

procedure TConvertForm1.QualitySpinChange(Sender: TObject);
begin
  MultiImage1.JpegSaveQuality:=QualitySpin.Value;
end;

procedure TConvertForm1.SmoothspinChange(Sender: TObject);
begin
  MultiImage1.JpegSaveSmooth:=Smoothspin.Value;
end;

procedure TConvertForm1.CTOJPEGClick(Sender: TObject);
begin
  QualityLabel.Visible:=CTOJPEG.Checked;
  SmoothLabel.Visible:=CTOJPEG.Checked;
  QualitySpin.Visible:=CTOJPEG.Checked;
  Smoothspin.Visible:=CTOJPEG.Checked;
  CheckBox2.Visible:=CTOPNG.Checked;
end;

procedure TConvertForm1.SaveRes(Sender: TObject);
begin
 {set Save resolution to 4 bit 16 color}
 if Saveres4.checked  then MultiImage1.ImageWriteRes:=Color16;

 {set Save resolution to 8 bit 256 color}
 if Saveres8.checked  then MultiImage1.ImageWriteRes:=Color256;

 {set Save resolution to 24 bit true color}
 if Saveres24.checked then MultiImage1.ImageWriteRes:=ColorTrue;
end;

procedure TConvertForm1.CheckBox2Click(Sender: TObject);
begin
   MultiImage1.PNGInterLaced:=CheckBox2.Checked;
end;

end.
