char *socks4_rcs = "$Id: socks4.c,v 1.3 1997/08/20 17:08:00 ACJC Exp OS/2$";
/* Written and copyright by the Anonymous Coders and Junkbusters Corporation.
 * Will be made available under the GNU General Public License.
 * This software comes with NO WARRANTY.
 * 1997/08/20 Gerd Flender
 * Added include-statement to get it work with OS/2 EMX
 */



#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#ifdef OS2
#include <sys/param.h>
#endif

#ifdef REGEX
#include "regex.h"
#endif

#include "jcc.h"

#define SOCKS_REQUEST_GRANTED		90
#define SOCKS_REQUEST_REJECT		91
#define SOCKS_REQUEST_IDENT_FAILED	92
#define SOCKS_REQUEST_IDENT_CONFLICT	93

/* structure of a socks client operation */
struct socks_op {
	unsigned char vn;		/* socks version number */
	unsigned char cd;		/* command code		*/
	unsigned char dstport[2];	/* destination port	*/
	unsigned char dstip[4];		/* destination address	*/
	unsigned char userid;		/* first byte of userid	*/
	/* more bytes of the userid follow, terminated by a NULL	*/
};

/* structure of a socks server reply */
struct socks_reply {
	unsigned char vn;		/* socks version number */
	unsigned char cd;		/* command code		*/
	unsigned char dstport[2];	/* destination port	*/
	unsigned char dstip[4];		/* destination address	*/
};

static char socks_userid[] = "anonymous";

int
socks4_connect_to(char *host, int port, struct gateway *gw)
{
	unsigned char cbuf[BUFSIZ];
	unsigned char sbuf[BUFSIZ];
	struct socks_op    *c = (struct socks_op    *)cbuf;
	struct socks_reply *s = (struct socks_reply *)sbuf;
	int web_server_addr;
	int n, csiz, sfd;
	int err = 0;
	char *errstr;

	if((gw->host == NULL) || (*gw->host == '\0')) {
		if(DEBUG(CON)) fprintf(log,
			" socks4_connect: NULL host specified\n");
		err = 1;
	}

	if(gw->port <= 0) {
		if(DEBUG(CON)) fprintf(log,
			" socks4_connect: invalid port specified\n");
		err = 1;
	}

	if(err) {
		errno = EINVAL;
		return(-1);
	}

	/* build a socks request for connection to the web server */

	strcpy((char *)&(c->userid), socks_userid);

	csiz = sizeof(*c) + sizeof(socks_userid) - 1;

	switch(gw->type) {
	case SOCKS_4:
		web_server_addr = htonl(atoip(host));
		break;
	case SOCKS_4A:
		web_server_addr = 0x00000001;
		n = csiz + strlen(host) + 1;
		if(n > sizeof(cbuf)) {
			errno = EINVAL;
			return(-1);
		}
		strcpy(((char *)cbuf) + csiz, host);
		csiz = n;
		break;
	}

	c->vn         = 4;
	c->cd         = 1;
	c->dstport[0] = (port             >> 8) & 0xff;
	c->dstport[1] = (port                 ) & 0xff;
	c->dstip[0]   = (web_server_addr >> 24) & 0xff;
	c->dstip[1]   = (web_server_addr >> 16) & 0xff;
	c->dstip[2]   = (web_server_addr >>  8) & 0xff;
	c->dstip[3]   = (web_server_addr      ) & 0xff;

	/* pass the request to the real socks server */
	sfd = connect_to(gw->host, gw->port);

	if(sfd < 0) {
		return(-1);
	}

	if((n = write(sfd, c, csiz)) != csiz) {
		close(sfd);
		return(-1);
	}

	if((n = read(sfd, sbuf, sizeof(sbuf))) != sizeof(*s)) {
		close(sfd);
		return(-1);
	}

	switch(s->cd) {
	case SOCKS_REQUEST_GRANTED:
		return(sfd);
		break;
	case SOCKS_REQUEST_REJECT:
		errstr = "SOCKS request rejected or failed";
		errno = EINVAL;
		break;
	case SOCKS_REQUEST_IDENT_FAILED:
		errstr = "SOCKS request rejected because "
			 "SOCKS server cannot connect to identd on the client";
		errno = EACCES;
		break;
	case SOCKS_REQUEST_IDENT_CONFLICT:
		errstr = "SOCKS request rejected because "
			 "the client program and identd report "
			 "different user-ids";
		errno = EACCES;
		break;
	default:
		errstr = (char *) cbuf;
		errno = ENOENT;
		sprintf(errstr,
			"SOCKS request rejected for reason code %d\n", s->cd);
	}

	if(DEBUG(CON)) {
		fprintf(log, " socks4_connect_to: %s\n", errstr);
	}

	close(sfd);
	return(-1);
}
