#define GPC		0x0001
#define CON		0x0002
#define IO		0x0004
#define HDR		0x0008
#define LOG		0x0010

#define DEBUG(X)	(debug & X)

struct textlist {
	char *text;
	struct textlist *next;
};

extern struct textlist proxy_args[];

#ifdef OS2
#define VERSION "IJ/1.4 OS/2"
#else
#define VERSION "IJ/1.4"
#endif

extern int debug;
extern int SSL;

extern FILE *log;

extern char *prog;

extern char *blockfile;
extern char *cookiefile;

extern char *jarfile;
extern FILE *jar;

extern char *referer;
extern char *uagent;
extern char *from;

extern int send_vanilla_wafer;
extern int add_forwarded;

extern char *cookie_list[];
extern char * wafer_list[];
extern char *  xtra_list[];
extern char  x_forwarded[];

extern int send_user_cookie;
extern int accept_server_cookie;

struct parsers {
	char *str;
	char  len;
	int (*parser)();
};

/* this allows the proxy to permit/block access to any host and/or path */
struct url_spec {
	char  *spec;
	char  *domain;
	char **dvec;
	int    dcnt;

	char *path;
	int   pathlen;
	int   port;
#ifdef REGEX
	regex_t *preg;
#endif
};

struct block_spec {
	struct url_spec url[1];
	int   reject;
	struct block_spec *next;
};

struct cookie_spec {
	struct url_spec url[1];
	int   send_user_cookie;
	int   accept_server_cookie;
	struct cookie_spec *next;
};

extern struct block_spec  blist[];
extern struct cookie_spec clist[];
extern int (*loaders[])();
extern int run_loader();
extern void add_loader(), unload_url(), add_proxy_args();
extern int bind_port(), accept_connection(), atoip();

#define NLOADERS 4

#define SZ(X)	(sizeof(X) / sizeof(*X))

extern char *remote_ip;
extern char *url_code_map[];
extern char *cookie_code_map[];

extern void fperror(), xwrite(), enlist();
extern char *safe_strerror();
extern int dsplit(), domaincmp();

extern int crumble(), zap();
extern int read_header(), convert_url(), sed(), connect_to(), main();
extern int url_http(), url_https();
extern int client_referer(), client_uagent(), client_ua();
extern int client_from(), client_send_cookie();
extern int client_cookie_adder(), client_xtra_adder();
extern int client_x_forwarded(), client_x_forwarded_adder();
extern int server_set_cookie();
extern int intercept_url(), show_proxy_args();
extern int load_blockfile(), load_cookiefile();
extern struct textlist *init_proxy_args(), *end_proxy_args();
extern void po();

extern char *url_encode();

extern struct block_spec  *block_url();
extern struct cookie_spec *cookie_url();

extern char fd_in_body[];
extern char connected_to[];

extern char *forward_host;
extern int   forward_port;

extern struct parsers url_patterns[];
extern struct parsers client_patterns[];
extern struct parsers server_patterns[];
extern int (*add_client_headers[])();
extern int (*add_server_headers[])();

extern char DEFAULT_USER_AGENT[];

extern int (*interceptor)();

struct gateway {
        char *name;
        char *host;
        int   port;
        int   type;
        int (*conn)();
};

extern int socks4_connect_to();
#define SOCKS_4		40	/* original SOCKS 4 protocol */
#define SOCKS_4A	41	/* as modified for hosts w/o external DNS */

