char *jcc_rcs = "$Id: jcc.c,v 3.7 1997/08/20 17:08:10 ACJC Exp OS/2$";
/* Written and copyright by the Anonymous Coders and Junkbusters Corporation.
 * Will be made available under the GNU General Public License.
 * This software comes with NO WARRANTY.
 */

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/stat.h>

#ifndef FD_ZERO
#include <select.h>
#endif

#ifdef REGEX
#include <regex.h>
#endif

#include "jcc.h"

char *prog;

struct textlist proxy_args[1];

char CFAIL[]   = "HTTP/1.0 404 Connect failed.\n\n"
		 "TCP connection to '%s' failed: %s.\n<br>"
		 "This may be the fault of the server, not the proxy.\n<br>"
	         "To find out, disable the proxy in your browser configuration "
	         "and try again.<br>"
		 "If it still doesn't work, it wasn't the proxy's fault.\n";

char CNXDOM[]  = "HTTP/1.0 404 Connect failed.\n\n"
		 "No such domain: %s\n";

char CDENIED[] = "HTTP/1.0 404 Request denied.\n\n"
		 "The request for<p><center>%s%s%s</center><p>was denied by the proxy server.\n"
		 "This is because the URL matches a pattern in the blockfile.\n"
		 "The pattern that blocked this URL is<p><center>%s</center>\n"
		 ;

char CSUCCEED[] = "HTTP/1.0 200 Connection established\n"
		  "Proxy-Agent: " VERSION "\n\n";

char CHEADER[] = "HTTP/1.0 400 Invalid header received from browser\n\n";

char SHEADER[] = "HTTP/1.0 400 Invalid header received from server\n\n";

char VANILLA_WAFER[] =
	"NOTICE=TO_WHOM_IT_MAY_CONCERN_"
	"Do_not_send_me_any_copyrighted_information_other_than_the_"
	"document_that_I_am_requesting_or_any_of_its_necessary_components._"
	"In_particular_do_not_send_me_any_cookies_that_"
	"are_subject_to_a_claim_of_copyright_by_anybody._"
	"Take_notice_that_I_refuse_to_be_bound_by_any_license_condition_"
	"(copyright_or_otherwise)_applying_to_any_cookie._";

char DEFAULT_USER_AGENT[] ="User-Agent: Mozilla/3.0 (OS/2; I)";

int debug     = 0;
int can_fork  = 1;
int SSL       = 0;

char *logfile = NULL;
FILE *log     = stdout;

char *blockfile  = NULL;
char *cookiefile = NULL;

char *jarfile = NULL;
FILE *jar;

char *referer    = NULL;
char *uagent     = NULL;
char *from       = NULL;

int send_vanilla_wafer = 0;
int add_forwarded      = 0;

char *cookie_list[64];
char * wafer_list[64];
char *  xtra_list[64];
char x_forwarded[BUFSIZ];

int send_user_cookie     = 0;
int accept_server_cookie = 0;

int (*interceptor)() = NULL;

struct block_spec  blist[1];
struct cookie_spec clist[1];
int (*loaders[4])();

char fd_in_body[1024];
char connected_to[1024];

char *forward_host = NULL;
int   forward_port = 8000;

struct gateway gateways[] = {
{ "direct",	NULL,	0,	0,		connect_to		},
{ "socks",	NULL,	1080,	SOCKS_4,	socks4_connect_to	},
{ "socks4",	NULL,	1080,	SOCKS_4,	socks4_connect_to	},
{ "socks4a",	NULL,	1080,	SOCKS_4A,	socks4_connect_to	},
};

extern struct gateway *gateway();

char *gateway_spec   = "direct";

int
main(argc, argv)
char *argv[];
{
	char buf[32 * 1024];
	char host[BUFSIZ], path[BUFSIZ], pspec[32], *p;
	fd_set rfds, wfds;
	int bfd, c, n, cfd, sfd, maxfd, rfd, wfd, child;
	struct parsers *patterns;
	struct block_spec *b;
	struct cookie_spec *cs;
	struct timeval tv[1];
	struct gateway *gw;
	struct textlist *t;
	int (**more_headers)();
	extern char *optarg;
	extern int optind;

	int err = 0;

	char *haddr = NULL;
	int   hport = 8000;

	prog = argv[0];

	t = init_proxy_args(argc, argv);

	cfd  = -1;
	sfd  = -1;

	while((c = getopt(argc, argv, "vyw:g:x:c:b:l:j:h:f:su:r:t:d:")) != EOF) {
		switch(c) {
		case 'd': debug    |= atoi (optarg);	po(t, c, optarg);	break;
		case 'y': add_forwarded     = 1;	po(t, c, NULL);		break;
		case 's': can_fork          = 0;	po(t, c, NULL);		break;

		case 'w': enlist(wafer_list, optarg);	po(t, c, optarg);	break;
		case 'v': send_vanilla_wafer = -1;	po(t, c, NULL);		break;
		case 'x': enlist(xtra_list,  optarg);	po(t, c, optarg);	break;

		case 'c': cookiefile         = optarg;	po(t, c, optarg);	break;
		case 'l': logfile            = optarg;	po(t, c, optarg);	break;
		case 'b': blockfile          = optarg;	po(t, c, optarg);	break;
		case 'j': jarfile            = optarg;	po(t, c, optarg);	break;

		case 'h': haddr              = optarg;	po(t, c, optarg);	break;

		case 'f': forward_host       = optarg;	po(t, c, optarg);	break;
		case 'g': gateway_spec       = optarg;	po(t, c, optarg);	break;
		case 'u': uagent             = optarg;	po(t, c, optarg);	break;
		case 'r': referer            = optarg;	po(t, c, optarg);	break;
		case 't': from               = optarg;	po(t, c, optarg);	break;

		default : err                = 1;	po(t, c, NULL);		break;
		}
	}

	if(err) exit(1);

	if(logfile) {
		FILE *tlog = fopen(logfile, "a");
		if(tlog == NULL) {
			fprintf(log, "%s: can't open logfile '%s': ",
				prog, logfile);
			fperror(log, "");
			err = 1;
		}
		log = tlog;
	}

	setbuf(log, NULL);

	if(cookiefile) add_loader(load_cookiefile);

	if(blockfile)  add_loader(load_blockfile);

	if(jarfile) {
		jar = fopen(jarfile, "a");
		setbuf(jar, NULL);
		if(jar == NULL) {
			fprintf(log, "%s: can't open jarfile '%s': ",
				prog, jarfile);
			fperror(log, "");
			err = 1;
		}
		if(send_vanilla_wafer == 0) send_vanilla_wafer = 1;
	}

	if(haddr) {
		if((p = strchr(haddr, ':'))) {
			*p++ = '\0';
			if(*p) hport = atoi(p);
		}

		if(hport <= 0) {
			*--p = ':' ;
			fprintf(log, "%s: invalid bind port spec %s",
				prog, haddr);
			err = 1;
		}
		if(*haddr == '\0') haddr = NULL;
	}

	/* select a gateway/connection protocol */

	gw = gateway(gateway_spec);

	if(gw == NULL) {
		fprintf(log, "%s: invalid gateway spec %s\n",
			prog, gateway_spec);
		err = 1;
	}

	if(forward_host) {
		if((p = strchr(forward_host, ':'))) {
			*p++ = '\0';
			if(*p) forward_port = atoi(p);
		}

		if(forward_port <= 0) {
			*--p = ':' ;
			fprintf(log, "%s: invalid forwarding port spec %s\n",
				prog, forward_host);
			err = 1;
		}
	}

	if(run_loader()) err = 1;

	if(err) exit(1);

	if((send_vanilla_wafer > 0)
	&& (wafer_list[0] == NULL)) {
		wafer_list[0] = VANILLA_WAFER;
	}

	if(DEBUG(CON)) {
		fprintf(log, "%s: bind (%s, %d)\n",
			prog, haddr ? haddr : "INADDR_ANY", hport);
	}

	bfd = bind_port(haddr, hport);

	if(bfd < 0) {
		fprintf(log, "%s: can't bind %s:%d: ",
			prog, haddr ? haddr : "INADDR_ANY", hport);
		fperror(log, "");
		err = 1;
	}

	if(err) exit(1);

	end_proxy_args();

	signal(SIGPIPE, SIG_IGN);
	signal(SIGCHLD, SIG_IGN);

	child = 0;

	for(;;) {
		if(child) exit(0);

		while(waitpid(-1, NULL, WNOHANG) > 0) {
			/* zombie children */
		}

		if(cookie_list[0]) {
			free(cookie_list[0]);
			cookie_list[0] = NULL;
		}
		x_forwarded[0] = '\0';
		SSL            = 0;

		memset(fd_in_body, '\0', sizeof(fd_in_body));

		if(cfd >= 0) close(cfd);
		if(sfd >= 0) close(sfd);

		if(DEBUG(CON)) {
			fprintf(log, "%s: accept connection ... ", prog);
		}

		cfd = accept_connection(bfd);

		if(cfd < 0) {
			if(DEBUG(CON)) {
				fprintf(log, "%s: accept failed: ", prog);
				fperror(log, "");
			}
			continue;
		} else {
			if(DEBUG(CON)) {
				fprintf(log, "OK\n");
			}
		}

		if(run_loader()) {
			fprintf(log, "%s: a loader failed - must exit\n", prog);
			exit(1);
		}

		if(can_fork) switch(fork()) {
		case -1: /* failed */
			fprintf(log, "%s: can't fork: ", prog);
			fperror(log, "");

			sprintf(buf , "%s: can't fork: errno = %d",
				prog, errno);

			write(cfd, buf, strlen(buf));
			close(cfd), cfd = -1;
			sleep(5);
			break;
		default: /* parent */
			continue;
			break;
		case 0:	/* child */
			child = 1;
			break;
		}

		/* read the browser's header */
		n = read_header(cfd, buf, sizeof(buf));

		if(n <= 0) {
			strcpy(buf, CHEADER);
			xwrite(cfd, buf, strlen(buf));
			continue;
		}

		n = convert_url(buf, host, &hport, path);

		if(n < 0) continue;

		if(hport == 80) {
			*pspec = '\0';
		} else {
			sprintf(pspec, ":%d", hport);
		}

		if((b = block_url(host, hport, path)) && (b->reject)) {
			if(DEBUG(GPC)) {
				fprintf(log, "%s: GPC\t%s%s%s crunch!\n",
					prog, host, pspec, path);
			}
			if(DEBUG(CON)) {
				fprintf(log,
					"%s: connect to: %s%s%s blocked by %s.\n",
						prog, host, pspec, path, b->url->spec);
			}
			sprintf(buf, CDENIED, host, pspec, path, b->url->spec);
			xwrite(cfd, buf, strlen(buf));
			continue;
		}

		accept_server_cookie = 0;
		send_user_cookie     = 0;

		if(cs = cookie_url(host, hport, path)) {
			accept_server_cookie = cs->accept_server_cookie;
			send_user_cookie     = cs->send_user_cookie;
		}

		n = sed(cfd, buf, sizeof(buf), n, client_patterns, add_client_headers);
		if(n <= 0) continue;

		/* this url has been intercepted */
		if(interceptor) {
			if(DEBUG(HDR)) fprintf(log, "%s: intercepted by proxy\n", prog);
			n = (interceptor)(buf, sizeof(buf));

			if(DEBUG(LOG)) fwrite(buf, n, 1, log);

			xwrite(cfd, buf, n);
			continue;
		}

		if(DEBUG(GPC)) {
			fprintf(log, "%s: GPC\t%s%s%s\n", prog, host, pspec, path);
		}

		if(DEBUG(CON)) {
			if(forward_host) {
				fprintf(log,
					"%s: connect via %s:%d to: %s%s ... ",
						prog,
						forward_host, forward_port,
						host, pspec);
			} else {
				fprintf(log,
					"%s: connect to: %s%s ... ",
						prog, host, pspec);
			}
		}

		if(forward_host) {
			sfd = (gw->conn)(forward_host, forward_port, gw);
		} else {
			sfd = (gw->conn)(host, hport, gw);
		}

		if(sfd < 0) {
			if(DEBUG(CON)) {
				fprintf(log, "%s: connect to: %s%s failed: ",
						prog, host, pspec);
				fperror(log, "");
			}

			if(errno == EINVAL) {
				sprintf(buf, CNXDOM, host);
				xwrite(cfd, buf, strlen(buf));
			} else {
				sprintf(buf, CFAIL, host, safe_strerror(errno));
				xwrite(cfd, buf, strlen(buf));
			}

			continue;
		}
		
		if(DEBUG(CON)) {
			fprintf(log, "OK\n");
		}

		strcpy(connected_to, host);

		if(SSL) {
			/* send "connect succeeded" message to client
			 * then get out of the way...
			 */
			if(forward_host == NULL) {
				xwrite(cfd, CSUCCEED, sizeof(CSUCCEED)-1);
				if(DEBUG(LOG)) fwrite(CSUCCEED, sizeof(CSUCCEED)-1, 1, log);
			}
			n = 0;
		}

		/* write the browser header to the server */
		if((n > 0) && (write(sfd, buf, n) != n)) {
			if(DEBUG(CON)) {
				fprintf(log, "%s: write header to: %s%s failed: ",
					prog, host, pspec);
				fperror(log, "");
			}

			sprintf(buf, CFAIL, host, safe_strerror(errno));
			write(cfd, buf, strlen(buf));
			continue;
		}

		if(DEBUG(LOG)) fwrite(buf, n, 1, log);

		maxfd = ( cfd > sfd ) ? cfd : sfd;

		/* pass data between the client and server
		 * until one or the other shuts down the connection.
		 */
		for(;;) {
			FD_ZERO(&rfds);

			FD_SET(cfd, &rfds);
			FD_SET(sfd, &rfds);

			n = select(maxfd+1, &rfds, NULL, NULL, NULL);

			if(n < 0) {
				fprintf(log, "%s: select() failed!: ", prog);
				fperror(log, "");
				exit(1);
			}

			if(FD_ISSET(cfd, &rfds)) {
				patterns     = client_patterns;
				more_headers = add_client_headers;
				rfd = cfd;
				wfd = sfd;
			} else if(FD_ISSET(sfd, &rfds)) {
				patterns     = server_patterns;
				more_headers = add_server_headers;
				rfd = sfd;
				wfd = cfd;
			} else {
				/* huh? */
				continue;
			}

			if((fd_in_body[rfd]) || (SSL)) {
				n = read(rfd, buf, sizeof(buf));
			} else {
				/* N.B. this must be a read of the header from the server
				 * since we read the client's header earlier.
				 */
				if((n = read_header(rfd, buf, sizeof(buf))) > 0) {
					n = sed(rfd, buf, sizeof(buf), n, patterns, more_headers);
				}

				if(n <= 0) {
					strcpy(buf, SHEADER);
					xwrite(cfd, buf, strlen(buf));
				}
			}

			if(n <= 0) break; /* "game over, man" */

			if(DEBUG(LOG)) fwrite(buf, n, 1, log);

			if(write(wfd, buf, n) != n) {
				if(DEBUG(CON)) {
					if(wfd == sfd) {
						fprintf(log, "%s: write to: %s%s failed: ",
							prog, host, pspec);
						fperror(log, "");
					} else {
						fprintf(log, "%s: write to browser failed: ",
							prog);
						fperror(log, "");
					}
				}
				/* if this is an SSL connection,
				 * we can't say anything that would help ... */
				if(!SSL) {
					sprintf(buf, CFAIL, host, safe_strerror(errno));
					write(cfd, buf, strlen(buf));
				}
				exit(1);
			}
		}
	}
	/* NOTREACHED */
	return(1);
}

#ifdef NOSTRERROR
char *
strerror(int err)
{
	static char buf[BUFSIZ];
	sprintf(buf, "(errno = %d)", err);
	return(buf);
}
#endif /* NOSTRERROR */

char *safe_strerror(int err)
{
	char *s = strerror(err);
	static char buf[BUFSIZ];

	if(s) return(s);

	sprintf(buf, "(errno = %d)", err);
	return(buf);
}

void
fperror(FILE *fp, char *str)
{
	if(str && *str) {
		fprintf(fp, "%s: %s\n", str, safe_strerror(errno));
	} else {
		fprintf(fp, "%s\n", safe_strerror(errno));
	}
}

/* write or die */
void
xwrite(int fd, char *buf, int n)
{
	if(write(fd, buf, n) != n) {
		if(DEBUG(IO)) {
			fprintf(log, "%s: write(%d bytes) failed: ", prog, n);
			fperror(log, "");
			exit(1);
		}
	}
}

struct gateway *
gateway(char *spec)
{
	static struct gateway gw[1];
	struct gateway *g;
	struct gateway *eog = gateways + SZ(gateways);

	char *v[10];
	char *p;
	char buf[BUFSIZ];
	int n;
	static struct textlist t[1];

	if(t->text) {
		t->text[0] = '\0';
	} else {
		add_proxy_args(t);
	}

	sprintf(buf, "<h2>It supports the following gateway protocols:</h2>\n");

	po(t, 0, buf);

	for(g = gateways; g < eog; g++) {
		sprintf(buf, "%s\n", g->name);
		po(t, 0, buf);
	}

	memset(gw, '\0', sizeof(*gw));

	p = strdup(spec);

	n = ssplit(p, ":", v, SZ(v), 0, 0);

	if(n > 0) {

		for(g = gateways; g < eog; g++) {
			if(strcmp(p, g->name) == 0) {

				memcpy(gw, g, sizeof(*gw));

				switch(n) {
				case 3:	gw->port = atoi(v[2]);
				case 2:	gw->host = v[1];
				case 1: return(gw);
				}
			}
		}
	}
	return(NULL);
}
