char *encode_rcs = "$Id: encode.c,v 2.2 1997/04/03 20:31:10 ACJC Exp $";
/* Written and copyright by the Anonymous Coders and Junkbusters Corporation.
 * Will be made available under the GNU General Public License.
 * This software comes with NO WARRANTY.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

char *url_code_map[256];
char *cookie_code_map[256];

char *
url_encode(char **code_map, unsigned char *s)
{
	static char buf[BUFSIZ];
	unsigned char c, *p;
	char *m;

	static int one_shot = 1;

	if(one_shot) {

		/* initialize the code maps */

		int i;

		one_shot = 0;

		/* for cookies, we turn white-space into '+'
		 * hex encode comma and semi-colons
		 * and leave everything else alone.
		 */

		cookie_code_map[' '] = "+";

		sprintf(buf, "%%%02X", ',');
		cookie_code_map[','] = strdup(buf);

		sprintf(buf, "%%%02X", ';');
		cookie_code_map[';'] = strdup(buf);

		/* for url's, we do full URL encoding.		*/
		/* non-alphanumerics get turned into hex ...	*/
		for(i=0; i < 256; i++) {
			if(isalnum(i) == 0) {
				sprintf(buf, "%%%02X", i);
				url_code_map[i] = strdup(buf);
			}
		}

		/* ... with the following 6 exceptions:		*/
		/* white-space gets turned into '+' ...		*/

		url_code_map[' '] = "+";

		/* ... and these punctuation chars map to themselves */
		url_code_map['-'] = "-";
		url_code_map['_'] = "_";
		url_code_map['.'] = ".";
		url_code_map['*'] = "*";
		url_code_map['@'] = "@";
	}

	for(p = (unsigned char *) buf; (c = *s); s++) {
		if(m = code_map[c]) {
			strcpy((char *) p, m);
			p += strlen(m);
		} else {
			*p++ = c;
		}
	}

	*p = '\0';

	return(buf);
}
