char *conn_rcs = "$Id: conn.c,v 2.3 1997/04/20 17:09:47 ACJC Exp $";
/* Written and copyright by the Anonymous Coders and Junkbusters Corporation.
 * Will be made available under the GNU General Public License.
 * This software comes with NO WARRANTY.
 */

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <netdb.h> 
#include <sys/socket.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
extern int errno;

int
atoip(char *host)
{
  struct sockaddr_in inaddr;
  struct hostent *hostp;

  if((host == NULL) || (*host == '\0')) return(INADDR_ANY);

  memset ((char*) &inaddr, 0, sizeof inaddr);
  if ((inaddr.sin_addr.s_addr = inet_addr(host)) == -1) {
    if (((hostp = gethostbyname(host)) == NULL)
	&& ((hostp = gethostbyname(host)) == NULL)) {
      errno = EINVAL;
      return(-1);
    }
    if (hostp->h_addrtype != AF_INET) {
      errno = EPROTOTYPE;
      return(-1);
    }
    memcpy((char*) &inaddr.sin_addr, (char*) hostp->h_addr,
	  sizeof(inaddr.sin_addr));
  }
  return(inaddr.sin_addr.s_addr);
}

int
connect_to (host, portnum)
     char *host;
     int portnum;
{
  struct sockaddr_in inaddr;
  struct hostent *hostp;
  int fd;
  fd_set wfds;
  struct timeval tv[1];
  int flags;

  memset ((char*) &inaddr, 0, sizeof inaddr);
  if ((inaddr.sin_addr.s_addr = inet_addr(host)) == -1) {
    if (((hostp = gethostbyname(host)) == NULL)
	&& ((hostp = gethostbyname(host)) == NULL)) {
      errno = EINVAL;
      return -1;
    }
    if (hostp->h_addrtype != AF_INET) {
      errno = EPROTOTYPE;
      return -1;
    }
    inaddr.sin_family = hostp->h_addrtype;
    memcpy((char*) &inaddr.sin_addr, (char*) hostp->h_addr,
	  sizeof(inaddr.sin_addr));
  } else {
    inaddr.sin_family = AF_INET;
  }

  if(sizeof(inaddr.sin_port) == sizeof(short)) {
    inaddr.sin_port = htons(portnum);
  } else {
    inaddr.sin_port = htonl(portnum);
  }

  fd = socket(inaddr.sin_family, SOCK_STREAM, 0);
  if (fd < 0)
    return -1;
#ifdef TCP_NODELAY
  { /* turn off TCP coalescence */
    int mi = 1;
    setsockopt (fd, IPPROTO_TCP, TCP_NODELAY, (char*) &mi, sizeof (int));
  }
#endif
  /* attempt a non blocking connect */
  if ((flags = fcntl(fd, F_GETFL, 0)) != -1) {
    flags |= O_NDELAY;
    fcntl(fd, F_SETFL, flags);
  }
  while (connect(fd, (struct sockaddr *)&inaddr, sizeof inaddr) == -1) {
    if (errno == EINPROGRESS) {
      break;
    }
    if (errno != EINTR) {
      (void) close (fd);
      return -1;
    }
  }
  if(flags != -1) {
  	flags &= ~O_NDELAY;
	fcntl(fd, F_SETFL, flags);
  }

  /* wait for connection to complete */
  FD_ZERO(&wfds);
  FD_SET(fd, &wfds);

  tv->tv_sec  = 30;
  tv->tv_usec = 0;

  if(select(fd+1, NULL, &wfds, NULL, tv) <= 0) {
  	(void) close(fd);
	return(-1);
  }
  return(fd);
}
