#!/bin/bash

# This script generates a very simple sendmail.cf file for people whith only
# one fido link, and one or none internet link.
# Pablo Saratxaga <srtxg@f2219.n293.z2.fidonet.org>

##### configurable options. You MUST change them according to your situation.

# where to put the output
SENDMAIL_CF=./sendmail.cf

# Want you to use $FIDO_GATE to route mail to the internet ?
# If you have FTN only access you will have to "yes"
USEFGATE=no

# The SENDMAIL.frm
SENDMAIL_FRM=./SENDMAIL.frm

# _Your_ fido address. In f.n.z.domain format. Only the part after the "@"
FIDO_ADDR=p28.f301.n345.z2.fidonet.org

# Your fido _uplink_ address (again in f.n.z.domain form, and only the
# part after the "@")
FIDO_LINK=f301.n345.z2.fidonet.org

# Your fido --> internet gateway (in f.n.z.domain form, only the part after
# the "@" )
FIDO_GATE=f875.n292.z2.fidonet.org

# Your local machine name (FQDN). If none (eg you are not connected to the
# internet) leave it blank, $FIDO_ADDR will be used instead.
LOCAL_ADDR=

# an email address different from your fido one or one on your local machine.
# if none let it blank. 
EMAIL_ADDR=srtxg@chanae.stben.be

# Your local login
LOCAL_LOGIN=emartine

# Your internet smart host. If none let it blank.
SMART_HOST=smtp.provider.com

####### end of configurable options

if [ "$LOCAL_ADDR" = "" ]; then
   LOCAL_ADDR=${FIDO_ADDR}
fi

if [ "$EMAIL_ADDR" = "" ]; then
   EMAIL_ADDR=${LOCAL_LOGIN}@${FIDO_ADDR}
fi

if [ "$USEFGATE" = "yes" ]; then
   USEFGATE_1=
   USEFGATE_2="#"
else
   USEFGATE_1="#"
   USEFGATE_2=
fi


if true
then

	FIDO_ZONE=`echo ${FIDO_ADDR} | cut -dz -f2 | cut -d. -f1`
	FIDO_NET=`echo ${FIDO_ADDR} | cut -dn -f2 | cut -d. -f1`
	UUCP_NAME=`echo ${LOCAL_ADDR} | cut -d. -f1`
	EMAIL_ADDR=`echo ${EMAIL_ADDR} | gawk ' { n = split($0, t, "@") \
	; printf("%s<@%s.>",t[1],t[2]) } '`
	BASENAME=`basename $0`
	DATE=`date | tr ' ' '_'`

	cat ${SENDMAIL_FRM} \
	| sed s/{FIDO_ADDR}/${FIDO_ADDR}/g    \
	| sed s/{FIDO_LINK}/${FIDO_LINK}/g    \
	| sed s/{FIDO_GATE}/${FIDO_GATE}/g    \
        | sed s/{LOCAL_ADDR}/${LOCAL_ADDR}/g  \
        | sed s/{LOCAL_LOGIN}/${LOCAL_LOGIN}/g\
        | sed s/{EMAIL_ADDR}/${EMAIL_ADDR}/g  \
        | sed s/{SMART_HOST}/${SMART_HOST}/g  \
        | sed s/{FIDO_ZONE}/${FIDO_ZONE}/g    \
        | sed s/{FIDO_NET}/${FIDO_NET}/g      \
	| sed s/{UUCP_NAME}/${UUCP_NAME}/g    \
	| sed s/{USEFGATE_1}/${USEFGATE_1}/g  \
	| sed s/{USEFGATE_2}/${USEFGATE_2}/g  \
	| sed s/{BASENAME}/${BASENAME}/       \
	| sed s/{DATE}/${DATE}/               \
	> ${SENDMAIL_CF}

fi
