# Copyright (c) 1983 Eric P. Allman
# Copyright (c) 1988, 1993
#	The Regents of the University of California.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by the University of
#	California, Berkeley and its contributors.
# 4. Neither the name of the University nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#


######################################################################
######################################################################
#####
#####		SENDMAIL CONFIGURATION FILE
#####
##### built by {BASENAME} on {DATE}
##### for machine {LOCAL_ADDR} 
#####
######################################################################
######################################################################

# level 5 config file format
V5

##################
#   local info   #
##################

## List of local machine aliases _MUST_ include localhost
Cwlocalhost {LOCAL_ADDR} {FIDO_ADDR} {UUCP_NAME}

# pseudo-domains
CPz1.fidonet.org z2.fidonet.org z3.fidonet.org z4.fidonet.org z5.fidonet.org z6.fidonet.org ftn uucp

## "Smart" relay host (may be null)
DS{SMART_HOST}

## Gateway !!! NON OFFICIAL !!!
## for user%address@gateway constructs
DG{FIDO_GATE}

## Fidonet smart host !!! NON OFFICIAL !!!
DF{FIDO_LINK}

## UUCP names
CU{UUCP_NAME}

# who I send unqualified names to (null means deliver locally)
DR

# who gets all local email traffic ($R has precedence for unqualified names)
DH

# who I masquerade as (null for no masquerading)
DM

# class L: names that should be delivered locally, even if we have a relay
# class E: names that should be exposed as from this host, even if we masquerade
#CLroot
CEroot

# operators that cannot be in local usernames (i.e., network indicators)
CO @ % 

# a class with just dot (for identifying canonical names)
C..

# dequoting map
Kdequote dequote


######################
#   Special macros   #
######################

# SMTP initial login message
De$j Sendmail $v/$Z ready at $b

# UNIX initial From header format
DlFrom $g  $d

# my name for error messages
DnMAILER-DAEMON

# delimiter (operator) characters
Do.:%@!^/[]

# format of a total name
Dq$?x$x <$g>$|$g$.

# Configuration version number
DZ8.6.9


###############
#   Options   #
###############

# strip message body to 7 bits on input?
O7False

# wait (in minutes) for alias file rebuild
Oa10

# location of alias file
OA/etc/aliases

# minimum number of free blocks on filesystem
Ob15

# substitution for space (blank) characters
OB.

# avoid connecting to "expensive" mailers on initial submission?
OcTrue

# checkpoint queue runs after every N successful deliveries
OC10

# default delivery mode
Odbackground

# automatically rebuild the alias database?
ODFalse

# error message header/file
#OE/etc/sendmail.oE

# error mode
#Oep

# save Unix-style "From_" lines at top of header?
OfFalse

# temporary file mode
OF0600

# match recipients against GECOS field?
OGTrue

# default GID
Og1

# maximum hop count
Oh17

# location of help file
OH/usr/lib/sendmail.hf

# ignore dots as terminators in incoming messages?
OiFalse

# Insist that the BIND name server be running to resolve names
OI

# deliver MIME-encapsulated error messages?
OjTrue

# Forward file search path
#OJ/var/forward/$u:$z/.forward.$w:$z/.forward

# open connection cache size
Ok2

# open connection cache timeout
OK5m

# use Errors-To: header?
OlTrue

# log level
OL9

# send to me too, even in an alias expansion?
OmFalse

# verify RHS in newaliases?
OnTrue

# default messages to old style headers if no special punctuation?
OoTrue

# SMTP daemon options
#OOPort=esmtp

# privacy flags
Opauthwarnings

# who (if anyone) should get extra copies of error messages
OPPostmaster

# slope of queue-only function
#Oq600000

# queue directory
OQ/var/spool/mqueue

# read timeout -- now OK per RFC 1123 section 5.3.2
#Ordatablock=10m

# queue up everything before forking?
OsTrue

# status file
OS/etc/sendmail.st

# default message timeout interval
OT5d/1d

# time zone handling:
#  if undefined, use system default
#  if defined but null, use TZ envariable passed in
#  if defined and non-null, use that info
#Ot

# default UID
Ou1

# list of locations of user database file (null means no lookup)
OU

# fallback MX host
#OVfall.back.host.net

# if we are the best MX host for a site, try it directly instead of config err
OwFalse

# load average at which we just queue messages
Ox8

# load average at which we refuse connections
OX12

# work recipient factor
#Oy30000

# deliver each queued job in a separate process?
OYFalse

# work class factor
#Oz1800

# work time factor
#OZ90000

###########################
#   Message precedences   #
###########################

Pfirst-class=0
Pspecial-delivery=100
Plist=-30
Pbulk=-60
Pjunk=-100

#####################
#   Trusted users   #
#####################

Troot
Tdaemon
Tuucp fnet

#########################
#   Format of headers   #
#########################

H?P?Return-Path: $g
HReceived: $?sfrom $s $.$?_($?s$|from $.$_) $.by $j ($v/$Z)$?r with $r$. id $i$?u for $u$.; $b
H?D?Resent-Date: $a
H?D?Date: $a
H?F?Resent-From: $q
H?F?From: $q
H?x?Full-Name: $x
HSubject:
# HPosted-Date: $a
# H?l?Received-Date: $b
H?M?Resent-Message-ID: <$t.$i@$j>
H?M?Message-ID: <$t.$i@$j>
#
######################################################################
######################################################################
#####
#####			REWRITING RULES
#####
######################################################################
######################################################################


###########################################
###  Rulset 3 -- Name Canonicalization  ###
###########################################
S3

# handle null input (translate to <@> special case)
R$@			$@ <@>

# basic textual canonicalization -- note RFC733 heuristic here
R$*<$*>$*<$*>$*		$2$3<$4>$5			strip multiple <> <>
R$*<$*<$+>$*>$*		<$3>$5				2-level <> nesting
R$*<>$*			$@ <@>				MAIL FROM:<> case
R$*<$+>$*		$2				basic RFC821/822 parsing

# handle list:; syntax as special case
R$*:;$*			$@ $1 :; <@>

# make sure <@a,@b,@c:user@d> syntax is easy to parse -- undone later
R@ $+ , $+		@ $1 : $2			change all "," to ":"

# localize and dispose of route-based addresses
R@ $+ : $+		$@ $>96 < @$1 > : $2		handle <route-addr>

# find focus for list syntax
R $+ : $* ; @ $+	$@ $>96 $1 : $2 ; < @ $3 >	list syntax
R $+ : $* ;		$@ $1 : $2;			list syntax

# find focus for @ syntax addresses
R$+ @ $+		$: $1 < @ $2 >			focus on domain
R$+ < $+ @ $+ >		$1 $2 < @ $3 >			move gaze right
R$+ < @ $+ >		$@ $>96 $1 < @ $2 >		already canonical

# do some sanity checking
R$* < @ $* : $* > $*	$1 < @ $2 $3 > $4		nix colons in addrs

# convert old-style addresses to a domain-based address
R$=w ! $- ! $+		$@ $>96 $3 < @ $2 . UUCP >
R$=w ! $+		$@ $>96 $2
R$- ! $+		$@ $>96 $2 < @ $1 .UUCP >	resolve uucp names
R$+ . $- ! $+		$@ $>96 $3 < @ $1 . $2 >	domain uucps
R$+ ! $+		$@ $>96 $2 < @ $1 .UUCP >	uucp subdomains

# if we have % signs, take the rightmost one
R$* % $*		$1 @ $2				First make them all @s.
R$* @ $* @ $*		$1 % $2 @ $3			Undo all but the last.
R$* @ $*		$@ $>96 $1 < @ $2 >		Insert < > and finish

# else we must be a local name


################################################
###  Ruleset 96 -- bottom half of ruleset 3  ###
################################################

#  At this point, everything should be in a "local_part<@domain>extra" format.
S96

# Some adress mappings 
R$+				$: $>99 $1

# handle special cases for local names
R$* < @ localhost > $*		$: $1 < @ $j . > $2		no domain at all
R$* < @ localhost . $m > $*	$: $1 < @ $j . > $2		local domain
R$* < @ [ $+ ] > $*		$: $1 < @@ [ $2 ] > $3		mark [a.b.c.d]
R$* < @@ $=w > $*		$: $1 < @ $j . > $3		self-literal
R$* < @@ $+ > $*		$@ $1 < @ $2 > $3		canon IP addr

# if really UUCP, handle it immediately

# try UUCP traffic as a local address
#R$* < @ $+ . UUCP > $*		$: $1 < @ $[ $2 $] . UUCP . > $3
R$* < @ $+ . . UUCP . > $*	$@ $1 < @ $2 . > $3

# local host aliases and pseudo-domains are always canonical
R$* < @ $=w > $*		$: $1 < @ $2 . > $3
R$* < @ $* $=P > $*		$: $1 < @ $2 $3 . > $4

## pass to name server to make hostname canonical...
#R$* < @ $* $~. > $*		$: $1 < @ $[ $2 $3 $] > $4
## or not use a DNS, assume addresses are FQDN.
R$* < @ $* $~. > $*		$: $1 < @ $2 $3 . > $4

R$* < @ $* . . > $*		$1 < @ $2 . > $3

# if this is the local hostname, make sure we treat is as canonical
R$* < @ $j > $*			$: $1 < @ $j . > $2

##################################################
###  Ruleset 4 -- Final Output Post-rewriting  ###
##################################################
S4

R$*<@>			$@ $1				handle <> and list:;

# strip trailing dot off possibly canonical name
R$* < @ $+ . > $*	$1 < @ $2 > $3

# externalize local domain info
R$* < $+ > $*		$1 $2 $3			defocus
R@ $+ : @ $+ : $+	@ $1 , @ $2 : $3		<route-addr> canonical
R@ $*			$@ @ $1				... and exit

## UUCP must always be presented in old form
#R$+ @ $- . UUCP	$2!$1				u@h.UUCP => h!u

# delete duplicate local names
R$+ % $=w @ $=w		$1 @ $j				u%host@host => u@host



##############################################################
###   Ruleset 97 -- recanonicalize and call ruleset zero   ###
###		   (used for recursive calls)		   ###
##############################################################

S97
R$*			$: $>3 $1
R$*			$@ $>0 $1

######################################
###   Ruleset 0 -- Parse Address   ###
######################################

S0

R<@>			$#local $: <>			special case error msgs
R$* : $* ;		$#error $@ USAGE $: "list:; syntax illegal for recipient addresses"
R<@ $+>			$#error $@ USAGE $: "user address required"
R<$* : $* >		$#error $@ USAGE $: "colon illegal in host name part"

# handle numeric address spec
R$* < @ [ $+ ] > $*	$: $>98 $1 < @ [ $2 ] > $3	numeric internet spec
R$* < @ [ $+ ] > $*	$#smtp $@ [$2] $: $1 < @ [$2] > $3	still numeric: send

# now delete the local info -- note $=O to find characters that cause forwarding
R$* < @ > $*		$@ $>97 $1		user@ => user
R< @ $=w . > : $*	$@ $>97 $2		@here:... -> ...
R$* $=O $* < @ $=w . >	$@ $>97 $1 $2 $3	...@here -> ...

## To: "UUCP" at local is returned back. Because it happens whith ifmail
## receiving mail to "UUCP" via FTN but whitout a To: line specifying a
## destination ! 8-)
RUUCP			$#error $: "You MUST provide a To: address "

# short circuit local delivery so forwarded email works
R$+ < @ $=w . >		$: $1 < @ $2 . @ $H >		first try hub
R$+ < $+ @ $+ >		$#local $: $1			yep ....
R$+ < $+ @ >		$#local $: @ $1			nope, local address

# handle local hacks
R$*			$: $>98 $1

# resolve fake top level domains by forwarding to other hosts

R$* < @ [ $+ ] > $*			$#smtp $@ [$2] $: $1 < @ [$2] > $3	still numeric: s
## FTN gateway to route to internet...
{USEFGATE_1}R$* < @ $* . > $*			$#fnet $@ $S $: $1 % $2 < @ $G > $3
## ...or maybe you have a true internet access whith a Smart host...
{USEFGATE_2}R$* < @ $* . > $*			$#smtp $@ [$S] $: $1 < @ $2 > $3
## ...or whithout a smart host, rely on DNS.
{USEFGATE_2}R$* < @ $* . > $*			$#smtp $@ [$2] $: $1 < @ $2 > $3

# pass names that still have a host to a smarthost (if defined)
R$* < @ $* > $*		$: $>95 < $S > $1 < @ $2 > $3	glue on smarthost name

# deal with other remote names
R$* < @$* > $*		$#smtp $@ $2 $: $1 < @ $2 > $3		user@host.domain

# if this is quoted, strip the quotes and try again
R$+			$: $(dequote $1 $)		strip quotes
R$+ $=O $+		$@ $>97 $1 $2 $3			try again

# handle locally delivered names
R$=L			$#local $: @ $1			special local names
R$+			$#local $: $1			regular local names

###########################################################################
###   Ruleset 5 -- special rewriting after aliases have been expanded   ###
###		   (new sendmail only)					###
###########################################################################

S5

# see if we have a relay or a hub
R$+			$: < $R > $1			try relay
R< > $+			$: < $H > $1			try hub
R< > $+			$@ $1				nope, give up
R< $- : $+ > $+		$: $>95 < $1 : $2 > $3 < @ $2 >
R< $+ > $+		$@ $>95 < $1 > $2 < @ $1 >

###################################################################
###  Ruleset 95 -- canonify mailer:host syntax to triple	###
###################################################################

S95
R< > $*			$@ $1				strip off null relay
R< $- : $+ > $*		$# $1 $@ $2 $: $3		try qualified mailer
R< $=w > $*		$@ $2				delete local host
R< $+ > $*		$#relay $@ $1 $: $2		use unqualified mailer

###################################################################
###  Ruleset 98 -- local part of ruleset zero (can be null)	###
###################################################################

S98

#  ************* Pour les Linux-Party :) *****
#R$* < @ $* drug.be . > $*	$#smtp $@ [$2 drug.be] $: $1 < @ $2 drug.be > $3

#  ************ ME (and local) ***************
#R{EMAIL_ADDR} $*		$#local $: {LOCAL_LOGIN}

#  ************ LOCAL (points etc) ***********
#R$* < @ p5.{FIDO_ADDR} . > $*	$#fnet $@ p5.{FIDO_ADDR} $: $1 < @ p5.{FIDO_ADDR} . > $2
R$* < @ $+ . $w . > $*			$#error $: sorry but machine $1.$w doesn't exist !

#  ************ FIDONET.ORG and others FTN ***

# for nodes allways put leading $* if you want to route his points too
# routed trough default smart host $S
R$* < @ $+ .z1.fidonet.org . > $*	$#fnet $@ $F $: $1 < @ $2 .z1.fidonet.org > $3
R$* < @ $+ .z2.fidonet.org . > $*	$#fnet $@ $F $: $1 < @ $2 .z2.fidonet.org > $3
R$* < @ $+ .z3.fidonet.org . > $*	$#fnet $@ $F $: $1 < @ $2 .z3.fidonet.org > $3
R$* < @ $+ .z4.fidonet.org . > $*	$#fnet $@ $F $: $1 < @ $2 .z4.fidonet.org > $3
R$* < @ $+ .z5.fidonet.org . > $*	$#fnet $@ $F $: $1 < @ $2 .z5.fidonet.org > $3
R$* < @ $+ .z6.fidonet.org . > $*	$#fnet $@ $F $: $1 < @ $2 .z6.fidonet.org > $3

# mexwellnet
#R$* < @ $+ .z86.mexwellnet.ftn . > $*	$#fnet $@ f57.n99.z86.mexwellnet.ftn $: $1 < @ $2 .z86.mexwellnet.ftn > $3

# all the remaining FTN's (via fido smart host $F)
R$* < @ $+ .ftn . > $*				$#fnet $@ $F $: $1 < @ $2 .ftn > $3

###################################################################
###  Ruleset 99 (not standard) -- adress names mapping          ###
###################################################################

S99

# mapping for fidonet.org adresses
R$+ < @ $+ . fidonet > $*	$: $1 < @ $2 . fidonet . org  > $3
R$+ < @ $+ . fido > $*		$: $1 < @ $2 . fidonet . org  > $3
R$+ < @ $+ . z{FIDO_ZONE} > $*		$: $1 < @ $2 . z{FIDO_ZONE} . fidonet . org  > $3
R$+ < @ $+ . n{FIDO_NET} > $*		$: $1 < @ $2 . n{FIDO_NET} . z{FIDO_ZONE} . fidonet . org  > $3

# mappings for other FTN's

R$+ < @ $+ . francom > $*		$: $1 < @ $2 . francom . ftn > $3
R$+ < @ $+ . francomedia > $*		$: $1 < @ $2 . francom . ftn > $3
R$+ < @ $+ . francomedia.ftn > $*	$: $1 < @ $2 . francom . ftn > $3
R$+ < @ $+ . fmedia > $*		$: $1 < @ $2 . francom . ftn > $3
R$+ < @ $+ . fmedia.ftn > $*		$: $1 < @ $2 . francom . ftn > $3
R$+ < @ $+ . z101.fidonet.org > $*	$: $1 < @ $2 . z101 . francom . ftn > $3
R$+ < @ $+ .n320.z101.francom.ftn > $*	$: $1 < @ $2 .belgique.fm.alphanet.ch > $3
R$+ < @ $+ .n352.z101.francom.ftn > $*	$: $1 < @ $2 .luxembourg.fm.alphanet.ch > $3
R$+ < @ $+ .n340.z101.francom.ftn > $*	$: $1 < @ $2 .espagne.fm.alphanet.ch > $3
R$+ < @ $+ .n180.z101.francom.ftn > $*	$: $1 < @ $2 .suisse.fm.alphanet.ch > $3

#
######################################################################
######################################################################
#####
#####			MAILER DEFINITIONS
#####
######################################################################
######################################################################


##################################################
###   Local and Program Mailer specification   ###
##################################################

#####  @(#)local.m4	8.6 (Berkeley) 10/24/93  #####

Mlocal,		P=/usr/bin/deliver, F=lsDFMShP, S=10, R=20/40,
		A=deliver $u
Mprog,		P=/bin/sh, F=lsDFMu, S=10, R=20/40, D=$z:/,
		A=sh -c $u

S10
R<@>			$n			errors to mailer-daemon
R$+			$: $>40 $1

S20
R$+ < @ $* >		$: $1			strip host part

S40
R$* < @ $* > $*		$@ $1 < @ $2 > $3	already fully qualified
R$*			$: $1 @ $M		add local qualification
R$* @			$: $1 @ $j		if $M not defined

####################################
###  USENET Mailer specification ###
####################################

#### @(#)usenet.m4        8.3 (Berkeley) 1/24/94 ####

Musenet,	P=/usr/lib/news/inews, F=rlsDFMmn, , S=10, R=20,
		A=inews -h 
#-m -h -n $u

####################################
###   FAX Mailer specification   ###
####################################

#### @(#)fax.m4   8.2 (Berkeley) 1/24/94 ####

Mfax,		P=/usr/local/lib/fax/mailfax, F=DFMhu, S=14, R=24, M=100000,
		A=mailfax $u $h $f

#####################################
###   FNET Mailer specification   ###
#####################################
Mfnet, 		P=/usr/lib/ifmail/ifmail, F=mDFMuSC, S=11, R=21,
		A=ifmail -r $h -g h $u

# "fido" don't write Received: lines
#"-r $h" is required as ifmail requires packet routing address.
#-g h is hold flavour.

#####################################
###   SMTP Mailer specification   ###
#####################################

#####  @(#)smtp.m4	8.15 (Berkeley) 2/14/94  #####

Msmtp,		P=[IPC], F=mDFMuX, S=11/31, R=21, E=\r\n,
		L=990, A=IPC $h
Mesmtp,		P=[IPC], F=mDFMuXa, S=11/31, R=21, E=\r\n,
		L=990, A=IPC $h
Mrelay,		P=[IPC], F=mDFMuXa, S=11/31, R=61, E=\r\n,
		L=2040, A=IPC $h

#
#  envelope sender and masquerading recipient rewriting
#
S11
R$+			$: $>51 $1			sender/recipient common
R$* :; <@>		$@ $1 :;			list:; special case
R$*			$@ $>61 $1			qualify unqual'ed names


#
#  header recipient rewriting if not masquerading recipients
#
S21

# do sender/recipient common rewriting
R$+			$: $>51 $1

# unqualified names (e.g., "eric") are qualified by local host
R$* < @ $* > $*		$@ $1 < @ $2 > $3		already qualified
R$+			$: $1 < @ $j >			add local domain


#
#  header sender and masquerading recipient rewriting
#
S31
R$+			$: $>51 $1			sender/recipient common
R$* :; <@>		$@ $1 :;			list:; special case

# do special header rewriting
R$* <@> $*		$@ $1 <@> $2			pass null host through
R< @ $* > $*		$@ < @ $1 > $2			pass route-addr through
R$=E < @ $=w . >	$@ $1 < @ $2 >			exposed user as is
R$* < @ $=w . >		$: $1 < @ $2 @ $M >		masquerade as domain
R$* < @ $+ @ >		$@ $1 < @ $2 >			in case $M undefined
R$* < @ $+ @ $+ >	$@ $1 < @ $3 >			$M is defined -- use it
R$*			$@ $>61 $1			qualify unqual'ed names


#
#  convert pseudo-domain addresses to real domain addresses
#
S51

# pass <route-addr>s through
R< @ $+ > $*		$@ < @ $1 > $2			resolve <route-addr>

# output fake domains as user%fake@relay

# do UUCP heuristics; note that these are shared with UUCP mailers
R$+ < @ $+ .UUCP. >	$: < $2 ! > $1			convert to UUCP form
R$+ < @ $* > $*		$@ $1 < @ $2 > $3		not UUCP form

# leave these in .UUCP form to avoid further tampering
R< $&h ! > $- ! $+	$@ $2 < @ $1 .UUCP. >
R< $&h ! > $-.$+ ! $+	$@ $3 < @ $1.$2 >
R< $&h ! > $+		$@ $1 < @ $&h .UUCP. >
R< $+ ! > $+		$: $1 ! $2 < @ $Y >
R$+ < @ >		$: $1 < @ $j >			in case $Y undefined
R$+ < @ $+ : $+ >	$: $1 < @ $3 >			strip mailer: part


#
#  common sender and masquerading recipient rewriting
#
S61

R$* < @ $* > $*		$@ $1 < @ $2 > $3		already qualified
R$=E			$@ $1 < @ $j>			show exposed names
R$+			$: $1 < @ $M >			user w/o host
R$+ <@>			$: $1 < @ $j >			in case $M undefined

#####################################
###   UUCP Mailer specification   ###
#####################################

#####  @(#)uucp.m4      8.16 (Berkeley) 4/14/94  #####

#
#  There are innumerable variations on the UUCP mailer.  It really
#  is rather absurd.
#

# old UUCP mailer (two names)
Muucp,		P=/usr/bin/uux, F=DFMhuU, S=12, R=22/42, M=100000,
		A=uux - -r -a$f -gC $h!rmail ($u)
Muucp-old,	P=/usr/bin/uux, F=DFMhuU, S=12, R=22/42, M=100000,
		A=uux - -r -a$f -gC $h!rmail ($u)

# smart UUCP mailer (handles multiple addresses) (two names)
Msuucp,		P=/usr/bin/uux, F=mDFMhuU, S=12, R=22/42, M=100000,
		A=uux - -r -a$f -gC $h!rmail ($u)
Muucp-new,	P=/usr/bin/uux, F=mDFMhuU, S=12, R=22/42, M=100000,
		A=uux - -r -a$f -gC $h!rmail ($u)

# domain-ized UUCP mailer
Muucp-dom,	P=/usr/bin/uux, F=mDFMhu, S=52/31, R=21, M=100000,
		A=uux - -r -a$f -gC $h!rmail ($u)

# domain-ized UUCP mailer with UUCP-style sender envelope
Muucp-uudom,	P=/usr/bin/uux, F=mDFMhu, S=72/31, R=21, M=100000,
		A=uux - -r -a$f -gC $h!rmail ($u)


#
#  envelope and header sender rewriting
#
S12

# handle error address as a special case
R<@>				$n			errors to mailer-daemon

# do not qualify list:; syntax
R$* :; <@>			$@ $1 :;

R$* < @ $* . >			$1 < @ $2 >		strip trailing dots
R$* < @ $=w >			$1			strip local name
R<@ $- . UUCP > : $+		$1 ! $2			convert to UUCP format
R<@ $+ > : $+			$1 ! $2			convert to UUCP format
R$* < @ $- . UUCP >		$2 ! $1			convert to UUCP format
R$* < @ $+ >			$2 ! $1			convert to UUCP format
R$&h ! $+ ! $+			$@ $1 ! $2		$h!...!user => ...!user
R$&h ! $+			$@ $&h ! $1		$h!user => $h!user
R$+				$: $U ! $1		prepend our name
R! $+				$: $k ! $1		in case $U undefined

#
#  envelope recipient rewriting
#
S22

# don't touch list:; syntax
R$* :; <@>			$@ $1 :;

R$* < @ $* . >			$1 < @ $2 >		strip trailing dots
R$* < @ $j >			$1			strip local name
R<@ $- . UUCP > : $+		$1 ! $2			convert to UUCP format
R<@ $+ > : $+			$1 ! $2			convert to UUCP format
R$* < @ $- . UUCP >		$2 ! $1			convert to UUCP format
R$* < @ $+ >			$2 ! $1			convert to UUCP format

#
#  header recipient rewriting
#
S42

# don't touch list:; syntax
R$* :; <@>			$@ $1 :;

R$* < @ $* . >			$1 < @ $2 >		strip trailing dots
R$* < @ $j >			$1			strip local name
R<@ $- . UUCP > : $+		$1 ! $2			convert to UUCP format
R<@ $+ > : $+			$1 ! $2			convert to UUCP format
R$* < @ $- . UUCP >		$2 ! $1			convert to UUCP format
R$* < @ $+ >			$2 ! $1			convert to UUCP format
R$&h ! $+ ! $+			$@ $1 ! $2		$h!...!user => ...!user
R$&h ! $+			$@ $&h ! $1		$h!user => $h!user
R$+				$: $U ! $1		prepend our name
R! $+				$: $k ! $1		in case $U undefined


#
#  envelope sender rewriting for uucp-dom mailer
#
S52

# handle error address as a special case
R<@>				$n			errors to mailer-daemon

# pass everything to standard SMTP mailer rewriting
R$*				$@ $>11 $1

#
#  envelope sender rewriting for uucp-uudom mailer
#
S72

# handle error address as a special case
R<@>				$n			errors to mailer-daemon

# do not qualify list:; syntax
R$* :; <@>			$@ $1 :;

R$* < @ $* . >			$1 < @ $2 >		strip trailing dots
R$* < @ $=w >			$1			strip local name
R<@ $- . UUCP > : $+		$1 ! $2			convert to UUCP format
R<@ $+ > : $+			$1 ! $2			convert to UUCP format
R$* < @ $- . UUCP >		$2 ! $1			convert to UUCP format
R$* < @ $+ >			$@ $2 ! $1		convert to UUCP format

R$&h ! $+ ! $+			$@ $1 ! $2		$h!...!user => ...!user
R$&h ! $+			$@ $&h ! $1		$h!user => $h!user
R$+				$: $M ! $1		prepend masquerade name
R! $+				$: $j ! $1		in case $M undefined

