#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <stdio.h>
#include "needed.h"
#include "lutil.h"
#include "xutil.h"

/* QP-Decode code by T.Tanaka <tt@efnet.com> */
/* QP-Encode inspired from sendmail code of Berkley */

#define        XD(c)   ( (((c) >= '0') && ((c) <= '9')) ? (c) - '0' :         \
		(((c) >= 'A') && ((c) <= 'F')) ? (c) - 'A' + 10 :    \
		(((c) >= 'a') && ((c) <= 'f')) ? (c) - 'a' + 10 : 0)

char	badchars[] = 	    "\001\002\003\004\005\006\007" \
			"\010\011\012\013\014\015\016\017" \
			"\020\021\022\023\024\025\026\027" \
			"\030\031\032\033\034\035\036\037" \
			"\177" \
			"\200\201\202\203\204\205\206\207" \
			"\210\211\212\213\214\215\216\217" \
			"\220\221\222\223\224\225\226\227" \
			"\230\231\232\233\234\235\236\237" \
			"\240\241\242\243\244\245\246\247" \
			"\250\251\252\253\254\255\256\257" \
			"\260\261\262\263\264\265\266\267" \
			"\270\271\272\273\274\275\276\277" \
			"\300\301\302\303\304\305\306\307" \
			"\310\311\312\313\314\315\316\317" \
			"\320\321\322\323\324\325\326\327" \
			"\330\331\332\333\334\335\336\337" \
			"\340\341\342\343\344\345\346\347" \
			"\350\351\352\353\354\355\356\357" \
			"\360\361\362\363\364\365\366\367" \
			"\370\371\372\373\374\375\376\377";

/* char	badchars2[] =	"#$[]^`{|}~"; */

char    Base16Code[] =  "0123456789ABCDEF";
char    Base64Code[] =  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

char *qp_decode(s)
char *s;
{
	static char *buf;
	char *p, *q;

	if (buf)
		free(buf);
	if ((buf = malloc(strlen(s) + 1 * sizeof(char))) == NULL) {
		loginf("dequote:out of memory:string too long:\"%s\"", s);
		return s;
	}
	for (p = s, q = buf; *p != '\0';) {
		if (*p == '=') {
			++p;
			if (*p == '\0') {	/* ends with "=(null)" */
				*q++ = '=';
				break;
			} else if (*p == '\n')
				break;
			else if (isxdigit(*p) && isxdigit(*(p + 1))) {
				*q++ = 16 * XD(*p) + XD(*(p + 1));
				++p;
				++p;
			} else {	/* "=1x" "=5(null)" "=G\n" "=0=" etc. */
				*q++ = '=';
				*q++ = *p++;
			}
		} else
			*q++ = *p++;
	}
	*q = '\0';

	return buf;
}

char *qp_encode(s)
char *s;
{
	static char *buf;
	char *p, *q;
	int linelen=0;

	if (buf)
		free(buf);
	if ((buf = malloc(3 * strlen(s) + 1 * sizeof(char))) == NULL) {
		loginf("dequote:out of memory:string too long:\"%s\"", s);
		return s;
	}
	for (p = s, q = buf; *p != '\0';) {
		if (*p == '\n')
		{
			*q++ = *p++;
			linelen = 0;
		}
		else if (*p == ' ' || *p == '\t')
		{
			if ((linelen > 72) && (*(p+1) != '\n'))
			{
				*q++ = *p++;
				*q++ = '=';
				*q++ = '\n';
				linelen = 0;
			}
			else if (*(p+1) == '\n')
			{
				*q++ = *p++;
				*q++ = '=';
				*q++ = *p++;
				linelen = 0;
			}
			else
			{
				*q++ = *p++; 
				linelen += 1;
			}
		}
		else if (strchr(badchars,*p))
		{
			if (linelen > 72)
			{
				*q++ = '\n';
				linelen = 0;
			}
			*q++ = '=';
			*q++ = Base16Code[(*p >> 4) & 0x0f];
			*q++ = Base16Code[*p & 0x0f];
			linelen += 3;
			p++;
		}
		else if (*p == '=')
		{
			if ((*(p+1)) && (*(p+2)) &&
			    (strchr(Base16Code,*(p+1))) &&
			    (strchr(Base16Code,*(p+2))))
			{
				*q++ = *p++;
				*q++ = *p++;
				*q++ = *p++;
				linelen += 3;
			}
			else if ((*(p+1)) && (*(p+1) == '\n'))
			{
				*q++ = *p++;
				*q++ = *p++;
				linelen = 0;
			}
			else
			{
				*q++ = '=';
              	                *q++ = Base16Code[(*p >> 4) & 0x0f];
              	                *q++ = Base16Code[*p & 0x0f];
              	                linelen += 3;
              	                p++;
			}
		}
		else
		{
			*q++ = *p++;
			linelen++;
		}
	}
	*q = '\0';

	return buf;
}

/* ##################################### */
/* #         not defined yet           # */
/* ##################################### */

char *b64_decode(s)
char *s;
{
	return s;
}

char *b64_encode(s)
char *s;
{
	return s;
}

