/* recognized charsets */
#define CHRS_AUTODETECT		-1
#define CHRS_NOTSET		 0
#define CHRS_ASCII		 1 /* us-ascii */
#define CHRS_CP424		 2 /* hebrew EBCDIC */
#define CHRS_CP437		 3 /* Latin-1 MS codage (cp437) */
#define CHRS_CP852		 4 /* Polish MS-DOS codage */
#define CHRS_CP862		 5 /* Hebrew PC */
#define CHRS_CP866		 6 /* Cyrillic Alt-PC (cp866) */
#define CHRS_EUC_JP		 7 /* Japanese EUC */
#define CHRS_EUC_KR		 8 /* Korean EUC */
#define CHRS_ISO_2022_CN	 9 /* Chinese GB 2312 7 bits */
#define CHRS_ISO_2022_JP	10 /* Japanese iso-2022-jp */
#define CHRS_ISO_2022_KR        11 /* Korean iso-2022-kr */
#define CHRS_ISO_2022_TW	12 /* Taiwanese iso-2022-tw */
#define CHRS_ISO_8859_1		13 /* Latin-1, Western Europe, America */ 
#define CHRS_ISO_8859_1_QP	14
#define CHRS_ISO_8859_2		15 /* Latin-2, Eastern Europe */
#define CHRS_ISO_8859_3		16 /* Latin-3, Balkanics languages */
#define CHRS_ISO_8859_4		17 /* Latin-4, Scandinavian, Baltic */
#define CHRS_ISO_8859_5		18 /* Cyrillic (iso-8859-5) */
#define CHRS_ISO_8859_6		19 /* Arabic (iso-8859-6) */
#define CHRS_ISO_8859_7		20 /* Greek (iso-8859-7) */
#define CHRS_ISO_8859_8		21 /* Hebrew (iso-8859-8) */
#define CHRS_ISO_8859_9		22 /* Latin-5, Turkish */
#define CHRS_ISO_8859_10	23 /* Latin-6, Lappish/Nordic/Eskimo */
#define CHRS_KOI8_R		24 /* Cyrillic Koi8 (Russian) */
#define CHRS_KOI8_U		25 /* Cyrillic Koi8 (Ukranian) */
#define CHRS_NEC		26 /* Japanese NEC-JIS */
#define CHRS_SJIS		27 /* Japanese Shift-JIS (MS codage) */
#define CHRS_UNICODE_1_1	28 /* Unicode-1-1 */
#define CHRS_FIDOMAZOVIA	29 /* Polish "FIDOMAZOVIA" charset */

#define CHRS_ISO_11             91
#define CHRS_ISO_4              92
#define CHRS_ISO_60             93

/* languages (used for LANG_DEFAULT definition) */
#define LANG_WEST		1 /* West-European languages */	
#define LANG_EAST		2 /* East-Eurpean languages */
#define LANG_JAPAN		3 /* japanese */
#define LANG_KOREA		4 /* korean */
#define LANG_CYRILLIC		5 /* Cyrillic based languages */

/* Define these according to the values used in your country */
#define CHRS_DEFAULT_FTN	CHRS_CP437
#define CHRS_DEFAULT_RFC	CHRS_ISO_8859_1
#define LANG_DEFAULT		LANG_JAPAN

/* some special chars values */
#define NUL         0
#define NL          10
#define FF          12
#define CR          13
#define ESC         27
#define TRUE        1
#define FALSE       0
#ifndef SEEK_CUR
#define SEEK_CUR    1
#endif

/* ************ general functions ************* */
char *strnkconv(const char *src, int incode, int outcode, int maxlen);
char *strkconv(const char *src, int incode, int outcode);
void kconv(FILE *in, FILE *out, int incode, int outcode);

/* ************ 8 bit charsets **************** */

void noconv(FILE *in, FILE *out);
void eight2eight(FILE *in,FILE *out, char *filemap);

/* maptabs names */
#define CP424__CP862		"cp424__cp862"
#define CP424__ISO_8859_8	"cp424__iso-8859-8"
#define CP437__ISO_8859_1	"cp437__iso-8859-1"
#define CP852__FIDOMAZOVIA	"cp852__fidomazovia"
#define CP852__ISO_8859_2	"cp852__iso-8859-2"
#define CP862__CP424		"cp862__cp424"
#define CP862__ISO_8859_8	"cp862__iso-8859-8"
#define CP866__ISO_8859_5	"cp866__iso-8859-5"
#define CP866__KOI8_R		"cp866__koi8"
#define ISO_11__ISO_8859_1	"iso-11__iso-8859-1"
#define ISO_4__ISO_8859_1	"iso-4__iso-8859-1"
#define ISO_60__ISO_8859_1	"iso-60__iso-8859-1"
#define ISO_8859_1__CP437	"iso-8859-1__cp437"
#define ISO_8859_2__CP852	"iso-8859-2__cp852"
#define ISO_8859_2__FIDOMAZOVIA	"iso-8859-2__fidomazovia"
#define ISO_8859_5__CP866	"iso-8859-5__cp866"
#define ISO_8859_5__KOI8_R	"iso-8859-5__koi8"
#define ISO_8859_8__CP424	"iso-8859-8__cp424"
#define ISO_8859_8__CP862	"iso-8859-8__cp862"
#define KOI8_R__CP866		"koi8__cp866"
#define KOI8_R__ISO_8859_5	"koi8__iso-8859-5"
#define FIDOMAZOVIA__CP852	"fidomazovia__cp852"
#define FIDOMAZOVIA__ISO_8859_2	"fidomazovia__iso-8859-2"

/* ************ 16 bits charsets ************* */
/* japanese charsets */

#define SJIS1(A)    ((A >= 129 && A <= 159) || (A >= 224 && A <= 239))
#define SJIS2(A)    (A >= 64 && A <= 252)
#define HANKATA(A)  (A >= 161 && A <= 223)
#define ISEUC(A)    (A >= 161 && A <= 254)
#define ISMARU(A)   (A >= 202 && A <= 206)
#define ISNIGORI(A) ((A >= 182 && A <= 196) || (A >= 202 && A <= 206))

void han2zen(FILE *in,int *p1,int *p2,int incode);
void sjis2jis(int *p1,int *p2);
void jis2sjis(int *p1,int *p2);
void shift2seven(FILE *in,FILE *out,int incode,char ki[],char ko[]);
void shift2euc(FILE *in,FILE *out,int incode,int tofullsize);
void euc2seven(FILE *in,FILE *out,int incode,char ki[],char ko[]);
void euc2euc(FILE *in,FILE *out,int incode,int tofullsize);
void shift2shift(FILE *in,FILE *out,int incode,int tofullsize);
void euc2shift(FILE *in,FILE *out,int incode,int tofullsize);
void seven2shift(FILE *in,FILE *out);
void seven2euc(FILE *in,FILE *out);
void seven2seven(FILE *in,FILE *out,char ki[],char ko[]);
int iso2022_detectcode(FILE *in,int);

/* ??? */
int toup(int data);
int SkipESCSeq(FILE *in,int temp,int *intwobyte);
int getkcode(int code,char ki[],char ko[]);
