/*
   ICESTAT.C - iceStat v1.00
   Copyright (C) 1994 by Life Force.
   You may use any of this code that you wish, as long as you
   give credit to Life Force.  If you use the spin function,
   you must give credit to Tolkien.
   Most of this code is ANSI C compatible.
   It will compile successfully under Borland's Turbo C++ v3.00
   for DOS.  You may have to make minor modifications for other
   compilers.

   last modification:  12 nov 1994
*/

#pragma warn -aus
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* vardec.h is a header file from the WWIV software by Wayne Bell.
   You need to include a copy of vardec.h from WWIV version 4.22
   or greater.  Versions v4.23+ may require additional header files.
   Read the compiler's error message to find out which one(s).
*/
#include "vardec.h"
#include <sys\stat.h>
#include <sys\types.h>
#include <time.h>
#include <dos.h>

userrec thisuser;  /* userrec data structure defined in vardec.h */
char    ansi,            /* ansi enabled? */
		data[81],        /* data dir with trailing backslash */
		systemname[51];
int     usernum;
void    show_help (void),
		goxy (int x, int y),
		left (int amount),
		display_data (void),
		spin(unsigned char *s);
int     test_ansi (char *filename),
		display (char *filename),
		read_chaintxt (char *filename),
		read_userlst (void);

FILE    *chaintxt,
		*userlst;
/*=========================================================================*/
void main (int argc, char *argv[])
{
	if (argc < 2)
	{
		show_help();
		exit (1);
	}

	if (!test_ansi(argv[1])) /* if they don't have ANSI, simply exit */
		exit (1);

	if (!read_chaintxt(argv[1]))
	{
		printf ("\n## Error:  unable to read data from %s. \n", argv[1]);
		exit (2);
	}

	if (!read_userlst())
	{
		printf ("\n## Error:  unable to read data from %sUSER.LST. \n", data);
		exit (2);
	}

	printf ("\x1b[2J"); /* clear screen */
	if (!display ("ICESTAT.ANS"))
	{
		printf ("\n## Error:  unable to display ICESTAT.ANS. \n");
		exit (2);
	}

	display_data ();
	printf ("\x1b[2J"); /* clear screen */
}

/*=========================================================================*/
/* goxy moves the cursor to a specific point on the screen using
   ANSI escape sequences.
*/
void goxy(int x, int y)
{
	printf ("\x1b[%d;%dH", y, x);
}
/*=========================================================================*/
/* left uses ANSI escape sequences to cause the cursor to move left a
   specified amount.
*/
void left(int amount)
{
	printf ("\x1b[%dD", amount);
}
/*=========================================================================*/
/* test_ansi examines CHAIN.TXT to determine if the user has ANSI graphics
   support turned on.
*/
int test_ansi (char *filename)
{
	char    buffer[81],
			ansi_status;
	register int i;

	if ((chaintxt = fopen(filename, "rt")) == NULL)
	  {
		printf ("\n## Error:  unable to read data from %s. \n", filename);
		exit (2);
	  }

	for (i = 1; i < 14; i++)   /* this loop moves to line #14 */
		fgets (buffer, 80, chaintxt);
	ansi_status = getc (chaintxt);
	fclose (chaintxt);
	if (ansi_status != '0')
		return 1;
	else
		return 0;
}
/*=========================================================================*/
void show_help (void)
{
	printf ("\n\niceStat v1.00 \n");
	printf ("Copyright (C) 1994 by Life Force \n");
	printf ("Beta testing by Troy Lancaster & Jim Nunn. \n");
	printf ("Compiled under Turbo C++ v3.00 on %s \n", __DATE__);
	printf ("Syntax is: \n");
	printf ("    ICESTAT <chain.txt> \n");
	printf ("Example: \n");
	printf ("    ICESTAT C:\\WWIV\\CHAIN.TXT \n\n");
	printf ("This program is FREEWARE and may be freely used and copied. \n");
}
/*=========================================================================*/
/* display outputs the contents of a specificed file to standard output
   device by block reading the file into memory, then block writing the
   memory buffer to stdout.
*/
int     display (char *filename)
{
	FILE    *fp;
	struct  stat    buff;
	char    *membuf;

	if ((fp = fopen(filename, "rb")) == NULL)
	  return(0);

	stat(filename, &buff);

	if ((membuf = malloc(buff.st_size + 1024)) == NULL) {
	  printf("\ncannot allocate memory\n");
	  fclose(fp);
	  return(0);
	}

	fread( (void *)membuf, buff.st_size, 1, fp);
	fwrite( (void *)membuf, buff.st_size, 1, stdout);
	fclose(fp);
	free(membuf);
	return(1);
}
/*=========================================================================*/
/* read_chaintxt reads in data from specific lines of the specified
   file name.
*/
int  read_chaintxt (char *filename)
{
	char    temp[7];
	int     i;

	if ((chaintxt = fopen(filename, "rt")) == NULL)
	  return (0);

	fgets (temp, 6, chaintxt);   /* grab first line and */
	usernum = atoi (temp);       /* put it into usernum */

	for (i = 1; i < 18; i++)                 /* grab data dir off line #18 */
		fgets (data, 81, chaintxt);
	data[strlen (data) - 1] = '\0';

	for (i = 18; i < 22; i++)  /* grab system name off line #22 */
		fgets (systemname, 51, chaintxt);
	systemname[strlen (systemname) - 1] = '\0';

	fclose (chaintxt);
	return (1);
}
/*=========================================================================*/
int  read_userlst (void)
{
	char    path[128];
	long    size;

	size = sizeof (userrec);

	sprintf (path, "%sUSER.LST", data);
	if ((userlst = fopen (path, "rb")) == NULL)
	  return (0);

	fseek (userlst, size * (long) (usernum), SEEK_SET);
	fread (&thisuser, size, 1, userlst);

	fclose (userlst);
	return (1);
}
/*=========================================================================*/
void    display_data (void)
{
	time_t now;  /* holds time data */
	int ch;

	time (&now);  /* fill structure with current time info */

	goxy (39, 4);
	printf ("\x1b[0;37;40m"); /* set color to low white */
	printf ("%s #%d", thisuser.name, usernum);
	goxy (39, 5); printf (systemname);
	goxy (39, 6); printf ("%s", ctime (&now));
	goxy (18, 12); printf (thisuser.city);
	goxy (31, 13); printf ("%d", thisuser.msgpost);
	goxy (28, 14); printf ("%d", (thisuser.emailsent + thisuser.emailnet
								   + thisuser.feedbacksent) );
	goxy (19, 15); printf ("%dbps", thisuser.lastrate);
	goxy (25, 16); printf ("%dK", thisuser.uk);
	goxy (25, 17); printf ("%dK", thisuser.dk);
	goxy (24, 18); printf ("%lu minutes", (unsigned long) thisuser.timeon / (unsigned long) 60);
	goxy (23, 19);
	if (thisuser.forwardusr)
		printf ("%d@%d", thisuser.forwardusr, thisuser.forwardsys);
	else
		printf ("<not forwarded>");
	goxy (27, 20); printf ("%d", thisuser.logons);
	goxy (52, 13); printf ("%c", thisuser.sex);
	goxy (51, 14); printf ("%d", thisuser.age);
	goxy (63, 15); printf ("%d", thisuser.sl);
	goxy (70, 16); printf ("%d", thisuser.dsl);
	goxy (69, 17); printf ("%d", thisuser.uploaded);
	goxy (69, 18); printf ("%d", thisuser.downloaded);
	goxy (59, 19); printf ("%s", thisuser.laston);
	goxy (61, 20); printf ("%d", thisuser.waiting);

	goxy (34, 22);

	while ( !kbhit() )
	{
		printf ("\x1b[1;34;40mPRESS A KEY");  /* switch color to blue */
		left (11);
		spin ("PRESS A KEY");
		left (11);
	}
	ch = getch();
	printf ("\x1b[0;0;40m");  /* reset colors */
}

/*=========================================================================*/
/* spin is a slightly modified version of Tolkien's spin function from
   his ENHANCE.C.  If you use this function, you -must- give credit
   to Tolkien.
*/
void spin (unsigned char *s)
{
	register int i = 0,
				 dly = 18;

	printf ("\x1b[1;36;40m");  /* switch color to cyan */
	while (s[i]) 
	{
		delay(dly); putchar('/');  left(1);
		delay(dly); putchar('-');  left(1);
		delay(dly); putchar('\\'); left(1);
		delay(dly); putchar('|');  left(1);
		delay(dly); putchar(s[i]); delay(dly);
		i++;
	}
}

/*=========================================================================*/
