'ICAP.BAS
'Version 1.03
'12/3/94

'Written by Joseph C. Frankiewicz
'The Majestik Moose BBS, 708-843-2871

'Released to the Public Domain

'Retrieve and store modem status reports

'For USRobotics modems supporting the I6 and I11 commands.

'Written for QuickBASIC 4.5

'This program also uses and requires the QBSERIAL communications
'library by Jeff Sumberg, The SailBoard BBS, 201-831-8152

'To recompile:   BC /O /E ICAP.BAS
'                LINK /EX ICAP.OBJ+QBSER.OBJ

'-----------------------------------------------------------------------

 'External declares for QBSerial library, version 3.20

 DECLARE SUB OpenComm CDECL ALIAS "_open_comm" (BYVAL Port%, IRQ%, BYVAL Wlen%, BYVAL Parity%, BYVAL Bits%, BYVAL Baud&, BYVAL HS%, BYVAL FOSSIL%)
 DECLARE SUB CloseComm CDECL ALIAS "_close_comm" ()
 DECLARE FUNCTION WriteChar% CDECL (BYVAL c%)
 DECLARE FUNCTION ReadChar% CDECL ()
 DECLARE SUB transmit CDECL ALIAS "_transmit_string" (addr$)
 DECLARE FUNCTION DataWaiting% CDECL ALIAS "_data_waiting" ()
 DECLARE SUB ClearInputBuffer CDECL ALIAS "_clear_input_buffer" ()
 DECLARE SUB CarrierDetect CDECL ALIAS "_carrier_detect_flag" (BYVAL OnOff%)
 DECLARE FUNCTION CarrierLost% CDECL ALIAS "_carrier_state" ()
 DECLARE FUNCTION DriverCopyright% CDECL ()
 DECLARE SUB DTRcontrol CDECL ALIAS "_dtr" (BYVAL OnOff%)
 DECLARE SUB RTScontrol CDECL ALIAS "_rts" (BYVAL Onff%)
 DECLARE FUNCTION ModemStatus% CDECL ALIAS "_inputstatus" ()
 DECLARE SUB BREAKcontrol CDECL ALIAS "_break_state" (BYVAL state%)

'-----------------------------------------------------------------------

 'constants

 crlf$ = CHR$(&HD) + CHR$(&HA)

'-----------------------------------------------------------------------

 'start of main code

 'catch-all error handler
 ON ERROR GOTO errexit3

 PRINT
 PRINT
 PRINT "ICAP Version 1.03 - 12/3/94"
 PRINT "By Joseph C. Frankiewicz"
 PRINT

'-----------------------------------------------
'parse command line

'command line parameters are:
' port : irq : speed:  fossil  :  filename

 'make a copy of the command line
 x$ = COMMAND$

 'see if user was asking for help
 IF INSTR(x$, "?") THEN x$ = ""
 IF INSTR(x$, "/") THEN x$ = ""
 IF INSTR(x$, "HELP") THEN x$ = ""

 x$ = LTRIM$(RTRIM$(x$))

 IF x$ = "" THEN
    PRINT "Usage is:"
    PRINT
    PRINT "ICAP  <port> <irq> <speed> <fossil> <logfile>"
    PRINT
    PRINT "   PORT: comm or FOSSIL port number, or decimal base address"
    PRINT "    IRQ: 1-15, or 0 for default"
    PRINT "  SPEED: 0-115200, use 0 for FOSSIL only"
    PRINT " FOSSIL: 0=no FOSSIL, 1=use FOSSIL"
    PRINT "LOGFILE: name of output file to append"
    PRINT
    END
 END IF

 'pick off command line options from left to right

 x$ = LTRIM$(x$)

 'build a string, adding leftmost character until we hit a space or EOL.
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
 temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND
 'assign the option value
 comport% = VAL(temp$)

 x$ = LTRIM$(x$)
 
 'build a string, adding leftmost character until we hit a space or EOL.
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
    temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND
 'assign the option value
 comirq% = VAL(temp$)

 x$ = LTRIM$(x$)
 
 'build a string, adding leftmost character until we hit a space or EOL.
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
    temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND
 'assign the option value
 comspeed& = VAL(temp$)

 x$ = LTRIM$(x$)
 
 'build a string, adding leftmost character until we hit a space or EOL.
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
    temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND
 'assign the option value
 usefossil% = VAL(temp$)

 'whatever is left is the last option
 logfile$ = LTRIM$(RTRIM$(x$))


 'display what we parsed
 PRINT "PORT="; comport%; " IRQ="; comirq%; " SPEED="; comspeed&; " FOSSIL="; usefossil%
 PRINT "LOGFILE= "; logfile$
 PRINT


 'Probably should check for valid/legal filename here, but I'm too lazy.


 PRINT "Opening log file."

 'don't really know if this syntax works properly.  It should
 'allow for file sharing under network/multitask environment
 'but hasn't been tested.
 OPEN logfile$ FOR APPEND ACCESS READ WRITE SHARED AS #1
 
 'for non-sharing mode, use this instead:
 'OPEN logfile$ FOR APPEND AS #1
 
 'write seperator and time stamp to the file
 PRINT #1, "--------------------------------------------------------------"
 PRINT #1, LEFT$(DATE$, 6); RIGHT$(DATE$, 2); " "; TIME$

 PRINT "Opening COM port."

 'open the comm port using 8 bits, no parity,
 '1 stop bit, no flow control
 OpenComm comport%, comirq%, 8, 0, 1, comspeed&, 0, usefossil%

 'point the error handler at the routine that will close
 'the comm port in case we crash.
 ON ERROR GOTO errexit1

 'turn off carrier detect checking
 CarrierDetect 0

 'small delay
 zzz = TIMER + .2
 WHILE TIMER < zzz
 WEND

 PRINT "Toggling DTR."
 'drop DTR signal to modem
 DTRcontrol 0

 'wait a while for the modem to go into command mode
 zzz = TIMER + 1
 WHILE TIMER < zzz
 WEND

 'turn DTR signal back on so we can talk to modem
 DTRcontrol 1
 'and make sure the RTS signal is on too
 RTScontrol 1
 
 'wait a bit so the modem sees DTR
 zzz = TIMER + 1
 WHILE TIMER < zzz
 WEND


 'if carrier is still detected after dropping dtr, modem must be running
 'with &D1.  And if that is true, then dropping DTR has put me in on-line
 'command mode, so I need to send an ATH0 to hang up

 IF CarrierLost = 0 THEN
   
    'send hangup command
    PRINT "Carrier still detected, sending hang-up command."
   
    transmit "ATH0" + crlf$
   
    'wait up to 2 seconds for carrier detect to drop
    PRINT "Waiting for carrier to drop."
   
    t1 = TIMER + 2
    WHILE (TIMER < t1) AND CarrierLost = 0
    WEND
   
    IF CarrierLost = 0 THEN
       PRINT "Carrier not dropping, ICAP aborting."
       PRINT #1, "Cannot drop carrier!"
       GOTO errexit1
    END IF
   
    PRINT "Carrier dropped."
   
    'small delay
    t1 = TIMER + 1
    WHILE TIMER < t1
    WEND

 END IF

 'flush the receive buffer
 ClearInputBuffer

 PRINT "Querying modem."

 transmit "ATI6I11" + crlf$

 PRINT "Getting response."

 GOSUB mdmtodisk

errexit1:

 PRINT "Closing COM port."
 
 'drop dtr and rts
 DTRcontrol 0
 RTScontrol 0

 'shut down QBSERIAL interrupt driver!!!
 CloseComm

 PRINT #1, "--------------------------------------------------------------"

 PRINT "Closing log file."

errexit3:

 CLOSE

 PRINT "Done."

 END

'end of main code

'=========================================================================
'subroutine
'get from modem and write to disk, file 1 is already opened

mdmtodisk:

 mbuff$ = ""

 'wait up to 5 seconds for first character to arrive
 zzz = TIMER + 5
 WHILE TIMER < zzz AND DataWaiting% = 0
 WEND

 'if no chars have arrived, then something is wrong, so just exit
 IF DataWaiting% = 0 THEN RETURN


mdmtodisk2:

 'loop, getting characters from modem and writing
 'to disk file until no more come in
 WHILE DataWaiting%
    mbuff$ = mbuff$ + CHR$(ReadChar%)
 WEND

 'wait up to 3 seconds to see if another character arrives
 zzz = TIMER + 3
 WHILE TIMER < zzz AND DataWaiting% = 0
 WEND

 'if another character came in then go back into the read loop
 IF DataWaiting% THEN GOTO mdmtodisk2
 
 PRINT #1, mbuff$;

 RETURN

'=========================================================
'end of file
'=========================================================

