
package jlouie.beans;

import java.awt.*;
import java.awt.image.*;

public class GrayFilter extends RGBImageFilter {
   public GrayFilter() {
      canFilterIndexColorModel= true;
   }
   
   public int filterRGB(int x, int y, int rgb) {
      int a= rgb & 0xff000000;
      int r= ((rgb & 0xff0000)+0xff0000)/2;
      int g= ((rgb & 0x00ff00)+0x00ff00)/2;
      int b= ((rgb & 0x0000ff)+0x0000ff)/2;
      return a | r |g | b;
   }
}
