/*
 * Decompiled with CFR 0.152.
 */
package jlouie.beans;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.Serializable;
import java.net.URL;
import jlouie.beans.GrayFilter;

public class ImageButton
extends Canvas
implements Serializable {
    private static final String DEFAULT_FILE = "default.gif";
    private static final Dimension DEFAULT_DIMENSION = new Dimension(30, 10);
    private Image image;
    private Image gray;
    private boolean isSticky = false;
    private boolean isDown = false;
    private transient boolean isFocus = false;
    private String imageName = "default.gif";
    private transient ActionListener actionListener;

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.addNotify();
        frame.setLayout(new GridLayout(1, 2));
        ImageButton imageButton = new ImageButton(DEFAULT_FILE, true);
        frame.add(imageButton);
        frame.add(new ImageButton());
        ((Component)frame).setSize(200, 200);
        frame.show();
    }

    public ImageButton(String string, boolean bl) {
        this.isSticky = bl;
        this.image = this.loadImage(string);
        this.sizeToFit();
        GrayFilter grayFilter = new GrayFilter();
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.image.getSource(), grayFilter);
        this.gray = this.createImage(filteredImageSource);
        this.enableEvents(60L);
    }

    public ImageButton(String string) {
        this(string, false);
    }

    public ImageButton() {
        this(DEFAULT_FILE, false);
    }

    private void sizeToFit() {
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension.width, dimension.height);
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).invalidate();
            ((Component)container).doLayout();
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String string) {
        if (string != null) {
            this.imageName = string;
            this.image = this.loadImage(string);
            this.sizeToFit();
        }
    }

    public boolean isSticky() {
        return this.isSticky;
    }

    public void setSticky(boolean bl) {
        this.isSticky = bl;
    }

    public boolean isFocus() {
        return this.isFocus;
    }

    public boolean isDown() {
        return this.isDown;
    }

    public synchronized void AddActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1004: {
                this.isFocus = true;
                this.update(this.getGraphics());
                break;
            }
            case 1005: {
                this.isFocus = false;
                this.update(this.getGraphics());
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.isDown = !this.isDown;
                this.update(this.getGraphics());
                break;
            }
            case 502: {
                if (!this.isDown || this.isSticky) break;
                this.processActionEvent(new ActionEvent(this, 1001, null));
                this.isDown = false;
                this.update(this.getGraphics());
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyChar() == ' ') {
            if (this.isSticky) {
                this.isDown = !this.isDown;
                this.update(this.getGraphics());
            } else {
                this.isDown = true;
                this.update(this.getGraphics());
                this.processActionEvent(new ActionEvent(this, 1001, null));
                this.isDown = false;
                this.update(this.getGraphics());
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506 && !this.isSticky) {
            Point point = mouseEvent.getPoint();
            if (point.x < 0 || point.x > this.getSize().width || point.y < 0 || point.y > this.getSize().height) {
                if (this.isDown) {
                    this.isDown = false;
                    this.update(this.getGraphics());
                }
            } else if (!this.isDown) {
                this.isDown = true;
                this.update(this.getGraphics());
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public Image loadImage(String string) {
        try {
            URL uRL = this.getClass().getResource(string);
            Object object = uRL.getContent();
            if (object instanceof ImageProducer) {
                return this.createImage((ImageProducer)object);
            }
            return null;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public Dimension preferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        }
        return DEFAULT_DIMENSION;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.preferredSize();
        if (this.image != null && this.gray != null) {
            if (this.isDown) {
                graphics.drawImage(this.gray, 0, 0, this);
            } else {
                graphics.drawImage(this.image, 0, 0, this);
            }
        } else {
            graphics.drawString("ImageButton", 10, 10);
        }
        if (this.isFocus) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.darkGray);
        }
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, !this.isDown);
    }
}

