@echo off
:: --- Checks that a file encoded with Horst Schaeffer's CSCRIPT is intact,
:: --- by checking its CRC value.
:: --- Uses Horst's CRC32.COM and NSET.COM. Also, of course, needs DEBUG.
:: --- Assumes a properly clean script file!
:: --- My own version has CRC32 and NSET in a PACO archive  <grin>
if exist %1 goto GO
::
echo 
echo Can't find file %1!
goto END
::
:GO
:: --- get the filename from line #1,
:: --- pipe it into an environmental variable using NSET
:: --- preface "n" (lower case) is removed by declaring it a separator (/Sn)
type %1 | nset /L1/Sn FILENAME=$1
::
:: --- extract the CRC value put into the original script by CSCRIPT
find "CSCRIPT 2.2 by Horst Schaeffer" < %1 | nset ORIGINAL_CRC=$3
:: --- re-create the file
debug < %1
::
:: --- now extract the CRC value of the decoded file into an environmental
:: --- variable using CRC32 and NSET
crc32 %FILENAME% | nset DECODED_CRC=$1
::
:: --- and match them
if [%ORIGINAL_CRC%]==[%DECODED_CRC%] goto OK
echo 
echo.
echo   CRCs do not match!
echo   Original=%ORIGINAL_CRC%, decoded=%DECODED_CRC%
echo   Please check for file corruption!
echo.
goto END
::
:OK
echo.
echo CRCs match (%ORIGINAL_CRC%), file %FILENAME% is OK
echo.
::
::
:END
:: --- be kind to your environment, tidy up;
set FILENAME=
set ORIGINAL_CRC=
set DECODED_CRC=
