/****************************************************************************
	FILE:		write.c


	CONTENTS:	Compose()			window procedure for Compose dialog box.
				FillAttach()		initializes the Attach field
				FillBody()          initializes the Body field
				FillRecipients()	initializes the Recipient fields
				FillSubject()		initializes the Subject field
				PreFillComposeBox()	initializes Compose box Edit controls.

	COMMENTS:	This file contains the window procedures and other utilities
				used in composing a mail message.
****************************************************************************/
#include "MyMail.h"
#include "io.h"
#include "string.h"
#include "dos.h"

#define INCL_STDA_UI
#define INCL_STDA
#include "vnsstda.h"
#undef  INCL_STDA_UI
#undef  INCL_STDA

#include "stdlib.h"

/*** fmode is used in opening DOS files. ***/
#define fmode OF_READ|OF_SHARE_DENY_WRITE

extern Cap2			UserCaps;

/****************************************************************************
	FUNCTION:	Compose()

	PURPOSE:	Processes messages for Compose dialog box

	COMMENTS:	This same dialog procedure is used for Composing, Answering,
				and Editing mail messages.  The procedure uses the lParam
				value of the WM_INITDIALOG message to determine which action
				is required.
****************************************************************************/
BOOL FAR PASCAL _export Compose(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{

	BOOL 			BadFile;
	CallStatus		uStat;
	short           retcount;
	GLOBALHANDLE	hFile;
	GLOBALHANDLE	hEditText, hBody, hFolder;
	char            date_str[50], result[1600], buff[110], far *tempptr,
					far *text, rclass, far *filename;
	int 			confirmed, i, j, offset, fhandle, destination, index;
	unsigned int	bytes, line, linestart;
	MailFolder far	*TempFolder;
	BodyPart 		Body[11];
	Env 			MailEnv;
	LOGFONT			lf;
	HFONT			hFont;
	long			lBytes, zone, date, textbytes;
	HVNSD			hVNSD;
	RECT			Rect;
	DWORD			dwResult;
	static WORD		menuitem, controlID;
	static char 	MsgID[14], FoldName[14], OldMsgID[14];
	static BOOL		modified;
	HWND			hEdit;


	/*** Send Window Messages to Status Bar. ***/
	StatBarCtrlMsg(hDlg, ComposeBox, message, wParam, lParam);

	switch (message) {
		case WM_INITDIALOG:

			/*** Center the Dialog Window in the HappyMail Main window ***/
			CenterWindow(hDlg, GetDesktopWindow());

			/*** The LOWORD of lParam contains either IDM_ANSWER, IDM_COMPOSE ***/
			/*** or IDM_EDIT. The HIWORD contains the message ID or NULL.     ***/
			menuitem = LOWORD(lParam);

			/*** Create an emptry string to initialize the edit field. ***/
			/*** This allows the field to properly handle text greater than 32K in length. ***/
			if ((hEditText = SafeAlloc(GLOBAL, MAXMSGBODY, hDlg)) == NULL) {
				return TRUE;
			}
			tempptr = GlobalLock(hEditText);
			_fmemset(tempptr, ' ', MAXMSGBODY);
			tempptr[MAXMSGBODY-1L] = '\0';
			SetDlgItemText(hDlg, CB_MBODY, tempptr);
			SetDlgItemText(hDlg, CB_MBODY, "\0");
			SafeFree(GLOBAL, hEditText);

			/**** Set text limits and fonts. ****/
			SendDlgItemMessage(hDlg, CB_MBODY, WM_SETFONT, GetStockObject(SYSTEM_FIXED_FONT), NULL);
			SendDlgItemMessage(hDlg, CB_MBODY, EM_LIMITTEXT, 0, 0L);
			SendDlgItemMessage(hDlg, CB_TO, EM_LIMITTEXT, MAXNAMESLEN, NULL);
			SendDlgItemMessage(hDlg, CB_CC, EM_LIMITTEXT, MAXNAMESLEN, NULL);
			SendDlgItemMessage(hDlg, CB_BCC, EM_LIMITTEXT, MAXNAMESLEN, NULL);
			SendDlgItemMessage(hDlg, CB_SUBJECT, EM_LIMITTEXT, MAXSUBSTR, NULL);

			if (menuitem==IDM_COMPOSE) {
				/*** Get the folder name of the current folder ***/
				hFolder = GetFolder(GetWindow(GetWindow(hWnd, GW_CHILD), GW_CHILD));
				if (hFolder == 0) {
					BWCCMessageBox(hDlg, "No Folder Selected.", "WARNING!", MB_ICONSTOP | MB_OK);
					EndDialog(hDlg, TRUE);
					return (TRUE);
				}
				TempFolder = (MailFolder far *) GlobalLock(hFolder);
				lstrcpy((LPSTR) &FoldName, TempFolder->Name);
				GlobalUnlock(hFolder);
			}
			else {
				/*** Get the MessageID and folder name of the current letter ***/
				GetLetterInfo((LPSTR) &MsgID, (LPSTR) &FoldName, lParam >> 16, NULL);

				/*** Fill the Envelope structure.  ***/
				uStat=VnsGetMailEnvelope(hVNMAS, (LPSTR) &UserName, (LPSTR) &FoldName, (LPSTR) &MsgID, &MailEnv);
				if (Recover(uStat))
					uStat=VnsGetMailEnvelope(hVNMAS, (LPSTR) &UserName, (LPSTR) &FoldName, (LPSTR) &MsgID, &MailEnv);
				if(uStat){
					DspMsgCode( hWnd, "Unable to Read Mail Envelope: ", uStat, FALSE );
					EndDialog(hDlg, TRUE);
					return (TRUE);
				}
				lstrcpy(OldMsgID, MsgID);

				/*** Change Status on old message (UNREAD to READ) ***/
				if (menuitem != IDM_EDIT)
					ChangeUnread((LPSTR) &FoldName, (LPSTR) &MsgID);

			}

			/*** Pre-fill the fields of the dialog box ***/
			/*** i.e. the date, from, subject, etc...  ***/
			PreFillComposeBox(hDlg, menuitem, (LPSTR) &FoldName, (LPSTR) &MsgID, &MailEnv);


			/**** Store address of old Editproc and assign new Editproc ****/
			lpfnOldEdit = (FARPROC) GetWindowLong(GetDlgItem(hDlg, CB_MBODY), GWL_WNDPROC);
			if (lpfnOldEdit)
				SetWindowLong(GetDlgItem(hDlg, CB_MBODY), GWL_WNDPROC, (LONG) MakeProcInstance((FARPROC) EditProc, hInst));


			/*** Set the Menu. ***/
			SetMenu(hDlg, hMenuWrite);
			EnableMenuItem(hMenuWrite, IDM_ATTACH, MF_ENABLED | MF_BYCOMMAND);
			if (menuitem == IDM_FORWARD)
				EnableMenuItem(hMenuWrite, IDM_ATTACH, MF_GRAYED | MF_DISABLED | MF_BYCOMMAND);


			/*** Change font in Compose box ***/
			if (GetINIFont("ComposeFont", &lf)) {
				ChangeFont(&lf, GetDlgItem(hDlg, CB_MBODY));
			}

			/*** Pre-set the modify flag ***/
			modified = FALSE;


			/*** Initialize Date and Time fields. ***/
			SendDlgItemMessage(hDlg, CB_EXPTIME, VW_SETFIELDSTRING, 0, (LPARAM)(LPSTR)"@MASK(##:##)");
			SendDlgItemMessage(hDlg, CB_DEFTIME, VW_SETFIELDSTRING, 0, (LPARAM)(LPSTR)"@MASK(##:##)");
			return (TRUE);



		case WM_SIZE:
			/*** User is resizing dialog box, so stretch the affected controls. ***/
			if(wParam == SIZENORMAL || wParam == SIZEFULLSCREEN) {
				GetWindowRect(GetDlgItem(hDlg, CB_LINE1), (RECT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &Rect);
				MoveWindow(GetDlgItem(hDlg, CB_LINE1), Rect.left, Rect.top, (int) (LOWORD(lParam) - Rect.left), 1, TRUE);

				GetWindowRect(GetDlgItem(hDlg, CB_LINE2), (RECT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &Rect);
				MoveWindow(GetDlgItem(hDlg, CB_LINE2), 0, Rect.top, (int) LOWORD(lParam), 1, TRUE);

				GetWindowRect(GetDlgItem(hDlg, CB_MBODY), (RECT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &Rect);
				MoveWindow(GetDlgItem(hDlg, CB_MBODY), Rect.left, Rect.top, (int) LOWORD(lParam) - (Rect.left * 2), (int) (HIWORD(lParam) - Rect.top)-6, TRUE);

				GetWindowRect(GetDlgItem(hDlg, CB_MESSAGE), (RECT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &(Rect.right));
				MoveWindow(GetDlgItem(hDlg, CB_MESSAGE), Rect.left, Rect.top, (int) LOWORD(lParam) - (Rect.left * 2), Rect.bottom - Rect.top, TRUE);
			}

			break;

		case WM_MENUSELECT:
			/*** User is selecting a menu item with the mouse or keyboard.  ***/
			/*** Use the current menu item's control ID number to load the  ***/
			/*** correct status bar message string.   If the menu item      ***/
			/*** is a pop-up, there is no control ID number, so the text    ***/
			/*** of the menu item is used to determine which string to use. ***/
			if ((LOWORD(lParam)&MF_SYSMENU) || (LOWORD(lParam)&MF_SEPARATOR))
				break;

			buff[0] = '\0';
			HelpID = HELP_INDEXES;
			if (!(LOWORD(lParam) & MF_POPUP)) {
				LoadString(hInst, wParam, (LPSTR) &buff, 110);
				HelpID = wParam;
			}
			else {
				GetMenuString((HMENU) wParam, 0, (LPSTR) &buff, 110, MF_BYPOSITION);
				switch (buff[1]) {
					case 'u':
						LoadString(hInst, STR_EDIT, (LPSTR) &buff, 110);
						HelpID = STR_EDIT;
						break;
					case 'A':
						LoadString(hInst, STR_UTILITY2, (LPSTR) &buff, 110);
						HelpID = STR_UTILITY;
						break;
					case 'C':
						LoadString(hInst, STR_OPTIONS, (LPSTR) &buff, 110);
						HelpID = STR_OPTIONS;
						break;
					case 'I':
						LoadString(hInst, STR_HELP, (LPSTR) &buff, 110);
						HelpID = HELP_INDEXES;
						break;
					default:
						buff[0] = '\0';
						HelpID = HELP_INDEXES;
						break;
				}
			}
			if (hStatus)
				SendMessage(hStatus, STB_STRING, 0, (LONG) &buff);
			break;


		case WM_RBUTTONDBLCLK:
		case WM_NCRBUTTONDBLCLK:
			/*** Add support for the right button double click. ***/
			if (modified)
				PostMessage(hDlg, WM_COMMAND, IDM_OK, 0L);
			else
				PostMessage(hDlg, WM_COMMAND, IDCANCEL, 0L);
			return 0;


		case WM_COMMAND:
			/*** If an edit control gains the focus, store its ID and de-select the text. ***/
			if (HIWORD(lParam) == EN_SETFOCUS)
				controlID = wParam;

			/*** If any edit control is changed, set the modified flag. ***/
			if (HIWORD(lParam) == EN_CHANGE)
				modified = TRUE;

			switch(wParam) {

				case WM_KEYCTRLBACK:
					if (controlID == CB_MBODY) {
						hEdit = GetDlgItem(hDlg, CB_MBODY);
						dwResult = SendMessage(hEdit, EM_GETSEL, 0, 0L);
						line = SendMessage(hEdit, EM_LINEFROMCHAR, HIWORD(dwResult), 0L);
						*(WORD *) result = sizeof(result)-1;
						offset = SendMessage(hEdit, EM_GETLINE, line, (LPARAM) &result);
						result[offset] = '\0';
						linestart = SendMessage(hEdit, EM_LINEINDEX, line, 0L);
						index = HIWORD(dwResult) - linestart;
						for(i=index; i>0 && ((result[i]== ' ') || (result[i]=='\t')); i--);
						for(; i>0 && ((result[i]!= ' ') && (result[i]!='\t')); i--);
						SendMessage(hEdit, EM_SETSEL, 0, MAKELPARAM(linestart+i, HIWORD(dwResult)));
						SendMessage(hEdit, WM_CLEAR, 0, 0L);
					}
					break;

				case WM_KEYCTRL_T:
					if (controlID == CB_MBODY) {
						hEdit = GetDlgItem(hDlg, CB_MBODY);
						dwResult = SendMessage(hEdit, EM_GETSEL, 0, 0L);
						line = SendMessage(hEdit, EM_LINEFROMCHAR, HIWORD(dwResult), 0L);
						*(WORD *) result = sizeof(result)-1;
						offset = SendMessage(hEdit, EM_GETLINE, line, (LPARAM) &result);
						result[offset] = '\0';
						linestart = SendMessage(hEdit, EM_LINEINDEX, line, 0L);
						index = HIWORD(dwResult) - linestart;
						for(i=index; i<(lstrlen(result)) && ((result[i]!= ' ') && (result[i]!='\t')); i++);
						for(; i<(lstrlen(result)) && ((result[i]== ' ') || (result[i]=='\t')); i++);
						if (index == i) i++;
						SendMessage(hEdit, EM_SETSEL, 0, MAKELPARAM(linestart+i, HIWORD(dwResult)));
						SendMessage(hEdit, WM_CLEAR, 0, 0L);
					}
					break;

				case IDM_OK:
					/*** Change to HourGlass Cursor before starting ***/
					SetCursor(LoadCursor(NULL, IDC_WAIT));

					/*** User selected the OK button. ***/
					/**** Validate the TO: recipient list. ***/
					if (hStatus)
						SendMessage(hStatus, STB_STRING, 0, (LONG) "Checking Names ...");
					NullFill((LPSTR) &result, 1064);
					SendDlgItemMessage(hDlg, CB_TO, WM_GETTEXT, MAXNAMESLEN + 64, (long) &result);
					if (result[0] != '\0') {
						if (CheckNames((LPSTR) &result, GetDlgItem(hDlg, CB_TO), 0, (LPINT) &bytes) != 0)
							return(TRUE);
					}
					else {
						BWCCMessageBox(hDlg, "No Destination was Specified.", "WARNING!", MB_ICONSTOP | MB_OK);
						SetFocus(GetDlgItem(hDlg, CB_TO));
						return(TRUE);
					}

					/**** Validate the CC: recipient list. ***/
					NullFill((LPSTR) &result, 1064);
					SendDlgItemMessage(hDlg, CB_CC, WM_GETTEXT, MAXNAMESLEN+64, (long) &result);
					if (result[0] != '\0') {
						if (CheckNames((LPSTR) &result, GetDlgItem(hDlg, CB_CC), 0, (LPINT) &bytes) != 0)
							return(TRUE);
					}


					/**** Validate the BCC: recipient list. ***/
					NullFill((LPSTR) &result, 1064);
					SendDlgItemMessage(hDlg, CB_BCC, WM_GETTEXT, MAXNAMESLEN+64, (long) &result);
					if (result[0] != '\0') {
						if (CheckNames((LPSTR) &result, GetDlgItem(hDlg, CB_BCC), 0, (LPINT) &bytes) != 0)
							return(TRUE);
					}


					/**** Check attachments for valid file names and  ****/
					/**** fill in Body Parts list for attachments.    ****/
					if (menuitem != IDM_FORWARD) {
						if (hStatus)
							SendMessage(hStatus, STB_STRING, 0, (LONG) "Checking Attachments ...");
						NullFill((char far *)&Body, sizeof(BodyPart) * 11);
						Body[0].present=PRESENT;
						Body[0].bodypartId=MAINBODY;
						Body[0].contentType=FREETXT2;
						Body[0].label[0]=0x0;
						i = 1;
						NullFill((LPSTR) &result, 1500);
						SendDlgItemMessage(hDlg, CB_ATTACH, WM_GETTEXT, 1500, (long) &result);
						tempptr = (char far *) &result;
						while(*tempptr != '\0' && (i<11)) {
							Body[i].present=PRESENT;
							Body[i].bodypartId=MAINBODY+i;
							Body[i].contentType=UNDEFCONT;
							for(j=0; *tempptr != '\0' && (*tempptr != ',') && (j<128); j++, tempptr++)
								Body[i].label[j] = *tempptr;
							Body[i].label[j] = '\0';
							while(*tempptr != '\0' &&  *tempptr != ',') tempptr++;
							if ((fhandle = _lopen(Body[i].label, fmode)) == HFILE_ERROR) {
								offset = (int) tempptr - (int) result;
								BWCCMessageBox(hDlg, "\nUnable to open one\n\nof the attachments.", "WARNING!", MB_ICONSTOP | MB_OK);
								SendDlgItemMessage(hDlg, CB_ATTACH, EM_SETSEL, NULL, MAKELONG(offset - lstrlen((LPSTR) &Body[i].label),  offset));
								SetFocus(GetDlgItem(hDlg, CB_ATTACH));
								return(TRUE);
							}
							_lclose(fhandle);
							i++;
							while (*tempptr == ' ' || *tempptr == ',') tempptr++;
						}
						if (i <= 10)
							Body[i].present = NOTPRESENT;
					}


					/*** Store the message to Banyan folder, delete it ***
					/*** if necessary, and update the Folder windows.  ***/
					if (!SaveMessage(hDlg, Body, menuitem, (LPSTR) &FoldName, (LPSTR) &MsgID, (LPSTR) &OldMsgID))
						return(TRUE);

					/*** No break intentionally. ***/

				case IDCANCEL:
					/*** User selected Cancel button. ***/

					/*** Verify before closing dialog box.  (i.e. Changes will be lost.) ***/
					if (wParam == IDCANCEL) {
						if  (!Options.expertmode && modified) {
							if (CallDlg(hDlg, (FARPROC) AskChange, YesNoBox, 9L)) {
								SetFocus(GetDlgItem(hDlg, IDM_OK));
								SendMessage(hDlg, WM_COMMAND, IDM_OK, 0L);
								return TRUE;
							}
						}
					}


					/*** Release any allocated resources. ***/
					/*** Delete the font resource. ***/
					if ((hFont = (HFONT) SendDlgItemMessage(hDlg, CB_MBODY, WM_GETFONT, 0, 0L))!=0) {
						SendDlgItemMessage(hDlg, CB_MBODY, WM_SETFONT, 0, 0L);
						DeleteObject(hFont);
					}

					/*** Reset the Menu. ***/
					SetMenu(hDlg, NULL);

					EndDialog(hDlg, TRUE);
					return (TRUE);

				case IDM_ATTACH:
					/*** User selected the Attach Files button (or menu item). ***/
					if (menuitem != IDM_FORWARD) {
						FileOpen(hDlg);
						SetFocus(GetDlgItem(hDlg, CB_ATTACH));
					}
					break;

				case HELP_HELP:
					/*** User selected Using Help from the Help Menu. ***/
					WinHelp(hWnd, NULL, HELP_HELPONHELP, NULL);
					return 0;

				case HELP_INDEXES:
				case HELP_MENUS:
				case HELP_GLOSSARY:
				case HELP_PROCEDURES:
				case HELP_FIELDS:
					/*** User selected one of the above items from the Help Menu. ***/
					WinHelp(hWnd, "HMHELP.HLP", HELP_CONTEXT, (long) wParam);
					return 0;

				case IDM_ABOUT:
					/*** User selected About HappyMail from the Help menu. ***/
					CallDlg(hDlg, (FARPROC) About, AboutBox, NULL);
					break;

				case IDM_LOGO:
					/*** User selected Logo from the Help Menu. ***/
					CallDlg(hDlg, Logo, SplashBox, NULL);
					return 0;


				case IDM_SIGN:
					/*** User selected the Sign button. ***/

					/*** Allocate enough memory to store the contents ***/
					/*** of the Message and the new signature.        ***/
					lBytes = MAKELONG(SendDlgItemMessage(hDlg, CB_MBODY, WM_GETTEXTLENGTH, 0, 0L)+1, 0);
					if ((lBytes + lstrlen((LPSTR) &Options.sign)) > MAXMSGBODY) {
						BWCCMessageBox(hDlg, "Sorry.\n\nNot enough room\n to add signature.", "WARNING!", MB_ICONSTOP | MB_OK);
						SetFocus(GetDlgItem(hDlg, CB_MBODY));
						break;
					}
					if ((hEditText = SafeAlloc(GLOBAL, lBytes + MAX_SIGN, hDlg)) == NULL) {
						return TRUE;
					}
					tempptr = GlobalLock(hEditText);

					/*** Get a pointer to the Edit control text. ***/
					SendDlgItemMessage(hDlg, CB_MBODY, WM_GETTEXT, (unsigned int) lBytes, (LPARAM) tempptr);

					/*** Append the Closing Signature. ***/
					lstrcat(tempptr, (LPSTR) &Options.sign);

					/*** Reset the Edit control Text to the new buffer. ***/
					SetDlgItemText(hDlg, CB_MBODY, tempptr);
					SafeFree(GLOBAL, hEditText);
					SetFocus(GetDlgItem(hDlg, CB_MBODY));
					break;

				case IDM_ADDRESS:
					/*** User selected the Address Book button (or menu item). ***/
					if (CallDlg(hDlg, AddressBk, AddressBox, (long) result))
						break;

					/*** If the user selected an addressbook       ***/
					/*** entry, continue on to the IDM_NAMES code. ***/

				case IDM_NAMES:
					/*** User selected StreetTalk Names button (or menu item). ***/
					if (wParam == IDM_NAMES) {
						/*** Call the Vines supplied StreetTalk dialog box.  This box ***/
						/*** will return a list of names seperated with CR-LF pairs.  ***/
						NullFill((LPSTR) &result, MAXNAMESLEN);
						if (hSTDA)
							VnsDlgStdaMultiSelect(hSTDA, hDlg, STDATYPE_USER | STDATYPE_LIST | STDATYPE_NICKNAME, "Send Mail To", "Selected Recipients:", &confirmed, (LPSTR) &result, MAXNAMESLEN);
						else {
							BWCCMessageBox(hDlg, "No STDA Service is available.", "HappyMail", MB_ICONHAND);
							return TRUE;
						}

					}


					/*** An empty string indicates no names were selected. ***/
					if (result[0] != 0) {
						/*** Ask the user which recipient class to   ***/
						/*** copy the names to. (TO:, CC:, or BCC:). ***/
						destination = (WORD) CallDlg(hDlg, (FARPROC) ChooseTo, ChooseBox, controlID);
						switch (destination) {
							case 1:
								index = CB_TO;
								break;
							case 2:
								index = CB_CC;
								break;
							case 3:
								index = CB_BCC;
								break;
						} /*** end switch(destination) ***/

						/*** Check for enough space in control. ***/
						bytes = SendDlgItemMessage(hDlg, index, EM_LINELENGTH, 0, 0L);
						bytes =  (MAXNAMESLEN < bytes) ? 0 : (MAXNAMESLEN - bytes);
						if ( lstrlen((LPSTR) &result) > bytes) {
							wsprintf((LPSTR) &buff, "\nToo many addresses!\n\n Only %u character(s) remain.", (unsigned int) bytes);
							BWCCMessageBox(hDlg, (LPSTR) &buff, "WARNING!", MB_ICONSTOP | MB_OK);
							return TRUE;
						}

						/*** Replace CR-LF pairs with commas. ***/
						for(i=0; i < (MAXNAMESLEN-1); i++) {
							if ((result[i] == 13 && result[i+1] == 10) || (result[i] == 10 && result[i+1] == 13)) {
								result[i]   = 44;
								result[i+1] = 32;
							}
							if (result[i] == 13 || result[i] == 10) result[i] = 44;
						}

						/*** If the Edit control is not empty, append the new  ***/
						/*** names. Else, simply copy the names to the control. ***/
						if (SendDlgItemMessage(hDlg, index, EM_LINELENGTH, 0, 0L)) {
							/*** Grab the memory for a temporary buffer. ***/
							if ((hBody = SafeAlloc(GLOBAL, MAXNAMESLEN, hDlg)) == NULL) {
								return TRUE;
							}
							text  = GlobalLock(hBody);

							/*** Copy the Edit control's text to the temporary buffer. ***/
							SendDlgItemMessage(hDlg, index, WM_GETTEXT, MAXNAMESLEN, (LPARAM) text);

							/*** Append the new names to the temporary buffer. ***/
							lstrcat(text, ", ");
							lstrcat(text, (LPSTR) &result);

							/*** Copy the temporary buffer to the Edit control. ***/
							SetDlgItemText(hDlg, index, text);
							SafeFree(GLOBAL, hBody);
						}
						else
							SetDlgItemText(hDlg, index, (LPSTR) &result);

						SetFocus(GetDlgItem(hDlg, index));
					}
					return (TRUE);


				case IDM_CUT:
					/*** User has selected Cut from the Edit Menu. ***/
					SendDlgItemMessage(hDlg, controlID, WM_CUT, 0, 0L);
					return TRUE;

				case IDM_COPY:
					/*** User has selected Copy from the Edit menu. ***/
					SendDlgItemMessage(hDlg, controlID, WM_COPY, 0, 0L);
					return TRUE;

				case IDM_PASTE:
					/*** User has selected Paste from the Edit menu. ***/
					SendDlgItemMessage(hDlg, controlID, WM_PASTE, 0, 0L);
					return TRUE;

				case IDM_CBDELETE:
					/*** User has selected Delete from the Edit menu. ***/
					SendDlgItemMessage(hDlg, controlID, WM_CLEAR, 0, 0L);
					return TRUE;

				case IDM_UNDO:
					/*** User has selected Undo from the Edit menu. ***/
					SendDlgItemMessage(hDlg, controlID, WM_UNDO, 0, 0L);
					return TRUE;

				case IDM_COMPOSEOPT:
					/*** Change to HourGlass Cursor before starting. ***/
					SetCursor(LoadCursor(NULL, IDC_WAIT));
					CallDlg(hDlg, ComposeOptions, ComposeOptBox, hDlg);
					return 0;

				case IDM_FOLDEROPT:
					/*** Change to HourGlass Cursor before starting. ***/
					SetCursor(LoadCursor(NULL, IDC_WAIT));
					CallDlg(hDlg, FolderOptions, FolderOptBox, 0L);
					return 0;

				case IDM_GENERALOPT:
					/*** Change to HourGlass Cursor before starting. ***/
					SetCursor(LoadCursor(NULL, IDC_WAIT));
					CallDlg(hDlg, GeneralOptions, GeneralOptBox, 0L);
					return 0;

				case IDM_PRINTOPT:
					/*** Change to HourGlass Cursor before starting. ***/
					SetCursor(LoadCursor(NULL, IDC_WAIT));
					CallDlg(hDlg, PrintOptions, PrintOptBox, 0L);
					return 0;

				case IDM_READOPT:
					/*** Change to HourGlass Cursor before starting. ***/
					SetCursor(LoadCursor(NULL, IDC_WAIT));
					CallDlg(hDlg, ReadOptions, ReadOptBox, 0L);
					return 0;


				case IDM_IMPORT:
					/*** User has selected the Import Files button (or menu item). ***/
					/*** Retrieve a file name using the OpenFile common dialog box. ***/
					hFile = ImportFile(hDlg);

					if (hFile != NULL) {
						/*** Open the file. ***/
						filename = GlobalLock(hFile);
						fhandle = _lopen((char far *) filename, fmode);
						SafeFree(GLOBAL, hFile);
						if (fhandle == HFILE_ERROR){
							BWCCMessageBox(hDlg, "Unable to Open File.", "WARNING!", MB_ICONSTOP | MB_OK);
						}
						else {
							/*** Check if file length > MAXBODY before continuing. ***/
							/*** If continuing, load only first part of the file.  ***/
							offset=0;
							lBytes = fsize(fhandle);
							textbytes = (unsigned) SendDlgItemMessage(hDlg, CB_MBODY, WM_GETTEXTLENGTH, 0, 0L)+1;
							if ((lBytes > (unsigned long) (MAXMSGBODY - textbytes)) || (lBytes == 0L))
								if (!CallDlg(hDlg, (FARPROC) AskChange, YesNoBox, 10L)) {
									_lclose(fhandle);
									return TRUE;
								}

							/*** Allocate enough memory to store the message contents. ***/
							if ((hEditText = SafeAlloc(GLOBAL, textbytes, hDlg)) == NULL) {
								return TRUE;
							}
							tempptr = GlobalLock(hEditText);

							/*** Get a pointer to the Edit control text. ***/
							SendDlgItemMessage(hDlg, CB_MBODY, WM_GETTEXT, (unsigned)textbytes, (LPARAM) tempptr);


							/*** Allocate a temporary buffer. ***/
							if ((hBody = SafeAlloc(GLOBAL, MAXMSGBODY, hDlg)) == NULL) {
								_lclose(fhandle);
								return TRUE;
							}
							text  = (char far *) GlobalLock(hBody);


							/*** Get the position of the selected text in the buffer. ***/
							zone = SendDlgItemMessage(hDlg, CB_MBODY, EM_GETSEL, 0, 0L);
							offset = LOWORD(zone);

							/*** Copy the text before the selected ***/
							/*** text to the temporary buffer.     ***/
							lstrncpy(text, tempptr, (unsigned) offset);
							lBytes = (unsigned long) (MAXMSGBODY - textbytes - 1L);

							/*** Append the import file to the temporary buffer. If the  ***/
							/*** file contains embedded NULLS, verify before continuing. ***/
							textbytes = _lread(fhandle, (text + (unsigned)offset), (unsigned int) lBytes);
							if (textbytes < lBytes)
								textbytes -= 1;
							textbytes += (unsigned long) offset;
							text[textbytes] = '\0';
							BadFile = FALSE;

							/*** Scan for embedded NULLs. ***/
							while ((offset < ((unsigned)textbytes-1)) && !BadFile)
								if (text[offset++] == 0 )
									BadFile = TRUE;

							/*** Found some Nulls. Verify the Copy. ***/
							if (BadFile)
								if (CallDlg(hDlg, (FARPROC) AskChange, YesNoBox, 7L))
									BadFile = FALSE;


							if (!BadFile) {
								/*** Append the original edit text after the selected text ***/
								tempptr += (unsigned) HIWORD(zone);
								lstrcat(text, tempptr);
								text[MAXMSGBODY-1] = '\0';
								/*** Reset the Edit window Text ***/
								SetDlgItemText(hDlg, CB_MBODY, (LPSTR) text);
							}
							else
								/*** Discontinued the import so just return the focus to the control. ***/
								SetFocus(GetDlgItem(hDlg, CB_MBODY));

							/*** Resource clean up. ***/
							SafeFree(GLOBAL, hEditText);
							SafeFree(GLOBAL, hBody);
							_lclose(fhandle);

						}
					}
					SetFocus(GetDlgItem(hDlg, CB_MBODY));
					return TRUE;

			} /** end switch (wParam) **/
			break;
	} /* end switch (message) */
	return (FALSE);               /* Didn't process a message    */
}



/******************************************************************************
	FUNCTION:	FillAttach()

	PURPOSE:	To pre-fill the attachment field in the Compose Dialog box
*******************************************************************************/
BOOL FillAttach(HWND hDlg, WORD menuitem, char far *MsgID)
{

	CallStatus		uStat;
	short           retcount, i;
	BodyPart 		Body[11];
	char            result[1024];


	switch (menuitem) {
		case IDM_FORWARD:
		case IDM_EDIT:
			/*** Copy the Attachment names to the ATTACHED field ***/
			NullFill((char far *)&Body, sizeof(BodyPart) * 11);
			uStat=VnsGetMailBodyPartList(hVNMAS, MsgID, Body, (unsigned short far *)&retcount);
			if (Recover(uStat))
				uStat=VnsGetMailBodyPartList(hVNMAS, MsgID, Body, (unsigned short far *)&retcount);
			if(uStat)
				return (TRUE);

			result[0] = '\0';
			for (i=1;i<=10 && Body[i].present == PRESENT;i++) {
				lstrcat(result, Body[i].label);
				if (i<10 && Body[i+1].present == PRESENT) lstrcat(result, ", ");
			}
			SetDlgItemText(hDlg, CB_ATTACH, result);
			break;

		case IDM_QUOTE:
		case IDM_QUOTEALL:
		case IDM_ANSWER:
		case IDM_ANSALL:
		case IDM_COMPOSE:
			break;
	}

	return FALSE;
}

/******************************************************************************
	FUNCTION:	FillBody()

	PURPOSE:	To pre-fill the attachment field in the Compose Dialog box
*******************************************************************************/
BOOL FillBody(HWND hDlg, WORD menuitem, char far *FoldName, char far *MsgID, Env far *MailEnv)
{

	CallStatus		uStat;
	GLOBALHANDLE	hBody, hBody2;
	char far 		*text, date_str[128], buff[512], far *text2;
	RECT			Rect;
	HFONT			hFont;
	long			bytes, i, bytecnt, prefixlen, linecnt, maxsize;
	HWND			hEdit;
	GLOBALHANDLE	hEditDS;

	switch (menuitem) {
		case IDM_FORWARD:
		case IDM_ANSWER:
		case IDM_ANSALL:
		case IDM_COMPOSE:
			break;
		case IDM_EDIT:
			if ((hBody = SafeAlloc(GLOBAL, MAXMSGBODY, hDlg)) == NULL)
				return (TRUE);

			FormatBody(FoldName, MsgID, hBody, MAXMSGBODY);
			text = (char far *) GlobalLock(hBody);
			SetDlgItemText(hDlg, CB_MBODY, text);
			SafeFree(GLOBAL, hBody);
			break;

		case IDM_QUOTE:
		case IDM_QUOTEALL:

			/*** Grab enough memory for a Mail Msg. ***/
			if ((hBody = SafeAlloc(GLOBAL, MAXMSGBODY, hDlg)) == NULL)
				return (TRUE);

			/*** Grab enough memory for a Mail Msg. ***/
			if ((hBody2 = SafeAlloc(GLOBAL, MAXMSGBODY, hDlg)) == NULL)
				return (TRUE);

			FormatBody(FoldName, MsgID, hBody, MAXMSGBODY);
			text = GlobalLock(hBody);
			text2 = GlobalLock(hBody2);

			/*** Reformat the original text, inserting the ***/
			/*** prefix string at the start of each line.  ***/
			if (Options.useprefix) {
				/*** Create a temporary edit window for processing. ***/
				hEditDS = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT | GMEM_SHARE, 256L);
				if (hEditDS == NULL) {
					hEditDS = hInst;  // Allocation failed; use default.
				}
				hEdit = CreateWindow("edit", "", WS_CHILD | ES_MULTILINE, 0, 0, 200,
										200, hWnd, PB_EDIT, hEditDS, NULL);
				SendMessage(hEdit, EM_LIMITTEXT, 0, 0L);
				SetWindowText(hEdit, text);
				SendMessage(hEdit, EM_FMTLINES, FALSE, 0L);

				/*** Create the header string (ie On date x, so&so said:) ***/
				buff[0] = '\0';
				VnsGetMailMsgTimeStr(hVNMAS, (LPSTR) &UserName, MsgID, (LPSTR) &date_str);
				wsprintf((LPSTR) &buff, "On %s,\r\012%s wrote:\r\012", (LPSTR) &date_str, (LPSTR) MailEnv->from);
				lstrcpy(text, buff);

				/*** Initialize some variables. ***/
				maxsize = MAXMSGBODY - Options.linelength - 2;
				prefixlen = lstrlen((LPSTR) &Options.prefix);
				ResizeWindow(hEdit, Options.linelength - prefixlen, &Rect, &hFont);
				linecnt = SendMessage(hEdit, EM_GETLINECOUNT, 0, 0L);

				/*** Display Status Message. ***/
				if (hStatus)
					SendMessage(hStatus, STB_STRING, 0, (LONG) "Reformating Original Message ...");

				/*** Grab a line at a time and add the prefix and a CR-LF. ***/
				for(bytecnt=i=0; (i<linecnt) && (bytecnt < maxsize); i++){
					*(WORD *) buff = sizeof(buff) - 1;
					bytes = SendMessage(hEdit, EM_GETLINE, i, (LPARAM)(LPSTR) &buff);
					buff[bytes] = '\0';
					bytecnt += bytes + prefixlen + 2;
					lstrcat(text, (LPSTR) &Options.prefix);
					lstrcat(text, (LPSTR) &buff);
					lstrcat(text, (LPSTR) "\r\012");
				}

				/*** Free up resources. ***/
				DestroyWindow(hEdit);
				SafeFree(GLOBAL, hEditDS);
			}


			/*** Add a Header and footer to the original message text. ***/
			if (Options.useheader) {
				lstrcpy(text2, "\r\012- - - - - - - - - - - - - - Original Message - - - - - - - - - - - - - -\r\012");
				lstrcat(text2, text);
				lstrcat(text2, "\r\012- - - - - - - - - - - - End of Original Message - - - - - - - - - - - -\r\012");
			}
			else
				lstrcpy(text2, text);

			SetDlgItemText(hDlg, CB_MBODY, text2);
			SafeFree(GLOBAL, hBody);
			SafeFree(GLOBAL, hBody2);
			break;

	}

	return FALSE;
}



/******************************************************************************
	FUNCTION:	FillRecipients()

	PURPOSE:	To pre-fill the recipient fields in the Compose Dialog box
*******************************************************************************/
BOOL FillRecipients(HWND hDlg, WORD menuitem, char far *MsgID, Env far *MailEnv)
{

	char result[1024];

	switch (menuitem) {
		case IDM_FORWARD:
		case IDM_COMPOSE:
			break;

		case IDM_EDIT:
		case IDM_QUOTEALL:
		case IDM_ANSALL:
			/*** Presdt the CC: and BCC: fields. ***/
			result[0] = '\0';
			ReadRecipients(NULL, RECIPIENTCC, (LPSTR) &result, MsgID, NULL, NULL);
			SetDlgItemText(hDlg, CB_CC, (LPSTR) &result);

			result[0] = '\0';
			ReadRecipients(NULL, RECIPIENTBCC, (LPSTR) &result, MsgID, NULL, NULL);
			SetDlgItemText(hDlg, CB_BCC, (LPSTR) &result);

			/*** No break intentional. ***/

		case IDM_QUOTE:
		case IDM_ANSWER:
			/*** Pre-set the To: field ***/
			result[0] = '\0';
			if (menuitem != IDM_EDIT) {
				if (MailEnv->replyTo[0] != '\0')
					lstrcpy((LPSTR) &result, MailEnv->replyTo);
				else if (MailEnv->forwarder[0] != '\0')
					lstrcpy((LPSTR) &result, MailEnv->forwarder);
				else {
					lstrcpy((LPSTR) &result, MailEnv->from);
				}
				if ((menuitem == IDM_QUOTEALL) || (menuitem == IDM_ANSALL)) {
					/*** Spin through the names list for the TO: field ***/
					lstrcat((LPSTR) &result, ", ");
					ReadRecipients(NULL, RECIPIENTTO, (LPSTR) &result, MsgID, NULL, NULL);
				}
			}
			else
				ReadRecipients(NULL, RECIPIENTTO, (LPSTR) &result, MsgID, NULL, NULL);

			SetDlgItemText(hDlg, CB_TO, (LPSTR) &result);

			break;
	}
	return FALSE;
}


/******************************************************************************
	FUNCTION:	FillSubject()

	PURPOSE:	To pre-fill the subject field in the Compose Dialog box
*******************************************************************************/
BOOL FillSubject(HWND hDlg, WORD menuitem, Env far *MailEnv)
{
	char result[512];

	result[0] = '\0';
	switch (menuitem) {
		case IDM_COMPOSE:
			return FALSE;
		case IDM_EDIT:
			break;

		case IDM_FORWARD:
			lstrcpy((LPSTR) &result, "Fwd: ");
			break;

		case IDM_QUOTE:
		case IDM_QUOTEALL:
		case IDM_ANSWER:
		case IDM_ANSALL:
			lstrcpy((LPSTR) &result, "re: ");
			break;
	}
	lstrcat((LPSTR) &result, MailEnv->subject);
	SetDlgItemText(hDlg, CB_SUBJECT, (LPSTR) &result);

	return FALSE;

}


/******************************************************************************
	FUNCTION:	PreFillComposeBox()

	PURPOSE:	To pre-fill the edit controls of the Compose Dialog box with
				values from the current mail message.
*******************************************************************************/
PreFillComposeBox(HWND hDlg, WORD menuitem, char far *FoldName, char far *MsgID, Env far *MailEnv)
{

	char            date_str[50], buff[128];
	BOOL			error;


	/*** Fill the subject, attach, and recipient field. ***/
	error  = FillAttach(hDlg, menuitem, MsgID);
	if (!error) error = FillRecipients(hDlg, menuitem, MsgID, MailEnv);
	if (!error) error = FillSubject(hDlg, menuitem, MailEnv);
	if (!error) error = FillBody(hDlg, menuitem, FoldName, MsgID, MailEnv);

	if (error) {
		VnsReleaseMailEnvelope(hVNMAS, MsgID);
		EndDialog(hDlg, TRUE);
		return (TRUE);
	}

	/*** Fill in Certify field. ***/
	if (Options.certify) SendDlgItemMessage(hDlg, CB_CERTIFY, BM_SETCHECK, 1, 0L);

	/*** Set the priority field. ***/
	switch (UserCaps.priority) {
		case LOW_PRIORITY:
			EnableWindow(GetDlgItem(hDlg, CB_MED), FALSE);
			EnableWindow(GetDlgItem(hDlg, CB_HIGH), FALSE);
			SendDlgItemMessage(hDlg, CB_LOW, BM_SETCHECK, 1, 0L);
			break;
		case MED_PRIORITY:
			EnableWindow(GetDlgItem(hDlg, CB_HIGH), FALSE);
		case HIGH_PRIORITY:
			SendDlgItemMessage(hDlg, CB_MED, BM_SETCHECK, 1, 0L);
	}


	switch (menuitem) {
		case IDM_FORWARD:
			/*** Disable controls that forward don't use. ***/
			EnableWindow(GetDlgItem(hDlg, CB_ATTACH), FALSE);
			EnableWindow(GetDlgItem(hDlg, CB_SUBJECT), FALSE);
			EnableWindow(GetDlgItem(hDlg, IDM_ATTACH), FALSE);

			/**** Change the Window's Title Bar. ***/
			SendMessage(hDlg, WM_SETTEXT, NULL, (LONG) "Forward");
			break;

		case IDM_ANSALL :
		case IDM_QUOTEALL:
		case IDM_QUOTE:
		case IDM_ANSWER :

			SendMessage(hDlg, WM_SETTEXT, NULL, (LONG) "Reply");
			SetFocus(GetDlgItem(hDlg, CB_CC));
			break;


		case IDM_EDIT:
			/*** Fill the certify and priority field ***/
			if (MailEnv->certified == MESCONFIRM)
				SendDlgItemMessage(hDlg, CB_CERTIFY, BM_SETCHECK, 1, 0L);
			if (MailEnv->priority == LOW_PRIORITY)
				SendDlgItemMessage(hDlg, CB_LOW, BM_SETCHECK, 1, 0L);
			else if (MailEnv->priority == HIGH_PRIORITY)
				SendDlgItemMessage(hDlg, CB_HIGH, BM_SETCHECK, 1, 0L);
			else
				SendDlgItemMessage(hDlg, CB_MED, BM_SETCHECK, 1, 0L);

			break;

	} /*** end switch (menuitem) ***/


	VnsReleaseMailEnvelope(hVNMAS, MsgID);
	return (TRUE);
}

