/****************************************************************************
	FILE:		view.c


	CONTENTS:   ViewFile()		window procedure for View Attachments dialog
								box.
				PrintAttach()   Uses PrintWindow function to print the attachment
								currently being viewed.

	COMMENTS:	This file contains all the procedure(s) used in viewing
				files attached to Banyan mail messages.
****************************************************************************/
#include "MyMail.h"
#include "string.h"
#include "io.h"
#include "commdlg.h"

extern BOOL	PrintWindow( PRINTDLG, HWND );

/******************************************************************************
	FUNCTION: 	ViewFile()

	PURPOSE:  	Dialog Box procedure for View Attachments Window.
*******************************************************************************/
BOOL FAR PASCAL _export ViewFile(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
	char 					Buff[1025];
	int 					RetCount, fhandle;
	Env						env;
	unsigned short			bytes, offset;
	GLOBALHANDLE			hBody;
	LOGFONT					lf;
	static HWND				eHnd;
	RECT					Rect;
	static Attach_Rec far 	*aRec;



	/*** Send Window Messages to Status Bar ***/
	StatBarCtrlMsg(hDlg, ViewBox, message, wParam, lParam);

	switch (message) {
		case WM_INITDIALOG:        /* message: initialize dialog box */

			/*** Center the Dialog Window in the HappyMail Main window ***/
			CenterWindow(hDlg, GetDesktopWindow());

			/***** Get the Message ID and Folder Name for the Current Message ***/
			aRec = (Attach_Rec far *) lParam;

			/*** Store the Edit windows handle for future reference. ***/
			eHnd = GetDlgItem(hDlg, VB_EDIT);


			/*** Change font in Edit box ***/
			SendMessage(eHnd, WM_SETFONT, GetStockObject(SYSTEM_FIXED_FONT), NULL);
			if (GetINIFont("ViewFont", &lf)) {
				ChangeFont(&lf, eHnd);
			}

			/*** Send the VB_VIEW command to read the attachment from the temporary file. ***/
			SendMessage(hDlg, WM_COMMAND, VB_VIEW, 0L);
			return (TRUE);

		case WM_SIZE:
			/*** User is resizing the View dialog box, so    ***/
			/*** resize the controls to match the new shape. ***/
			if(wParam == SIZENORMAL || wParam == SIZEFULLSCREEN) {
				GetWindowRect(GetDlgItem(hDlg, VB_LINE), (RECT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &Rect);
				MoveWindow(GetDlgItem(hDlg, VB_LINE), 0, Rect.top, (int) LOWORD(lParam), 1, TRUE);

				GetWindowRect(eHnd, (RECT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &Rect);
				MoveWindow(eHnd, Rect.left, Rect.top, (int) LOWORD(lParam) - (Rect.left * 2), (int) (HIWORD(lParam) - Rect.top)-6, TRUE);

				GetWindowRect(GetDlgItem(hDlg, VB_TITLE), (RECT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &Rect);
				ScreenToClient(hDlg, (POINT far *) &(Rect.right));
				MoveWindow(GetDlgItem(hDlg, VB_TITLE), Rect.left, Rect.top, (int) LOWORD(lParam) - (Rect.left * 2), (Rect.bottom - Rect.top), TRUE);
			}
			break;

		case WM_SYSCOMMAND:
			/*** User selected Close from the Sytem Menu. ***/
			if ((wParam & 0xFFF0) == SC_CLOSE) {
				EndDialog(hDlg, TRUE);
				return (TRUE);
			}
			break;
		case WM_COMMAND:
			switch (wParam) {

				case VB_PRINT:
					/*** User wants to print the window contents. ***/

					/*** Check for an empty edit window before proceeding. ***/
					if (SendMessage(eHnd, EM_GETLINECOUNT,0,0L)==0) {
						BWCCMessageBox(hDlg, "Window is Empty.\nSelect &View Attachment\nbefore printing.", "WARNING!", MB_ICONSTOP | MB_OK);
						return (TRUE);
					}

					/*** Update Status bar. ***/
					if (hStatus)
						SendMessage(hStatus, STB_STRING, 0, (LONG)"Printing Current Attachment...");
					PrintAttach(eHnd, hDlg);
					break;


				case VB_VIEW:
					/*** Update Status bar. ***/
					if (hStatus)
						SendMessage(hStatus, STB_STRING, 0, (LONG)"Reading Attachment File...");

					/*** Change to HourGlass Cursor before starting ***/
					SetCursor(LoadCursor(NULL, IDC_WAIT));

					/*** Clear old edit control of text. ***/
					SendMessage(eHnd, EM_SETSEL, 0, MAKELPARAM(0, -1));
					SendMessage(eHnd, WM_CLEAR, 0, 0L);
					SendMessage(eHnd, EM_SETSEL, 1, 0L);
					SetWindowLong(eHnd, GWL_STYLE, GetWindowLong(eHnd, GWL_STYLE)&WS_INVISIBLE);

					/*** Open the temporary file. ***/
					FileType = TEXT;
					fhandle = _lopen((char far *) aRec->FileName, READ_WRITE);
					if (fhandle == HFILE_ERROR){
						BWCCMessageBox(hDlg, "Unable to Open File.", "WARNING!", MB_ICONSTOP | MB_OK);
						return TRUE;
					}


					/*** If the file is straight text, just read it in. ***/
					if (FileType == TEXT) {
						bytes = 0;
						RetCount = 0;
						do {
							bytes = _lread(fhandle, &Buff, (WORD) 1024);
							Buff[bytes] = '\0';
							SendMessage(eHnd, EM_REPLACESEL, 0, (long) (char far *)&Buff);
							RetCount += bytes;
							SendMessage(eHnd, EM_SETSEL, 1, MAKELPARAM(RetCount, RetCount));
						} while (bytes > 0);
					}


					/*** Close the temporary file ***/
					_lclose(fhandle);

					/*** Make Edit window Visible again. ***/
					ShowWindow(eHnd, SW_SHOWNORMAL);

					/*** Update Status bar. ***/
					if (hStatus)
						SendMessage(hStatus, STB_STRING, 0, 0L);

					return (TRUE);


				case IDCANCEL:
                    /*** User select Exit button. ***/
					EndDialog(hDlg, TRUE);
					return (TRUE);


			} /** end switch(wParam) **/
			break;
	} /* end switch (message) */
	return (FALSE);               

}


/****************************************************************************
	FUNCTION:	PrintAttach()

	PURPOSE:	Prints the contents of an edit window (an attachment).

	COMMENTS:	This procedure does some simple initializations, then calls
				the common dialog Print box and finally calls PrintWindow()
				for the actual printing chores.
****************************************************************************/
PrintAttach(HWND hEdit, HWND hDlg)
{

	unsigned int 	tabset[1];
	PRINTDLG		pd;
	char			buff[81];
	char 			szMsg[50];
	BOOL			bError = FALSE;
	FARPROC			lpfnAbortProc, lpfnPrintCancel;
	unsigned int 	i, copy;
	HFONT			hOldFont, hFont, hEditFont;
	RECT			Rect, Oldrect;
	DWORD			tSize;
	HDC				hDC;
	unsigned int 	ScreenAspect, PrinterAspect;
	LOGFONT			lfPrint;
	DOCINFO			DI;


	/*** Initialize the PRINTDLG structure ***/
	NullFill((LPSTR) &pd, sizeof(PRINTDLG));
	pd.lStructSize = sizeof(PRINTDLG);
	pd.hwndOwner   = hWnd;
	pd.Flags = PD_RETURNDC;

	/*** Call the Print common dialog box. ***/
	if (PrintDlg(&pd)) {
		/*** User OK'ed the print action. ***/

		/*** Check for invalid Device context. ***/
		if (pd.hDC == NULL) {
			BWCCMessageBox(hWnd, "Not enough memory\nto access printer.", "HappyMail Print", MB_ICONHAND);
			return FALSE;
		}


		/*** Change the Printer's font, & the edit windows font and size. ***/
		GetWindowRect(hEdit, (LPRECT) &Oldrect);
		ScreenToClient(hDlg, (LPPOINT) &Oldrect);
		ScreenToClient(hDlg, (LPPOINT) &Oldrect.right);
		SendMessage(hEdit, EM_GETRECT, 0, (LPARAM) (RECT far *) &Rect);
		SendMessage(hEdit, EM_FMTLINES, FALSE, 0L);
		hDC = GetDC(hEdit);
		ScreenAspect=GetDeviceCaps(hDC, LOGPIXELSY);
		ReleaseDC(hEdit, hDC);
		SetWindowLong(hEdit, GWL_STYLE, GetWindowLong(hEdit, GWL_STYLE)&WS_INVISIBLE);
		PrinterAspect = GetDeviceCaps(pd.hDC, LOGPIXELSY);
		Rect.left = Rect.top = 0;
		Rect.right = GetDeviceCaps(pd.hDC, HORZRES) - (PrinterAspect/2);
		SendMessage(hEdit, EM_SETRECT, 0, (LPARAM) (RECT far *) &Rect);
		MoveWindow(hEdit, 0, 0, Rect.right, Rect.bottom, TRUE);
		GetINIFont("PrintFont", &lfPrint);
		lfPrint.lfHeight = (signed int) ((long)((long) lfPrint.lfHeight * (long)PrinterAspect)/(long)ScreenAspect);
		hFont = CreateFontIndirect(&lfPrint);
		hOldFont = SelectObject(pd.hDC, hFont);
		hEditFont = SendMessage(hEdit, WM_SETFONT, hFont, NULL);


		/*** Create a Bar Graf dialog box to illustrate the progress of our printing. ***/
		bUserAbort = FALSE;
		lpfnPrintCancel = MakeProcInstance(BarGraf, hInst);
		hDlgCancel = CreateDialog(hInst, MAKEINTRESOURCE(BarGrafBox), hWnd, lpfnPrintCancel);
		lstrcpy((LPSTR) &szMsg,"Now Printing Window");
		SendMessage(hDlgCancel, WM_SETTEXT, NULL, (LONG) &szMsg);


		/*** Set the Abort procedure to run while spooling to the printer. ***/
		lpfnAbortProc = MakeProcInstance(AbortProc, hInst);
		if (SetAbortProc(pd.hDC, (ABORTPROC) lpfnAbortProc) < 0) {
			BWCCMessageBox(hDlg, "Error starting print job.", "Error", MB_ICONSTOP);
			/*** Free up the resources. ***/
			DestroyWindow(hDlgCancel);
			hDlgCancel = NULL;
			FreeProcInstance(lpfnAbortProc);
			FreeProcInstance(lpfnPrintCancel);
			DeleteObject(SelectObject(pd.hDC, hOldFont));
			DeleteDC(pd.hDC);

			/*** Restore the Edit window to the proper dimensions and font. ***/
			SendMessage(hEdit, WM_SETFONT, hOldFont, NULL);
			MoveWindow(hEdit, Oldrect.left, Oldrect.top, Oldrect.right - Oldrect.left, Oldrect.bottom-Oldrect.top, TRUE);
			ShowWindow(hEdit, SW_SHOWNORMAL);
			return TRUE;
		}


		/*** Begin Printing. ***/
		lstrcpy((LPSTR) &szMsg, "H.M. - Attachment");
		bError = FALSE;
		DI.lpszDocName = (LPCSTR) &szMsg;
		DI.lpszOutput  = NULL;
		DI.cbSize = sizeof(DOCINFO);
		if (StartDoc(pd.hDC, &DI) > 0) {

			/*** Loop to print multiple copies of the attachment. ***/
			for (copy=0;copy < pd.nCopies && !bUserAbort && !bError; copy++) {

				/*** Add printing data to Bar Graph Box ***/
				wsprintf((char far *) &szMsg,"Printing Window : Copy #%d", copy+1);
				SendMessage(GetDlgItem(hDlgCancel, BG_TITLE), WM_SETTEXT, NULL, (LONG) &szMsg);
				SendMessage(hDlgCancel, WM_INITDIALOG, 0, 0L);

				bError = PrintWindow(pd, hEdit);

			}
		}
		else
			bError = TRUE;


		EndDoc(pd.hDC);

		if (bError)
			/*** Error occurred when initializing printer or when sending a page break. ***/
			BWCCMessageBox(hWnd, "Unable to print. Please check printer connection.", "HappyMail", MB_OK | MB_ICONEXCLAMATION);


		if (bUserAbort)
			/*** User aborted the print operation. ***/
			BWCCMessageBox(hWnd, "Print Operation Aborted!", "HappyMail", MB_OK | MB_ICONEXCLAMATION);
		else
			DestroyWindow(hDlgCancel);


		/*** Release memory blocks, bitmaps, and device contexts. ***/
		hDlgCancel = NULL;
		FreeProcInstance(lpfnAbortProc);
		FreeProcInstance(lpfnPrintCancel);
		DeleteObject(SelectObject(pd.hDC, hOldFont));
		DeleteDC(pd.hDC);


		/*** Restore the Edit window to the proper dimensions and font. ***/
		SendMessage(hEdit, WM_SETFONT, hEditFont, NULL);
		MoveWindow(hEdit, Oldrect.left, Oldrect.top, Oldrect.right - Oldrect.left, Oldrect.bottom-Oldrect.top, TRUE);
		ShowWindow(hEdit, SW_SHOWNORMAL);


	}

	return TRUE;
}







