/****************************************************************************
	FILE:		superlib.c


	CONTENTS:   BB_InitSuperClass()	creates a superclassed Borland style button.
				BBProc()			window procedure for new SuperBorBtn class


	COMMENTS:	This file contains all the procedures used in creating and
				managing the SuperBorBtn class.

				The SuperBorBtn class is nearly identical to the Borland
				class BorBtn.  The main differnce is the new class 
				translates certain cursor keys into tabs and the return key
				into a spacebar. 


****************************************************************************/
#include "MyMail.h"
#include "string.h"
/****************************************************************************
	FUNCTION: BB_InitSuperClass(HANDLE hInst, HWND hParent)

	PURPOSE:  Creates and registers the new Superclassed Borland Button Class
****************************************************************************/
BOOL BB_InitSuperClass(HANDLE hInst, HWND hParent)
{
	HWND 		hBBWnd;
	WNDCLASS	Class;

	/*** Create a Borland button in order to copy ***/
	/*** its class information to our new class.  ***/
	hBBWnd = CreateWindow((LPSTR) "BorBtn",	(LPSTR) "",	WS_CHILD,
				0, 0, 0, 0,	(HWND) hParent,	0, (HANDLE) hInst, (LPSTR) NULL);

    /*** Store a pointer to the Borlands Button window procedure as a global variable. ***/
	lpfnOldBBProc = (FARPROC) GetWindowLong(hBBWnd, GWL_WNDPROC);

    /*** Fill our class structure with info from the Borland Button's class. ***/
	Class.style 		= GetClassWord(hBBWnd, GCW_STYLE);
	Class.lpfnWndProc   = (WNDPROC) BBProc;
	Class.cbClsExtra	= GetClassWord(hBBWnd, GCW_CBCLSEXTRA);
	Class.cbWndExtra	= GetClassWord(hBBWnd, GCW_CBWNDEXTRA);
	Class.hInstance		= hInst;
	Class.hIcon			= GetClassWord(hBBWnd, GCW_HICON);
	Class.hCursor		= GetClassWord(hBBWnd, GCW_HCURSOR);
	Class.hbrBackground	= GetClassWord(hBBWnd, GCW_HBRBACKGROUND);
	Class.lpszMenuName	= NULL;
	Class.lpszClassName = (LPSTR) "SuperBorBtn";

    /*** Done copying info from the Borland button.. so delete it. ***/
	DestroyWindow(hBBWnd);

    /*** Registrer our new class. ***/
	if (!RegisterClass((LPWNDCLASS) &Class)) {
		return FALSE;
	}

	return TRUE;
}




/****************************************************************************
	FUNCTION: BBProc(HWND, WORD, WORD, LONG)

	PURPOSE:  Pre-Processes messages for new "SuperBorBtn" control
****************************************************************************/

long FAR PASCAL _export BBProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	FARPROC 	lpfnNewBBProc;
	long 		lret;
	char 		States[256], OldState[1], buff[100];
	BOOL		changed;

	/*** This variable is used when sending a [SHIFT] [TAB] to the   ***/
	/*** old window procedure. To send a [SHIFT] key, the keyboard   ***/
	/*** state must be set.  When changed is TRUE, then the keyboard ***/
	/*** state is reset after calling the default window procedure.  ***/
	changed = FALSE;

	switch (message) {
		case WM_KEYDOWN:
			/*** Convert [RETURN]s to [SPACE]s, [UP] and  ***/
			/*** and [RIGHT] arrows to [TAB]s, and [LEFT] ***/
            /*** and [DOWN] arrows to [SHIFT][TAB]s.      ***/
			if (wParam == VK_RETURN)
				wParam = VK_SPACE;
			if (wParam == VK_UP || wParam == VK_RIGHT)
				wParam = VK_TAB;
			if (wParam == VK_DOWN || wParam == VK_LEFT) {
				wParam = VK_TAB;
                /*** Change the Keyboard state to indicate a [SHIFT] key. ***/
				GetKeyboardState(States);
				OldState[0] = States[VK_SHIFT];
				changed = TRUE;
				States[VK_SHIFT] |= 0x80;
				SetKeyboardState(States);
			}
			break;

		case WM_KEYUP:
			if (wParam == VK_RETURN)
				wParam = VK_SPACE;

			if (wParam == VK_F1)
				PostMessage(hWnd, WM_F1, MSGF_DIALOGBOX, 0);
			break;

		case WM_DESTROY:
			/*** Release the pointer to this procedure  ***/
			/*** and restore the old procedure pointer. ***/
			lpfnNewBBProc = (FARPROC) GetWindowLong(hwnd, GWL_WNDPROC);
			SetWindowLong(hwnd, GWL_WNDPROC, (LONG) lpfnOldBBProc);
			FreeProcInstance(lpfnNewBBProc);
			break;

		case WM_SETFOCUS:
            /*** This button is gaining the focus so display the help string. ***/
			LoadString(hInst, GetDlgCtrlID(hwnd), buff, 100);
			if (hStatus)
				SendMessage(hStatus, STB_STRING, lstrlen((LPSTR) &buff), (LONG) &buff);
            break;

		case WM_KILLFOCUS:
			/*** This button is losing the focus so display a blank string. ***/
			if (hStatus)
				SendMessage(hStatus, STB_STRING, 0, 0L);
			break;

	} /** end switch(message) **/

    /*** Call the default window procedure for Borland Buttons. ***/
	lret = CallWindowProc(lpfnOldBBProc, hwnd, message, wParam, lParam);

    /*** Reset the state of the [SHIFT] key. ***/  
	if (changed) {
		GetKeyboardState(States);
		States[VK_SHIFT] = OldState[0];
		SetKeyboardState(States);
	}
	return(lret);
}

