/****************************************************************************
	FILE:		search.c


	CONTENTS:	SearchProc()	Dialog Box procedure for Search Window.
				quikscan() 		searches for the occurence of one string
								embedded within another


	COMMENTS:	This file contains all the functions used to search through
				a user's mail messages for a text string.
****************************************************************************/
#include "MyMail.h"
#include "string.h"
long quikscan(char far *, char far *);

/******************************************************************************
	FUNCTION: 	SearchProc()

	PURPOSE:  	Dialog Box procedure for Search Window.
*******************************************************************************/
BOOL FAR PASCAL _export SearchProc(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
	char 		  	buff[1025], FoldName[20], far *txtptr,
					title[64], itemstr[80];
	BOOL		  	bText, bSubject, bTempFold;
	CallStatus 	  	uStat = 0;
	unsigned short	bytes, offset, retcount=0, foldercount, i, j, k, keycnt,
					msgcount, hits, scans, indexarr[100], msgtotal;
	GLOBALHANDLE  	hText, hFold, hLetter;
	LOGFONT		  	lf;
	FolderInfo	  	Folder[MAXFOLDERS];
	DWORD		  	dwIndex;
	MailFolder far	*SearchFolder;
	Letter far 		*TempLetter;
	MsgInfo 	  	OneMsg;
	Env         	env;
	HWND			hEdit, hResults, hRead;
	static int		index, scanning = FALSE, cancel = FALSE, foldsizes[256], endproc = FALSE;
	static char 	SearchStr[5][64];
	static HWND		hSearchIcon;


	/*** Send Window Messages to Status Bar ***/
	StatBarCtrlMsg(hDlg, SearchBox, message, wParam, lParam);

	switch (message) {
		case WM_INITDIALOG:        /* message: initialize dialog box */
			if (hDlgSearch != NULL) {
				DestroyWindow(hDlg);
				ShowWindow(hDlgSearch, SW_RESTORE);
				return TRUE;
			}
			hDlgSearch = hDlg;

			/*** Set the Window's Icon. ***/
			hSearchIcon = LoadIcon(hInst, "mail");
			SetClassWord(hDlg, GCW_HICON, hSearchIcon);

			/*** Center the Dialog Window in the HappyMail Main window ***/
			CenterWindow(hDlg, GetDesktopWindow());

			/*** Check the Text Button. ***/
			CheckDlgButton(hDlg, SB_SUBJECT, 1);

			/*** Fill the folders list box and select the "General" folder. ***/
			offset = uStat = 0;
			retcount = 1;
			while (uStat == 0 && retcount>0) {
				uStat=VnsListMailFolders(hVNMAS, UserName, Folder, offset, MAXFOLDERS, &retcount, &foldercount);
				if (Recover(uStat))
					uStat=VnsListMailFolders(hVNMAS, UserName, Folder, offset, MAXFOLDERS, &retcount, &foldercount);

				offset+=retcount;
				for(i=0; i<retcount && uStat == 0; i++) {
					SendDlgItemMessage(hDlg, SB_FOLDERS, LB_ADDSTRING, 0, (LPARAM)(LPSTR) &(Folder[i].name));
					foldsizes[i] = Folder[i].num;
				}
			}
			if(uStat) {
				DspMsgCode(hWnd, "Error Reading Folder Names : ", uStat, FALSE);
			}
			dwIndex = SendDlgItemMessage(hDlg, SB_FOLDERS, LB_FINDSTRING, -1, (LPARAM)(LPSTR) "General");
			SendDlgItemMessage(hDlg, SB_FOLDERS, LB_SETSEL, TRUE, dwIndex);

			return (TRUE);

		case WM_SYSCOMMAND:
			/*** User selected Close from the Sytem Menu. ***/
			if ((wParam & 0xFFF0) == SC_CLOSE) {
				SendMessage(hDlg, WM_COMMAND, IDCANCEL, 0L);
			}
			break;

		case SB_GETID:
			SendDlgItemMessage(hDlg, SB_IDS, LB_GETTEXT, index, lParam);
			break;

		case SB_GETFOLDER:
			SendDlgItemMessage(hDlg, SB_FOLDIDS, LB_GETTEXT, index, lParam);
			break;

		case WM_ICONERASEBKGND:
			return TRUE;

		case WM_COMMAND:
			/*** If user double Clicks in the results list box, do a read. ***/
			if ((HIWORD(lParam) == LBN_DBLCLK) && (wParam == SB_RESULTS)) {
				SendMessage(hDlg, WM_COMMAND, IDM_READ, 0L);
				break;
			}

			switch (wParam) {

				case IDCANCEL:
					/*** First abort the scan   ***/
					if (scanning) {
						SendMessage(hDlg, WM_SETTEXT, 0, (LPARAM) "Search Aborted");
						cancel = TRUE;
						endproc = TRUE;
						break;
					}
					/*** User select Exit button. ***/
					DestroyWindow(hDlg);
					DestroyIcon(hSearchIcon);
					hDlgSearch = 0;
					return (TRUE);

				case IDABORT:
					/*** Abort a scan   ***/
					if (scanning) {
						SendMessage(hDlg, WM_SETTEXT, 0, (LPARAM) "Search Aborted");
						cancel = TRUE;
						break;
					}
					return 0;

				case IDM_READ:
					index = SendDlgItemMessage(hDlg, SB_RESULTS, LB_GETCURSEL, 0, 0L);
					if (index != LB_ERR) {
						bSearchRead = TRUE;

						/*** Open a new read window with the selected message. ***/
						hRead = SendMessage(hWnd, WM_COMMAND, IDM_READ, NULL);

						/*** Highlight the first hit in the top read window. ***/
						SendDlgItemMessage(hDlg, SB_IDS, LB_GETTEXT, index, (LPARAM)(LPSTR)&buff);
						SendDlgItemMessage(hDlg, SB_FOLDIDS, LB_GETTEXT, index, (LPARAM)(LPSTR)&FoldName);
						hLetter = GetLetter(hRead);
						TempLetter = (Letter far *) GlobalLock(hLetter);

						if (FormatMessage((LPSTR) &FoldName, (LPSTR) &buff, &env, &hText, TempLetter->hViewMail)) {
							txtptr = GlobalLock(hText);
							offset = quikscan(txtptr, (LPSTR) &SearchStr);
							SendMessage(TempLetter->hViewMail, EM_SETSEL, NULL, MAKELONG(offset + lstrlen((LPSTR) &SearchStr), offset));
							SafeFree(GLOBAL, hText);
						}
						GlobalUnlock(hLetter);

						bSearchRead = FALSE;
					}
					break;

				case SB_START:
					/*** First retrieve the search string, ***/
					/*** folder name, and search fields.   ***/
					hits = scans = 0;
					bSubject 	= SendDlgItemMessage(hDlg, SB_SUBJECT, 	BM_GETCHECK, 0, 0L);
					bText		= SendDlgItemMessage(hDlg, SB_TEXT, 	BM_GETCHECK, 0, 0L);
					SendDlgItemMessage(hDlg, SB_SEARCHKEY, WM_GETTEXT, 128, (LPARAM)(LPSTR) &buff);
					txtptr = _fstrtok(buff, "&");
					for(keycnt=0;(keycnt<5) && (txtptr != NULL);keycnt++) {
						lstrcpy((LPSTR) &(SearchStr[keycnt]), txtptr);
						_fstrupr((LPSTR) &(SearchStr[keycnt]));
						txtptr = _fstrtok(NULL, "&");
					}


					/*** Check for missing parameters. ***/
					if (keycnt == 0) {
						BWCCMessageBox(hDlg, "No Search String Specified.", "WARNING", MB_ICONHAND);
						break;
					}
					if ((!bSubject) && (!bText)) {
						BWCCMessageBox(hDlg, "No Search Area Specified.", "WARNING", MB_ICONHAND);
						break;
					}
					foldercount = SendDlgItemMessage(hDlg, SB_FOLDERS, LB_GETSELCOUNT, 0, 0L);
					if (foldercount <= 0 ) {
						BWCCMessageBox(hDlg, "No Folder Specified.", "WARNING", MB_ICONHAND);
						break;
					}



					/*** Initialize Buttons, List Boxes, temporary edit window, etc... ***/
					EnableWindow(GetDlgItem(hDlg, IDABORT), TRUE);
					scanning = TRUE;
					hResults = GetDlgItem(hDlg, SB_RESULTS);
					SendMessage(hResults, LB_RESETCONTENT, 0, 0L);
					SendDlgItemMessage(hDlg, SB_IDS, LB_RESETCONTENT, 0, 0L);
					SendDlgItemMessage(hDlg, SB_FOLDIDS, LB_RESETCONTENT, 0, 0L);
					hEdit = CreateWindow("edit", "", WS_CHILD | ES_MULTILINE, 0, 0, CW_USEDEFAULT,
						CW_USEDEFAULT, hWnd, PB_EDIT, hInst, NULL);


					/*** Initialize the Bargraf. ***/
					SendDlgItemMessage(hDlg, SB_FOLDERS, LB_GETSELITEMS, 100, (LPARAM) (int far *)&indexarr);
					msgtotal = 0;
					for (offset=0;offset<foldercount;offset++)
						msgtotal += foldsizes[indexarr[offset]];
					BarGraf(hDlg, WM_NEXTSTEP, 0, 0L);

					/*** Spin through each selected folder looking for matches. ***/
					for (offset=0;offset<foldercount;offset++) {
						/*** Initialize Folder name to General (just in case). ***/
						/*** Then retrieve the next selected folder name. ***/
						lstrcpy((LPSTR) &FoldName, "General");
						SendDlgItemMessage(hDlg, SB_FOLDERS, LB_GETTEXT, indexarr[offset], (LPARAM) (LPSTR)&FoldName);
						/*** If folder is open, use folder structure to retrieve message id's. ***/
						/*** otherwise use a temp folder structure to read the message id's.   ***/
						bTempFold = FALSE;
						hFold = GetFolder2((LPSTR) &FoldName);
						if (hFold == NULL) {
							bTempFold = TRUE;
							if ((hFold = AddFolder((LPSTR) &FoldName)) == NULL) {
								/*** Error occurred creating new Folder structure ***/
								DspMsgCode( hWnd, "Error Reading Folder : ", 1, FALSE);
								scanning = FALSE;
								EnableWindow(GetDlgItem(hDlg, IDABORT), FALSE);
								return (FALSE);
							}
							VnsListMailMsgs(hVNMAS, UserName, (LPSTR) &FoldName, (MsgInfo WFAR *)&OneMsg, 0, 1, &retcount,&msgcount, CREATEDATE);
							SearchFolder = (MailFolder far *) GlobalLock(hFold);
							SearchFolder->MsgCount	= msgcount;
							SearchFolder->hListBox  = NULL;
							SearchFolder->hListMail = NULL;
						}
						else
							SearchFolder = (MailFolder far *) GlobalLock(hFold);

						/*** Spin through each message scanning for occurrences of the search string. ***/
						if (bSubject && !bText) {
							for (i=0;(i<SearchFolder->MsgCount) && (hits<100) && (!cancel); i++, scans++) {
								BarGraf(hDlg, WM_NEXTSTEP, (100*scans)/msgtotal, 0L);
								DeClogDlgMsg(hDlg);
								/*** Update Subject line. ***/
								wsprintf((LPSTR) &title, "Scanning : Message #%i in %s", i, (LPSTR) &FoldName);
								SendMessage(hDlg, WM_SETTEXT, 0, (LPARAM) (LPSTR) &title);
								ReadItem(SearchFolder, i, (LPSTR) &buff);
								lstrcpy((LPSTR) &itemstr, (LPSTR) &buff);
								for (k=0, retcount=1;(k<keycnt) && (retcount>0);k++)
									retcount = quikscan((LPSTR) &buff, (LPSTR) &(SearchStr[k]));
								if (retcount > 0) {
									/*** Search String was found so add msg to list box. ***/
									hits++;

									SendMessage(hResults, LB_ADDSTRING, 0, (LPARAM)(LPSTR) &itemstr);
									UpdateWindow(hResults);
									ReadID(SearchFolder, i, (LPSTR) &buff);
									SendDlgItemMessage(hDlg, SB_IDS, LB_ADDSTRING, 0, (LPARAM)(LPSTR) &buff);
									SendDlgItemMessage(hDlg, SB_FOLDIDS, LB_ADDSTRING, 0, (LPARAM)(LPSTR) &FoldName);
								}
							}
						}

						if (bText) {
							/*** Create an invisible edit control for formatting the Message. ***/
							for (i=0; (i < SearchFolder->MsgCount) && (hits<100) && (!cancel); i++, scans++) {
								BarGraf(hDlg, WM_NEXTSTEP, (100*scans)/msgtotal, 0L);
								DeClogDlgMsg(hDlg);
								/*** Update Subject line. ***/
								wsprintf((LPSTR) &title, "Scanning : Message #%i in %s", i, (LPSTR) &FoldName);
								SendMessage(hDlg, WM_SETTEXT, 0, (LPARAM) (LPSTR) &title);

								ReadID(SearchFolder, i, (LPSTR) &buff);
								if (FormatMessage((LPSTR) &FoldName, (LPSTR) &buff, &env, &hText, hEdit) != TRUE)
									continue;
								txtptr = GlobalLock(hText);
								for (k=0, retcount=1;(k<keycnt) && (retcount>0);k++)
									retcount = quikscan(txtptr, (LPSTR) &(SearchStr[k]));
								if (retcount > 0) {
									/*** Search String was found so add msg to list box. ***/
									hits++;
									SendDlgItemMessage(hDlg, SB_IDS, LB_ADDSTRING, 0, (LPARAM)(LPSTR) &buff);
									ReadItem(SearchFolder, i, (LPSTR) &buff);
									SendMessage(hResults, LB_ADDSTRING, 0, (LPARAM)(LPSTR) &buff);
									UpdateWindow(hResults);
									SendDlgItemMessage(hDlg, SB_FOLDIDS, LB_ADDSTRING, 0, (LPARAM)(LPSTR) &FoldName);
								}
								SafeFree(GLOBAL, hText);
							}
						}

						GlobalUnlock(hFold);
						if (bTempFold) KillFolder2((LPSTR) &FoldName);
					}
					/*** Reset Title Bar and destroy temp edit window. ***/
					if (cancel)
						wsprintf((LPSTR) &title, "Search Aborted : %i Matches Found", hits);
					else {
						wsprintf((LPSTR) &title, "Search Done : %i Matches Found", hits);
						BarGraf(hDlg, WM_NEXTSTEP, 100, 0L);
					}
					if (hits>0)
						SendDlgItemMessage(hDlg, SB_RESULTS, LB_SETCURSEL, 0, 0L);
					SendMessage(hDlg, WM_SETTEXT, 0, (LPARAM) (LPSTR) &title);
					DestroyWindow(hEdit);
					scanning = FALSE;
					cancel = FALSE;
					EnableWindow(GetDlgItem(hDlg, IDABORT), FALSE);
					if (endproc)
						SendMessage(hDlg, WM_COMMAND, IDCANCEL, 0L);
					break;


			} /** end switch(wParam) **/
			break;
	} /* end switch (message) */
	return (FALSE);

}

/******************************************************************************
	FUNCTION: 	quikscan()

	PURPOSE:  	procedure for doing rapid text searches.  Currently uses the
				C library function _fstrstr(), but could probably be optimized
				by writing your own function to do the search.
*******************************************************************************/
long quikscan(char far *text, char far *key)
{
	char far *ptr;

	_fstrupr(text);
	if ((ptr = (LPSTR) _fstrstr(text, key))==NULL)
		return 0;
	return ((long) (ptr - text));
}


