#include "bwcc.h"
#define pc
#define WINDOWS
#define _WINDOWS
#define _WINDLL

#define INCL_ST
#define INCL_WS  	/*** VnsGetUserName ***/
#define INCL_MAIL
#include "vnsapi.h"

#include "defines.h"


/*** The following structures are used to store data about ***/
/*** open letters and folders in global linked lists. 	   ***/
typedef struct {
	unsigned char	flags;
	char 			string[66];
	char			ID[13];
} ItemRec;

typedef struct {
	FARPROC			lpOldEditProc;
	HWND			hViewMail;
	HWND			hChild;
	HWND			hList;
	char 			MsgID[14];
	char			FolderName[14];
	GLOBALHANDLE	hFolder;
	GLOBALHANDLE	Prev;
	GLOBALHANDLE	Next;
} Letter;

typedef struct {
	FARPROC			lpOldListProc;
	HWND			hListMail;
	HWND			hListBox;
	char 			Name[32];
	int				MsgCount;
	BOOL			Updating;
	GLOBALHANDLE	Prev;
	GLOBALHANDLE	Next;
	ItemRec			Item[800];
} MailFolder;


typedef struct {
	BOOL			STDA;
	BOOL			expertmode;
	char 			defdir[256];
	char			sortorder;
	BOOL			certify;
	char			defaultdest;
	char 			sign[512];
	int				linelength;
	char			deletemode;
	char   			answermode;
	BOOL			logo;
	BOOL			date;
	BOOL			pagenum;
	BOOL			happybook;
	BOOL			icon;
	BOOL			usedefault;
	BOOL			usefilters;
	BOOL			useheader;
	BOOL			useprefix;
	char 			prefix[6];
} OptionRec;


typedef unsigned int  HVNSD;


/*** The next structure is used when working with the address book. ***/
/*** It will store the book's contents when it is being modified.   ***/
typedef struct {
	int			num_entries;
	int 		length;
	HANDLE  	hData[100];
	char far 	*pData[100];
	char 		labels[100][16];
} AddressBook;


/*** The following structure is used in sorting messages in Folder windows. ***/
typedef struct node SortNode;
struct node {
	char			ItemKey[30];
	char			ItemStr[70];
	char			ItemID[13];
	int				ItemNum;
	SortNode far *	lptr;
	SortNode far *	rptr;
	GLOBALHANDLE	hSelf;
};


/*** The following structure is used by the Managing Attachment windows. ***/
typedef struct {
	char	FoldName[14];
	char	MsID[14];
	short	Partnum;
	char 	FileName[144];
	BOOL	UseDef;
	BOOL	UseFilters;
} Attach_Rec;



/*** The followingf typedef is used in the common dialog procedures.  ***/
typedef UINT (CALLBACK *DLGHOOKPROC)(HWND, UINT, WPARAM, LPARAM);


/*** The Main Window Procedures are next ***/
extern int PASCAL      	WinMain             ( HANDLE, HANDLE, LPSTR, int);
extern BOOL            	InitApplication		( HANDLE, int, HANDLE far *, HANDLE far * );
extern long FAR PASCAL 	FrameWndProc     	( HWND, unsigned, WORD, LONG );


/*** Following are all the Dialog Procedures for HappyMail ***/
extern BOOL FAR PASCAL 	AbortProc          	( HDC, short );
extern BOOL FAR PASCAL 	About              	( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	AddressBk      	   	( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	AskChange          	( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	BarGraf				( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	ChooseDest         	( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	ComposeOptions		( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	ChooseTo	      	( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	Compose            	( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	EditAdBk		   	( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	FolderOptions		( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	Forward		   		( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	GeneralOptions		( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	GetName				( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	GetNewName			( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	Logo				( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	Manage		   		( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	ManageAttach   		( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	MoveMail		   	( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	ReadOptions			( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	PrintOptions		( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL 	SearchProc			( HWND, unsigned, WORD, LONG );
extern BOOL FAR PASCAL	ViewFile       	   	( HWND, unsigned, WORD, LONG );


/*** Following are all the Window Procedures used by HappyMail ***/
extern long FAR PASCAL 	BBProc				( HWND, WORD, WORD, LONG );
extern long FAR PASCAL 	EditProc           	( HWND, WORD, WORD, LONG );
extern long FAR PASCAL 	ListMail           	( HWND, WORD, WORD, LONG );
extern long FAR PASCAL 	ListProc           	( HWND, WORD, WORD, LONG );
extern long FAR PASCAL 	ListProc2          	( HWND, WORD, WORD, LONG );
extern long FAR PASCAL 	NewWndProc			( HWND, WORD, WORD, LONG );
extern long FAR PASCAL 	ReadMail           	( HWND, WORD, WORD, LONG );
extern long FAR PASCAL 	StatusBarProc      	( HWND, WORD, WORD, LONG );


/*** Following are Callback Functions to be exported ***/
extern BOOL FAR PASCAL 	CloseKids			( HWND, LONG );
UINT CALLBACK 			SaveHook			( HWND, UINT, WORD, LONG );
UINT CALLBACK 			HookProc			( HWND, UINT, WORD, LONG );
UINT CALLBACK 			DirBrowseHook		( HWND, UINT, WORD, LONG );
int FAR PASCAL			FilterFunc			( int, WORD, DWORD );


/*** Following are all the support functions used by HappyMail ***/
extern GLOBALHANDLE 	AddFolder			( char far * );
extern GLOBALHANDLE		AddLetter			( void );
extern					AddMsgString		( MsgInfo, HWND );
extern					AddNode				( SortNode far *, SortNode far * );
extern					AddTabs				( char far *, unsigned int , HWND, int far * );
extern BOOL 			BB_InitSuperClass	( HANDLE, HWND );
extern LONG			   	CallDlg				( HWND, FARPROC, unsigned int, long );
extern BOOL 			CapCmp				( char far *, char far * );
extern BOOL 			CapnCmp				( char far *, char far *, int );
extern					CenterWindow		( HWND, HWND );
extern void				ChangeFont			( LOGFONT far *, HWND );
extern 					ChangeUnread		( char far *, char far * );
extern 				  	CheckNames	   		( char far *, HWND, int, int far * );
extern long 			convert_date		( char far * );
extern					DeClogDlgMsg		( HWND );
extern					DeleteTempFiles		( void );
extern 					delnchr				( char far *, int, int );
extern					DrawBar				( HWND, HDC, char far * );
extern 					DrawBitMap			( HDC, HBITMAP, short, short, BOOL, BOOL );
extern void            	DspMsgCode         	( HWND, char far *, unsigned long, int );
extern HANDLE 			ExpandNames			( char far * , int );
extern BOOL				fexist				( char far * );
extern void 			FileOpen			( HWND );
extern BOOL 			FillAttach			( HWND, WORD, char far * );
extern BOOL 			FillBody			( HWND, WORD, char far *, char far *, Env far * );
extern BOOL 			FillRecipients		( HWND, WORD, char far *, Env far * );
extern BOOL 			FillSubject			( HWND, WORD, Env far * );
extern int 				FindID				( GLOBALHANDLE, char far * );
extern BOOL 			FontPick			( HWND, WORD, LOGFONT far *);
extern BOOL 			FormatBody			( char far *, char far *, GLOBALHANDLE, unsigned long );
extern					FormatEnvelope		( char far *, char far *, Env far *, GLOBALHANDLE far *, HWND, BOOL);
extern BOOL 			FormatMessage		( char far *, char far *, Env far *, GLOBALHANDLE far *, HWND );
extern					FormatText			( HWND, char far *, char far *, char far *, unsigned int, int far * );
extern long 		   	fsize		   		( int );
extern					get_datestr			( char far * );
extern GLOBALHANDLE		GetFolder			( HWND );
extern GLOBALHANDLE		GetFolder2			( char far * );
extern int				GetFontHeight		( HWND );
extern int 				GetFontWidth		( HWND );
extern BOOL 			GetINIFont			( char far *, LOGFONT far * );
extern BOOL 			GetINILetter		( int far *, int far *, int far *, int far * );
extern GLOBALHANDLE	   	GetLetter	   		( HWND );
extern GLOBALHANDLE		GetLetterByFoldName	( char far * );
extern GLOBALHANDLE		GetLetterByID		( char far * );
extern int 				GetLetterInfo		( char far *, char far *, long, GLOBALHANDLE far * );
extern unsigned short	getrev				( void );
extern GLOBALHANDLE 	ImportFile			( HWND );
extern BOOL 			InAddressBook		( char far *, char far *, BOOL );
extern					InitLocal			( void );
extern 					InitMain			( int );
extern					InitOptions			( void );
extern 					InitScreen			( void );
extern					InitSysVars			( void );
extern BOOL 			IsLocal				( char far * );
extern void 			KillFolder			( HWND );
extern void 			KillFolder2			( char far * );
extern void     	   	KillLetter	   		( HWND );
extern 					KillTree			( SortNode far * );
extern BOOL 			NextLetter			( HWND, BOOL, BOOL );
extern void            	NullFill	        ( char far * , unsigned int );
extern BOOL 			OldReadBlock		( MailFolder far *, int );
extern int  			ParseName			( char far * );
extern 					PreFillComposeBox	( HWND, WORD, char far *, char far *, Env far * );
extern					PrintAttach			( HWND, HWND );
extern					PrintMessage		( LONG );
extern BOOL 			ReadBlock			( MailFolder far *, int );
extern BOOL 			ReadID				( MailFolder far *, int , char far * );
extern BOOL 			ReadItem			( MailFolder far *, int , char far * );
extern					ReadRecipients		( HWND, char, char far *, char far *, unsigned int, int far * );
extern					ReadTree			( SortNode far *, HWND, MailFolder far * );
extern BOOL 			Recover				( CallStatus );
extern					ResetLists			( char far *, char far *, int, char far * );
extern 					ResizeWindow		( HWND, int, RECT far *, HFONT far * );
extern HANDLE	   	   	SafeAlloc	   		( BOOL, unsigned long, HWND );
extern				   	SafeFree		   	( BOOL, HANDLE );
extern BOOL 			SaveAttachments		( HWND, Attach_Rec far *, BodyPart far * );
extern BOOL 			SaveMessage			( HWND, BodyPart far *, WORD, char far *, char far *, char far * );
extern BOOL				SaveOptions			( void );
extern 					SaveScreen			( void );
extern 					SaveTopLetter		( void );
extern					setcwd				( char far * );
extern					SortLists			( char far * );
extern BOOL				StartMail			( HVNMA WFAR * );
extern HVNSD			StartSTDA			( void );
extern					StatBarCtrlMsg		( HWND,  unsigned int, WORD, WORD, LONG );
extern int  			StoreNames			( char far *, char, char far * );
extern 					trim				( char far * );
extern					WriteTitleBar		( MailFolder far * );
extern BOOL				WritePrivateProfileInt( char far *, char far *, int, char far * );




/*** The Following are global variables used throughout HappyMail ***/
extern HANDLE		hInst;
extern HWND			hWnd, hDlgCancel, hStatus, hDlgSearch;
extern GLOBALHANDLE	TopLetter, TopFolder, hTempArr;

extern char			UserName[65], INI_FILE[256];

extern short		index, HelpID, VnsRev, MaxMsgs;

extern unsigned long MAXBODY, MAXMSGBODY;

extern FARPROC		lpfnOldEdit, lpfnOldBBProc, lpFilterFunc;

extern HANDLE		hAccel, hMailAccel, hReadAccel;
extern HMENU		hMenuMail, hMenuWrite, hMenuWindow, hMenuEdit;

extern HVNMA		hVNMAS;
extern HVNSD		hSTDA;

extern BOOL			bUserAbort, bSpellMode, bNewListFont, bSearchRead;

extern HBITMAP		hBMPaperClip;

extern OptionRec	Options;
