/****************************************************************************
	FILE:		move.c


	CONTENTS:   MoveMail()	window procedure for Move messages dialog box.

	COMMENTS:	This file contains the main window procedures used in
    			moving mail messages between folders.
****************************************************************************/
#include "MyMail.h"
#include "string.h"


/****************************************************************************
	FUNCTION:	MoveMail()

	PURPOSE:	Processes messages for "MoveBox" dialog box
****************************************************************************/
BOOL FAR PASCAL _export MoveMail(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{

	CallStatus		uStat;
	unsigned short 	offset, retcount=0, foldercount, tabset[1];
	char 			buff[32], far *MsgID, MsID[14], TempName[15], title[50];
	int 			i, count, retcode, index;
	static int		NumItems;
	static char		FoldName[15];
	FolderInfo		Folder[MAXFOLDERS];
	long			inc;
	FARPROC			lpfnBarGraf;
	HWND			hLetter;
	Letter far 		*TempLetter;
	GLOBALHANDLE	hTempMem;


	/*** Send Window Messages to Status Bar ***/
	StatBarCtrlMsg(hDlg, MoveBox, message, wParam, lParam);

	switch (message) {
		case WM_INITDIALOG:
			/*** Center the Dialog Window in the HappyMail Main window ***/
			CenterWindow(hDlg, GetDesktopWindow());

			/*** Change the default pushbutton and set text limits. ***/
			SendMessage(hDlg, DM_SETDEFID, NULL, NULL);
			SendDlgItemMessage(hDlg, MB_FOLDERS, LB_RESETCONTENT, NULL, NULL);

			/*** Set the Tab Stops for the List Box. ***/
			tabset[0] = 104;
			SendDlgItemMessage(hDlg, MB_FOLDERS, LB_SETTABSTOPS, 1, (long) &tabset);

			/*** Get the Network folder names and place in the list box. ***/
			offset = uStat = 0;
			retcount = 1;
			while (uStat == 0 && retcount>0) {
				uStat=VnsListMailFolders(hVNMAS, UserName, Folder, offset, MAXFOLDERS, &retcount, &foldercount);
				if (Recover(uStat))
					uStat=VnsListMailFolders(hVNMAS, UserName, Folder, offset, MAXFOLDERS, &retcount, &foldercount);
				offset+=retcount;
				for(i=0; i<retcount && uStat == 0; i++) {
					wsprintf((char far *) &buff, "%s\t%i", (char far *)  &(Folder[i]), (int) Folder[i].num);
					SendDlgItemMessage(hDlg, MB_FOLDERS, LB_ADDSTRING, 0, (LONG) &buff);
				}
			}

            /*** A Banyan error occurred reading the folder list. ***/
			if(uStat) DspMsgCode(hWnd, "Error Reading Folder List : ", uStat, FALSE);

			/*** Select the first item in the list box.  ***/
			SendDlgItemMessage(hDlg, MB_FOLDERS, LB_SETCURSEL, 0, NULL);


			/*** Get the Folder Name and MessageID for the Highlighted or Current Message ***/
			NumItems = GetLetterInfo((LPSTR) &MsID, (LPSTR) &FoldName, lParam, &hTempArr);

			/*** No Messages in Folder or None Selected. ***/
			if (NumItems <= 0) {
				BWCCMessageBox(hWnd, "No Message(s) Selected.", "WARNING!", MB_ICONSTOP | MB_OK);
				EndDialog(hDlg, TRUE);
				return TRUE;
			}

			/*** Verify if multiple messages are selected. ***/
			if (!Options.expertmode && NumItems > 1) {
				if (!CallDlg(hWnd, AskChange, YesNoBox, 5L)) {
					SafeFree(GLOBAL, hTempArr);
					EndDialog(hDlg, TRUE);
					break;
				}
			}
			break;

		case WM_COMMAND:                   
			/*** User pressed enter key in List Box. ***/
			if (wParam == 0x0001)
				wParam = IDM_OK;

			/*** User double-clicked in the listbox of folder ***/
			/*** names, so simulate a click on the OK button. ***/
			if (HIWORD(lParam)== LBN_DBLCLK)
				wParam = IDM_OK;

			switch(wParam) {
				case MB_NEWFOLD:
					/*** User selected the New Folders button. ***/
                    buff[0] = '\0';
                    /*** Call the new names dialog box. ***/
					if (CallDlg(hDlg, GetNewName, NameBox, (long) &buff)) {

						/*** Make sure name is not already in use by scanning   ***/
                        /*** thru the names already in the folder name list box.***/
						index = (WORD) SendDlgItemMessage(hDlg, MB_FOLDERS, LB_FINDSTRING, -1, (LONG) &buff);
						if (index != LB_ERR) {
							SendDlgItemMessage(hDlg, MB_FOLDERS, LB_GETTEXT, index, (LONG) &TempName);
							for(i=0;i<lstrlen((LPSTR) &TempName);i++) if (TempName[i] == '\t') TempName[i] = '\0';
							if (lstrcmp((LPSTR) &buff, (LPSTR) &TempName) == 0) {
								BWCCMessageBox(hDlg, "Folder name already exists.", "WARNING!", MB_ICONSTOP | MB_OK);
								break;
							}
						}

						/*** Create the new Banyan folder. ***/
						uStat = VnsCreateMailFolder(hVNMAS, UserName, buff);
						if (Recover(uStat))
							uStat = VnsCreateMailFolder(hVNMAS, UserName, buff);

						/*** Banyan was unable to create the folder. ***/
						if (uStat != 0) {
							if (uStat == MS_BADNAME)
								BWCCMessageBox(hDlg, "Name contains illegal character(s).\rSuch as a '/'.", "WARNING!", MB_ICONSTOP | MB_OK);
							else if (uStat == MS_FOLDEREXISTS)
								BWCCMessageBox(hDlg, "Folder name already exists.", "WARNING!", MB_ICONSTOP | MB_OK);
							else
								BWCCMessageBox(hDlg, "Error Creating Folder.", "WARNING!", MB_ICONSTOP | MB_OK);
							break;
						}
					}
					else
						break;
					/*** If creating a new folder was successful,    ***/
					/*** continue on and execute the OK button code. ***/


				case IDM_OK:
					/*** User selected OK button. ***/
					/*** Change to HourGlass Cursor before starting ***/
					SetCursor(LoadCursor(NULL, IDC_WAIT));

					/*** Get the name of the folder to move ***/
					/*** the messages to,  Then do the move ***/
					if (wParam == IDM_OK) {
						i = SendDlgItemMessage(hDlg, MB_FOLDERS, LB_GETCURSEL, 0, 0L);
						SendDlgItemMessage(hDlg, MB_FOLDERS, LB_GETTEXT, i, (LONG) &buff);
	
						/*** Trim the number of messages off the end   ***/
						/*** of the string -- leaving the folder name. ***/
						for(i=0;i<lstrlen((LPSTR) &buff);i++) if (buff[i] == '\t') buff[i] = '\0';
					}
					if (lstrcmp((LPSTR) &FoldName, (LPSTR) &buff) != 0) {

						/*** Create and initialize the Bar Graph ***/
						/*** dialog box for displaying progress. ***/
						bUserAbort = FALSE;
						if (NumItems > 4) {
							lpfnBarGraf = MakeProcInstance(BarGraf, hInst);
							hDlgCancel = CreateDialog(hInst, MAKEINTRESOURCE(BarGrafBox), hWnd, lpfnBarGraf);
							wsprintf(title, "Moving %u Messages", NumItems);
							SendMessage(hDlgCancel, WM_SETTEXT, NULL, (LONG) title);
							wsprintf(title, "From: %s   To: %s", (char far *) FoldName, (char far *) buff);
							SendDlgItemMessage(hDlgCancel, BG_TITLE, WM_SETTEXT, NULL, (LONG) title);
						}


						MsgID = (char far *) GlobalLock(hTempArr);

						if (hDlgCancel)	DeClogDlgMsg(hDlgCancel);

						for(i=0; i< NumItems && !bUserAbort; i++) {
							uStat = VnsMoveMailMsg(hVNMAS, UserName, FoldName, &(MsgID[i*14]), (char far *) buff);
							if (Recover(uStat))
								uStat = VnsMoveMailMsg(hVNMAS, UserName, FoldName, &(MsgID[i*14]), (char far *) buff);
							if (uStat) {
								DspMsgCode(hWnd, "Error Moving Mail : ", uStat, FALSE);
								lstrncpy(&(MsgID[i*14]), &(MsgID[(i+1)*14]), 14*(NumItems-(i+1)));
								NumItems--;
								i--;
								continue;
							}

							/*** Send a percentage to the BarGraf dialog ***/
							if (hDlgCancel) {
								inc = ((long)i * 100L)/(long)NumItems;
								SendMessage(hDlgCancel, WM_NEXTSTEP, (WPARAM) (unsigned int) inc, 0L);
								DeClogDlgMsg(hDlgCancel);
							}
						}
						if (hDlgCancel)
							SendMessage(hDlgCancel, WM_NEXTSTEP, 100, 0L);

						/*** Modify the list boxes. ***/
						ResetLists((LPSTR) &FoldName, (LPSTR) &buff, i, MsgID);

						/*** Free the memory reserved for the dialog box procedure ***/
						if (NumItems > 4) {
							if (!bUserAbort)
								/*** Close Bar graph dialog box ***/
								DestroyWindow(hDlgCancel);
							else 
								/*** User pressed cancel so issue warning. ***/
								BWCCMessageBox(hWnd, "Message Delete Aborted!", "HappyMail", MB_OK | MB_ICONEXCLAMATION);

							hDlgCancel = NULL;
							FreeProcInstance(lpfnBarGraf);
						}

					}

				case IDCANCEL:
					/*** User selected Cancel or close. ***/
					SafeFree(GLOBAL, hTempArr);
					EndDialog(hDlg, TRUE);
					return (TRUE);
			}
	} /* end switch (message) */
	return (FALSE);               /* Didn't process a message    */
}

