/****************************************************************************
	FILE:		messsage.c


	CONTENTS:   FilterFunc()	a message filter accelerator key support


	COMMENTS:	This file contains the functions related to message
    			filtering.
****************************************************************************/
#include "MyMail.h"

/****************************************************************************
	FUNCTION: 	FilterFunc()

	PURPOSE:	A Message filter for adding accelerator key support
				and context-sensitive help to dialogs, menus, etc...

	COMMENTS:	The message filter hooks into the main message loop and
				intercepts all messages destined for menus, dialog boxes,
				and message boxes.	
****************************************************************************/
int FAR PASCAL _export FilterFunc(int nCode, WORD wParam, DWORD lParam)
{
	LPMSG lpmsg;
	char   buff[100], States[256];

	lpmsg = (LPMSG) lParam;

    /*** Look for generic keystrokes going to a dialog box or a menu. ***/
	if ((nCode == MSGF_DIALOGBOX || nCode == MSGF_MENU) &&
		lpmsg->message == WM_KEYDOWN) {
			switch (lpmsg->wParam) {
				case VK_F1:
                	/*** User pressed F1. ***/
					PostMessage(hWnd, WM_F1, nCode, 0L);
					break;

				case VK_F2:
					/*** User pressed F2. ***/
					if (lpmsg->hwnd)
						PostMessage(GetParent(lpmsg->hwnd), WM_COMMAND, IDM_NAMES, 0L);
					break;

				case VK_F3:
					/*** User pressed F3. ***/
					if (lpmsg->hwnd)
						PostMessage(GetParent(lpmsg->hwnd), WM_COMMAND, IDM_IMPORT, 0L);
					break;

				case VK_F5:
					/*** User pressed F5. ***/
					if (lpmsg->hwnd)
						PostMessage(GetParent(lpmsg->hwnd), WM_COMMAND, IDM_ATTACH, 0L);
					break;

				case VK_F6:
					/*** User pressed F6. ***/
					if (lpmsg->hwnd)
						PostMessage(GetParent(lpmsg->hwnd), WM_COMMAND, IDM_ADDRESS, 0L);
					break;

				case VK_BACK:
					/*** User pressed Backspace, check for CTRL key. ***/
					GetKeyboardState((LPBYTE) &States);
					if ((States[VK_CONTROL] & 0x80) && lpmsg->hwnd){
						PostMessage(GetParent(lpmsg->hwnd), WM_COMMAND, WM_KEYCTRLBACK, 0L);
						return TRUE;
					}
					break;

				case 'T':
				case VK_DELETE:
					/*** User pressed Backspace, check for CTRL key. ***/
					GetKeyboardState((LPBYTE) &States);
					if ((States[VK_CONTROL] & 0x80) && lpmsg->hwnd){
						PostMessage(GetParent(lpmsg->hwnd), WM_COMMAND, WM_KEYCTRL_T, 0L);
						return TRUE;
					}
					break;

		}
	}

	/*** Check for a function key [F10] going to a dialog box. ***/
	if ((nCode == MSGF_DIALOGBOX) && (lpmsg->message == WM_SYSKEYDOWN) &&
			(lpmsg->wParam == VK_F10) && (lpmsg->hwnd)) {
		/*** Simulate an OK message if [F10] was pressed. ***/
		SetFocus(GetDlgItem(GetParent(lpmsg->hwnd), IDM_OK));
		SendMessage(GetParent(lpmsg->hwnd), WM_COMMAND, IDM_OK, 0L);
		return 0;
	}

	/*** Call the default message hook procedure. ***/
	DefHookProc(nCode, wParam, lParam, &lpFilterFunc);

	return 0;
}
