/****************************************************************************
	FILE:		import.c


	CONTENTS:   ImportFile()	retrieves an import file name.

	COMMENTS:	This file contains all the functions related to importing
				files into a mail message.
****************************************************************************/
#include "MyMail.h"
#include "string.h"
#include "commdlg.h"
#include "dir.h"
/******************************************************************************
	FUNCTION:	ImportFile()

	PURPOSE:	retrieves an import file name using a common dialog box.
*******************************************************************************/

GLOBALHANDLE ImportFile(HWND hDlg)
{

	OPENFILENAME 	ofn;
	GLOBALHANDLE    hFileName;
	DWORD 			Errval;	// Error value
	char 			buf[15];	// Error buffer
	char 			szFilter[] = "All Files (*.*)\0*.*\0Text Files (*.txt)\0*.txt\0";
	char 			szName[500], curdir[128], TempBuff[32], far *textstr;
	BOOL			bError;


	/*** Save the current working directory (cwd) -- then ***/
	/*** reset the cwd to the default directory (DEF_DIR) ***/
	getcwd((char *) curdir, 128);
	setcwd(Options.defdir);

	/*** Initialize the OPENFILENAME structure ***/
	lstrcpy((LPSTR)&szName, "*.*");
	ofn.lStructSize = sizeof( OPENFILENAME );
	ofn.hwndOwner = hDlg;				// An invalid hWnd causes non-modality
	ofn.hInstance = hInst;
	ofn.lpstrFilter = (LPSTR)szFilter;
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = (LPSTR)szName;		// Stores the result in this variable
	ofn.nMaxFile = sizeof( szName );
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = Options.defdir;
	ofn.lpstrTitle = "Select a File to Import";	// Title for dialog
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLEHOOK;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = "*";
	ofn.lCustData = NULL;
	ofn.lpfnHook = (DLGHOOKPROC) MakeProcInstance((FARPROC)SaveHook, hInst);
	ofn.lpTemplateName = NULL;

	/*** Call the Open File common dialog box ***/
	bError = GetOpenFileName( &ofn );

	/*** Free up the procedure memory. ***/
	FreeProcInstance((FARPROC)ofn.lpfnHook);

	/*** Reset the current working directory ***/
	setcwd(curdir);

	if(bError == FALSE) {
		/*** Possible error occured ***/
		Errval=CommDlgExtendedError();
		if(Errval!=0) {					// 0 value means user selected Cancel
			wsprintf((LPSTR) &TempBuff,"Error = %ld",Errval);
			BWCCMessageBox(hWnd, "Unable to Choose Files", TempBuff, MB_ICONSTOP | MB_OK);
		}
		return NULL;
	}

	/*** Pass on the selected file name ***/
	if ((hFileName = SafeAlloc(GLOBAL, 115L, hDlg)) != NULL) {
		textstr = GlobalLock(hFileName);
		lstrcpy(textstr, (LPSTR)&szName);
		GlobalUnlock(hFileName);
	}

	/*** The filename is passed back by setting the return value to its LocalHandle ***/
	return(hFileName);

}

