/****************************************************************************
	FILE:		font.c


	CONTENTS:	ChangeFont()	changes the font in a given window.
				FontPick() 		lets user select font(s).
				GetFontHeight()	finds the average height of current font.
				GetFontWidth()	finds the average width of current font.


	COMMENTS:	This file contains all the functions used to select or
				manipulate fonts.
****************************************************************************/
#include "MyMail.h"
#include "commdlg.h"
#include "string.h"
#include "stdlib.h"


/****************************************************************************
	FUNCTION:	ChangeFont()

	PURPOSE:	Sets a new font in the given window
****************************************************************************/
void ChangeFont(LOGFONT far *lf, HWND hTextWnd)
{
	HFONT 			hFont, hOldFont;

	/*** First grab a handle to the old font ***/
	hOldFont = SendMessage(hTextWnd, WM_GETFONT, 0, 0L);

    /*** Create a new font and assign it to the window ***/
	hFont = CreateFontIndirect(lf);
	SendMessage(hTextWnd, WM_SETFONT, hFont, TRUE);

	/*** Remove the old font from memory ***/
	if (hOldFont)
		DeleteObject(hOldFont);


	return;
}


/****************************************************************************
	FUNCTION:	FontPick()

	PURPOSE:	To allow user to select a font for various windows.

	COMMENTS:	This function relies on the common dialog boxes for
				the actual selecting of fonts.
****************************************************************************/
BOOL FontPick(HWND hDlg, WORD wParam, LOGFONT far *lf)
{

	CHOOSEFONT			chf;
	DWORD				CFflags;

	/*** Blank out the CHOOSEFONT structure ***/
	NullFill((LPSTR) &chf, sizeof(CHOOSEFONT));

	/*** Initialize the CHOOSEFONT fields ***/
	CFflags = CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT;
	chf.lStructSize 	= sizeof(CHOOSEFONT);
	chf.hwndOwner 		= hDlg;
	chf.hDC				= GetDC(hDlg);
	chf.lpLogFont	 	= (LOGFONT FAR *) lf;
	chf.iPointSize 		= 12;
	chf.Flags 			= CFflags;
	chf.rgbColors 		= RGB(0, 0, 0);
	chf.lCustData	 	= 0L;
	chf.lpfnHook 	   	= (FARPROC) NULL;
	chf.lpTemplateName 	= (LPSTR) NULL;
	chf.hInstance 		= (HANDLE) NULL;
	chf.lpszStyle		= (LPSTR) NULL;
	chf.nFontType		=  SCREEN_FONTTYPE;
	chf.nSizeMin		= 0;
	chf.nSizeMax		= 0;
	ReleaseDC(hDlg, chf.hDC);

	/*** Call the CHOOSEFONT dialog box ***/
	if (ChooseFont(&chf)) {
		SetDlgItemText(hDlg, wParam, (LPSTR) lf->lfFaceName);
		return TRUE;
	}
	return FALSE;

}


/******************************************************************************
	FUNCTION:	GetFontHeight()

	PURPOSE:	Returns the average height of the font used in the given window
*******************************************************************************/
GetFontHeight(HWND hwnd)
{
	HDC			hDC;
	TEXTMETRIC	tm;

	/*** Use the device context and the textmetrics     ***/
	/*** structure to find the average character Height. ***/
	hDC = GetDC(hwnd);
	GetTextMetrics(hDC, &tm);
	ReleaseDC(hwnd, hDC);
	return(tm.tmExternalLeading + tm.tmHeight);
}


/****************************************************************************
	FUNCTION:	GetFontWidth()

	PURPOSE:	Returns the average width of the font used in the given window
****************************************************************************/
int GetFontWidth(HWND hwnd)
{
	HDC			hDC;
	TEXTMETRIC	tm;

	/*** Use the device context and the textmetrics     ***/
	/*** structure to find the average character width. ***/
	hDC = GetDC(hwnd);
	GetTextMetrics(hDC, &tm);
	ReleaseDC(hwnd, hDC);
	return (tm.tmAveCharWidth);

}

