/****************************************************************************
	FILE:		file.c


	CONTENTS:	MultiSave()		procedure for saving multiple messages to one
								file.
				ParseName()		utlity for parsing the name from a filename
								path combination.
				SaveHook()		hook procedure for common dialog box.


	COMMENTS:	If the user selects file from the Folder window and multiple
				messages have been selected, the MuliSave() function will be
				called.  This procedure stores only the text from the selected
				messages.  SaveFile() is called when only one message is
				selected or if File is called from the Read window.  This
				procedure allows the saving of attachments as well as the
				message text.
****************************************************************************/

#include "MyMail.h"
#include "string.h"
#include "io.h"
#include "commdlg.h"
#include "dos.h"
#include "dir.h"


/****************************************************************************
	FUNCTION: 	MultiSave()

	PURPOSE:  	Allows users to save multiple messages to one DOS file
****************************************************************************/
MultiSave(long lParam)
{
	char 			MsID[14], FoldName[32], TempBuff[256], buff[80], far *MsgID,
					far *textstr, FileBuff[256], PathBuff[256], curdir[128],
					szFilter[] = "All Files (*.*)\0*.*\0", Buff[1040];
	int 			fhandle, i, j;
	Env				env;
	unsigned int 	tabset[2], NumItems;
	FARPROC			lpfnBarGraf;
	HWND			hEdit;
	DWORD			Errval, textSize;
	RECT			Rect;
	HDC				hDC;
	GLOBALHANDLE	hMessage, hEditDS, hFolder;
	MailFolder far *CurFolder;
	unsigned short	bytes, offset, index, RetCount;
	CallStatus		uStat;
	HFONT			hFont;
	TEXTMETRIC		tm;
	OPENFILENAME 	ofn;
	BodyPart		Body[11];
	Attach_Rec		aRec;
	unsigned long	ulPercent, ulBytes, ulSize, numparts;


	/***** Get the Message ID Array and Folder Name ***/
	NumItems = GetLetterInfo((LPSTR) &MsID,  (LPSTR) &FoldName, lParam,  &hTempArr);

	/*** Use the Default Directory and filename to prime the OpenFileName structure ***/
	lstrcpy((LPSTR) &PathBuff, Options.defdir);
	lstrcpy((LPSTR) &FileBuff, "message.txt");
	lstrcpy((LPSTR) &TempBuff, (LPSTR) &FileBuff);

	/*** Save the current working directory (cwd) -- then ***/
	/*** reset the cwd to the default directory (DEF_DIR) ***/
	getcwd((char *) curdir, 128);
	setcwd(Options.defdir);

	/*** Initialize the OPENFILENAME structure ***/
	ofn.lStructSize = sizeof( OPENFILENAME );
	ofn.hwndOwner = hWnd;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = (LPSTR)szFilter;
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = (LPSTR) &TempBuff;		// Stores the result in this variable
	ofn.nMaxFile = sizeof( TempBuff );
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = Options.defdir;
	ofn.lpstrTitle = "Select a File Name and Path";	// Title for dialog
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT |
				OFN_ENABLEHOOK | OFN_ENABLETEMPLATE;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = "*";
	ofn.lCustData = NULL;
	ofn.lpfnHook = (DLGHOOKPROC) MakeProcInstance((FARPROC)SaveHook, hInst);
	ofn.lpTemplateName = MAKEINTRESOURCE(MsgSaveBox);


	/*** Call the Open File common dialog box ***/
	if(GetSaveFileName( &ofn ) != TRUE) {

		/*** Possible error occured ***/
		Errval=CommDlgExtendedError();
		if(Errval!=0) {					// 0 value means user selected Cancel
			wsprintf((LPSTR) &TempBuff,"Error = %ld",Errval);
			BWCCMessageBox(hWnd, "Unable to Choose Files", TempBuff, MB_ICONSTOP | MB_OK);
		}
		setcwd(curdir);
		FreeProcInstance((FARPROC)ofn.lpfnHook);
		SafeFree(GLOBAL, hTempArr);
		return;
	}

	/*** Free up the procedure memory. ***/
	FreeProcInstance((FARPROC)ofn.lpfnHook);

	/*** Copy the selected filename to FileBuff and the path to PathBuff ***/
	lstrcpy((LPSTR) &FileBuff, (LPSTR) &TempBuff + ParseName((LPSTR)&TempBuff));
	lstrcpy((LPSTR) &PathBuff, (LPSTR) &TempBuff);
	PathBuff[ParseName((LPSTR)&TempBuff)] = '\0';


	/**** Copy Messages to Specified File ***/
	/*** Open/Create the Specified file ***/
	if ( (fhandle = (_lcreat(TempBuff, 0)) ) == HFILE_ERROR){
		BWCCMessageBox(hWnd, "Unable to Open File -- Invalid File Name.", "WARNING!", MB_ICONSTOP | MB_OK);
		setcwd(curdir);
		SafeFree(GLOBAL, hTempArr);
		return;
	}

	/*** Create and initialize the Bar Graph dialog box for displaying progress ***/
	bUserAbort = FALSE;
	lpfnBarGraf = MakeProcInstance(BarGraf, hInst);
	hDlgCancel = CreateDialog(hInst, MAKEINTRESOURCE(BarGrafBox), hWnd, lpfnBarGraf);
	wsprintf((LPSTR) &buff, "Saving to: %s", (LPSTR) &FileBuff);
	SendMessage(hDlgCancel, WM_SETTEXT, NULL, (LONG) &buff);
	SendMessage(hDlgCancel, WM_NEXTSTEP,  0, 1L);

	/*** Create a New Data Segment for the Edit window. ***/
	/*** This will maximize the edit control's available memory. ***/
	hEditDS = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT | GMEM_SHARE, 256L);
	if (hEditDS == NULL) {
		hEditDS = hInst;  // Allocation failed; use default.
	}

	/*** Create a temporary invisible edit window for formatting the messages ***/
	hEdit = CreateWindow("edit", "", WS_CHILD | ES_MULTILINE, 0, 0,
			200, 200, hWnd, PB_EDIT, hEditDS, NULL);

	/*** Unable to create the edit window ***/
	if (!hEdit) {
		/*** Change Cursor back to Arrow ***/
		SetCursor(LoadCursor(NULL, IDC_ARROW));
		setcwd(curdir);
		BWCCMessageBox(hWnd, "Unable to Format Mail Message!", "WARNING!", MB_OK | MB_ICONEXCLAMATION);
		SafeFree(GLOBAL, hTempArr);
		_lclose(fhandle);
		unlink((char *) TempBuff);
		return;
	}

	/*** Set the font and tab settings in the hidden edit window ***/
	/*** Change Font and set tabs. ***/
	hFont = GetStockObject(ANSI_FIXED_FONT);
	SendMessage(hEdit, WM_SETFONT, hFont, NULL);

	/*** Calculate the Options.linelength size for window -- then resize. ***/
	_fmemset((void far *) &TempBuff, 'A', Options.linelength);
	TempBuff[Options.linelength] = '\0';
	hDC = GetDC(hEdit);
	SelectObject(hDC, hFont);
	textSize = GetTextExtent(hDC, (LPSTR) &TempBuff,  Options.linelength);
	ReleaseDC(hEdit, hDC);
	SendMessage(hEdit, EM_GETRECT, 0, (LPARAM) (RECT far *) &Rect);
	Rect.right = LOWORD(textSize) + Rect.left;
	Rect.bottom += Rect.top;
	Rect.top = Rect.left = 0;
	SendMessage(hEdit, EM_FMTLINES, FALSE, 0L);
	SendMessage(hEdit, EM_SETRECT, 0, (LPARAM) (RECT far *) &Rect);
	MoveWindow(hEdit, 0, 0, Rect.right, Rect.bottom, TRUE);
	SendMessage(hEdit, EM_FMTLINES, TRUE, 0L);


	/*** Get a pointer to the array of Message ID numbers ***/
	MsgID 	= (char far *) GlobalLock(hTempArr);
	hFolder = GetFolder2((LPSTR) &FoldName);
	CurFolder = (MailFolder far *) GlobalLock(hFolder);
	lstrcpy(aRec.FoldName, FoldName);
	aRec.UseDef = FALSE;

	/*** Initialize the Bar Graf. ***/
	SendMessage(hDlgCancel, WM_NEXTSTEP,  0, 0L);
	DeClogDlgMsg(hDlgCancel);

	/*** Format the text of one message at a time and copy the text ***/
	/*** to the open file. Messages are then seperated with "# # #". ***/
	for(i=0; (i<NumItems) && (!bUserAbort); i++) {
		lstrncpy(MsID, &(MsgID[i*14]), 14);


		/*** If saving only one message,  use the bar graf to show ***/
		/*** the progrss of the one message, so grab its size first. ***/
		if (NumItems == 1) {
			RetCount = 0;
			ulSize = MAXBODY;
			NullFill((char far *) &Body, sizeof(BodyPart) * 11);
			uStat=VnsGetMailBodyPartSize(hVNMAS, UserName, FoldName, MsID, MAINBODY, &ulSize);
			if (Recover(uStat))
				uStat=VnsGetMailBodyPartSize(hVNMAS, UserName, FoldName, MsID, MAINBODY, &ulSize);
			numparts = (ulSize/1024) + 2;
		}

		wsprintf((LPSTR) &buff, "Saving to: %s", (LPSTR) &FileBuff);
		SendMessage(hDlgCancel, WM_SETTEXT, NULL, (LONG) &buff);
		wsprintf((LPSTR) &buff, "Message %i of %i", i+1, NumItems);
		SendDlgItemMessage(hDlgCancel, BG_TITLE, WM_SETTEXT, NULL, (LONG) &buff);
		DeClogDlgMsg(hDlgCancel);

		if (FormatEnvelope((LPSTR) &FoldName, (LPSTR) &MsID, &env, &hMessage, hEdit, TRUE) != TRUE) {
			/*** Error occurred in formatting message ***/
			/*** Change Cursor back to Arrow ***/
			SetCursor(LoadCursor(NULL, IDC_ARROW));
			DspMsgCode( hDlgCancel, "Error Reading a Mail Message", 0, FALSE );
			break;
		}
		else {

			/*** Check for Cancel being pressed ***/
			if (bUserAbort)
				break;

			/*** Write the envelope string to the file then free the string's memory ***/
			textstr = GlobalLock(hMessage);
			_lwrite(fhandle, (void huge *) textstr, (unsigned int) lstrlen(textstr));
			SafeFree(GLOBAL, hMessage);

			/*** Update the Bar Graf. ***/
			if (NumItems == 1)
				ulPercent = 100L/numparts;
			else
				ulPercent = ((unsigned long)i*100L)/(unsigned long)NumItems;
			SendMessage(hDlgCancel, WM_NEXTSTEP,(unsigned) ulPercent, 0L);
			DeClogDlgMsg(hDlgCancel);

			/*** Read in the body parts and write them to the output file ***/
			NullFill((LPSTR) &Buff, 1024);
			offset = 0;
			do {
				uStat = VnsGetMailBodyPart(hVNMAS, UserName, FoldName, MsID, MAINBODY, (LPSTR) Buff, offset, (unsigned short WFAR *) &bytes);
				if (uStat == 0) {
					if (bytes > 0) {
						_lwrite(fhandle, (void huge *) &Buff, (unsigned int) bytes);
					}
					offset++;
				}
				else {
					wsprintf((LPSTR)&Buff,"Error Reading Message = %ld", uStat);
					BWCCMessageBox(hDlgCancel, Buff, "Error", MB_ICONSTOP | MB_OK);
					bytes = 0;
				}

				/*** If just one message, update the bar graf. ***/
				if (NumItems == 1) {
					ulPercent = ((unsigned long)offset*100L)/(unsigned long)numparts;
					SendMessage(hDlgCancel, WM_NEXTSTEP,(unsigned) ulPercent, 0L);
					DeClogDlgMsg(hDlgCancel);
				}

			} while(bytes!=0 && !bUserAbort);

			/*** Write the message seperator ***/
			if (NumItems > 1)
				_lwrite(fhandle, "\x0D\x0A\x0D\x0A# # #\x0D\x0A\x0D\x0A", 13);

			/*** Check for attachments. ***/
			if (ofn.lCustData) {
				index = FindID(hFolder, MsID);
				if (CurFolder->Item[index].flags & ATTACHED) {

					/*** Retrieve info on the attached files ***/
					RetCount = 0;
					NullFill((char far *) &Body, sizeof(BodyPart) * 11);
					uStat=VnsGetMailBodyPartList(hVNMAS, MsID, Body, &RetCount);
					if (Recover(uStat))
						uStat=VnsGetMailBodyPartList(hVNMAS, MsID, Body, &RetCount);
					if (uStat) {
						wsprintf((LPSTR)&Buff,"Error Reading Attachment Names = %ld", uStat);
						BWCCMessageBox(hDlgCancel, Buff, "Error", MB_ICONSTOP | MB_OK);
					}
					else {
						/*** Loop through and save each attachment. ***/
						lstrcpy(aRec.MsID, MsID);
						for(j=1;j<RetCount && !bUserAbort;j++) {
							wsprintf((LPSTR) &buff, "Attachment %i of %i", j, RetCount-1);
							SendDlgItemMessage(hDlgCancel, BG_TITLE, WM_SETTEXT, NULL, (LONG) &buff);
							aRec.Partnum = j;
							SaveAttachments(hDlgCancel, &aRec, (BodyPart far *) &Body);
						}
					}
				}
			}

			/*** Release the Envelope. ***/
			VnsReleaseMailEnvelope(hVNMAS, MsID);


		}

	}

	/*** Finish up the BarGraf display. ***/
	SendMessage(hDlgCancel, WM_NEXTSTEP,  100, 0L);
	DeClogDlgMsg(hDlgCancel);

	/*** Free the message array memory and close the output file ***/
	SafeFree(GLOBAL, hTempArr);
	_lwrite(fhandle, "\0", 1);
	_lclose(fhandle);
	GlobalUnlock(hFolder);

	/*** Wait for the OK button to be pressed. ***/
	if (!bUserAbort)
		DestroyWindow(GetDlgItem(hDlgCancel, IDCANCEL));
	while (hDlgCancel) DeClogDlgMsg(hDlgCancel);

	if (!bUserAbort)
		/*** Close the Bar Graph dialog ***/
		DestroyWindow(hDlgCancel);
	else {
		/*** User pressed cancel so delete the output file ***/
		/*** Do an Unlink (Unlink == Delete) on the created file ***/
		unlink((char *) TempBuff);
		BWCCMessageBox(hWnd, "File Save Aborted!", "HappyMail", MB_OK | MB_ICONEXCLAMATION);
	}

	/*** Reset the current working directory ***/
	setcwd(curdir);

	/*** Free the memory for the BarGraf dialog procedure. ***/
	hDlgCancel = NULL;
	FreeProcInstance(lpfnBarGraf);
	DestroyWindow(hEdit);
	SafeFree(GLOBAL, hEditDS);
	return;
}


/****************************************************************************
	FUNCTION: 	ParseName()

	PURPOSE:  	Returns an index to the beginning of a file name in a path-
				file name combo.
****************************************************************************/
int ParseName(char far *FilePath)
{
	int len;
	len = lstrlen(FilePath);
	len--;
	while (len >= 0 && FilePath[len] != '\\' && FilePath[len] != ':') len--;
	return(++len);
}



/******************************************************************************
	FUNCTION:	SaveHook()

	PURPOSE:	Dialog Procedure for Common Dialog Save As Box

    COMMENTS:   Purpose of this hook is to center the dialog box and
                add a period to names with no extensions
*******************************************************************************/
#pragma argsused
UINT CALLBACK _export SaveHook(HWND hDlg, UINT message, WORD wParam, LONG lParam)
{

	static OPENFILENAME far *ofnptr;
	char	buff[15], i;

	switch (message) {
		case WM_INITDIALOG:       	     /* message: initialize dialog box */
			/*** Stretch the window, then Center it. ***/
			CenterWindow(hDlg, GetDesktopWindow());

			/*** Add a period to names without one. ***/
			SendDlgItemMessage(hDlg, FILE_NAME, WM_GETTEXT, 15, (long) buff);
			for(i=0; i<15 && buff[i] != '\0' && buff[i] != '.';i++);
			if (buff[i] != '.') {
				lstrcat((LPSTR) &buff, ".");
				SendDlgItemMessage(hDlg, FILE_NAME, WM_SETTEXT, NULL, (long) buff);
			}

			ofnptr = (OPENFILENAME far *)lParam;
			return (TRUE);

		case WM_COMMAND:
			if (wParam == IDOK) {
				SendDlgItemMessage(hDlg, FILE_NAME, WM_GETTEXT, 15, (long) buff);
				for(i=0; i<15 && buff[i] != '\0' && buff[i] != '.';i++);
				if (buff[i] != '.') {
					lstrcat((LPSTR) &buff, ".");
					SendDlgItemMessage(hDlg, FILE_NAME, WM_SETTEXT, NULL, (long) buff);
				}

				ofnptr->lCustData = (DWORD) IsDlgButtonChecked(hDlg, MSV_SAVEATTACH);
			}

	} /** end switch (message) **/

	return (FALSE);
}




