/****************************************************************************
	FILE:		about.c


	CONTENTS:   About()	- window procedure for the About dialog box.
				Logo()	- window procedure for the Logo dialog box.


	COMMENTS:	The About dialog states version, name, and programmer.
				The Logo box redisplays the opening Logo with some added
				animation and sound.    
****************************************************************************/
#include "mymail.h"
#include "mmsystem.h"


/****************************************************************************
    FUNCTION:	About()

	PURPOSE:	Processes messages for "About" dialog box
****************************************************************************/
BOOL FAR PASCAL _export About(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{

	/*** Send Window Messages to Status Bar ***/
	StatBarCtrlMsg(hDlg, AboutBox, message, wParam, lParam);

	switch (message) {
        case WM_INITDIALOG:
            /*** Center the Dialog Window in the HappyMail Main window ***/
			CenterWindow(hDlg, GetDesktopWindow());
			return (TRUE);

		case WM_COMMAND:
        	/*** Received an OK or Close command ***/
			if (wParam == IDM_OK || wParam == IDCANCEL) {
				EndDialog(hDlg, TRUE);
                return (TRUE);
			}
			break;

    } /* end switch (message) */
    return (FALSE);               /* Didn't process a message    */
}




/****************************************************************************

    FUNCTION:	Logo()

	PURPOSE:	Processes messages for "SplashBox" dialog box

****************************************************************************/
#pragma argsused
BOOL FAR PASCAL _export Logo(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{

	int 		x, i, BM_Arr[] = {0,1,2,3,2,1,7,4,5,6,5,4,7,8,9,10,11,12};
	HDC			hDC, hdcMem;
	HBITMAP		hBitMap, hBM[BitMapTotal];
    PAINTSTRUCT	ps;
	BITMAP 		bm;
	HMENU		hMenu;
	RECT		Rect;
    HRSRC		hrSound;
    HGLOBAL		hgSound;

    switch (message) {
        case WM_INITDIALOG:
            /*** Load the Logo Bitmap and find its size (for resizing the window) ***/
			hBitMap = LoadBitmap(hInst, (LPSTR) "ScrnLogo");
            hDC = GetDC(hDlg);
			hdcMem = CreateCompatibleDC(hDC);
			if (hdcMem == NULL)
				return (TRUE);
			SelectObject(hdcMem, hBitMap);
			SetMapMode(hdcMem, GetMapMode(hDC));
			GetObject(hBitMap, sizeof(BITMAP), (LPSTR) &bm);
			ReleaseDC(hDlg, hDC);
			DeleteDC(hdcMem);
			DeleteObject(hBitMap);

			/*** Resize window to match size of Logo Bitmap and center it ***/
			MoveWindow(hDlg, 0, 0, bm.bmWidth+2, bm.bmHeight+GetSystemMetrics(SM_CYCAPTION)+1, FALSE);
			CenterWindow(hDlg, GetDesktopWindow());

            /*** Modify system Menu to add the WAG command ***/
			hMenu = GetSystemMenu(hDlg, FALSE);
			AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
			AppendMenu(hMenu, MF_ENABLED, IDM_WAG, (LPCSTR) "&Wag"); 
			return (TRUE);

		case WM_SYSCOMMAND:
			/*** WAG command was selected from the system menu	***/
			if (wParam == IDM_WAG) {
				/*** Play the BOING.WAV soundfile							 ***/
				/*** Use ASYNC mode so that on machines that are capable the ***/
				/*** sound will play in the background while the tongue wags ***/	
				hrSound = FindResource(hInst, MAKEINTRESOURCE(HappySnd), RT_RCDATA);
				if (hrSound != NULL) {
            		hgSound = LoadResource(hInst, hrSound);
					sndPlaySound(LockResource(hgSound), SND_ASYNC | SND_MEMORY);
				}

				hDC = GetDC(hDlg);

				/*** Load the animation bitmaps and store their ***/
				/*** handles in the Bitmap handle array -- hBM. ***/
				for (i=0;i<BitMapTotal;i++)
					hBM[i] = LoadBitmap(hInst, MAKEINTRESOURCE(7700+i));


				/*** Animate Logo by drawing the bitmaps -- if machines get ***/
				/*** much faster, will probably need to add some delays to  ***/
                /*** slow down the motion. 									***/
				for (i=17; i>12; i--)
					DrawBitMap(hDC, hBM[BM_Arr[i]], 45, 210, TRUE, FALSE);

				for (x=0; x<8; x++)
    			    for (i=0; i<13; i++)
						DrawBitMap(hDC, hBM[BM_Arr[i]], 45, 210, TRUE, FALSE);

				for (i=13; i<18; i++)
					DrawBitMap(hDC, hBM[BM_Arr[i]], 45, 210, TRUE, FALSE);


                /*** Done drawing -- Delete the bitmaps to recover the memory ***/
				for (i=0; i<BitMapTotal; i++)
					DeleteObject(hBM[i]);
				ReleaseDC(hDlg, hDC);

                /*** Stop the music ***/
				sndPlaySound(NULL, SND_ASYNC);
				UnlockResource(hgSound);
				FreeResource(hgSound);
			}
			break;

		case WM_PAINT:
			/*** Need to repaint -- so do the sound and wag as well ***/
			hDC = BeginPaint(hDlg, &ps);
			hBitMap = LoadBitmap(hInst, (LPSTR) "ScrnLogo");
			if (hBitMap != NULL) {
				DrawBitMap(hDC, hBitMap, 0, 0, TRUE, TRUE);

                /*** Play the BOING ***/
				hrSound = FindResource(hInst, MAKEINTRESOURCE(HappySnd), RT_RCDATA);
				if (hrSound != NULL) {
					hgSound = LoadResource(hInst, hrSound);
					sndPlaySound(LockResource(hgSound), SND_ASYNC | SND_MEMORY);
				}

				/*** Load the Bitmaps ***/
				for (i=0;i<BitMapTotal;i++)
					hBM[i] = LoadBitmap(hInst, MAKEINTRESOURCE(7700+i));

				/*** Wag the tongue ***/
				for (x=0; x<8; x++)
					for (i=0; i<13; i++)
						DrawBitMap(hDC, hBM[BM_Arr[i]], 45, 210, TRUE, FALSE);
				for (i=13; i<18; i++)
					DrawBitMap(hDC, hBM[BM_Arr[i]], 45, 210, TRUE, FALSE);

				/*** Delete the bitmaps ***/
				for (i=0; i<BitMapTotal; i++)
					DeleteObject(hBM[i]);
				DeleteObject(hBitMap);

				/*** Stop the sound ***/
				sndPlaySound(NULL, SND_ASYNC);
				UnlockResource(hgSound);
				FreeResource(hgSound);
			}
			EndPaint(hDlg, &ps);
			return (TRUE);

		case WM_COMMAND:
			/*** Received a Cancel or a Close ***/
			if (wParam == IDCANCEL) {
				EndDialog(hDlg, TRUE);
				return (TRUE);
			}
			break;
	} /* end switch (message) */
    return (FALSE);               /* Didn't process a message    */
}

