* For normal .DBF and .NTX testing, leave both comment sections below
* commented
*
#define TOTAL_RECORDS 100

FIELD Field1, Field2, Field3 IN Test
LOCAL nCount
* * * * FOR COMIX * * * * * * * *
*  REQUEST DBFCMX             // Force a link to FlexFile
*  RDDSETDEFAULT("DBFCMX")    // Set the Default RDD to Comix
* * * * FOR FLEXFILE* * * * * * *
*  REQUEST FLEXFILE           // Force a link to FlexFile
*  RDDSETDEFAULT("FLEXFILE")  // Set the Default RDD to FlexFile
* * * * * * * * * * * * * * * * *
*  V_SUPERRDD("DBFCMX")       // Set COMIX on top of FlexFile
* * * * * * * * * * * * * * * * *

* Create a Test database
DBCREATE("TEST", {{"Field1","C",10,0},{"Field2","C",10,0},;
                  {"Field3","C",10,0},{"Field4","C",10,0}},)

USE Test                             // Open Database in Single User Mode
INDEX ON UPPER(Field1) TO Test1      // Create Index 1
INDEX ON UPPER(Field2) TO Test2      // Create Index 2
INDEX ON UPPER(Field3) TO Test3      // Create Index 3
USE Test INDEX Test1,Test2,Test3     // Open Database and indexes
FOR nCount := 1 TO TOTAL_RECORDS     // Loop for creating records
    APPEND BLANK                     // Add a blank record
    Field1 := STR(nCount)            // Make dummy field assignments
    Field2 := "Field2"
    Field3 := "Field3"
NEXT nCount                          // End of Loop
USE                                  // Close Database and End
                                  
