(*
  Copyright 1995, Richard Hansen.
  All rights reserved.

  This source code may be freely distributed and used. The author
  accepts no responsibility for its use or misuse.
*)

unit HintEdit;

interface

uses
  DsgnIntf, SysUtils, WinTypes, WinProcs, Messages, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls, Buttons, Menus;

type
  TfrmHintEditor = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    memTip: TMemo;
    txtHint: TEdit;
  end;

 THintProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

procedure Register;

implementation

{$R *.DFM}

function THintProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paMultiSelect, paAutoUpdate];
end;

procedure THintProperty.Edit;

  procedure ParseText(Lines : TStrings; const S : String);
  var
    x : Integer;
    Temp : String;

  begin
    if (S <> '') then begin
      Temp := '';

      for x := 1 to Length(S) do begin
        if S[x] = #13 then begin
          Lines.Add(Temp);
          Temp := '';
        end

        else
          Temp := Temp + S[x];
      end;

      if (Temp <> '') then
        Lines.Add(Temp);
    end;
  end;

  procedure ExtractText(Lines : TStrings; var S : String);
  var
    x : Integer;

  begin
    for x := 0 to Lines.Count - 1 do begin
      if (x <> 0) then
        S := S + #13;

      S := S + Lines[x];
    end
  end;

var
  Editor : TfrmHintEditor;
  x : Integer;
  S : String;

begin
  Editor := TfrmHintEditor.Create(Application);

  try
    S := GetStrValue;
    x := Pos('|', S);

    if (x > 0) then begin
      ParseText(Editor.memTip.Lines,  Copy(S, 1,x-1));
      Editor.txtHint.Text := Copy(S, x+1, Length(S));
    end

    else
      Editor.txtHint.Text := S;

    if (Editor.ShowModal = mrOK) then begin
      S := '';
      ExtractText(Editor.memTip.Lines, S);

      if (S <> '') then
        S := S + '|';

      if (Editor.txtHint.Text <> '') then
        S := S + Editor.txtHint.Text;

      SetStrValue(S);
    end;
  finally
    Editor.Free;
  end;
end;


procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(String), TControl, 'Hint', THintProperty);
end;

end.

