.**********************************************************************
.* hfs.ipf
.**********************************************************************

:userdoc.
:docprof toc=12.

.nameit symbol=HFS text='HFS/2'

:title.&HFS.

.**********************************************************************
:h1.Title page
.**********************************************************************

:font facename=Helv size=28x18.
.ce HFS/2
:font facename=default size=0x0.
.ce A Hierarchical File System Driver for OS/2
.ce Copyright (C) 1996, 1997 by Marcus Better
.ce Based on "MacFS", Copyright (C) 1996 by
.ce Peter A. Dinda, George C. Necula, and Morgan Price

.**********************************************************************
:h1 id=100.Introduction
.**********************************************************************

:p.  
&HFS. is a file system driver for OS/2 
that reads and writes
Macintosh disks. With &HFS., Macintosh-formatted media can be used
seamlessly in OS/2.  The program has been tested with 
1.44MB diskettes :link reftype=fn refid=diskette.(**):elink.
and CD-ROMs. Other removable media may also work, and
fixed-disk support will be added in future releases.

:hp8.
:warning.
This program is in an early, experimental stage, and may still have
bugs and problems.  
You should backup your system before using the program,
and make backup copies of any diskettes that you use with this program.
:ewarning.
:ehp8.
&HFS. is based on MacFS, a free, portable implementation of the
Macintosh Hierarchical File System by Peter A. Dinda, George
C. Necula, and Morgan Price. The source code for MacFS is incorporated
in &HFS., slightly modified. I have found it helpful to 
look at the source code of Matthieu Willm's ext2-os2 driver and the
ext2flt partition filter written by Deon van der Westhuysen. The IFS part of
&HFS. follows an architecture for a split ring 0/ring 3 IFS described
in articles by Andre Asselin in the Electronic OS/2 Developer's
Magazine. Parts of &HFS. were developed using Eberhard Mattes' ports
of Emacs and gcc. 

:p.
&HFS. has been tested with OS/2 Warp versions 3 and 4.
The latest version of &HFS. is available on the World Wide Web at 
http&colon.//www.student.nada.kth.se/~f96-bet/HFS.

:p.
I hope you will find &HFS. useful. Comments, success/bug reports,
patches and ideas are always welcome. I am also interested
in hearing how &HFS. works with different types of media.

:p.
Marcus Better

:p.
:parml tsize=15 break=fit.
:pt.Email:
:pd.Marcus.Better@abc.se
:eparml.

.**********************************************************************
:h1 id=200.Licence and conditions of use
.**********************************************************************
:sl compact.
:li.:link reftype=hd refid=210.Licence for &HFS.:elink.
:li.:link reftype=hd refid=220.Licence for MacFS:elink.
:esl.

:h2 id=210.Licence for &HFS.

:p.
:hp8.
:nt text='Disclaimer'.
This program is supplied as is. The author assumes no responsibility
for damages which may result from the use of this program.
:ent.
:ehp8.
:p.
&HFS. may be used and freely distributed within the limits stated below.
You may also modify &HFS. and incorporate it in other programs within
these limits.

:ol.
:li.
&HFS. may be freely used for non-commercial purposes only.

:li.
If you alter &HFS. in any way and distribute the work, then that work
must be similarly free, and the source code must be freely available
to the public.
:eol.

:p.
This program incorporates MacFS, which is covered by a 
:link reftype=hd refid=220.licence:elink. of its own.

:p.
&HFS. is Copyright (C) 1996, 1997 by Marcus Better.

:h2 id=220.Licence for MacFS

:p.
:xmp.
WARNINGS
--------

THIS SOURCE CODE IS NOT PUBLIC DOMAIN, FREEWARE, SHAREWARE, or "COPY-LEFTED."

THIS SOURCE CODE MAY BE FREELY DISTRIBUTED UNDER THE LIMITS SPECIFIED BELOW.

THIS SOURCE CODE HAS NO ACTUAL OR IMPLIED WARRANTY OR GUARANTEE OF ANY
KIND FROM PETER A. DINDA, GEORGE C. NECULA, MORGAN PRICE, CARNEGIE MELLON
UNIVERSITY, OR ANY OTHER PARTY.

THIS SOURCE CODE IS NOT SUPPORTED BY PETER A. DINDA, GEORGE C. NECULA,
MORGAN PRICE, CARNEGIE MELLON UNIVERSITY, OR ANY OTHER PARTY.

To the best of our knowledge, this source code, "MacFS", is correct 
and suitable.  However, no warranty or guarantee of any kind, either actual
or implied, is provided for this software.  Additionally, no support is
provided for this software.  It is used at your own risk.

==============================================================================

LICENSE
-------

This source code, "MacFS", is 
                
  Copyright (c) 1996 by Peter A. Dinda, George C. Necula, and Morgan Price
                                         

Current version is available via:
    http&colon.//www.cs.cmu.edu/afs/cs.cmu.edu/usr/pdinda/html/pdinda.html
    ftp&colon.//ftp.cs.cmu.edu/user/pdinda

Permission is granted to distribute and freely use and extend "MacFS", or
to incorporate the "MacFS" source code into other software within these
limits&colon.

   0) "MacFS" and any derivatives of "MacFS" must retain this license,
display the above copyright notice when run, and include this file.

   1) "MacFS" and any derivatives of "MacFS" may only be freely used for
non-commercial purposes.  If you are interested in commercial use of
"MacFS", contact Peter A. Dinda (pdinda@cs.cmu.edu).

   2) "MacFS" and any derivatives of "MacFS" may not be used for military
purposes.

   3) Peter A. Dinda (pdinda@cs.cmu.edu) must be notified of any
derivatives of "MacFS"


In simple terms, "MacFS" may be freely used for any non-commercial,
non-military purposes.  Derivatives of "MacFS" must be similarly free
and Peter A. Dinda (pdinda@cs) must be notified of their existence.  
Commercial use of "MacFS" and commercial derivatives of "MacFS" are NOT
ALLOWED under this license.  To use "MacFS" commercially, contact
Peter A. Dinda (pdinda@cs.cmu.edu) for more information.



Peter August Dinda                                     pdinda@cs.cmu.edu
Doctoral Student, School of Computer Science, Carnegie Mellon University
   http&colon.//www.cs.cmu.edu/afs/cs.cmu.edu/usr/pdinda/html/pdinda.html
:exmp.

.**********************************************************************
:h1 id=300.Installation instructions
.**********************************************************************

:p.  
&HFS. can be installed automatically using the "Device Driver
Install" object in the "System Setup" folder, or by manually editing
CONFIG.SYS.  

:p.
:sl compact.
:li.:link reftype=hd refid=310.Automated installation:elink.
:li.:link reftype=hd refid=320.Manual installation:elink.
:esl.


:h2 id=310.Automated installation

:p.
The following steps describe how to install &HFS. on OS/2 Warp.
:ol.
:li.
Open the "Device Driver Install" object. It is located in the "System
Setup" folder.
:li.
In the "Source directory" box, press the "Change" button and enter the
directory where you unpacked the &HFS. distribution archive.
:li.
In the "Destination directory" box, enter your OS/2 boot drive.
:li.
Press the "Install" button.
:li.
A list box will be displayed with the line "HFS/2 - A Hierarchical
File System Driver for OS/2". Select this line and press "OK".
:li.
Optionally add the directory d&colon.\OS2\FS\HFS (where d&colon. is your boot
drive) to the PATH statement in the CONFIG.SYS file.
:li.
Reboot the computer.
:eol.

:p.  
If you intend to use a CD-ROM drive with &HFS., you will need to
make one further alteration to CONFIG.SYS. See the :link reftype=hd
refid=530.usage notes:elink. for more information.

:h2 id=320.Manual installation

:p.
The following steps describe how to install &HFS. manually.
:ol.
:li.
Unpack the distribution archive hfs:hp1.nnn:ehp1..zip into a directory
anywhere on your system.
:li.
Copy the file HFSFLT.FLT to the \OS2\BOOT directory of your boot drive
for OS/2 Warp, or the \OS2 directory for earlier versions of OS/2. 
:li.
Add the following line to the CONFIG.SYS file on your boot drive:
:xmp.IFS=d&colon.\path\HFS.IFS

:exmp.
where d&colon.\path\ is the path to the directory where you unpacked
the files. The line must be located after the IFS= statement for the
file system where &HFS. resides, if any. If you intend to use
&HFS. with CD-ROMs, you must also place the line before the line that
loads CDFS.IFS.
:li.
Add the line
:xmp.BASEDEV=HFSFLT.FLT

:exmp.
to the CONFIG.SYS file.
.*:li.
.*Copy the file :link reftype=fn refid=emxrt.emx.dll:elink.
.*to a directory on your DLLPATH. Usually \OS2\APPS\DLL
.*will do.
:li.
You may add the line
:xmp.RUN=d&colon.\path\HFS.EXE

:exmp.
to the CONFIG.SYS file to have the :link reftype=fn refid=control.control 
program:elink. HFS.EXE started in the background at boot time. This program
must be activated, either in this way or simply by running it from an OS/2
prompt, before using &HFS.. The control program can also be started
from STARTUP.CMD.
:li.
Reboot the computer.
:eol.

.**********************************************************************
:h1 id=400.Using &HFS.
.**********************************************************************

:p.
Using &HFS. is simple. You can access a Macintosh diskette almost like
an ordinary diskette. These are the steps involved in using a
Macintosh diskette with &HFS.&colon.
:ol compact.
:li.Make sure the control program is running.
:li.Insert the diskette into a diskette drive. 
:li.Access the files on the diskette in any way you like.
:li.Synchronize the data on the diskette by invoking the
:link reftype=hd refid=450.SYNC:elink. command.
:li.Remove the diskette from the drive.
:eol.

:p.
&HFS. is made up of several parts:
:ul compact.
:li.The :link reftype=hd refid=420.control program:elink..
:li.The IFS, HFS.IFS.
:li.The :link reftype=hd refid=440.filter driver:elink., HFSFLT.FLT.
:li.The utilities :link reftype=hd refid=450.SYNC.EXE:elink.
and :link reftype=hd refid=460.PREPARE.EXE:elink..
:eul.

.*********************************
:h2 id=420.The control program
.*********************************

:p.
The file HFS.EXE contains the :hp1.control program:ehp1.. It is the control
program that carries out most tasks on behalf of the file system
driver. HFS.EXE can be started either from an OS/2 prompt, with
a RUN= statement in CONFIG.SYS, or from STARTUP.CMD. The control
program must be running for &HFS. to be active.

:p.
HFS.EXE has the following command line syntax&colon.
:xmp.HFS.EXE [/FN&colon.mode]

:exmp.
where brackets indicate an optional parameter.

:dl tsize=14.
:dthd.:hp2.Option:ehp2.
:ddhd.:hp2.Description:ehp2.
:dt./FN&colon.:hp1.mode:ehp1.
:dd.
Set the file name translation mode. 

:p.
This option determines how &HFS. translates Macintosh file names that
contain 8-bit characters or characters that are illegal in OS/2 file names.
:hp1.mode:ehp1. can be any of CP850, 7BIT or 8BIT. The default is
CP850. See the section on :link reftype=hd refid=510.File name
translation:elink. for details.
:edl.

:p.
When the control program is started, it connects to the IFS and starts
processing file system requests. Macintosh volumes can be accessed
only when the control program is running. The control program will
refuse to load if another instance of the program is already running.

:warning.  
If the control program is interrupted while a Macintosh
diskette is mounted, data may be lost and the diskette left in an
inconsistent state.
:ewarning. 
It is best to leave the control program
running once it has been started.  If you need to interrupt it for some
reason, be sure to :link reftype=hd refid=450.sync:elink. and remove
all diskettes first.  The control program may also cause a fault as a
result of a bug. If this happens, you should remove the Macintosh
diskettes immediately. It may also be necessary to run the FSKILL
utility before continuing if the control program traps. FSKILL will
tell the IFS to disconnect from the crashed control program.


.****************************
:h2 id=440.The filter driver
.****************************

:p.
Because of the way OS/2 handles diskettes, a Macintosh diskette cannot
be used directly in an OS/2 system. The diskette needs an OS/2-compatible
boot sector in order to be recognized. The :hp1.filter driver:ehp1.,
HFSFLT.FLT, is used to take care of this problem.

:p.
HFSFLT.FLT is loaded as a base device driver when the system start up. It
operates by filtering input/output requests to any diskette drives in
the system. If the operating system tries to read the boot sector of a
diskette, the filter will first check if the diskette is formatted
with HFS. If this is the case, the filter will supply a fake boot
sector to the operating system. The filter does not alter any
data on the diskette itself.

:p.  
The filter driver is new in this release of &HFS..
If the filter doesn't work on your system for any reason, an
alternative is to use the :link reftype=hd
refid=460.PREPARE:elink. program.


.*********************************
:h2 id=450.Synchronizing a volume
.*********************************

:p.
When an HFS volume is accessed, the file system driver keeps 
some HFS data structures
in memory for performance reasons. Before the diskette is removed from
the drive, these structures must be written to the volume. This
is done by running the program SYNC.EXE.

:p.
Invoking SYNC is simple. Just type
:xmp.SYNC d&colon.

:exmp.
at a command prompt to sync the diskette in drive d&colon..
If you omit the drive letter, SYNC will use drive A&colon..
If the sync succeeds, the program will print a message saying that the
diskette may be removed.

:warning.
If you remove an HFS diskette from the drive without running SYNC first,
the diskette may be left in an inconsistent state. 
:ewarning.
:note.
If the diskette is write-protected, then no data can be written to
it. In that case, you do not need to use SYNC. The same applies to
CD-ROMs.

.************************************************
:h2 id=460.Preparing a diskette for use with &HFS.
.************************************************

:p.
In previous versions of &HFS., the PREPARE utility was used
instead of the :link reftype=hd refid=440.filter driver:elink..
It is no longer necessary to use PREPARE, and it is included
here only in case there are problems with the filter driver.

:p.
PREPARE.EXE writes an OS/2-style boot sector to the first sector of
the diskette. The syntax is
:xmp.PREPARE /P d&colon.

:exmp.
where d&colon. is the drive with the diskette to be prepared. If the
drive letter is omitted, PREPARE will assume drive A&colon..

:p.
PREPARE.EXE will save the original boot sector in a data file in the current
directory. The name  will be the hexadecimal serial number of the
diskette. If a file with that name already exists, PREPARE will complain
and not prepare the diskette.

:p.
In order to restore the boot sector from this data file, use the command
:xmp.PREPARE /R d&colon.

:exmp.
This will copy the saved original boot sector from the data file back
to the diskette. The data file must be found in the current directory,
or PREPARE will complain.

:p.
Macintosh diskettes usually do not need a boot sector unless they are
used to boot from. An HFS diskette will work in a Macintosh computer
even if it has an OS/2-style boot sector. If you do not intend to restore
a diskette, you can delete the data file generated by PREPARE.

:note.
If the Macintosh has PC Exchange installed, then you will need to
restore the boot sector before using the diskette on the Macintosh.

.**********************************************************************
:h1 id=500.Usage notes
.**********************************************************************
:sl compact.
:li.:link reftype=hd refid=510.File name translation:elink.
:li.:link reftype=hd refid=520.Icon conversion:elink.
:li.:link reftype=hd refid=530.Using a CD-ROM:elink.
:esl.

.********************************
:h2 id=510.File name translation
.********************************

:p.
The rules for naming files differ between OS/2 and Macintosh system.
The most notable difference is that Macintosh file names cannot exceed
31 characters in length. Certain characters, such as '/' and '\', are
not allowed in OS/2 file names, but are perfectly valid in HFS file names.
Moreover, the Macintosh uses a character set different from those found
on OS/2 systems.

:p.
To accomodate these differences, some sort of file name translation is
necessary. &HFS. supports several translation modes. The translation
mode can be set with a command line option to the :link reftype=hd
refid=420.control program:elink..

:p.
The following translation modes are supported.
:parml tsize=12 break=none.
.***
:pt.:hp4.CP850:ehp4.
:pd.This mode of translation tries to map characters in the Macintosh
character set to their equivalents in codepage 850. 
It is the default translation mode for &HFS..
:parml tsize=3.
:pt.Macintosh to OS/2&colon.
:pd.:ul compact.
:li.All valid characters in the range 32-127 except '%' remain unchanged.
:li.Characters in the range 128-255 that have an equivalent in codepage 850
map to that character.
:li.All other characters are replaced by the three characters 
'%xx', where xx is the character's hexadecimal representation.
:eul.
:pt.OS/2 to Macintosh&colon.
:pd.:ul compact.
:li.Characters 32-127 except '%' remain unchanged.
:li.Characters in the range 128-255 that have a Macintosh equivalent map
to it.
:li.The sequence '%xx' where xx is the hexadecimal representation of '%' 
becomes the '%' character. If xx is a hexadecimal number in the range
128-255 that does not have a Macintosh equivalent, 
then the sequence is replaced with that character. 
All other combinations of characters
are illegal, and will be rejected by &HFS..
:eul.
:eparml.
:p.
Note that some OS/2 file names will not be permitted by &HFS. with
this mode of translation, even though they may be short enough. This
is the price for eliminating name clashes.
.***
:pt.:hp4.7BIT:ehp4.
:pd.This translation mode quotes all characters in the range 128-255.
:parml tsize=3.
:pt.Macintosh to OS/2&colon.
:pd.:ul compact.
:li.Valid characters in the range 32-127 except '%' remain unchanged.
:li.All other characters are replaced by the three characters 
'%xx', where xx is the character's hexadecimal representation.
:eul.
:pt.OS/2 to Macintosh&colon.
:pd.:ul compact.
:li.Characters 32-127 except '%' remain unchanged.
:li.The sequence '%xx' where xx is the hexadecimal representation of
'%', a character in the range 32-127 not allowed in OS/2 file names, or
a character in the range 128-255, is mapped to the corresponding
character. In other cases, including when xx is not a hexadecimal
number, the combination is illegal, and will be rejected by &HFS..
:eul.
:eparml.
.***
:pt.:hp4.8BIT:ehp4.
:pd.This translation mode leaves most characters unchanged, even in the range
128-255.
:parml tsize=3.
:pt.Macintosh to OS/2&colon.
:pd.:ul compact.
:li.Valid characters in the range 32-255 except '%' remain unchanged.
:li.All other characters are replaced by the three characters 
'%xx', where xx is the character's hexadecimal representation.
:eul.
:pt.OS/2 to Macintosh&colon.
:pd.:ul compact.
:li.Characters 32-255 except '%' remain unchanged.
:li.The sequence '%xx' where xx is the hexadecimal representation of
'%' or a character not allowed in OS/2 file names 
is mapped to that character. 
In other cases, the combination is illegal, and will be rejected by &HFS..
:eul.
:eparml.
:eparml.

.**************************
:h2 id=520.Icon conversion
.**************************

:p.  
Some Macintosh files have icons attached to them. &HFS. will
convert any such :hp1.custom icons:ehp1. to the OS/2 format, 
so that they are displayed in the Workplace Shell.
The conversion is completely
transparent, and doesn't alter any data on the HFS volume.
The converted icons are presented to the system as extended attributes.

:p.
When converting icons, &HFS. uses an approximation of what is
hopefully the default colour table of the Macintosh.

:p.
Note that not all files have custom icons attached. Most files use
shared icons stored in a special resource file. This version of
&HFS. does not convert those icons.


.************************
:h2 id=530.Using a CD-ROM
.************************

:p.
Many CD-ROMs have a "hybrid" file system, with one HFS partition
visible on the Macintosh, and one ISO partition visible on other
systems. In order to access the HFS partition on such a CD-ROM,
&HFS. must get to see the CD-ROM before the built-in CD-ROM file
system driver does. This can be achieved by placing the line
:xmp.IFS=d&colon.\path\HFS.IFS

:exmp.
:hp1.before:ehp1. the line
:xmp.IFS=d&colon.\path\CDFS.IFS

:exmp.
in the CONFIG.SYS file.

:note.
Be sure to place the line for HFS.IFS :hp1.after:ehp1. the driver for
the file system that HFS.IFS resides in, or you will not be able to
boot the system. For example, if HFS.IFS resides in an HPFS partition,
you would load HPFS.IFS first, followed by HFS.IFS, followed by
CDFS.IFS.

:p.  
If you want to access the HFS file system on a hybrid CD-ROM but
CDFS is already mounted, remove the CD-ROM from the
drive, and then try to access it in some way so that an error message
is generated. This will unmount CDFS, and enable &HFS. to mount the CD-ROM
when it is inserted. This is typically necessary when the CD-ROM
is in the drive during system startup.

:p.  
The Workplace Shell may sometimes show a "System Error" message
box saying that the drive cannot be written to when an HFS CD-ROM or
other write-protected media is accessed. Select "Return error code to
program" and continue as usual. This inconvenience will be fixed in
future versions of &HFS..

.**********************************************************************
:h1 id=600.Building the sources
.**********************************************************************

:p.
The following sections describe how the sources of &HFS. are
organized, and what tools are needed to build the program. You do not
need to read this section unless you intend to compile &HFS. yourself.

:sl compact.
:li.:link reftype=hd refid=610.The tools needed:elink.
:li.:link reftype=hd refid=615.The sources:elink.
:li.:link reftype=hd refid=620.The Ring 0 piece:elink.
:li.:link reftype=hd refid=630.The Ring 3 piece:elink.
:esl.

.**************************
:h2 id=610.The tools needed
.**************************

:p.
To build &HFS., you will need two C compilers&colon. a 16-bit compiler
for the IFS and filter driver, and a 32-bit compiler for the control
program and the 
utilities. Small modifications to the sources and makefiles may
be necessary if you use different compilers than the ones listed below.
Some modifications to the makefiles will be necessary either way in order
to adjust them to
your system.

:p.
I used the following tools to develop &HFS..
:ul compact.
:li.
emx 0.9c for the 32-bit parts.
:li.
Borland C++ 3.1, Turbo Assembler and Borland's MAKE utility for the IFS
and the filter.
:li.
GNU Make version 3.75.
:li.
The Device Driver Kit (DDK) from IBM, which is available at
http&colon.//service.boulder.ibm.com/ddk.
:li.
The IFS Toolkit, which is available as
ftp&colon.//ftp-os2.nmsu.edu/os2/dev32/ifsinf.zip.
:eul.

.**************************
:h2 id=615.The sources
.**************************

:p.
The file hfssrc.zip contains the source tree. Some of the source files
have long file names, so you will have unpack it to an HPFS drive. The
directories in the tree are as follows:

:p.
:parml compact break=all.
:pt..
:pd.The root directory of the development tree contains header
files shared by the ring 0 and ring 3 pieces, as well as the 
top-level Makefile which is only used to create the distribution
archive.
:pt..\Ring0
:pd.This directory contains the source for the ring 0 piece (the IFS).
:pt..\Ring3
:pd.This directory contains the source for the control program and
the utilities.
:pt..\Ring3\MacFS
:pd.This is a slightly modified version of MacFS.
:pt..\hfsflt
:pd.The source for the filter.
:pt..\doc
:pd.The documentation source.
:eparml.

.**************************
:h2 id=620.The Ring 0 piece
.**************************

:p.
The .\Ring0 directory in the development tree contains C and asm sources,
and a makefile for Borland's MAKE utility. You will
have to edit the makefile so that the paths are correct for your
system.

:p.
The makefile contains compiler options for BCC. I have
sometimes experienced unexpected results after changing some
of these options, in particular those related to optimizations.

:p.
If the DEBUG symbol is defined, then the IFS will print some
debugging information through a logging facility. The messages
are printed out by the logging thread of the control program
if it is also compiled with DEBUG defined. 

:p.
To compile the IFS with debugging enabled, a vsprintf function
is needed. For licencing reasons, there is no such function
included in this distribution, so you must supply your own.

.**************************
:h2 id=630.The Ring 3 piece
.**************************

:p.
The .\Ring3 directory has several subdirectories, each with its
own Makefile (for GNU Make). They are all invoked as sub-makes
by the top-level makefile (.\Ring3\Makefile).

:p.
Dependencies can be generated by doing a
:xmp.make dep

:exmp.
This generates a dependency file called .depend in each subdirectory. 
However, the makefiles require the .depend files to be present
from the beginning, so you will have to create an empty .depend
file in each directory manually before you can run make. 
There are better ways to write
makefiles to avoid this, I just haven't got around to it yet.

:p.
Note that GNU Make doesn't like dependencies that contain drive
letters because of the colons.
This can be a problem if the default search path for gcc is
given by the C_INCLUDE_PATH environment variable and that
variable contains drive letters. gcc will prepend the pathname
from C_INCLUDE_PATH to the header file name when it generates
dependencies, so you will have to remove the drive letter
from C_INCLUDE_PATH. As a consequence, the emx header files will 
need to reside on the same drive as the &HFS. source.

:p.
The TOPDIR variable in .\Ring3\Makefile will need to be modified
to suit your system. When that is done, just type
:xmp.make

:exmp.
to compile everything.

:p.
If the symbol DEBUG is defined, HFS.EXE will print some information
on its actions. It will also create a logging thread which prints
messages from the IFS.

.**********************************************************************
:h1 id=800.History of changes
.**********************************************************************
:sl compact.
:li.:link reftype=hd refid=810.Changes in version 0.02:elink.
:esl.

.*********************************
:h2 id=810.Changes in version 0.02
.*********************************

:p.
These are the most important changes and new features in &HFS. version
0.02.

:ul compact.
:li.Works with CD-ROMs.
:li.Added file name translation to convert file names which are
invalid in OS/2.
:li.Hidden files are now supported.
:li.Implemented move operations.
:li.Drag and drop works in the Workplace Shell.
:li.Macintosh icons are transparently converted to OS/2 format (custom
icons only).
:li.A filter driver, HFSFLT.FLT, replaces PREPARE.
:li.SYNC and PREPARE now use drive A&colon. by default.
:li.Fixed a bug in MacFS which would cause the control program to
crash after a disk change.
:li.Added an interface for other programs to communicate with
&HFS. through DosFSCtl. Currently, this allows programs to read the
resource fork of a file.
:eul.

.**********************************************************************
.* Footnotes
.**********************************************************************

:fn id=control.
The :hp1.controlpProgram:ehp1., HFS.EXE, is the part of &HFS. that runs
in ring 3 (user privilege level). In order to access a Macintosh
diskette, the control program must be running.
:efn.

:fn id=diskette.
:p.
The only type of diskettes supported are 1.44MB diskettes 
formatted with the :hp1.Hierarchical File System:ehp1. (HFS).  
400K and 800K Macintosh diskettes cannot be used with the PC hardware.
:efn.

.*:fn id=emxrt.
.*This file is the emx run-time module. The full emx run-time
.*package can be obtained from ftp.uni-stuttgart.de in the directory
.*/pub/systems/os2/emx-0.9b.
.*:efn.

:euserdoc.
