                           /* Key Building and Comparation Routines */
#include <stdio.h>
#include <string.h>

#include "../defs.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "local_btree.h"
#include "../errors.h"


int KeyBldExt(LONGWORD fid, BYTE fork, WORD block, BT_KEY key)  {

BYTE *p_char;

  *(BYTE*)key = 7;	
  p_char = ((BYTE*)key) + 1;
  *p_char++ = fork;
  PutLongWord(fid, p_char);		/* Write the fid */
  p_char += 4;
  PutWord(block, p_char);
  return 0;
}

int KeyUnBldCat(BT_KEY key, LONGWORD *parentid, char * name) {
int namelen;

  if(parentid != NULL) *parentid = GetLongWord((BYTE*)key + 2);
  if(name == NULL)
    return 0;
  namelen = GetByte(key + 6);
  bcopy( key + 7, name, namelen); 
  name[namelen] = 0;
  return 0;
}


int KeyUnBldExt(BT_KEY key, LONGWORD *fileid, BYTE *fork, WORD *block) {

  if(fork != NULL) *fork = GetByte(key + 1);
  if(fileid != NULL) *fileid = GetLongWord(key + 2);
  if(block != NULL) *block = GetWord(key + 6);
  return 0;
}

int KeyBldCat(LONGWORD pid, char* name, BT_KEY key)  {

int len;
BYTE *p_char;

  len = strlen(name);
  *(BYTE*)key = (6 + len) | 1;		/* The key will be padded such that */
					/* will end on a word boundary */
  p_char = ((BYTE*)key) + 1;
  *p_char++ = 0;			/* Reserved byte */
  PutLongWord(pid, p_char);		/* Write the parent id */
  p_char += 4;
  *p_char++ = (BYTE)len;		/* Name length */
  bcopy(name, p_char, len & 1 ? len : len+1);
					/* If the name has even length then */
					/* should be padded with a 0 so copy */
					/* also the ending 0 */
  return 0;
}


int KeyCmpExt(BT_KEY key1, BT_KEY key2)  {

  BYTE *p1,*p2;
  BYTE len,f1,f2;
  LONGWORD id1,id2;
  WORD bl1,bl2;
  
  p1 = (BYTE*)key1;
  p2 = (BYTE*)key2;
  if((len = *p1) != *p2)		/* For the extents tree the key have */
    return(BT_BADKEY);			/* the same length (7) */

  id1 = GetLongWord((BYTE*)key1+2);
  id2 = GetLongWord((BYTE*)key2+2);
  if(id1 != id2)
    return id1 > id2 ? 1 : -1;

  f1 = GetByte((BYTE*)key1+1);
  f2 = GetByte((BYTE*)key2+1);

  if(f1 != f2)
    return f1 > f2 ? 1 : -1;

  bl1 = GetWord((BYTE*)key1+6);
  bl2 = GetWord((BYTE*)key2+6);
  if(bl1 != bl2)
    return bl1 > bl2 ? 1 : -1;

  return 0;
}


#define toupper(x) ((x)>='a' ? ( ((x)<='z') ? (x)&0xDF : (x) ) : (x))


int KeyCmpCat(BT_KEY key1, BT_KEY key2)  {

BYTE *p1,*p2;
BYTE len,len1,len2;

  p1 = (BYTE*)key1 + 1;			/* discard the total length of key */
  p2 = (BYTE*)key2 + 1;

  for(len=5;len>0;len--,p1++,p2++)	/* Compare the first 5 bytes */
    if(*p1 != *p2)
      return ( *p1 > *p2 ? 1 : -1);

  if((len1 = *p1++) < (len2 = *p2++))	/* Here there are the names */
    len = len1;
  else
    len = len2;

  for(;len>0;len--,p1++,p2++)		/* Compare the minimum length */
    if(toupper(*p1) != toupper(*p2))
      return ( toupper(*p1) > toupper(*p2) ? 1 : -1);

  if(len1 == len2)
    return 0;				/* The keys are equal */
  
  return (len1 > len2 ? 1 : -1);	/* If they are equal on the common */
					/* part then the longer is greater */
}

int KeyExpandExt(BT_KEY key, LONGWORD pointer) {

  PutLongWord(pointer, & key[8]);
  return 12;
}

int KeyExpandCat(BT_KEY key, LONGWORD pointer) {
int len;

  if(*key != 37) {
    *key = 37;
    len = key[6];
    bzero(& key[7 + len], 31 - len);
  }
  PutLongWord(pointer, & key[38]);
  return 42;
}



int KeyLength(BT_KEY key)  {		/* Returns the length of a key */

  return (( *(BYTE*)key | 1) + 1);	/* Normally there should be only */
					/* key having even size */
}




