
#include <stdlib.h>
#include <string.h>
#ifdef DEBUG
#include <stdio.h>
#endif

#include "../defs.h"
#include "../errors.h"
#include "../mountrec.h"
#include "../btree/btree.h"
#include "catalog.h"
#include "resolve.h"

int macresolvepathname(MOUNT_RECORD *mr, 
		       char *pathname,
		       CATALOG_RECORD *cr,
		       LONGWORD *pid,
		       char *name)
{
  char *localpathcopy;
  char *pathelement;
  char tokensep[2];
  LONGWORD curpid, lastpid;
  int rc;
  LONGWORD foundpid;
  char fnbuf[MAXFNLENGTH];

  if ((localpathcopy=(char *) malloc(strlen(pathname)+1))==NULL) 
    return PCROUTOFMEMORY;

  strcpy(localpathcopy, pathname);
  
  tokensep[0]=MACDIRSEP; tokensep[1]=0;

  if (*pathname==MACDIRSEP) {

/* ":" should be legal and open the root directory */

    if (strlen(pathname)==1) {
      free(localpathcopy);
      return mopenroot(mr, cr, name);
    } else {
      curpid=ROOTID;cr->cdrType=CDR_DIR;
      pathelement=strtok(localpathcopy+1,tokensep);
    }
  } else {
    pathelement=strtok(localpathcopy,tokensep);
    switch (cr->cdrType) {
    case CDR_DIR:
      curpid=cr->U.cdrDirRec.dirDirID;
      break;
    case CDR_FILE:
    case CDR_DTHREAD:
    case CDR_FTHREAD:
    default:
      free(localpathcopy);
      return PCRCWDNOTDIR;
    }
  }

/* OK, if we got this far, we have a valid cr and can continue normally */

    do {
      lastpid=curpid;
      switch (cr->cdrType) {
      case CDR_FILE: 
	free(localpathcopy);
	return PCRGOTFILENOTDIR;
	break;
      case CDR_DIR:
	if (((strlen(pathelement)<1)||strlen(pathelement)>MAXFNLENGTH)
	    && (curpid!=ROOTPID)) {
	  free(localpathcopy);
	  return PCRBADPATHELEMENT;
	}
	if ((rc=GetCatalogRecord(mr,curpid,pathelement,cr,&foundpid,fnbuf))) {
	  free(localpathcopy);
	  return rc;
	}
/*	if (((foundpid!=curpid)||(strcasecmp(pathelement,fnbuf)))
	    && (curpid!=ROOTPID)) { 
*/
	if ( foundpid!=curpid && curpid!=ROOTPID ) {
	  free(localpathcopy);
	  return PCRNOSUCHPATHELEMENT;
	}
	break;
      default:
	free(localpathcopy);
	return PCRUNEXPECTEDTYPE;
      }
      if (cr->cdrType==CDR_DIR) {
	curpid=cr->U.cdrDirRec.dirDirID;
      }
    } while ((pathelement=strtok(NULL,tokensep))!=NULL);

/* So now cr should correspond to the last element of the pathname */

  *pid=lastpid;
  strcpy(name,fnbuf);
  free(localpathcopy);

#ifdef DEBUG
  printf("resolved '%s' into pid=%u, name='%s'\n",
	 pathname, *pid, name);
#endif

  return 0;
}

int macresolvepnwithnonexistinglastelement(MOUNT_RECORD *mr,
					   char *absolutepathname,
					   LONGWORD *parpid,
					   char *parname,
					   CATALOG_RECORD *parcr,
					   char *name)
{
  int pos, rc;

  for (pos=strlen(absolutepathname)-1;pos>=0;pos--) 
    if (absolutepathname[pos]==MACDIRSEP)
      break;

  if (pos==0) {
    if ((rc=mopenroot(mr, parcr, parname)))
	return rc;
    if ((strlen(absolutepathname)>1)&&
	(strlen(absolutepathname)<(MAXFNLENGTH+1))) {
      strcpy(name,&(absolutepathname[1]));
      *parpid=ROOTPID;
      return 0;
    } else {
      *name=0;
      return BADFILEORFOLDERNAME;
    }
  }

  absolutepathname[pos]=0;

  rc=macresolvepathname(mr,
			absolutepathname,
			parcr,
			parpid,
			parname);

  absolutepathname[pos]=MACDIRSEP;

  if (rc)
    return rc;

  strcpy(name, &(absolutepathname[pos+1]));

#ifdef DEBUG
  printf("Resolved '%s' into parpid=%u, pid=%u, name='%s'\n",
	 absolutepathname, *parpid, parcr->U.cdrDirRec.dirDirID, name);
#endif

  return 0;

}
