/*
   Doom Editor Utility, by Brendon Wyber and Raphal Quinet.

   If you use any part of this code in one of your programs,
   please make it clear that you borrowed it from here...

   THINGS.H - Doom thing type defines.
*/

/* starting areas */
#define THING_PLAYER1         1
#define THING_PLAYER2         2
#define THING_PLAYER3         3
#define THING_PLAYER4         4
#define THING_DEATHMATCH      11

/* enhancements */
#define THING_EGG             30
#define THING_ESHIELD         31
#define THING_MYSTICURN       32
#define THING_TORCH           33
#define THING_TIMEBOMB        34
#define THING_MAP             35
#define THING_CHAOSDEVICE     36
#define THING_INVISO          75
#define THING_VILE            81
#define THING_FLASK           82
#define THING_WINGS           83
#define THING_INVULN          84
#define THING_SSHIELD         85
#define THING_TOMBOFPOWER     86

#define THING_GSHARD          73
#define THING_BSHARD          79
#define THING_YSHARD          80

/* weapons */
#define THING_BACKPACK        8
#define THING_WANDCRYSTAL     10
#define THING_GEODE           12
#define THING_MACESPHERE      13
#define THING_PILEOFSPHERES   16
#define THING_ARROWS          18
#define THING_QUIVER          19
#define THING_LESSERRUNES     20
#define THING_GREATERRUNES    21
#define THING_FLAMEORB        22
#define THING_INFERNOORB      23
#define THING_DRAGONCLAW      53
#define THING_CLAWORB         54
#define THING_ENERGYORB       55
#define THING_CROSSBOW        2001
#define THING_FIREMACE        2002
#define THING_PHOENIXROD      2003
#define THING_HELLSTAFF       2004
#define THING_GAUNTLET        2005

/* enemies */
#define THING_GARGOYLE_1      66
#define THING_GARGOYLE_2      5         // fire
#define THING_GOLEM_1         68
#define THING_GOLEM_2         69        // Ghost
#define THING_GOLEM_3         45        // Nitro
#define THING_GOLEM_4         46        // Ghost Nitro
#define THING_WARRIOR_1       64
#define THING_WARRIOR_2       65        // Ghost
#define THING_SOURCERER       15
#define THING_WEREDRAGON      70
#define THING_SABRECLAW       90
#define THING_ERUPTION        87
#define THING_IRONLICHE       6
#define THING_OPHIDIAN        92
#define THING_MAULOTAUR       9
#define THING_DSPARIL         7

/* decorations */
#define THING_BARREL          44
#define THING_SPORE           2035
#define THING_PEDASTAL        29
#define THING_SSTALAGTITE     37
#define THING_LSTALAGTITE     38
#define THING_SSTALAGMITE     39
#define THING_LSTALAGMITE     40
#define THING_CHANDALLEER     28
#define THING_COLUMN          47

/* decorations 2 - Light sources */
#define THING_WALLTORCH       50

#define THING_BSTATUE         94
#define THING_GSTATUE         95
#define THING_YSTATUE         96

#define THING_BRAZIER         76
#define THING_SKULLTOPPOLE    27

/* decorations 3 - Hanging objects */
#define THING_HANGSKULL1      26
#define THING_HANGSKULL2      25
#define THING_HANGSKULL3      24
#define THING_HANGSKULL4      17
#define THING_HANGBODY        51
#define THING_SLIME_1         48
#define THING_SLIME_2         49

/* decorations 4 - Invisible */
#define THING_SPORESPAWN      43

/* Sounds */
#define THING_WAIL            1200
#define THING_CRACKLE         1201
#define THING_DRIP            1202
#define THING_BURNING         1203
#define THING_HEARTBEAT       1204
#define THING_BELLS           1205
#define THING_MOAN            1206
#define THING_EERIE           1207
#define THING_LAUGH           1208
#define THING_BURNING_2       1209
#define THING_WIND            42
#define THING_RUNNINGWATER    41


/* teleport arrival */
#define THING_TELEPORT        14
#define THING_DSPARILEXIT     56
#define THING_TSHIMMERR       74
#define THING_TSHIMMERB       52


/* end of file */
