/*
   Doom Editor Utility, by Brendon Wyber and Raphal Quinet.

   You are allowed to use any parts of this code in another program, as
   long as you give credits to the authors in the documentation and in
   the program itself.  Read the file README.1ST for more information.

   This program comes with absolutely no warranty.

   THINGS.C - Thing name and type routines.
*/

/* the includes */
#include "deu.h"
#include "things.h"


/*
   get the colour of a thing
*/

int GetThingColour( int type)
{
   if (Colour2)
   {
      switch( type)
      {
      case THING_PLAYER1:
      case THING_PLAYER2:
      case THING_PLAYER3:
      case THING_PLAYER4:
      case THING_DEATHMATCH:
	 return 8;

      case THING_GOLEM_1:
      case THING_GOLEM_2:
      case THING_GOLEM_3:
      case THING_GOLEM_4:
	 return 4;
      case THING_GARGOYLE_1:
      case THING_GARGOYLE_2:
	 return 5;
      case THING_WARRIOR_1:
      case THING_WARRIOR_2:
      case THING_WEREDRAGON:
      case THING_SABRECLAW:
      case THING_ERUPTION:
	 return 6;
      case THING_SOURCERER:
      case THING_OPHIDIAN:
	 return 7;
      case THING_IRONLICHE:
      case THING_MAULOTAUR:
      case THING_DSPARIL:
	 return 8;

      /* Things you can always pick up */
      case THING_BSHARD:
      case THING_GSHARD:
      case THING_YSHARD:
      case THING_WINGS:
      case THING_TORCH:
      case THING_TOMBOFPOWER:
      case THING_INVISO:
      case THING_TIMEBOMB:
      case THING_FLASK:
      case THING_MAP:
      case THING_EGG:
      case THING_INVULN:
      case THING_MYSTICURN:
      case THING_CHAOSDEVICE:
	 return 5;
      case THING_VILE:
      case THING_SSHIELD:
      case THING_ESHIELD:
	 return 7;

      /* Guns */
      case THING_GAUNTLET:
      case THING_CROSSBOW:
      case THING_DRAGONCLAW:
      case THING_HELLSTAFF:
      case THING_PHOENIXROD:
      case THING_FIREMACE:
	 return 1;

      /* Things you can't always pick up */
      case THING_WANDCRYSTAL:
      case THING_GEODE:
      case THING_ARROWS:
      case THING_QUIVER:
      case THING_CLAWORB:
      case THING_ENERGYORB:
      case THING_BACKPACK:
      case THING_LESSERRUNES:
      case THING_FLAMEORB:
      case THING_INFERNOORB:
      case THING_MACESPHERE:
      case THING_GREATERRUNES:
      case THING_PILEOFSPHERES:
	 return 8;

      /* Decorations, et al */
      case THING_BSTATUE:
      case THING_GSTATUE:
      case THING_YSTATUE:
	 return 10;
      case THING_BARREL:
      case THING_SPORE:
      case THING_PEDASTAL:
      case THING_CHANDALLEER:
      case THING_SSTALAGTITE:
      case THING_LSTALAGTITE:
      case THING_SSTALAGMITE:
      case THING_LSTALAGMITE:
      case THING_SKULLTOPPOLE:
      case THING_BRAZIER:
      case THING_WALLTORCH:
      case THING_HANGSKULL1:
      case THING_HANGSKULL2:
      case THING_HANGSKULL3:
      case THING_HANGSKULL4:
      case THING_HANGBODY:
      case THING_SLIME_1:
      case THING_SLIME_2:
      case THING_COLUMN:
	 return 11;

      /* Invisible Things */
      case THING_SPORESPAWN:
	 return 15;

      /* Sounds */
      case THING_DRIP:
      case THING_BURNING:
      case THING_HEARTBEAT:
      case THING_BELLS:
      case THING_LAUGH:
      case THING_BURNING_2:
      case THING_WIND:
      case THING_WAIL:
      case THING_CRACKLE:
      case THING_MOAN:
      case THING_EERIE:
      case THING_RUNNINGWATER:
	 return 14;
      }
   }
   else
   {
      switch( type)
      {
      case THING_PLAYER1:
      case THING_PLAYER2:
      case THING_PLAYER3:
      case THING_PLAYER4:
      case THING_DEATHMATCH:
	 return GREEN;

      case THING_GARGOYLE_1:
      case THING_GARGOYLE_2:
      case THING_GOLEM_1:
      case THING_GOLEM_2:
      case THING_GOLEM_3:
      case THING_GOLEM_4:
      case THING_WARRIOR_1:
      case THING_WARRIOR_2:
      case THING_SOURCERER:
      case THING_IRONLICHE:
      case THING_WEREDRAGON:
      case THING_SABRECLAW:
      case THING_ERUPTION:
      case THING_OPHIDIAN:
      case THING_MAULOTAUR:
      case THING_DSPARIL:
	 return LIGHTRED;

      case THING_BSHARD:
      case THING_GSHARD:
      case THING_YSHARD:
	 return MAGENTA;

      case THING_VILE:
      case THING_SSHIELD:
      case THING_ESHIELD:
	 return BLUE;

      case THING_FLASK:
      case THING_WINGS:
      case THING_TORCH:
      case THING_TOMBOFPOWER:
      case THING_MAP:
      case THING_INVISO:
      case THING_TIMEBOMB:
      case THING_INVULN:
      case THING_MYSTICURN:
      case THING_CHAOSDEVICE:
      case THING_EGG:
	 return LIGHTBLUE;

      case THING_GAUNTLET:
      case THING_CROSSBOW:
      case THING_DRAGONCLAW:
      case THING_HELLSTAFF:
      case THING_PHOENIXROD:
      case THING_FIREMACE:
	 return YELLOW;

      case THING_BACKPACK:
      case THING_ARROWS:
      case THING_QUIVER:
      case THING_WANDCRYSTAL:
      case THING_GEODE:
      case THING_CLAWORB:
      case THING_ENERGYORB:
      case THING_LESSERRUNES:
      case THING_FLAMEORB:
      case THING_INFERNOORB:
      case THING_MACESPHERE:
      case THING_GREATERRUNES:
      case THING_PILEOFSPHERES:
	 return BROWN;

      case THING_SPORE:
      case THING_BARREL:
      case THING_PEDASTAL:
      case THING_BSTATUE:
      case THING_GSTATUE:
      case THING_YSTATUE:
      case THING_CHANDALLEER:
      case THING_SSTALAGTITE:
      case THING_LSTALAGTITE:
      case THING_SSTALAGMITE:
      case THING_LSTALAGMITE:
      case THING_SKULLTOPPOLE:
      case THING_BRAZIER:
      case THING_WALLTORCH:
      case THING_HANGSKULL1:
      case THING_HANGSKULL2:
      case THING_HANGSKULL3:
      case THING_HANGSKULL4:
      case THING_HANGBODY:
      case THING_COLUMN:
      case THING_SLIME_1:
      case THING_SLIME_2:

	 return LIGHTGRAY;

      /* Invisible Things */
      case THING_SPORESPAWN:
	 return DARKGRAY;

      /* Sounds */
      case THING_DRIP:
      case THING_BURNING:
      case THING_HEARTBEAT:
      case THING_BELLS:
      case THING_LAUGH:
      case THING_BURNING_2:
      case THING_WIND:
      case THING_WAIL:
      case THING_CRACKLE:
      case THING_MOAN:
      case THING_EERIE:
      case THING_RUNNINGWATER:
	 return DARKGRAY;
      }
   }
   return WHITE;
}



/*
   get the name of a thing
*/

char *GetThingName( int type)
{
   static char temp[ 20];

   switch( type)
   {
   /* the players */
   case THING_PLAYER1:
      return "Player 1 Start";
   case THING_PLAYER2:
      return "Player 2 Start";
   case THING_PLAYER3:
      return "Player 3 Start";
   case THING_PLAYER4:
      return "Player 4 Start";
   case THING_DEATHMATCH:
      return "DEATHMATCH Start";

   /* enemies */
   case THING_GARGOYLE_1:
      return "Gargoyle";
   case THING_GARGOYLE_2:
      return "Fire Gargoyle";
   case THING_GOLEM_1:
      return "Golem";
   case THING_GOLEM_2:
      return "Golem Ghost";
   case THING_GOLEM_3:
      return "Nitrogolem";
   case THING_GOLEM_4:
      return "Nitrogolem Ghost";
   case THING_WARRIOR_1:
      return "Warrior";
   case THING_WARRIOR_2:
      return "Warrior Ghost";
   case THING_SOURCERER:
      return "Sourcerer";
   case THING_IRONLICHE:
      return "Iron Liche";
   case THING_WEREDRAGON:
      return "Weredragon";
   case THING_SABRECLAW:
      return "Sabreclaw";
   case THING_ERUPTION:
      return "Eruption";
   case THING_OPHIDIAN:
      return "Ophidian";
   case THING_MAULOTAUR:
      return "Maulotaur";
   case THING_DSPARIL:
      return "D'Sparil";


   /* enhancements */
   case THING_WINGS:
      return "Wings of Wrath";
   case THING_TORCH:
      return "Torch";
   case THING_MAP:
      return "Map Scroll";
   case THING_TOMBOFPOWER:
      return "Tomb of Power";
   case THING_VILE:
      return "Vile of Health";
   case THING_FLASK:
      return "Crystal Flask";
   case THING_SSHIELD:
      return "Silver Shield";
   case THING_ESHIELD:
      return "Enchanted Shield";
   case THING_MYSTICURN:
      return "Mystic Urn";
   case THING_CHAOSDEVICE:
      return "Chaos Device";
   case THING_BSHARD:
      return "Blue Shard";
   case THING_GSHARD:
      return "Green Shard";
   case THING_YSHARD:
      return "Yellow Shard";
   case THING_EGG:
      return "Morphing Egg";
   case THING_INVISO:
      return "Shadow Sphere";
   case THING_TIMEBOMB:
      return "Time Bomb";
   case THING_INVULN:
      return "Invulnerability Ring";


   /* weapons */
   case THING_CROSSBOW:
      return "Crossbow";
   case THING_DRAGONCLAW:
      return "Dragon Claw";
   case THING_GAUNTLET:
      return "Gauntlets";
   case THING_WANDCRYSTAL:
      return "Wand Crystal";
   case THING_GEODE:
      return "Crystal Geode";
   case THING_ARROWS:
      return "Arrows";
   case THING_QUIVER:
      return "Quiver of Arrows";
   case THING_CLAWORB:
      return "Claw Orb";
   case THING_ENERGYORB:
      return "Energy Orb";
   case THING_BACKPACK:
      return "Bag of Holding";
   case THING_LESSERRUNES:
      return "Lesser Runes";
   case THING_FLAMEORB:
      return "Flame Orb";
   case THING_INFERNOORB:
      return "Inferno Orb";
   case THING_FIREMACE:
      return "Fire Mace";
   case THING_PHOENIXROD:
      return "Phoenix Rod";
   case THING_HELLSTAFF:
      return "Hell Staff";
   case THING_MACESPHERE:
      return "Mace Spheres";
   case THING_GREATERRUNES:
      return "Greater Runes";
   case THING_PILEOFSPHERES:
      return "Pile of Spheres";


   /* decorations */
   case THING_BARREL:
      return "Barrel";
   case THING_SPORE:
      return "Exploding Spore";
   case THING_PEDASTAL:
      return "Stone Pedastal";
   case THING_SKULLTOPPOLE:
      return "Pole with Skull";
   case THING_HANGSKULL1:
      return "Hanging Skull 1";
   case THING_HANGSKULL2:
      return "Hanging Skull 2";
   case THING_HANGSKULL3:
      return "Hanging Skull 3";
   case THING_HANGSKULL4:
      return "Hanging Skull 4";
   case THING_BSTATUE:
      return "Blue Statue";
   case THING_GSTATUE:
      return "Green Statue";
   case THING_YSTATUE:
      return "Yellow Statue";
   case THING_BRAZIER:
      return "Brazier";
   case THING_CHANDALLEER:
      return "Chandalleer";
   case THING_SSTALAGTITE:
      return "Small Stalagtite";
   case THING_LSTALAGTITE:
      return "Large Stalagtite";
   case THING_WALLTORCH:
      return "Wall Torch";
   case THING_SSTALAGMITE:
      return "Small Stalagmite";
   case THING_LSTALAGMITE:
      return "Large Stalagmite";
   case THING_HANGBODY:
      return "Hanging Body";
   case THING_COLUMN:
      return "Column";
   case THING_SLIME_1:
      return "Hanging Slime 1";
   case THING_SLIME_2:
      return "Hanging Slime 2";


   /* teleport */
   case THING_TELEPORT:
      return "Teleport exit";
   case THING_DSPARILEXIT:
      return "D'Sparil's exit";
   case THING_TSHIMMERR:
      return "Shimmer - Red";
   case THING_TSHIMMERB:
      return "Shimmer - Blue";

   /* Invisible Things */
   case THING_SPORESPAWN:
      return "Spore Spawn";

   /* Sounds */
   case THING_DRIP:
      return "Drip Sound";
   case THING_BURNING:
      return "Burning Sound";
   case THING_BURNING_2:
      return "Burning Sound 2";
   case THING_HEARTBEAT:
      return "Heartbeat Sound";
   case THING_BELLS:
      return "Bells Sound";
   case THING_LAUGH:
      return "Laugh Sound";
   case THING_WIND:
      return "Wind Sound";
   case THING_WAIL:
      return "Metallic Wail";
   case THING_CRACKLE:
      return "Crackle Sound";
   case THING_MOAN:
      return "Moaning Sound";
   case THING_EERIE:
      return "Eerie Sound";
   case THING_RUNNINGWATER:
      return "Running Water";

   }

   /* unknown */
   sprintf( temp, "<UNKNOWN %04d>", type);
   return temp;
}



/*
   get the size of a thing
*/

int GetThingRadius( int type)
{
   switch (type)
   {
   case THING_DSPARIL:
      return 64;
   case THING_MAULOTAUR:
      return 50;
   case THING_IRONLICHE:
   case THING_WEREDRAGON:
      return 40;
   case THING_GOLEM_1:
   case THING_GOLEM_2:
   case THING_GOLEM_3:
   case THING_GOLEM_4:
   case THING_OPHIDIAN:
      return 30;
   case THING_SOURCERER:
   case THING_WARRIOR_1:
   case THING_WARRIOR_2:
   case THING_SABRECLAW:
      return 24;
   case THING_PLAYER1:
   case THING_PLAYER2:
   case THING_PLAYER3:
   case THING_PLAYER4:
   case THING_DEATHMATCH:
   case THING_CROSSBOW:
   case THING_DRAGONCLAW:
   case THING_GAUNTLET:
   case THING_FIREMACE:
   case THING_PHOENIXROD:
   case THING_HELLSTAFF:
   case THING_ERUPTION:
      return 20;
   case THING_TELEPORT:
   case THING_DSPARILEXIT:
   case THING_TSHIMMERR:
   case THING_TSHIMMERB:
   case THING_BARREL:
   case THING_VILE:
   case THING_FLASK:
   case THING_SSHIELD:
   case THING_ESHIELD:
   case THING_BACKPACK:
   case THING_BSHARD:
   case THING_GSHARD:
   case THING_YSHARD:
   case THING_WINGS:
   case THING_MAP:
   case THING_TORCH:
   case THING_TOMBOFPOWER:
   case THING_TIMEBOMB:
   case THING_INVISO:
   case THING_INVULN:
   case THING_MYSTICURN:
   case THING_CHAOSDEVICE:
   case THING_EGG:
      return 10;
   default:
      return 16;
   }
}


/*
   get the name of the angle
*/

char *GetAngleName( int angle)
{
   switch (angle)
   {
   case 0:
      return "East";
   case 45:
      return "NorthEast";
   case 90:
      return "North";
   case 135:
      return "NorthWest";
   case 180:
      return "West";
   case 225:
      return "SouthWest";
   case 270:
      return "South";
   case 315:
      return "SouthEast";
   }
   return "<ILLEGAL ANGLE>";
}



/*
   get string of when something will appear
*/

char *GetWhenName( int when)
{
   static char temp[ 40];

   temp[ 0] = '\0';
   if (when & 0x01)
      strcat( temp, "D12 ");
   if (when & 0x02)
      strcat( temp, "D3 ");
   if (when & 0x04)
      strcat( temp, "D45 ");
   if (when & 0x08)
      strcat( temp, "Deaf ");
   if (when & 0x10)
      strcat( temp, "Multi ");
   return temp;
}



/* end of file */
