*$nocall,apost,comp-5,smallcomp
 COPY PMCALLS SUPPRESS.
 IDENTIFICATION DIVISION.
 PROGRAM-ID. REPORT.
 ENVIRONMENT DIVISION.
 CONFIGURATION SECTION.
 SOURCE-COMPUTER. IBM-PC.
 OBJECT-COMPUTER. IBM-PC.
 INPUT-OUTPUT SECTION.
 FILE-CONTROL.

     SELECT REPORT-FILE ASSIGN TO 'PRN[N]'
         FILE STATUS IS FILE-STATUS.

     SELECT DATA-FILE ASSIGN TO 'C:\FURNDAT[t]'
         FILE STATUS IS FILE-STATUS.

     SELECT EXCEL-FILE ASSIGN TO 'C:\FURNOUT.DAT[t]'
         FILE STATUS IS FILE-STATUS.

 DATA DIVISION.
 FILE SECTION.

 FD  REPORT-FILE.
 01  REPORT-REC                        PIC X(80).

 FD  DATA-FILE.
 01  DATA-RECORD.
     05  IN-RECORD-ID               PIC X(01).
     05  IN-RECORD-DAYCHAR          PIC X(03).
     05  FILLER                     PIC X(01).
     05  IN-RECORD-MONTH            PIC X(03).
     05  FILLER                     PIC X(01).
     05  IN-RECORD-DAY              PIC 9(02).
     05  FILLER                     PIC X(01).
     05  IN-RECORD-HOUR             PIC 9(02).
     05  FILLER                     PIC X(01).
     05  IN-RECORD-MINUTE           PIC 9(02).
     05  FILLER                     PIC X(01).
     05  IN-RECORD-SECOND           PIC 9(02).
     05  FILLER                     PIC X(01).
     05  IN-RECORD-YEAR             PIC 9(04).

 FD  EXCEL-FILE.
 01  EXCEL-RECORD.
     05  EXCEL-HOUR                 PIC 9(02).
     05  FILLER                     PIC X(01).
     05  EXCEL-TOTAL-ON             PIC 9(05).
     05  FILLER                     PIC X(01).
     05  EXCEL-TOTAL-OFF            PIC 9(05).
     05  FILLER                     PIC X(01).
     05  EXCEL-HOUR-COST            PIC 9(02)V99.

**************************************************************
**                                                          **
**************************************************************
 WORKING-STORAGE SECTION.
 01  EOF-SW                         PIC X(1) VALUE 'N'.
 01  FILE-STATUS                    PIC X(2).
 01  FIRST-PASS-SW                  PIC X(1) VALUE 'Y'.
 01  HELD-DATA.
     05  WS-HOLD-MONTH              PIC X(03).
     05  WS-HOLD-DAY                PIC 9(02).
     05  WS-HOLD-HOUR               PIC 9(02).
 01  CALCULATION-DATA.
     05  WS-CALC-MINUTES-ON         PIC 9(05).
     05  WS-CALC-SECONDS-ON         PIC 9(05).
     05  WS-CALC-MINUTES-OFF        PIC 9(05).
     05  WS-CALC-SECONDS-OFF        PIC 9(05).
     05  WS-TOTAL-MINUTES-ON        PIC 9(05).
     05  WS-TOTAL-SECONDS-ON        PIC 9(05).
     05  WS-TOTAL-MINUTES-OFF       PIC 9(05).
     05  WS-TOTAL-SECONDS-OFF       PIC 9(05).
     05  WS-CALC-COST               PIC 9(02)V99.
     05  WS-COST-PER-SECOND         PIC 9(02)V99 VALUE 0.
     05  WS-GRAND-TOTAL-ON          PIC 9(05).
     05  WS-GRAND-TOTAL-OFF         PIC 9(05).

 01  DATA-RECORD-1.
     05  WS1-RECORD-ID              PIC X(01).
     05  WS1-RECORD-DAYCHAR         PIC X(03).
     05  FILLER                     PIC X(01).
     05  WS1-RECORD-MONTH           PIC X(03).
     05  FILLER                     PIC X(01).
     05  WS1-RECORD-DAY             PIC 9(02).
     05  FILLER                     PIC X(01).
     05  WS1-RECORD-HOUR            PIC 9(02).
     05  FILLER                     PIC X(01).
     05  WS1-RECORD-MINUTE          PIC 9(02).
     05  FILLER                     PIC X(01).
     05  WS1-RECORD-SECOND          PIC 9(02).
     05  FILLER                     PIC X(01).
     05  WS1-RECORD-YEAR            PIC 9(04).

 01  DATA-RECORD-2.
     05  WS2-RECORD-ID              PIC X(01).
     05  WS2-RECORD-DAYCHAR         PIC X(03).
     05  FILLER                     PIC X(01).
     05  WS2-RECORD-MONTH           PIC X(03).
     05  FILLER                     PIC X(01).
     05  WS2-RECORD-DAY             PIC 9(02).
     05  FILLER                     PIC X(01).
     05  WS2-RECORD-HOUR            PIC 9(02).
     05  FILLER                     PIC X(01).
     05  WS2-RECORD-MINUTE          PIC 9(02).
     05  FILLER                     PIC X(01).
     05  WS2-RECORD-SECOND          PIC 9(02).
     05  FILLER                     PIC X(01).
     05  WS2-RECORD-YEAR            PIC 9(04).

  01 WS-REPORT-HEADING-LINE1.
     05  FILLER                     PIC X(02) VALUE SPACES.
     05  WS-HEADING1-DATE           PIC X(08) VALUE SPACES.
     05  FILLER                     PIC X(50) VALUE SPACES.

  01 WS-REPORT-HEADING-LINE2.
     05  FILLER                     PIC X(02) VALUE SPACES.
     05  FILLER                     PIC X(05) VALUE 'HOUR '.
     05  FILLER                     PIC X(10) VALUE SPACES.
     05  FILLER                     PIC X(09) VALUE 'TOTAL ON '.
     05  FILLER                     PIC X(10) VALUE SPACES.
     05  FILLER                     PIC X(10) VALUE 'TOTAL OFF'.
     05  FILLER                     PIC X(10) VALUE SPACES.
     05  FILLER                     PIC X(11) VALUE 'TOTAL COST'.

  01 WS-REPORT-HEADING-LINE3.
     05  FILLER                     PIC X(02) VALUE SPACES.
     05  FILLER                     PIC X(05) VALUE '-----'.
     05  FILLER                     PIC X(10) VALUE SPACES.
     05  FILLER                     PIC X(09) VALUE '---------'.
     05  FILLER                     PIC X(10) VALUE SPACES.
     05  FILLER                     PIC X(10) VALUE '---------'.
     05  FILLER                     PIC X(10) VALUE SPACES.
     05  FILLER                     PIC X(11) VALUE '----------'.

  01 WS-DETAIL-LINE1.
     05  FILLER                     PIC X(02) VALUE SPACES.
     05  WS-DETAIL-LINE1-HOUR       PIC 9(05) VALUE ZEROS.
     05  FILLER                     PIC X(10) VALUE SPACES.
     05  WS-DETAIL-LINE1-TOT-ON     PIC 9(07) VALUE ZEROS.
     05  FILLER                     PIC X(12) VALUE SPACES.
     05  WS-DETAIL-LINE1-TOT-OFF    PIC 9(07) VALUE ZEROS.
     05  FILLER                     PIC X(13) VALUE SPACES.
     05  WS-DETAIL-LINE1-TOT-COST   PIC 9(08) VALUE ZEROS.

  01 WS-DETAIL-LINE2.
     05  FILLER                     PIC X(17) VALUE SPACES.
     05  WS-DETAIL-LINE2-TOT-ON     PIC 9(07) VALUE ZEROS.
     05  FILLER                     PIC X(12) VALUE SPACES.
     05  WS-DETAIL-LINE2-TOT-OFF    PIC 9(07) VALUE ZEROS.
     05  FILLER                     PIC X(13) VALUE SPACES.
     05  WS-DETAIL-LINE2-TOT-COST   PIC 9(08) VALUE ZEROS.

  01 WS-DETAIL-LINE3.
     05  FILLER                     PIC X(23)
               VALUE 'AVERAGE ON          =>'.
     05  WS-DETAIL-LINE3-AVG-ON     PIC 9(03) VALUE ZEROS.

  01 WS-DETAIL-LINE4.
     05  FILLER                     PIC X(23)
               VALUE 'AVERAGE OFF         =>'.
     05  WS-DETAIL-LINE3-AVG-OFF    PIC 9(03) VALUE ZEROS.

  01 WS-DETAIL-LINE5.
     05  FILLER                     PIC X(23)
               VALUE 'AVERAGE INT         =>'.
     05  WS-DETAIL-LINE3-AVG-INT    PIC 9(03) VALUE ZEROS.

  01 WS-TOTAL-LINE1.
     05  FILLER                     PIC X(23)
               VALUE 'TOTAL ON TIME DAY   =>'.
     05  WS-TOTAL-LINE1-TOT-ON      PIC 9(03) VALUE ZEROS.

  01 WS-TOTAL-LINE2.
     05  FILLER                     PIC X(23)
               VALUE 'TOTAL OFF TIME DAY  =>'.
     05  WS-TOTAL-LINE2-TOT-OFF     PIC 9(03) VALUE ZEROS.

  01 WS-TOTAL-LINE3.
     05  FILLER                     PIC X(23)
               VALUE 'TOTAL GALS/COST DAY =>'.
     05  WS-TOTAL-LINE3-GAL-DAY     PIC 9(03) VALUE ZEROS.
     05  FILLER                     PIC X(02) VALUE SPACES.
     05  WS-TOTAL-LINE3-COST-DAY    PIC 9(05)V99 VALUE ZEROS.

  01 WS-TOTAL-LINE4.
     05  FILLER                     PIC X(23)
               VALUE 'TOTAL GALS/COST NIGHT>'.
     05  WS-TOTAL-LINE4-GAL-NIGHT   PIC 9(03) VALUE ZEROS.
     05  FILLER                     PIC X(02) VALUE SPACES.
     05  WS-TOTAL-LINE3-COST-NIGHT  PIC 9(05)V99 VALUE ZEROS.

  01 WS-WAIT-SW                     PIC X.

**************************************************************
**                                                          **
**************************************************************

 PROCEDURE DIVISION.
 00000-MAINLINE.

      OPEN INPUT  DATA-FILE.
      DISPLAY 'DATA FILE OPEN STATUS=> ' FILE-STATUS.
      OPEN OUTPUT EXCEL-FILE
      DISPLAY 'DATA OUTPUT FILE STATUS => ' FILE-STATUS.

      OPEN OUTPUT REPORT-FILE
      MOVE WS-REPORT-HEADING-LINE1 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-REPORT-HEADING-LINE2 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-REPORT-HEADING-LINE3 TO REPORT-REC
      WRITE REPORT-REC.

      PERFORM 100-PROCESS-DATA-FILE THRU
              199-EXIT UNTIL
                EOF-SW EQUAL TO 'Y'.
      PERFORM PROCESS-OUTPUT-DATA THRU
              PROCESS-OUTPUT-EXIT

      MOVE WS-DETAIL-LINE2 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-DETAIL-LINE3 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-DETAIL-LINE4 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-DETAIL-LINE5 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-TOTAL-LINE1 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-TOTAL-LINE2 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-TOTAL-LINE3 TO REPORT-REC
      WRITE REPORT-REC
      MOVE WS-TOTAL-LINE4 TO REPORT-REC
      WRITE REPORT-REC
      CLOSE REPORT-FILE.

      DISPLAY 'PROCESSING COMPLETE'.
      CLOSE DATA-FILE
            EXCEL-FILE.

      STOP RUN.

 00001-END-MAINLINE.

**************************************************************
**                                                          **
**************************************************************
 100-PROCESS-DATA-FILE.

      READ DATA-FILE
        AT END
          MOVE 'Y' TO EOF-SW
      END-READ.
      MOVE DATA-RECORD TO DATA-RECORD-1

     IF FIRST-PASS-SW EQUAL TO 'Y'
        READ DATA-FILE
         AT END
          MOVE 'Y' TO EOF-SW
        END-READ
        MOVE DATA-RECORD TO DATA-RECORD-2
        MOVE 'N' TO FIRST-PASS-SW
     ELSE
        DISPLAY 'WS2-RECORD-ID=> ' WS2-RECORD-ID
        DISPLAY 'WS1-RECORD-ID=> ' WS1-RECORD-ID
        COMPUTE WS-CALC-MINUTES-ON = WS2-RECORD-MINUTE -
                        WS1-RECORD-MINUTE
        COMPUTE WS-CALC-SECONDS-ON = WS2-RECORD-SECOND -
                        WS1-RECORD-SECOND
        COMPUTE WS-TOTAL-MINUTES-ON = WS-TOTAL-MINUTES-ON +
                           WS-CALC-MINUTES-ON
        COMPUTE WS-TOTAL-SECONDS-ON = WS-TOTAL-SECONDS-ON +
                            WS-CALC-SECONDS-ON
        DISPLAY '* COMPUTE CALC ON *'
        DISPLAY 'MINUTES ON->' WS-CALC-MINUTES-ON
        DISPLAY 'DATA2-> ' WS2-RECORD-MINUTE
        DISPLAY 'DATA1-> ' WS1-RECORD-MINUTE
        DISPLAY 'SECONDS ON->' WS-CALC-SECONDS-ON
        DISPLAY 'DATA2-> ' WS2-RECORD-SECOND
        DISPLAY 'DATA1-> ' WS1-RECORD-SECOND
        DISPLAY 'TOTAL MIN ON-> ' WS-TOTAL-MINUTES-ON
        DISPLAY 'TOTAL SEC ON-> ' WS-TOTAL-SECONDS-ON

        ACCEPT WS-WAIT-SW
        IF WS-TOTAL-SECONDS-ON > 60
           COMPUTE WS-TOTAL-SECONDS-ON = WS-TOTAL-SECONDS-ON - 60
           COMPUTE WS-TOTAL-MINUTES-ON = WS-TOTAL-MINUTES-ON + 1
        END-IF
        IF EOF-SW = 'Y'
           GO TO 199-EXIT
        END-IF
        READ DATA-FILE
           AT END
          MOVE 'Y' TO EOF-SW
        END-READ
        DISPLAY 'DATA IN=> ' DATA-RECORD
        MOVE DATA-RECORD TO DATA-RECORD-2
     END-IF.

     COMPUTE WS-CALC-MINUTES-OFF = WS2-RECORD-MINUTE -
                        WS1-RECORD-MINUTE.
     COMPUTE WS-CALC-SECONDS-OFF = WS2-RECORD-SECOND -
                        WS1-RECORD-SECOND.
     COMPUTE WS-TOTAL-MINUTES-OFF = WS-TOTAL-MINUTES-OFF +
                           WS-CALC-MINUTES-OFF.
     COMPUTE WS-TOTAL-SECONDS-OFF = WS-TOTAL-SECONDS-OFF +
                            WS-CALC-SECONDS-OFF.


     DISPLAY '* COMPUTE CALC OFF *'
     DISPLAY 'MINUTES OFF->' WS-CALC-MINUTES-OFF
     DISPLAY 'DATA2-> ' WS2-RECORD-MINUTE
     DISPLAY 'DATA1-> ' WS1-RECORD-MINUTE
     DISPLAY 'SECONDS OFF->' WS-CALC-SECONDS-OFF
     DISPLAY 'DATA2-> ' WS2-RECORD-SECOND
     DISPLAY 'DATA1-> ' WS1-RECORD-SECOND
     DISPLAY 'TOTAL MIN OFF-> ' WS-TOTAL-MINUTES-OFF
     DISPLAY 'TOTAL SEC OFF-> ' WS-TOTAL-SECONDS-OFF

     DISPLAY 'WS2-RECORD-ID=> ' WS2-RECORD-ID
     DISPLAY 'WS1-RECORD-ID=> ' WS1-RECORD-ID

     ACCEPT WS-WAIT-SW

     IF WS-TOTAL-SECONDS-OFF > 60
        COMPUTE WS-TOTAL-SECONDS-OFF = WS-TOTAL-SECONDS-OFF - 60
        COMPUTE WS-TOTAL-MINUTES-OFF = WS-TOTAL-MINUTES-OFF + 1
     END-IF.

      IF FIRST-PASS-SW EQUAL TO 'Y'
         MOVE WS1-RECORD-MONTH TO WS-HOLD-MONTH
         MOVE WS1-RECORD-DAY   TO WS-HOLD-DAY
         MOVE WS1-RECORD-HOUR  TO WS-HOLD-HOUR
      END-IF.

      DISPLAY 'WS-TOTAL-MINUTES ON=> ' WS-TOTAL-MINUTES-ON
      DISPLAY 'WS-TOTAL-MINUTES-OFF=> ' WS-TOTAL-MINUTES-OFF
      ACCEPT WS-WAIT-SW

      IF WS-HOLD-HOUR NOT EQUAL TO WS1-RECORD-HOUR
          DISPLAY 'PROCESSING OUTPUT DATA'

          PERFORM PROCESS-OUTPUT-DATA THRU
                  PROCESS-OUTPUT-EXIT
          MOVE ZEROS TO WS-CALC-MINUTES-ON
                        WS-CALC-SECONDS-ON
                        WS-CALC-MINUTES-OFF
                        WS-CALC-SECONDS-OFF
                        WS-TOTAL-MINUTES-ON
                        WS-TOTAL-SECONDS-ON
                        WS-TOTAL-MINUTES-OFF
                        WS-TOTAL-SECONDS-OFF
      END-IF.

 199-EXIT.
     EXIT.

**************************************************************
**                                                          **
**************************************************************
 PROCESS-OUTPUT-DATA.

     MOVE WS1-RECORD-HOUR      TO WS-HOLD-HOUR
     MOVE WS-HOLD-HOUR         TO EXCEL-HOUR.
     MOVE WS-TOTAL-MINUTES-ON  TO EXCEL-TOTAL-ON.
     MOVE WS-TOTAL-MINUTES-OFF TO EXCEL-TOTAL-OFF.
     WRITE EXCEL-RECORD.
     MOVE WS-HOLD-HOUR         TO WS-DETAIL-LINE1-HOUR
     MOVE WS-TOTAL-MINUTES-ON  TO WS-DETAIL-LINE1-TOT-ON
     MOVE WS-TOTAL-MINUTES-OFF TO WS-DETAIL-LINE1-TOT-OFF
     MOVE WS-DETAIL-LINE1      TO REPORT-REC
     WRITE REPORT-REC.

 PROCESS-OUTPUT-EXIT.
     EXIT.

**************************************************************
**                                                          **
**************************************************************
 PROCESS-REPORT.

      OPEN OUTPUT REPORT-FILE.
      CLOSE REPORT-FILE.

 PROCESS-REPORT-EXIT.
     EXIT.

